/*
 * Decompiled with CFR 0.152.
 */
package com.google.ads.googleads.v7.services.stub;

import com.google.ads.googleads.v7.resources.LifeEvent;
import com.google.ads.googleads.v7.services.GetLifeEventRequest;
import com.google.ads.googleads.v7.services.stub.GrpcLifeEventServiceCallableFactory;
import com.google.ads.googleads.v7.services.stub.LifeEventServiceStub;
import com.google.ads.googleads.v7.services.stub.LifeEventServiceStubSettings;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.core.BackgroundResourceAggregation;
import com.google.api.gax.grpc.GrpcCallSettings;
import com.google.api.gax.grpc.GrpcStubCallableFactory;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.RequestParamsExtractor;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.common.collect.ImmutableMap;
import com.google.longrunning.stub.GrpcOperationsStub;
import com.google.protobuf.Message;
import io.grpc.MethodDescriptor;
import io.grpc.protobuf.ProtoUtils;
import java.io.IOException;
import java.util.Map;
import java.util.concurrent.TimeUnit;

public class GrpcLifeEventServiceStub
extends LifeEventServiceStub {
    private static final MethodDescriptor<GetLifeEventRequest, LifeEvent> getLifeEventMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.ads.googleads.v7.services.LifeEventService/GetLifeEvent").setRequestMarshaller(ProtoUtils.marshaller((Message)GetLifeEventRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)LifeEvent.getDefaultInstance())).build();
    private final UnaryCallable<GetLifeEventRequest, LifeEvent> getLifeEventCallable;
    private final BackgroundResource backgroundResources;
    private final GrpcOperationsStub operationsStub;
    private final GrpcStubCallableFactory callableFactory;

    public static final GrpcLifeEventServiceStub create(LifeEventServiceStubSettings settings) throws IOException {
        return new GrpcLifeEventServiceStub(settings, ClientContext.create((StubSettings)settings));
    }

    public static final GrpcLifeEventServiceStub create(ClientContext clientContext) throws IOException {
        return new GrpcLifeEventServiceStub(LifeEventServiceStubSettings.newBuilder().build(), clientContext);
    }

    public static final GrpcLifeEventServiceStub create(ClientContext clientContext, GrpcStubCallableFactory callableFactory) throws IOException {
        return new GrpcLifeEventServiceStub(LifeEventServiceStubSettings.newBuilder().build(), clientContext, callableFactory);
    }

    protected GrpcLifeEventServiceStub(LifeEventServiceStubSettings settings, ClientContext clientContext) throws IOException {
        this(settings, clientContext, new GrpcLifeEventServiceCallableFactory());
    }

    protected GrpcLifeEventServiceStub(LifeEventServiceStubSettings settings, ClientContext clientContext, GrpcStubCallableFactory callableFactory) throws IOException {
        this.callableFactory = callableFactory;
        this.operationsStub = GrpcOperationsStub.create((ClientContext)clientContext, (GrpcStubCallableFactory)callableFactory);
        GrpcCallSettings getLifeEventTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(getLifeEventMethodDescriptor).setParamsExtractor((RequestParamsExtractor)new RequestParamsExtractor<GetLifeEventRequest>(){

            public Map<String, String> extract(GetLifeEventRequest request) {
                ImmutableMap.Builder params = ImmutableMap.builder();
                params.put((Object)"resource_name", (Object)String.valueOf(request.getResourceName()));
                return params.build();
            }
        }).build();
        this.getLifeEventCallable = callableFactory.createUnaryCallable(getLifeEventTransportSettings, settings.getLifeEventSettings(), clientContext);
        this.backgroundResources = new BackgroundResourceAggregation(clientContext.getBackgroundResources());
    }

    public GrpcOperationsStub getOperationsStub() {
        return this.operationsStub;
    }

    @Override
    public UnaryCallable<GetLifeEventRequest, LifeEvent> getLifeEventCallable() {
        return this.getLifeEventCallable;
    }

    @Override
    public final void close() {
        this.shutdown();
    }

    public void shutdown() {
        this.backgroundResources.shutdown();
    }

    public boolean isShutdown() {
        return this.backgroundResources.isShutdown();
    }

    public boolean isTerminated() {
        return this.backgroundResources.isTerminated();
    }

    public void shutdownNow() {
        this.backgroundResources.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.backgroundResources.awaitTermination(duration, unit);
    }
}

