/*
 * Decompiled with CFR 0.152.
 */
package com.google.ads.googleads.v8.resources;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class AdGroupAdLabelName
implements ResourceName {
    private static final PathTemplate CUSTOMER_ID_AD_GROUP_ID_AD_ID_LABEL_ID = PathTemplate.createWithoutUrlEncoding((String)"customers/{customer_id}/adGroupAdLabels/{ad_group_id}~{ad_id}~{label_id}");
    private volatile Map<String, String> fieldValuesMap;
    private final String customerId;
    private final String adGroupId;
    private final String adId;
    private final String labelId;

    @Deprecated
    protected AdGroupAdLabelName() {
        this.customerId = null;
        this.adGroupId = null;
        this.adId = null;
        this.labelId = null;
    }

    private AdGroupAdLabelName(Builder builder) {
        this.customerId = (String)Preconditions.checkNotNull((Object)builder.getCustomerId());
        this.adGroupId = (String)Preconditions.checkNotNull((Object)builder.getAdGroupId());
        this.adId = (String)Preconditions.checkNotNull((Object)builder.getAdId());
        this.labelId = (String)Preconditions.checkNotNull((Object)builder.getLabelId());
    }

    public String getCustomerId() {
        return this.customerId;
    }

    public String getAdGroupId() {
        return this.adGroupId;
    }

    public String getAdId() {
        return this.adId;
    }

    public String getLabelId() {
        return this.labelId;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static AdGroupAdLabelName of(String customerId, String adGroupId, String adId, String labelId) {
        return AdGroupAdLabelName.newBuilder().setCustomerId(customerId).setAdGroupId(adGroupId).setAdId(adId).setLabelId(labelId).build();
    }

    public static String format(String customerId, String adGroupId, String adId, String labelId) {
        return AdGroupAdLabelName.newBuilder().setCustomerId(customerId).setAdGroupId(adGroupId).setAdId(adId).setLabelId(labelId).build().toString();
    }

    public static AdGroupAdLabelName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = CUSTOMER_ID_AD_GROUP_ID_AD_ID_LABEL_ID.validatedMatch(formattedString, "AdGroupAdLabelName.parse: formattedString not in valid format");
        return AdGroupAdLabelName.of((String)matchMap.get("customer_id"), (String)matchMap.get("ad_group_id"), (String)matchMap.get("ad_id"), (String)matchMap.get("label_id"));
    }

    public static List<AdGroupAdLabelName> parseList(List<String> formattedStrings) {
        ArrayList<AdGroupAdLabelName> list = new ArrayList<AdGroupAdLabelName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(AdGroupAdLabelName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<AdGroupAdLabelName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (AdGroupAdLabelName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return CUSTOMER_ID_AD_GROUP_ID_AD_ID_LABEL_ID.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            AdGroupAdLabelName adGroupAdLabelName = this;
            synchronized (adGroupAdLabelName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.customerId != null) {
                        fieldMapBuilder.put((Object)"customer_id", (Object)this.customerId);
                    }
                    if (this.adGroupId != null) {
                        fieldMapBuilder.put((Object)"ad_group_id", (Object)this.adGroupId);
                    }
                    if (this.adId != null) {
                        fieldMapBuilder.put((Object)"ad_id", (Object)this.adId);
                    }
                    if (this.labelId != null) {
                        fieldMapBuilder.put((Object)"label_id", (Object)this.labelId);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return CUSTOMER_ID_AD_GROUP_ID_AD_ID_LABEL_ID.instantiate(new String[]{"customer_id", this.customerId, "ad_group_id", this.adGroupId, "ad_id", this.adId, "label_id", this.labelId});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null || this.getClass() == o.getClass()) {
            AdGroupAdLabelName that = (AdGroupAdLabelName)o;
            return Objects.equals(this.customerId, that.customerId) && Objects.equals(this.adGroupId, that.adGroupId) && Objects.equals(this.adId, that.adId) && Objects.equals(this.labelId, that.labelId);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= Objects.hashCode(this.customerId);
        h *= 1000003;
        h ^= Objects.hashCode(this.adGroupId);
        h *= 1000003;
        h ^= Objects.hashCode(this.adId);
        h *= 1000003;
        return h ^= Objects.hashCode(this.labelId);
    }

    public static class Builder {
        private String customerId;
        private String adGroupId;
        private String adId;
        private String labelId;

        protected Builder() {
        }

        public String getCustomerId() {
            return this.customerId;
        }

        public String getAdGroupId() {
            return this.adGroupId;
        }

        public String getAdId() {
            return this.adId;
        }

        public String getLabelId() {
            return this.labelId;
        }

        public Builder setCustomerId(String customerId) {
            this.customerId = customerId;
            return this;
        }

        public Builder setAdGroupId(String adGroupId) {
            this.adGroupId = adGroupId;
            return this;
        }

        public Builder setAdId(String adId) {
            this.adId = adId;
            return this;
        }

        public Builder setLabelId(String labelId) {
            this.labelId = labelId;
            return this;
        }

        private Builder(AdGroupAdLabelName adGroupAdLabelName) {
            this.customerId = adGroupAdLabelName.customerId;
            this.adGroupId = adGroupAdLabelName.adGroupId;
            this.adId = adGroupAdLabelName.adId;
            this.labelId = adGroupAdLabelName.labelId;
        }

        public AdGroupAdLabelName build() {
            return new AdGroupAdLabelName(this);
        }
    }
}

