/*
 * Decompiled with CFR 0.152.
 */
package com.google.ads.googleads.v8.resources;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class AdParameterName
implements ResourceName {
    private static final PathTemplate CUSTOMER_ID_AD_GROUP_ID_CRITERION_ID_PARAMETER_INDEX = PathTemplate.createWithoutUrlEncoding((String)"customers/{customer_id}/adParameters/{ad_group_id}~{criterion_id}~{parameter_index}");
    private volatile Map<String, String> fieldValuesMap;
    private final String customerId;
    private final String adGroupId;
    private final String criterionId;
    private final String parameterIndex;

    @Deprecated
    protected AdParameterName() {
        this.customerId = null;
        this.adGroupId = null;
        this.criterionId = null;
        this.parameterIndex = null;
    }

    private AdParameterName(Builder builder) {
        this.customerId = (String)Preconditions.checkNotNull((Object)builder.getCustomerId());
        this.adGroupId = (String)Preconditions.checkNotNull((Object)builder.getAdGroupId());
        this.criterionId = (String)Preconditions.checkNotNull((Object)builder.getCriterionId());
        this.parameterIndex = (String)Preconditions.checkNotNull((Object)builder.getParameterIndex());
    }

    public String getCustomerId() {
        return this.customerId;
    }

    public String getAdGroupId() {
        return this.adGroupId;
    }

    public String getCriterionId() {
        return this.criterionId;
    }

    public String getParameterIndex() {
        return this.parameterIndex;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static AdParameterName of(String customerId, String adGroupId, String criterionId, String parameterIndex) {
        return AdParameterName.newBuilder().setCustomerId(customerId).setAdGroupId(adGroupId).setCriterionId(criterionId).setParameterIndex(parameterIndex).build();
    }

    public static String format(String customerId, String adGroupId, String criterionId, String parameterIndex) {
        return AdParameterName.newBuilder().setCustomerId(customerId).setAdGroupId(adGroupId).setCriterionId(criterionId).setParameterIndex(parameterIndex).build().toString();
    }

    public static AdParameterName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = CUSTOMER_ID_AD_GROUP_ID_CRITERION_ID_PARAMETER_INDEX.validatedMatch(formattedString, "AdParameterName.parse: formattedString not in valid format");
        return AdParameterName.of((String)matchMap.get("customer_id"), (String)matchMap.get("ad_group_id"), (String)matchMap.get("criterion_id"), (String)matchMap.get("parameter_index"));
    }

    public static List<AdParameterName> parseList(List<String> formattedStrings) {
        ArrayList<AdParameterName> list = new ArrayList<AdParameterName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(AdParameterName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<AdParameterName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (AdParameterName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return CUSTOMER_ID_AD_GROUP_ID_CRITERION_ID_PARAMETER_INDEX.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            AdParameterName adParameterName = this;
            synchronized (adParameterName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.customerId != null) {
                        fieldMapBuilder.put((Object)"customer_id", (Object)this.customerId);
                    }
                    if (this.adGroupId != null) {
                        fieldMapBuilder.put((Object)"ad_group_id", (Object)this.adGroupId);
                    }
                    if (this.criterionId != null) {
                        fieldMapBuilder.put((Object)"criterion_id", (Object)this.criterionId);
                    }
                    if (this.parameterIndex != null) {
                        fieldMapBuilder.put((Object)"parameter_index", (Object)this.parameterIndex);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return CUSTOMER_ID_AD_GROUP_ID_CRITERION_ID_PARAMETER_INDEX.instantiate(new String[]{"customer_id", this.customerId, "ad_group_id", this.adGroupId, "criterion_id", this.criterionId, "parameter_index", this.parameterIndex});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null || this.getClass() == o.getClass()) {
            AdParameterName that = (AdParameterName)o;
            return Objects.equals(this.customerId, that.customerId) && Objects.equals(this.adGroupId, that.adGroupId) && Objects.equals(this.criterionId, that.criterionId) && Objects.equals(this.parameterIndex, that.parameterIndex);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= Objects.hashCode(this.customerId);
        h *= 1000003;
        h ^= Objects.hashCode(this.adGroupId);
        h *= 1000003;
        h ^= Objects.hashCode(this.criterionId);
        h *= 1000003;
        return h ^= Objects.hashCode(this.parameterIndex);
    }

    public static class Builder {
        private String customerId;
        private String adGroupId;
        private String criterionId;
        private String parameterIndex;

        protected Builder() {
        }

        public String getCustomerId() {
            return this.customerId;
        }

        public String getAdGroupId() {
            return this.adGroupId;
        }

        public String getCriterionId() {
            return this.criterionId;
        }

        public String getParameterIndex() {
            return this.parameterIndex;
        }

        public Builder setCustomerId(String customerId) {
            this.customerId = customerId;
            return this;
        }

        public Builder setAdGroupId(String adGroupId) {
            this.adGroupId = adGroupId;
            return this;
        }

        public Builder setCriterionId(String criterionId) {
            this.criterionId = criterionId;
            return this;
        }

        public Builder setParameterIndex(String parameterIndex) {
            this.parameterIndex = parameterIndex;
            return this;
        }

        private Builder(AdParameterName adParameterName) {
            this.customerId = adParameterName.customerId;
            this.adGroupId = adParameterName.adGroupId;
            this.criterionId = adParameterName.criterionId;
            this.parameterIndex = adParameterName.parameterIndex;
        }

        public AdParameterName build() {
            return new AdParameterName(this);
        }
    }
}

