/*
 * Decompiled with CFR 0.152.
 */
package com.google.ads.googleads.v8.resources;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class CampaignFeedName
implements ResourceName {
    private static final PathTemplate CUSTOMER_ID_CAMPAIGN_ID_FEED_ID = PathTemplate.createWithoutUrlEncoding((String)"customers/{customer_id}/campaignFeeds/{campaign_id}~{feed_id}");
    private volatile Map<String, String> fieldValuesMap;
    private final String customerId;
    private final String campaignId;
    private final String feedId;

    @Deprecated
    protected CampaignFeedName() {
        this.customerId = null;
        this.campaignId = null;
        this.feedId = null;
    }

    private CampaignFeedName(Builder builder) {
        this.customerId = (String)Preconditions.checkNotNull((Object)builder.getCustomerId());
        this.campaignId = (String)Preconditions.checkNotNull((Object)builder.getCampaignId());
        this.feedId = (String)Preconditions.checkNotNull((Object)builder.getFeedId());
    }

    public String getCustomerId() {
        return this.customerId;
    }

    public String getCampaignId() {
        return this.campaignId;
    }

    public String getFeedId() {
        return this.feedId;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static CampaignFeedName of(String customerId, String campaignId, String feedId) {
        return CampaignFeedName.newBuilder().setCustomerId(customerId).setCampaignId(campaignId).setFeedId(feedId).build();
    }

    public static String format(String customerId, String campaignId, String feedId) {
        return CampaignFeedName.newBuilder().setCustomerId(customerId).setCampaignId(campaignId).setFeedId(feedId).build().toString();
    }

    public static CampaignFeedName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = CUSTOMER_ID_CAMPAIGN_ID_FEED_ID.validatedMatch(formattedString, "CampaignFeedName.parse: formattedString not in valid format");
        return CampaignFeedName.of((String)matchMap.get("customer_id"), (String)matchMap.get("campaign_id"), (String)matchMap.get("feed_id"));
    }

    public static List<CampaignFeedName> parseList(List<String> formattedStrings) {
        ArrayList<CampaignFeedName> list = new ArrayList<CampaignFeedName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(CampaignFeedName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<CampaignFeedName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (CampaignFeedName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return CUSTOMER_ID_CAMPAIGN_ID_FEED_ID.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            CampaignFeedName campaignFeedName = this;
            synchronized (campaignFeedName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.customerId != null) {
                        fieldMapBuilder.put((Object)"customer_id", (Object)this.customerId);
                    }
                    if (this.campaignId != null) {
                        fieldMapBuilder.put((Object)"campaign_id", (Object)this.campaignId);
                    }
                    if (this.feedId != null) {
                        fieldMapBuilder.put((Object)"feed_id", (Object)this.feedId);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return CUSTOMER_ID_CAMPAIGN_ID_FEED_ID.instantiate(new String[]{"customer_id", this.customerId, "campaign_id", this.campaignId, "feed_id", this.feedId});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null || this.getClass() == o.getClass()) {
            CampaignFeedName that = (CampaignFeedName)o;
            return Objects.equals(this.customerId, that.customerId) && Objects.equals(this.campaignId, that.campaignId) && Objects.equals(this.feedId, that.feedId);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= Objects.hashCode(this.customerId);
        h *= 1000003;
        h ^= Objects.hashCode(this.campaignId);
        h *= 1000003;
        return h ^= Objects.hashCode(this.feedId);
    }

    public static class Builder {
        private String customerId;
        private String campaignId;
        private String feedId;

        protected Builder() {
        }

        public String getCustomerId() {
            return this.customerId;
        }

        public String getCampaignId() {
            return this.campaignId;
        }

        public String getFeedId() {
            return this.feedId;
        }

        public Builder setCustomerId(String customerId) {
            this.customerId = customerId;
            return this;
        }

        public Builder setCampaignId(String campaignId) {
            this.campaignId = campaignId;
            return this;
        }

        public Builder setFeedId(String feedId) {
            this.feedId = feedId;
            return this;
        }

        private Builder(CampaignFeedName campaignFeedName) {
            this.customerId = campaignFeedName.customerId;
            this.campaignId = campaignFeedName.campaignId;
            this.feedId = campaignFeedName.feedId;
        }

        public CampaignFeedName build() {
            return new CampaignFeedName(this);
        }
    }
}

