/*
 * Decompiled with CFR 0.152.
 */
package com.google.ads.googleads.v8.resources;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class ClickViewName
implements ResourceName {
    private static final PathTemplate CUSTOMER_ID_DATE_GCLID = PathTemplate.createWithoutUrlEncoding((String)"customers/{customer_id}/clickViews/{date}~{gclid}");
    private volatile Map<String, String> fieldValuesMap;
    private final String customerId;
    private final String date;
    private final String gclid;

    @Deprecated
    protected ClickViewName() {
        this.customerId = null;
        this.date = null;
        this.gclid = null;
    }

    private ClickViewName(Builder builder) {
        this.customerId = (String)Preconditions.checkNotNull((Object)builder.getCustomerId());
        this.date = (String)Preconditions.checkNotNull((Object)builder.getDate());
        this.gclid = (String)Preconditions.checkNotNull((Object)builder.getGclid());
    }

    public String getCustomerId() {
        return this.customerId;
    }

    public String getDate() {
        return this.date;
    }

    public String getGclid() {
        return this.gclid;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static ClickViewName of(String customerId, String date, String gclid) {
        return ClickViewName.newBuilder().setCustomerId(customerId).setDate(date).setGclid(gclid).build();
    }

    public static String format(String customerId, String date, String gclid) {
        return ClickViewName.newBuilder().setCustomerId(customerId).setDate(date).setGclid(gclid).build().toString();
    }

    public static ClickViewName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = CUSTOMER_ID_DATE_GCLID.validatedMatch(formattedString, "ClickViewName.parse: formattedString not in valid format");
        return ClickViewName.of((String)matchMap.get("customer_id"), (String)matchMap.get("date"), (String)matchMap.get("gclid"));
    }

    public static List<ClickViewName> parseList(List<String> formattedStrings) {
        ArrayList<ClickViewName> list = new ArrayList<ClickViewName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(ClickViewName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<ClickViewName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (ClickViewName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return CUSTOMER_ID_DATE_GCLID.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            ClickViewName clickViewName = this;
            synchronized (clickViewName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.customerId != null) {
                        fieldMapBuilder.put((Object)"customer_id", (Object)this.customerId);
                    }
                    if (this.date != null) {
                        fieldMapBuilder.put((Object)"date", (Object)this.date);
                    }
                    if (this.gclid != null) {
                        fieldMapBuilder.put((Object)"gclid", (Object)this.gclid);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return CUSTOMER_ID_DATE_GCLID.instantiate(new String[]{"customer_id", this.customerId, "date", this.date, "gclid", this.gclid});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null || this.getClass() == o.getClass()) {
            ClickViewName that = (ClickViewName)o;
            return Objects.equals(this.customerId, that.customerId) && Objects.equals(this.date, that.date) && Objects.equals(this.gclid, that.gclid);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= Objects.hashCode(this.customerId);
        h *= 1000003;
        h ^= Objects.hashCode(this.date);
        h *= 1000003;
        return h ^= Objects.hashCode(this.gclid);
    }

    public static class Builder {
        private String customerId;
        private String date;
        private String gclid;

        protected Builder() {
        }

        public String getCustomerId() {
            return this.customerId;
        }

        public String getDate() {
            return this.date;
        }

        public String getGclid() {
            return this.gclid;
        }

        public Builder setCustomerId(String customerId) {
            this.customerId = customerId;
            return this;
        }

        public Builder setDate(String date) {
            this.date = date;
            return this;
        }

        public Builder setGclid(String gclid) {
            this.gclid = gclid;
            return this;
        }

        private Builder(ClickViewName clickViewName) {
            this.customerId = clickViewName.customerId;
            this.date = clickViewName.date;
            this.gclid = clickViewName.gclid;
        }

        public ClickViewName build() {
            return new ClickViewName(this);
        }
    }
}

