/*
 * Decompiled with CFR 0.152.
 */
package com.google.ads.googleads.v8.services;

import com.google.ads.googleads.v8.resources.AccessibleBiddingStrategy;
import com.google.ads.googleads.v8.resources.AccessibleBiddingStrategyName;
import com.google.ads.googleads.v8.services.AccessibleBiddingStrategyServiceSettings;
import com.google.ads.googleads.v8.services.GetAccessibleBiddingStrategyRequest;
import com.google.ads.googleads.v8.services.stub.AccessibleBiddingStrategyServiceStub;
import com.google.ads.googleads.v8.services.stub.AccessibleBiddingStrategyServiceStubSettings;
import com.google.api.core.BetaApi;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.rpc.UnaryCallable;
import java.io.IOException;
import java.util.concurrent.TimeUnit;

public class AccessibleBiddingStrategyServiceClient
implements BackgroundResource {
    private final AccessibleBiddingStrategyServiceSettings settings;
    private final AccessibleBiddingStrategyServiceStub stub;

    public static final AccessibleBiddingStrategyServiceClient create() throws IOException {
        return AccessibleBiddingStrategyServiceClient.create(AccessibleBiddingStrategyServiceSettings.newBuilder().build());
    }

    public static final AccessibleBiddingStrategyServiceClient create(AccessibleBiddingStrategyServiceSettings settings) throws IOException {
        return new AccessibleBiddingStrategyServiceClient(settings);
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    public static final AccessibleBiddingStrategyServiceClient create(AccessibleBiddingStrategyServiceStub stub) {
        return new AccessibleBiddingStrategyServiceClient(stub);
    }

    protected AccessibleBiddingStrategyServiceClient(AccessibleBiddingStrategyServiceSettings settings) throws IOException {
        this.settings = settings;
        this.stub = ((AccessibleBiddingStrategyServiceStubSettings)settings.getStubSettings()).createStub();
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    protected AccessibleBiddingStrategyServiceClient(AccessibleBiddingStrategyServiceStub stub) {
        this.settings = null;
        this.stub = stub;
    }

    public final AccessibleBiddingStrategyServiceSettings getSettings() {
        return this.settings;
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    public AccessibleBiddingStrategyServiceStub getStub() {
        return this.stub;
    }

    public final AccessibleBiddingStrategy getAccessibleBiddingStrategy(AccessibleBiddingStrategyName resourceName) {
        GetAccessibleBiddingStrategyRequest request = GetAccessibleBiddingStrategyRequest.newBuilder().setResourceName(resourceName == null ? null : resourceName.toString()).build();
        return this.getAccessibleBiddingStrategy(request);
    }

    public final AccessibleBiddingStrategy getAccessibleBiddingStrategy(String resourceName) {
        GetAccessibleBiddingStrategyRequest request = GetAccessibleBiddingStrategyRequest.newBuilder().setResourceName(resourceName).build();
        return this.getAccessibleBiddingStrategy(request);
    }

    public final AccessibleBiddingStrategy getAccessibleBiddingStrategy(GetAccessibleBiddingStrategyRequest request) {
        return (AccessibleBiddingStrategy)this.getAccessibleBiddingStrategyCallable().call((Object)request);
    }

    public final UnaryCallable<GetAccessibleBiddingStrategyRequest, AccessibleBiddingStrategy> getAccessibleBiddingStrategyCallable() {
        return this.stub.getAccessibleBiddingStrategyCallable();
    }

    public final void close() {
        this.stub.close();
    }

    public void shutdown() {
        this.stub.shutdown();
    }

    public boolean isShutdown() {
        return this.stub.isShutdown();
    }

    public boolean isTerminated() {
        return this.stub.isTerminated();
    }

    public void shutdownNow() {
        this.stub.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.stub.awaitTermination(duration, unit);
    }
}

