/*
 * Decompiled with CFR 0.152.
 */
package com.google.ads.googleads.v8.services;

import com.google.ads.googleads.v8.resources.AdGroupAdLabel;
import com.google.ads.googleads.v8.resources.AdGroupAdLabelName;
import com.google.ads.googleads.v8.services.AdGroupAdLabelOperation;
import com.google.ads.googleads.v8.services.AdGroupAdLabelServiceSettings;
import com.google.ads.googleads.v8.services.GetAdGroupAdLabelRequest;
import com.google.ads.googleads.v8.services.MutateAdGroupAdLabelsRequest;
import com.google.ads.googleads.v8.services.MutateAdGroupAdLabelsResponse;
import com.google.ads.googleads.v8.services.stub.AdGroupAdLabelServiceStub;
import com.google.ads.googleads.v8.services.stub.AdGroupAdLabelServiceStubSettings;
import com.google.api.core.BetaApi;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.rpc.UnaryCallable;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.TimeUnit;

public class AdGroupAdLabelServiceClient
implements BackgroundResource {
    private final AdGroupAdLabelServiceSettings settings;
    private final AdGroupAdLabelServiceStub stub;

    public static final AdGroupAdLabelServiceClient create() throws IOException {
        return AdGroupAdLabelServiceClient.create(AdGroupAdLabelServiceSettings.newBuilder().build());
    }

    public static final AdGroupAdLabelServiceClient create(AdGroupAdLabelServiceSettings settings) throws IOException {
        return new AdGroupAdLabelServiceClient(settings);
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    public static final AdGroupAdLabelServiceClient create(AdGroupAdLabelServiceStub stub) {
        return new AdGroupAdLabelServiceClient(stub);
    }

    protected AdGroupAdLabelServiceClient(AdGroupAdLabelServiceSettings settings) throws IOException {
        this.settings = settings;
        this.stub = ((AdGroupAdLabelServiceStubSettings)settings.getStubSettings()).createStub();
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    protected AdGroupAdLabelServiceClient(AdGroupAdLabelServiceStub stub) {
        this.settings = null;
        this.stub = stub;
    }

    public final AdGroupAdLabelServiceSettings getSettings() {
        return this.settings;
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    public AdGroupAdLabelServiceStub getStub() {
        return this.stub;
    }

    public final AdGroupAdLabel getAdGroupAdLabel(AdGroupAdLabelName resourceName) {
        GetAdGroupAdLabelRequest request = GetAdGroupAdLabelRequest.newBuilder().setResourceName(resourceName == null ? null : resourceName.toString()).build();
        return this.getAdGroupAdLabel(request);
    }

    public final AdGroupAdLabel getAdGroupAdLabel(String resourceName) {
        GetAdGroupAdLabelRequest request = GetAdGroupAdLabelRequest.newBuilder().setResourceName(resourceName).build();
        return this.getAdGroupAdLabel(request);
    }

    public final AdGroupAdLabel getAdGroupAdLabel(GetAdGroupAdLabelRequest request) {
        return (AdGroupAdLabel)this.getAdGroupAdLabelCallable().call((Object)request);
    }

    public final UnaryCallable<GetAdGroupAdLabelRequest, AdGroupAdLabel> getAdGroupAdLabelCallable() {
        return this.stub.getAdGroupAdLabelCallable();
    }

    public final MutateAdGroupAdLabelsResponse mutateAdGroupAdLabels(String customerId, List<AdGroupAdLabelOperation> operations) {
        MutateAdGroupAdLabelsRequest request = MutateAdGroupAdLabelsRequest.newBuilder().setCustomerId(customerId).addAllOperations(operations).build();
        return this.mutateAdGroupAdLabels(request);
    }

    public final MutateAdGroupAdLabelsResponse mutateAdGroupAdLabels(MutateAdGroupAdLabelsRequest request) {
        return (MutateAdGroupAdLabelsResponse)this.mutateAdGroupAdLabelsCallable().call((Object)request);
    }

    public final UnaryCallable<MutateAdGroupAdLabelsRequest, MutateAdGroupAdLabelsResponse> mutateAdGroupAdLabelsCallable() {
        return this.stub.mutateAdGroupAdLabelsCallable();
    }

    public final void close() {
        this.stub.close();
    }

    public void shutdown() {
        this.stub.shutdown();
    }

    public boolean isShutdown() {
        return this.stub.isShutdown();
    }

    public boolean isTerminated() {
        return this.stub.isTerminated();
    }

    public void shutdownNow() {
        this.stub.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.stub.awaitTermination(duration, unit);
    }
}

