/*
 * Decompiled with CFR 0.152.
 */
package com.google.ads.googleads.v8.services;

import com.google.ads.googleads.v8.resources.Asset;
import com.google.ads.googleads.v8.resources.AssetName;
import com.google.ads.googleads.v8.services.AssetOperation;
import com.google.ads.googleads.v8.services.AssetServiceSettings;
import com.google.ads.googleads.v8.services.GetAssetRequest;
import com.google.ads.googleads.v8.services.MutateAssetsRequest;
import com.google.ads.googleads.v8.services.MutateAssetsResponse;
import com.google.ads.googleads.v8.services.stub.AssetServiceStub;
import com.google.ads.googleads.v8.services.stub.AssetServiceStubSettings;
import com.google.api.core.BetaApi;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.rpc.UnaryCallable;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.TimeUnit;

public class AssetServiceClient
implements BackgroundResource {
    private final AssetServiceSettings settings;
    private final AssetServiceStub stub;

    public static final AssetServiceClient create() throws IOException {
        return AssetServiceClient.create(AssetServiceSettings.newBuilder().build());
    }

    public static final AssetServiceClient create(AssetServiceSettings settings) throws IOException {
        return new AssetServiceClient(settings);
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    public static final AssetServiceClient create(AssetServiceStub stub) {
        return new AssetServiceClient(stub);
    }

    protected AssetServiceClient(AssetServiceSettings settings) throws IOException {
        this.settings = settings;
        this.stub = ((AssetServiceStubSettings)settings.getStubSettings()).createStub();
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    protected AssetServiceClient(AssetServiceStub stub) {
        this.settings = null;
        this.stub = stub;
    }

    public final AssetServiceSettings getSettings() {
        return this.settings;
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    public AssetServiceStub getStub() {
        return this.stub;
    }

    public final Asset getAsset(AssetName resourceName) {
        GetAssetRequest request = GetAssetRequest.newBuilder().setResourceName(resourceName == null ? null : resourceName.toString()).build();
        return this.getAsset(request);
    }

    public final Asset getAsset(String resourceName) {
        GetAssetRequest request = GetAssetRequest.newBuilder().setResourceName(resourceName).build();
        return this.getAsset(request);
    }

    public final Asset getAsset(GetAssetRequest request) {
        return (Asset)this.getAssetCallable().call((Object)request);
    }

    public final UnaryCallable<GetAssetRequest, Asset> getAssetCallable() {
        return this.stub.getAssetCallable();
    }

    public final MutateAssetsResponse mutateAssets(String customerId, List<AssetOperation> operations) {
        MutateAssetsRequest request = MutateAssetsRequest.newBuilder().setCustomerId(customerId).addAllOperations(operations).build();
        return this.mutateAssets(request);
    }

    public final MutateAssetsResponse mutateAssets(MutateAssetsRequest request) {
        return (MutateAssetsResponse)this.mutateAssetsCallable().call((Object)request);
    }

    public final UnaryCallable<MutateAssetsRequest, MutateAssetsResponse> mutateAssetsCallable() {
        return this.stub.mutateAssetsCallable();
    }

    public final void close() {
        this.stub.close();
    }

    public void shutdown() {
        this.stub.shutdown();
    }

    public boolean isShutdown() {
        return this.stub.isShutdown();
    }

    public boolean isTerminated() {
        return this.stub.isTerminated();
    }

    public void shutdownNow() {
        this.stub.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.stub.awaitTermination(duration, unit);
    }
}

