/*
 * Decompiled with CFR 0.152.
 */
package com.google.ads.googleads.v8.services;

import com.google.ads.googleads.v8.resources.CampaignAsset;
import com.google.ads.googleads.v8.resources.CampaignAssetName;
import com.google.ads.googleads.v8.services.CampaignAssetOperation;
import com.google.ads.googleads.v8.services.CampaignAssetServiceSettings;
import com.google.ads.googleads.v8.services.GetCampaignAssetRequest;
import com.google.ads.googleads.v8.services.MutateCampaignAssetsRequest;
import com.google.ads.googleads.v8.services.MutateCampaignAssetsResponse;
import com.google.ads.googleads.v8.services.stub.CampaignAssetServiceStub;
import com.google.ads.googleads.v8.services.stub.CampaignAssetServiceStubSettings;
import com.google.api.core.BetaApi;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.rpc.UnaryCallable;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.TimeUnit;

public class CampaignAssetServiceClient
implements BackgroundResource {
    private final CampaignAssetServiceSettings settings;
    private final CampaignAssetServiceStub stub;

    public static final CampaignAssetServiceClient create() throws IOException {
        return CampaignAssetServiceClient.create(CampaignAssetServiceSettings.newBuilder().build());
    }

    public static final CampaignAssetServiceClient create(CampaignAssetServiceSettings settings) throws IOException {
        return new CampaignAssetServiceClient(settings);
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    public static final CampaignAssetServiceClient create(CampaignAssetServiceStub stub) {
        return new CampaignAssetServiceClient(stub);
    }

    protected CampaignAssetServiceClient(CampaignAssetServiceSettings settings) throws IOException {
        this.settings = settings;
        this.stub = ((CampaignAssetServiceStubSettings)settings.getStubSettings()).createStub();
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    protected CampaignAssetServiceClient(CampaignAssetServiceStub stub) {
        this.settings = null;
        this.stub = stub;
    }

    public final CampaignAssetServiceSettings getSettings() {
        return this.settings;
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    public CampaignAssetServiceStub getStub() {
        return this.stub;
    }

    public final CampaignAsset getCampaignAsset(CampaignAssetName resourceName) {
        GetCampaignAssetRequest request = GetCampaignAssetRequest.newBuilder().setResourceName(resourceName == null ? null : resourceName.toString()).build();
        return this.getCampaignAsset(request);
    }

    public final CampaignAsset getCampaignAsset(String resourceName) {
        GetCampaignAssetRequest request = GetCampaignAssetRequest.newBuilder().setResourceName(resourceName).build();
        return this.getCampaignAsset(request);
    }

    public final CampaignAsset getCampaignAsset(GetCampaignAssetRequest request) {
        return (CampaignAsset)this.getCampaignAssetCallable().call((Object)request);
    }

    public final UnaryCallable<GetCampaignAssetRequest, CampaignAsset> getCampaignAssetCallable() {
        return this.stub.getCampaignAssetCallable();
    }

    public final MutateCampaignAssetsResponse mutateCampaignAssets(String customerId, List<CampaignAssetOperation> operations) {
        MutateCampaignAssetsRequest request = MutateCampaignAssetsRequest.newBuilder().setCustomerId(customerId).addAllOperations(operations).build();
        return this.mutateCampaignAssets(request);
    }

    public final MutateCampaignAssetsResponse mutateCampaignAssets(MutateCampaignAssetsRequest request) {
        return (MutateCampaignAssetsResponse)this.mutateCampaignAssetsCallable().call((Object)request);
    }

    public final UnaryCallable<MutateCampaignAssetsRequest, MutateCampaignAssetsResponse> mutateCampaignAssetsCallable() {
        return this.stub.mutateCampaignAssetsCallable();
    }

    public final void close() {
        this.stub.close();
    }

    public void shutdown() {
        this.stub.shutdown();
    }

    public boolean isShutdown() {
        return this.stub.isShutdown();
    }

    public boolean isTerminated() {
        return this.stub.isTerminated();
    }

    public void shutdownNow() {
        this.stub.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.stub.awaitTermination(duration, unit);
    }
}

