/*
 * Decompiled with CFR 0.152.
 */
package com.google.ads.googleads.v8.services;

import com.google.ads.googleads.v8.resources.CarrierConstant;
import com.google.ads.googleads.v8.resources.CarrierConstantName;
import com.google.ads.googleads.v8.services.CarrierConstantServiceSettings;
import com.google.ads.googleads.v8.services.GetCarrierConstantRequest;
import com.google.ads.googleads.v8.services.stub.CarrierConstantServiceStub;
import com.google.ads.googleads.v8.services.stub.CarrierConstantServiceStubSettings;
import com.google.api.core.BetaApi;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.rpc.UnaryCallable;
import java.io.IOException;
import java.util.concurrent.TimeUnit;

public class CarrierConstantServiceClient
implements BackgroundResource {
    private final CarrierConstantServiceSettings settings;
    private final CarrierConstantServiceStub stub;

    public static final CarrierConstantServiceClient create() throws IOException {
        return CarrierConstantServiceClient.create(CarrierConstantServiceSettings.newBuilder().build());
    }

    public static final CarrierConstantServiceClient create(CarrierConstantServiceSettings settings) throws IOException {
        return new CarrierConstantServiceClient(settings);
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    public static final CarrierConstantServiceClient create(CarrierConstantServiceStub stub) {
        return new CarrierConstantServiceClient(stub);
    }

    protected CarrierConstantServiceClient(CarrierConstantServiceSettings settings) throws IOException {
        this.settings = settings;
        this.stub = ((CarrierConstantServiceStubSettings)settings.getStubSettings()).createStub();
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    protected CarrierConstantServiceClient(CarrierConstantServiceStub stub) {
        this.settings = null;
        this.stub = stub;
    }

    public final CarrierConstantServiceSettings getSettings() {
        return this.settings;
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    public CarrierConstantServiceStub getStub() {
        return this.stub;
    }

    public final CarrierConstant getCarrierConstant(CarrierConstantName resourceName) {
        GetCarrierConstantRequest request = GetCarrierConstantRequest.newBuilder().setResourceName(resourceName == null ? null : resourceName.toString()).build();
        return this.getCarrierConstant(request);
    }

    public final CarrierConstant getCarrierConstant(String resourceName) {
        GetCarrierConstantRequest request = GetCarrierConstantRequest.newBuilder().setResourceName(resourceName).build();
        return this.getCarrierConstant(request);
    }

    public final CarrierConstant getCarrierConstant(GetCarrierConstantRequest request) {
        return (CarrierConstant)this.getCarrierConstantCallable().call((Object)request);
    }

    public final UnaryCallable<GetCarrierConstantRequest, CarrierConstant> getCarrierConstantCallable() {
        return this.stub.getCarrierConstantCallable();
    }

    public final void close() {
        this.stub.close();
    }

    public void shutdown() {
        this.stub.shutdown();
    }

    public boolean isShutdown() {
        return this.stub.isShutdown();
    }

    public boolean isTerminated() {
        return this.stub.isTerminated();
    }

    public void shutdownNow() {
        this.stub.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.stub.awaitTermination(duration, unit);
    }
}

