/*
 * Decompiled with CFR 0.152.
 */
package com.google.ads.googleads.v8.services;

import com.google.ads.googleads.v8.resources.CombinedAudience;
import com.google.ads.googleads.v8.resources.CombinedAudienceName;
import com.google.ads.googleads.v8.services.CombinedAudienceServiceSettings;
import com.google.ads.googleads.v8.services.GetCombinedAudienceRequest;
import com.google.ads.googleads.v8.services.stub.CombinedAudienceServiceStub;
import com.google.ads.googleads.v8.services.stub.CombinedAudienceServiceStubSettings;
import com.google.api.core.BetaApi;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.rpc.UnaryCallable;
import java.io.IOException;
import java.util.concurrent.TimeUnit;

public class CombinedAudienceServiceClient
implements BackgroundResource {
    private final CombinedAudienceServiceSettings settings;
    private final CombinedAudienceServiceStub stub;

    public static final CombinedAudienceServiceClient create() throws IOException {
        return CombinedAudienceServiceClient.create(CombinedAudienceServiceSettings.newBuilder().build());
    }

    public static final CombinedAudienceServiceClient create(CombinedAudienceServiceSettings settings) throws IOException {
        return new CombinedAudienceServiceClient(settings);
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    public static final CombinedAudienceServiceClient create(CombinedAudienceServiceStub stub) {
        return new CombinedAudienceServiceClient(stub);
    }

    protected CombinedAudienceServiceClient(CombinedAudienceServiceSettings settings) throws IOException {
        this.settings = settings;
        this.stub = ((CombinedAudienceServiceStubSettings)settings.getStubSettings()).createStub();
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    protected CombinedAudienceServiceClient(CombinedAudienceServiceStub stub) {
        this.settings = null;
        this.stub = stub;
    }

    public final CombinedAudienceServiceSettings getSettings() {
        return this.settings;
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    public CombinedAudienceServiceStub getStub() {
        return this.stub;
    }

    public final CombinedAudience getCombinedAudience(CombinedAudienceName resourceName) {
        GetCombinedAudienceRequest request = GetCombinedAudienceRequest.newBuilder().setResourceName(resourceName == null ? null : resourceName.toString()).build();
        return this.getCombinedAudience(request);
    }

    public final CombinedAudience getCombinedAudience(String resourceName) {
        GetCombinedAudienceRequest request = GetCombinedAudienceRequest.newBuilder().setResourceName(resourceName).build();
        return this.getCombinedAudience(request);
    }

    public final CombinedAudience getCombinedAudience(GetCombinedAudienceRequest request) {
        return (CombinedAudience)this.getCombinedAudienceCallable().call((Object)request);
    }

    public final UnaryCallable<GetCombinedAudienceRequest, CombinedAudience> getCombinedAudienceCallable() {
        return this.stub.getCombinedAudienceCallable();
    }

    public final void close() {
        this.stub.close();
    }

    public void shutdown() {
        this.stub.shutdown();
    }

    public boolean isShutdown() {
        return this.stub.isShutdown();
    }

    public boolean isTerminated() {
        return this.stub.isTerminated();
    }

    public void shutdownNow() {
        this.stub.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.stub.awaitTermination(duration, unit);
    }
}

