/*
 * Decompiled with CFR 0.152.
 */
package com.google.ads.googleads.v8.services;

import com.google.ads.googleads.v8.resources.ConversionAction;
import com.google.ads.googleads.v8.resources.ConversionActionName;
import com.google.ads.googleads.v8.services.ConversionActionOperation;
import com.google.ads.googleads.v8.services.ConversionActionServiceSettings;
import com.google.ads.googleads.v8.services.GetConversionActionRequest;
import com.google.ads.googleads.v8.services.MutateConversionActionsRequest;
import com.google.ads.googleads.v8.services.MutateConversionActionsResponse;
import com.google.ads.googleads.v8.services.stub.ConversionActionServiceStub;
import com.google.ads.googleads.v8.services.stub.ConversionActionServiceStubSettings;
import com.google.api.core.BetaApi;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.rpc.UnaryCallable;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.TimeUnit;

public class ConversionActionServiceClient
implements BackgroundResource {
    private final ConversionActionServiceSettings settings;
    private final ConversionActionServiceStub stub;

    public static final ConversionActionServiceClient create() throws IOException {
        return ConversionActionServiceClient.create(ConversionActionServiceSettings.newBuilder().build());
    }

    public static final ConversionActionServiceClient create(ConversionActionServiceSettings settings) throws IOException {
        return new ConversionActionServiceClient(settings);
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    public static final ConversionActionServiceClient create(ConversionActionServiceStub stub) {
        return new ConversionActionServiceClient(stub);
    }

    protected ConversionActionServiceClient(ConversionActionServiceSettings settings) throws IOException {
        this.settings = settings;
        this.stub = ((ConversionActionServiceStubSettings)settings.getStubSettings()).createStub();
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    protected ConversionActionServiceClient(ConversionActionServiceStub stub) {
        this.settings = null;
        this.stub = stub;
    }

    public final ConversionActionServiceSettings getSettings() {
        return this.settings;
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    public ConversionActionServiceStub getStub() {
        return this.stub;
    }

    public final ConversionAction getConversionAction(ConversionActionName resourceName) {
        GetConversionActionRequest request = GetConversionActionRequest.newBuilder().setResourceName(resourceName == null ? null : resourceName.toString()).build();
        return this.getConversionAction(request);
    }

    public final ConversionAction getConversionAction(String resourceName) {
        GetConversionActionRequest request = GetConversionActionRequest.newBuilder().setResourceName(resourceName).build();
        return this.getConversionAction(request);
    }

    public final ConversionAction getConversionAction(GetConversionActionRequest request) {
        return (ConversionAction)this.getConversionActionCallable().call((Object)request);
    }

    public final UnaryCallable<GetConversionActionRequest, ConversionAction> getConversionActionCallable() {
        return this.stub.getConversionActionCallable();
    }

    public final MutateConversionActionsResponse mutateConversionActions(String customerId, List<ConversionActionOperation> operations) {
        MutateConversionActionsRequest request = MutateConversionActionsRequest.newBuilder().setCustomerId(customerId).addAllOperations(operations).build();
        return this.mutateConversionActions(request);
    }

    public final MutateConversionActionsResponse mutateConversionActions(MutateConversionActionsRequest request) {
        return (MutateConversionActionsResponse)this.mutateConversionActionsCallable().call((Object)request);
    }

    public final UnaryCallable<MutateConversionActionsRequest, MutateConversionActionsResponse> mutateConversionActionsCallable() {
        return this.stub.mutateConversionActionsCallable();
    }

    public final void close() {
        this.stub.close();
    }

    public void shutdown() {
        this.stub.shutdown();
    }

    public boolean isShutdown() {
        return this.stub.isShutdown();
    }

    public boolean isTerminated() {
        return this.stub.isTerminated();
    }

    public void shutdownNow() {
        this.stub.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.stub.awaitTermination(duration, unit);
    }
}

