/*
 * Decompiled with CFR 0.152.
 */
package com.google.ads.googleads.v8.services;

import com.google.ads.googleads.v8.resources.CustomInterest;
import com.google.ads.googleads.v8.resources.CustomInterestName;
import com.google.ads.googleads.v8.services.CustomInterestOperation;
import com.google.ads.googleads.v8.services.CustomInterestServiceSettings;
import com.google.ads.googleads.v8.services.GetCustomInterestRequest;
import com.google.ads.googleads.v8.services.MutateCustomInterestsRequest;
import com.google.ads.googleads.v8.services.MutateCustomInterestsResponse;
import com.google.ads.googleads.v8.services.stub.CustomInterestServiceStub;
import com.google.ads.googleads.v8.services.stub.CustomInterestServiceStubSettings;
import com.google.api.core.BetaApi;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.rpc.UnaryCallable;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.TimeUnit;

public class CustomInterestServiceClient
implements BackgroundResource {
    private final CustomInterestServiceSettings settings;
    private final CustomInterestServiceStub stub;

    public static final CustomInterestServiceClient create() throws IOException {
        return CustomInterestServiceClient.create(CustomInterestServiceSettings.newBuilder().build());
    }

    public static final CustomInterestServiceClient create(CustomInterestServiceSettings settings) throws IOException {
        return new CustomInterestServiceClient(settings);
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    public static final CustomInterestServiceClient create(CustomInterestServiceStub stub) {
        return new CustomInterestServiceClient(stub);
    }

    protected CustomInterestServiceClient(CustomInterestServiceSettings settings) throws IOException {
        this.settings = settings;
        this.stub = ((CustomInterestServiceStubSettings)settings.getStubSettings()).createStub();
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    protected CustomInterestServiceClient(CustomInterestServiceStub stub) {
        this.settings = null;
        this.stub = stub;
    }

    public final CustomInterestServiceSettings getSettings() {
        return this.settings;
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    public CustomInterestServiceStub getStub() {
        return this.stub;
    }

    public final CustomInterest getCustomInterest(CustomInterestName resourceName) {
        GetCustomInterestRequest request = GetCustomInterestRequest.newBuilder().setResourceName(resourceName == null ? null : resourceName.toString()).build();
        return this.getCustomInterest(request);
    }

    public final CustomInterest getCustomInterest(String resourceName) {
        GetCustomInterestRequest request = GetCustomInterestRequest.newBuilder().setResourceName(resourceName).build();
        return this.getCustomInterest(request);
    }

    public final CustomInterest getCustomInterest(GetCustomInterestRequest request) {
        return (CustomInterest)this.getCustomInterestCallable().call((Object)request);
    }

    public final UnaryCallable<GetCustomInterestRequest, CustomInterest> getCustomInterestCallable() {
        return this.stub.getCustomInterestCallable();
    }

    public final MutateCustomInterestsResponse mutateCustomInterests(String customerId, List<CustomInterestOperation> operations) {
        MutateCustomInterestsRequest request = MutateCustomInterestsRequest.newBuilder().setCustomerId(customerId).addAllOperations(operations).build();
        return this.mutateCustomInterests(request);
    }

    public final MutateCustomInterestsResponse mutateCustomInterests(MutateCustomInterestsRequest request) {
        return (MutateCustomInterestsResponse)this.mutateCustomInterestsCallable().call((Object)request);
    }

    public final UnaryCallable<MutateCustomInterestsRequest, MutateCustomInterestsResponse> mutateCustomInterestsCallable() {
        return this.stub.mutateCustomInterestsCallable();
    }

    public final void close() {
        this.stub.close();
    }

    public void shutdown() {
        this.stub.shutdown();
    }

    public boolean isShutdown() {
        return this.stub.isShutdown();
    }

    public boolean isTerminated() {
        return this.stub.isTerminated();
    }

    public void shutdownNow() {
        this.stub.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.stub.awaitTermination(duration, unit);
    }
}

