/*
 * Decompiled with CFR 0.152.
 */
package com.google.ads.googleads.v8.services;

import com.google.ads.googleads.v8.resources.CustomerClient;
import com.google.ads.googleads.v8.resources.CustomerClientName;
import com.google.ads.googleads.v8.services.CustomerClientServiceSettings;
import com.google.ads.googleads.v8.services.GetCustomerClientRequest;
import com.google.ads.googleads.v8.services.stub.CustomerClientServiceStub;
import com.google.ads.googleads.v8.services.stub.CustomerClientServiceStubSettings;
import com.google.api.core.BetaApi;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.rpc.UnaryCallable;
import java.io.IOException;
import java.util.concurrent.TimeUnit;

public class CustomerClientServiceClient
implements BackgroundResource {
    private final CustomerClientServiceSettings settings;
    private final CustomerClientServiceStub stub;

    public static final CustomerClientServiceClient create() throws IOException {
        return CustomerClientServiceClient.create(CustomerClientServiceSettings.newBuilder().build());
    }

    public static final CustomerClientServiceClient create(CustomerClientServiceSettings settings) throws IOException {
        return new CustomerClientServiceClient(settings);
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    public static final CustomerClientServiceClient create(CustomerClientServiceStub stub) {
        return new CustomerClientServiceClient(stub);
    }

    protected CustomerClientServiceClient(CustomerClientServiceSettings settings) throws IOException {
        this.settings = settings;
        this.stub = ((CustomerClientServiceStubSettings)settings.getStubSettings()).createStub();
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    protected CustomerClientServiceClient(CustomerClientServiceStub stub) {
        this.settings = null;
        this.stub = stub;
    }

    public final CustomerClientServiceSettings getSettings() {
        return this.settings;
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    public CustomerClientServiceStub getStub() {
        return this.stub;
    }

    public final CustomerClient getCustomerClient(CustomerClientName resourceName) {
        GetCustomerClientRequest request = GetCustomerClientRequest.newBuilder().setResourceName(resourceName == null ? null : resourceName.toString()).build();
        return this.getCustomerClient(request);
    }

    public final CustomerClient getCustomerClient(String resourceName) {
        GetCustomerClientRequest request = GetCustomerClientRequest.newBuilder().setResourceName(resourceName).build();
        return this.getCustomerClient(request);
    }

    public final CustomerClient getCustomerClient(GetCustomerClientRequest request) {
        return (CustomerClient)this.getCustomerClientCallable().call((Object)request);
    }

    public final UnaryCallable<GetCustomerClientRequest, CustomerClient> getCustomerClientCallable() {
        return this.stub.getCustomerClientCallable();
    }

    public final void close() {
        this.stub.close();
    }

    public void shutdown() {
        this.stub.shutdown();
    }

    public boolean isShutdown() {
        return this.stub.isShutdown();
    }

    public boolean isTerminated() {
        return this.stub.isTerminated();
    }

    public void shutdownNow() {
        this.stub.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.stub.awaitTermination(duration, unit);
    }
}

