/*
 * Decompiled with CFR 0.152.
 */
package com.google.ads.googleads.v8.services;

import com.google.ads.googleads.v8.resources.GenderView;
import com.google.ads.googleads.v8.resources.GenderViewName;
import com.google.ads.googleads.v8.services.GenderViewServiceSettings;
import com.google.ads.googleads.v8.services.GetGenderViewRequest;
import com.google.ads.googleads.v8.services.stub.GenderViewServiceStub;
import com.google.ads.googleads.v8.services.stub.GenderViewServiceStubSettings;
import com.google.api.core.BetaApi;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.rpc.UnaryCallable;
import java.io.IOException;
import java.util.concurrent.TimeUnit;

public class GenderViewServiceClient
implements BackgroundResource {
    private final GenderViewServiceSettings settings;
    private final GenderViewServiceStub stub;

    public static final GenderViewServiceClient create() throws IOException {
        return GenderViewServiceClient.create(GenderViewServiceSettings.newBuilder().build());
    }

    public static final GenderViewServiceClient create(GenderViewServiceSettings settings) throws IOException {
        return new GenderViewServiceClient(settings);
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    public static final GenderViewServiceClient create(GenderViewServiceStub stub) {
        return new GenderViewServiceClient(stub);
    }

    protected GenderViewServiceClient(GenderViewServiceSettings settings) throws IOException {
        this.settings = settings;
        this.stub = ((GenderViewServiceStubSettings)settings.getStubSettings()).createStub();
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    protected GenderViewServiceClient(GenderViewServiceStub stub) {
        this.settings = null;
        this.stub = stub;
    }

    public final GenderViewServiceSettings getSettings() {
        return this.settings;
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    public GenderViewServiceStub getStub() {
        return this.stub;
    }

    public final GenderView getGenderView(GenderViewName resourceName) {
        GetGenderViewRequest request = GetGenderViewRequest.newBuilder().setResourceName(resourceName == null ? null : resourceName.toString()).build();
        return this.getGenderView(request);
    }

    public final GenderView getGenderView(String resourceName) {
        GetGenderViewRequest request = GetGenderViewRequest.newBuilder().setResourceName(resourceName).build();
        return this.getGenderView(request);
    }

    public final GenderView getGenderView(GetGenderViewRequest request) {
        return (GenderView)this.getGenderViewCallable().call((Object)request);
    }

    public final UnaryCallable<GetGenderViewRequest, GenderView> getGenderViewCallable() {
        return this.stub.getGenderViewCallable();
    }

    public final void close() {
        this.stub.close();
    }

    public void shutdown() {
        this.stub.shutdown();
    }

    public boolean isShutdown() {
        return this.stub.isShutdown();
    }

    public boolean isTerminated() {
        return this.stub.isTerminated();
    }

    public void shutdownNow() {
        this.stub.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.stub.awaitTermination(duration, unit);
    }
}

