/*
 * Decompiled with CFR 0.152.
 */
package com.google.ads.googleads.v8.services;

import com.google.ads.googleads.v8.resources.GeographicView;
import com.google.ads.googleads.v8.resources.GeographicViewName;
import com.google.ads.googleads.v8.services.GeographicViewServiceSettings;
import com.google.ads.googleads.v8.services.GetGeographicViewRequest;
import com.google.ads.googleads.v8.services.stub.GeographicViewServiceStub;
import com.google.ads.googleads.v8.services.stub.GeographicViewServiceStubSettings;
import com.google.api.core.BetaApi;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.rpc.UnaryCallable;
import java.io.IOException;
import java.util.concurrent.TimeUnit;

public class GeographicViewServiceClient
implements BackgroundResource {
    private final GeographicViewServiceSettings settings;
    private final GeographicViewServiceStub stub;

    public static final GeographicViewServiceClient create() throws IOException {
        return GeographicViewServiceClient.create(GeographicViewServiceSettings.newBuilder().build());
    }

    public static final GeographicViewServiceClient create(GeographicViewServiceSettings settings) throws IOException {
        return new GeographicViewServiceClient(settings);
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    public static final GeographicViewServiceClient create(GeographicViewServiceStub stub) {
        return new GeographicViewServiceClient(stub);
    }

    protected GeographicViewServiceClient(GeographicViewServiceSettings settings) throws IOException {
        this.settings = settings;
        this.stub = ((GeographicViewServiceStubSettings)settings.getStubSettings()).createStub();
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    protected GeographicViewServiceClient(GeographicViewServiceStub stub) {
        this.settings = null;
        this.stub = stub;
    }

    public final GeographicViewServiceSettings getSettings() {
        return this.settings;
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    public GeographicViewServiceStub getStub() {
        return this.stub;
    }

    public final GeographicView getGeographicView(GeographicViewName resourceName) {
        GetGeographicViewRequest request = GetGeographicViewRequest.newBuilder().setResourceName(resourceName == null ? null : resourceName.toString()).build();
        return this.getGeographicView(request);
    }

    public final GeographicView getGeographicView(String resourceName) {
        GetGeographicViewRequest request = GetGeographicViewRequest.newBuilder().setResourceName(resourceName).build();
        return this.getGeographicView(request);
    }

    public final GeographicView getGeographicView(GetGeographicViewRequest request) {
        return (GeographicView)this.getGeographicViewCallable().call((Object)request);
    }

    public final UnaryCallable<GetGeographicViewRequest, GeographicView> getGeographicViewCallable() {
        return this.stub.getGeographicViewCallable();
    }

    public final void close() {
        this.stub.close();
    }

    public void shutdown() {
        this.stub.shutdown();
    }

    public boolean isShutdown() {
        return this.stub.isShutdown();
    }

    public boolean isTerminated() {
        return this.stub.isTerminated();
    }

    public void shutdownNow() {
        this.stub.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.stub.awaitTermination(duration, unit);
    }
}

