/*
 * Decompiled with CFR 0.152.
 */
package com.google.ads.googleads.v8.services;

import com.google.ads.googleads.v8.resources.MerchantCenterLink;
import com.google.ads.googleads.v8.resources.MerchantCenterLinkName;
import com.google.ads.googleads.v8.services.GetMerchantCenterLinkRequest;
import com.google.ads.googleads.v8.services.ListMerchantCenterLinksRequest;
import com.google.ads.googleads.v8.services.ListMerchantCenterLinksResponse;
import com.google.ads.googleads.v8.services.MerchantCenterLinkOperation;
import com.google.ads.googleads.v8.services.MerchantCenterLinkServiceSettings;
import com.google.ads.googleads.v8.services.MutateMerchantCenterLinkRequest;
import com.google.ads.googleads.v8.services.MutateMerchantCenterLinkResponse;
import com.google.ads.googleads.v8.services.stub.MerchantCenterLinkServiceStub;
import com.google.ads.googleads.v8.services.stub.MerchantCenterLinkServiceStubSettings;
import com.google.api.core.BetaApi;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.rpc.UnaryCallable;
import java.io.IOException;
import java.util.concurrent.TimeUnit;

public class MerchantCenterLinkServiceClient
implements BackgroundResource {
    private final MerchantCenterLinkServiceSettings settings;
    private final MerchantCenterLinkServiceStub stub;

    public static final MerchantCenterLinkServiceClient create() throws IOException {
        return MerchantCenterLinkServiceClient.create(MerchantCenterLinkServiceSettings.newBuilder().build());
    }

    public static final MerchantCenterLinkServiceClient create(MerchantCenterLinkServiceSettings settings) throws IOException {
        return new MerchantCenterLinkServiceClient(settings);
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    public static final MerchantCenterLinkServiceClient create(MerchantCenterLinkServiceStub stub) {
        return new MerchantCenterLinkServiceClient(stub);
    }

    protected MerchantCenterLinkServiceClient(MerchantCenterLinkServiceSettings settings) throws IOException {
        this.settings = settings;
        this.stub = ((MerchantCenterLinkServiceStubSettings)settings.getStubSettings()).createStub();
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    protected MerchantCenterLinkServiceClient(MerchantCenterLinkServiceStub stub) {
        this.settings = null;
        this.stub = stub;
    }

    public final MerchantCenterLinkServiceSettings getSettings() {
        return this.settings;
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    public MerchantCenterLinkServiceStub getStub() {
        return this.stub;
    }

    public final ListMerchantCenterLinksResponse listMerchantCenterLinks(String customerId) {
        ListMerchantCenterLinksRequest request = ListMerchantCenterLinksRequest.newBuilder().setCustomerId(customerId).build();
        return this.listMerchantCenterLinks(request);
    }

    public final ListMerchantCenterLinksResponse listMerchantCenterLinks(ListMerchantCenterLinksRequest request) {
        return (ListMerchantCenterLinksResponse)this.listMerchantCenterLinksCallable().call((Object)request);
    }

    public final UnaryCallable<ListMerchantCenterLinksRequest, ListMerchantCenterLinksResponse> listMerchantCenterLinksCallable() {
        return this.stub.listMerchantCenterLinksCallable();
    }

    public final MerchantCenterLink getMerchantCenterLink(MerchantCenterLinkName resourceName) {
        GetMerchantCenterLinkRequest request = GetMerchantCenterLinkRequest.newBuilder().setResourceName(resourceName == null ? null : resourceName.toString()).build();
        return this.getMerchantCenterLink(request);
    }

    public final MerchantCenterLink getMerchantCenterLink(String resourceName) {
        GetMerchantCenterLinkRequest request = GetMerchantCenterLinkRequest.newBuilder().setResourceName(resourceName).build();
        return this.getMerchantCenterLink(request);
    }

    public final MerchantCenterLink getMerchantCenterLink(GetMerchantCenterLinkRequest request) {
        return (MerchantCenterLink)this.getMerchantCenterLinkCallable().call((Object)request);
    }

    public final UnaryCallable<GetMerchantCenterLinkRequest, MerchantCenterLink> getMerchantCenterLinkCallable() {
        return this.stub.getMerchantCenterLinkCallable();
    }

    public final MutateMerchantCenterLinkResponse mutateMerchantCenterLink(String customerId, MerchantCenterLinkOperation operation) {
        MutateMerchantCenterLinkRequest request = MutateMerchantCenterLinkRequest.newBuilder().setCustomerId(customerId).setOperation(operation).build();
        return this.mutateMerchantCenterLink(request);
    }

    public final MutateMerchantCenterLinkResponse mutateMerchantCenterLink(MutateMerchantCenterLinkRequest request) {
        return (MutateMerchantCenterLinkResponse)this.mutateMerchantCenterLinkCallable().call((Object)request);
    }

    public final UnaryCallable<MutateMerchantCenterLinkRequest, MutateMerchantCenterLinkResponse> mutateMerchantCenterLinkCallable() {
        return this.stub.mutateMerchantCenterLinkCallable();
    }

    public final void close() {
        this.stub.close();
    }

    public void shutdown() {
        this.stub.shutdown();
    }

    public boolean isShutdown() {
        return this.stub.isShutdown();
    }

    public boolean isTerminated() {
        return this.stub.isTerminated();
    }

    public void shutdownNow() {
        this.stub.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.stub.awaitTermination(duration, unit);
    }
}

