/*
 * Decompiled with CFR 0.152.
 */
package com.google.ads.googleads.v8.services;

import com.google.ads.googleads.v8.resources.ProductGroupView;
import com.google.ads.googleads.v8.resources.ProductGroupViewName;
import com.google.ads.googleads.v8.services.GetProductGroupViewRequest;
import com.google.ads.googleads.v8.services.ProductGroupViewServiceSettings;
import com.google.ads.googleads.v8.services.stub.ProductGroupViewServiceStub;
import com.google.ads.googleads.v8.services.stub.ProductGroupViewServiceStubSettings;
import com.google.api.core.BetaApi;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.rpc.UnaryCallable;
import java.io.IOException;
import java.util.concurrent.TimeUnit;

public class ProductGroupViewServiceClient
implements BackgroundResource {
    private final ProductGroupViewServiceSettings settings;
    private final ProductGroupViewServiceStub stub;

    public static final ProductGroupViewServiceClient create() throws IOException {
        return ProductGroupViewServiceClient.create(ProductGroupViewServiceSettings.newBuilder().build());
    }

    public static final ProductGroupViewServiceClient create(ProductGroupViewServiceSettings settings) throws IOException {
        return new ProductGroupViewServiceClient(settings);
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    public static final ProductGroupViewServiceClient create(ProductGroupViewServiceStub stub) {
        return new ProductGroupViewServiceClient(stub);
    }

    protected ProductGroupViewServiceClient(ProductGroupViewServiceSettings settings) throws IOException {
        this.settings = settings;
        this.stub = ((ProductGroupViewServiceStubSettings)settings.getStubSettings()).createStub();
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    protected ProductGroupViewServiceClient(ProductGroupViewServiceStub stub) {
        this.settings = null;
        this.stub = stub;
    }

    public final ProductGroupViewServiceSettings getSettings() {
        return this.settings;
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    public ProductGroupViewServiceStub getStub() {
        return this.stub;
    }

    public final ProductGroupView getProductGroupView(ProductGroupViewName resourceName) {
        GetProductGroupViewRequest request = GetProductGroupViewRequest.newBuilder().setResourceName(resourceName == null ? null : resourceName.toString()).build();
        return this.getProductGroupView(request);
    }

    public final ProductGroupView getProductGroupView(String resourceName) {
        GetProductGroupViewRequest request = GetProductGroupViewRequest.newBuilder().setResourceName(resourceName).build();
        return this.getProductGroupView(request);
    }

    public final ProductGroupView getProductGroupView(GetProductGroupViewRequest request) {
        return (ProductGroupView)this.getProductGroupViewCallable().call((Object)request);
    }

    public final UnaryCallable<GetProductGroupViewRequest, ProductGroupView> getProductGroupViewCallable() {
        return this.stub.getProductGroupViewCallable();
    }

    public final void close() {
        this.stub.close();
    }

    public void shutdown() {
        this.stub.shutdown();
    }

    public boolean isShutdown() {
        return this.stub.isShutdown();
    }

    public boolean isTerminated() {
        return this.stub.isTerminated();
    }

    public void shutdownNow() {
        this.stub.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.stub.awaitTermination(duration, unit);
    }
}

