/*
 * Decompiled with CFR 0.152.
 */
package com.google.ads.googleads.v8.services;

import com.google.ads.googleads.v8.resources.SharedCriterion;
import com.google.ads.googleads.v8.resources.SharedCriterionName;
import com.google.ads.googleads.v8.services.GetSharedCriterionRequest;
import com.google.ads.googleads.v8.services.MutateSharedCriteriaRequest;
import com.google.ads.googleads.v8.services.MutateSharedCriteriaResponse;
import com.google.ads.googleads.v8.services.SharedCriterionOperation;
import com.google.ads.googleads.v8.services.SharedCriterionServiceSettings;
import com.google.ads.googleads.v8.services.stub.SharedCriterionServiceStub;
import com.google.ads.googleads.v8.services.stub.SharedCriterionServiceStubSettings;
import com.google.api.core.BetaApi;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.rpc.UnaryCallable;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.TimeUnit;

public class SharedCriterionServiceClient
implements BackgroundResource {
    private final SharedCriterionServiceSettings settings;
    private final SharedCriterionServiceStub stub;

    public static final SharedCriterionServiceClient create() throws IOException {
        return SharedCriterionServiceClient.create(SharedCriterionServiceSettings.newBuilder().build());
    }

    public static final SharedCriterionServiceClient create(SharedCriterionServiceSettings settings) throws IOException {
        return new SharedCriterionServiceClient(settings);
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    public static final SharedCriterionServiceClient create(SharedCriterionServiceStub stub) {
        return new SharedCriterionServiceClient(stub);
    }

    protected SharedCriterionServiceClient(SharedCriterionServiceSettings settings) throws IOException {
        this.settings = settings;
        this.stub = ((SharedCriterionServiceStubSettings)settings.getStubSettings()).createStub();
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    protected SharedCriterionServiceClient(SharedCriterionServiceStub stub) {
        this.settings = null;
        this.stub = stub;
    }

    public final SharedCriterionServiceSettings getSettings() {
        return this.settings;
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    public SharedCriterionServiceStub getStub() {
        return this.stub;
    }

    public final SharedCriterion getSharedCriterion(SharedCriterionName resourceName) {
        GetSharedCriterionRequest request = GetSharedCriterionRequest.newBuilder().setResourceName(resourceName == null ? null : resourceName.toString()).build();
        return this.getSharedCriterion(request);
    }

    public final SharedCriterion getSharedCriterion(String resourceName) {
        GetSharedCriterionRequest request = GetSharedCriterionRequest.newBuilder().setResourceName(resourceName).build();
        return this.getSharedCriterion(request);
    }

    public final SharedCriterion getSharedCriterion(GetSharedCriterionRequest request) {
        return (SharedCriterion)this.getSharedCriterionCallable().call((Object)request);
    }

    public final UnaryCallable<GetSharedCriterionRequest, SharedCriterion> getSharedCriterionCallable() {
        return this.stub.getSharedCriterionCallable();
    }

    public final MutateSharedCriteriaResponse mutateSharedCriteria(String customerId, List<SharedCriterionOperation> operations) {
        MutateSharedCriteriaRequest request = MutateSharedCriteriaRequest.newBuilder().setCustomerId(customerId).addAllOperations(operations).build();
        return this.mutateSharedCriteria(request);
    }

    public final MutateSharedCriteriaResponse mutateSharedCriteria(MutateSharedCriteriaRequest request) {
        return (MutateSharedCriteriaResponse)this.mutateSharedCriteriaCallable().call((Object)request);
    }

    public final UnaryCallable<MutateSharedCriteriaRequest, MutateSharedCriteriaResponse> mutateSharedCriteriaCallable() {
        return this.stub.mutateSharedCriteriaCallable();
    }

    public final void close() {
        this.stub.close();
    }

    public void shutdown() {
        this.stub.shutdown();
    }

    public boolean isShutdown() {
        return this.stub.isShutdown();
    }

    public boolean isTerminated() {
        return this.stub.isTerminated();
    }

    public void shutdownNow() {
        this.stub.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.stub.awaitTermination(duration, unit);
    }
}

