/*
 * Decompiled with CFR 0.152.
 */
package com.google.ads.googleads.v8.services;

import com.google.ads.googleads.v8.resources.SharedSet;
import com.google.ads.googleads.v8.resources.SharedSetName;
import com.google.ads.googleads.v8.services.GetSharedSetRequest;
import com.google.ads.googleads.v8.services.MutateSharedSetsRequest;
import com.google.ads.googleads.v8.services.MutateSharedSetsResponse;
import com.google.ads.googleads.v8.services.SharedSetOperation;
import com.google.ads.googleads.v8.services.SharedSetServiceSettings;
import com.google.ads.googleads.v8.services.stub.SharedSetServiceStub;
import com.google.ads.googleads.v8.services.stub.SharedSetServiceStubSettings;
import com.google.api.core.BetaApi;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.rpc.UnaryCallable;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.TimeUnit;

public class SharedSetServiceClient
implements BackgroundResource {
    private final SharedSetServiceSettings settings;
    private final SharedSetServiceStub stub;

    public static final SharedSetServiceClient create() throws IOException {
        return SharedSetServiceClient.create(SharedSetServiceSettings.newBuilder().build());
    }

    public static final SharedSetServiceClient create(SharedSetServiceSettings settings) throws IOException {
        return new SharedSetServiceClient(settings);
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    public static final SharedSetServiceClient create(SharedSetServiceStub stub) {
        return new SharedSetServiceClient(stub);
    }

    protected SharedSetServiceClient(SharedSetServiceSettings settings) throws IOException {
        this.settings = settings;
        this.stub = ((SharedSetServiceStubSettings)settings.getStubSettings()).createStub();
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    protected SharedSetServiceClient(SharedSetServiceStub stub) {
        this.settings = null;
        this.stub = stub;
    }

    public final SharedSetServiceSettings getSettings() {
        return this.settings;
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    public SharedSetServiceStub getStub() {
        return this.stub;
    }

    public final SharedSet getSharedSet(SharedSetName resourceName) {
        GetSharedSetRequest request = GetSharedSetRequest.newBuilder().setResourceName(resourceName == null ? null : resourceName.toString()).build();
        return this.getSharedSet(request);
    }

    public final SharedSet getSharedSet(String resourceName) {
        GetSharedSetRequest request = GetSharedSetRequest.newBuilder().setResourceName(resourceName).build();
        return this.getSharedSet(request);
    }

    public final SharedSet getSharedSet(GetSharedSetRequest request) {
        return (SharedSet)this.getSharedSetCallable().call((Object)request);
    }

    public final UnaryCallable<GetSharedSetRequest, SharedSet> getSharedSetCallable() {
        return this.stub.getSharedSetCallable();
    }

    public final MutateSharedSetsResponse mutateSharedSets(String customerId, List<SharedSetOperation> operations) {
        MutateSharedSetsRequest request = MutateSharedSetsRequest.newBuilder().setCustomerId(customerId).addAllOperations(operations).build();
        return this.mutateSharedSets(request);
    }

    public final MutateSharedSetsResponse mutateSharedSets(MutateSharedSetsRequest request) {
        return (MutateSharedSetsResponse)this.mutateSharedSetsCallable().call((Object)request);
    }

    public final UnaryCallable<MutateSharedSetsRequest, MutateSharedSetsResponse> mutateSharedSetsCallable() {
        return this.stub.mutateSharedSetsCallable();
    }

    public final void close() {
        this.stub.close();
    }

    public void shutdown() {
        this.stub.shutdown();
    }

    public boolean isShutdown() {
        return this.stub.isShutdown();
    }

    public boolean isTerminated() {
        return this.stub.isTerminated();
    }

    public void shutdownNow() {
        this.stub.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.stub.awaitTermination(duration, unit);
    }
}

