/*
 * Decompiled with CFR 0.152.
 */
package com.google.ads.googleads.v8.services;

import com.google.ads.googleads.v8.resources.SmartCampaignSetting;
import com.google.ads.googleads.v8.resources.SmartCampaignSettingName;
import com.google.ads.googleads.v8.services.GetSmartCampaignSettingRequest;
import com.google.ads.googleads.v8.services.MutateSmartCampaignSettingsRequest;
import com.google.ads.googleads.v8.services.MutateSmartCampaignSettingsResponse;
import com.google.ads.googleads.v8.services.SmartCampaignSettingOperation;
import com.google.ads.googleads.v8.services.SmartCampaignSettingServiceSettings;
import com.google.ads.googleads.v8.services.stub.SmartCampaignSettingServiceStub;
import com.google.ads.googleads.v8.services.stub.SmartCampaignSettingServiceStubSettings;
import com.google.api.core.BetaApi;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.rpc.UnaryCallable;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.TimeUnit;

public class SmartCampaignSettingServiceClient
implements BackgroundResource {
    private final SmartCampaignSettingServiceSettings settings;
    private final SmartCampaignSettingServiceStub stub;

    public static final SmartCampaignSettingServiceClient create() throws IOException {
        return SmartCampaignSettingServiceClient.create(SmartCampaignSettingServiceSettings.newBuilder().build());
    }

    public static final SmartCampaignSettingServiceClient create(SmartCampaignSettingServiceSettings settings) throws IOException {
        return new SmartCampaignSettingServiceClient(settings);
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    public static final SmartCampaignSettingServiceClient create(SmartCampaignSettingServiceStub stub) {
        return new SmartCampaignSettingServiceClient(stub);
    }

    protected SmartCampaignSettingServiceClient(SmartCampaignSettingServiceSettings settings) throws IOException {
        this.settings = settings;
        this.stub = ((SmartCampaignSettingServiceStubSettings)settings.getStubSettings()).createStub();
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    protected SmartCampaignSettingServiceClient(SmartCampaignSettingServiceStub stub) {
        this.settings = null;
        this.stub = stub;
    }

    public final SmartCampaignSettingServiceSettings getSettings() {
        return this.settings;
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    public SmartCampaignSettingServiceStub getStub() {
        return this.stub;
    }

    public final SmartCampaignSetting getSmartCampaignSetting(SmartCampaignSettingName resourceName) {
        GetSmartCampaignSettingRequest request = GetSmartCampaignSettingRequest.newBuilder().setResourceName(resourceName == null ? null : resourceName.toString()).build();
        return this.getSmartCampaignSetting(request);
    }

    public final SmartCampaignSetting getSmartCampaignSetting(String resourceName) {
        GetSmartCampaignSettingRequest request = GetSmartCampaignSettingRequest.newBuilder().setResourceName(resourceName).build();
        return this.getSmartCampaignSetting(request);
    }

    public final SmartCampaignSetting getSmartCampaignSetting(GetSmartCampaignSettingRequest request) {
        return (SmartCampaignSetting)this.getSmartCampaignSettingCallable().call((Object)request);
    }

    public final UnaryCallable<GetSmartCampaignSettingRequest, SmartCampaignSetting> getSmartCampaignSettingCallable() {
        return this.stub.getSmartCampaignSettingCallable();
    }

    public final MutateSmartCampaignSettingsResponse mutateSmartCampaignSettings(String customerId, List<SmartCampaignSettingOperation> operations) {
        MutateSmartCampaignSettingsRequest request = MutateSmartCampaignSettingsRequest.newBuilder().setCustomerId(customerId).addAllOperations(operations).build();
        return this.mutateSmartCampaignSettings(request);
    }

    public final MutateSmartCampaignSettingsResponse mutateSmartCampaignSettings(MutateSmartCampaignSettingsRequest request) {
        return (MutateSmartCampaignSettingsResponse)this.mutateSmartCampaignSettingsCallable().call((Object)request);
    }

    public final UnaryCallable<MutateSmartCampaignSettingsRequest, MutateSmartCampaignSettingsResponse> mutateSmartCampaignSettingsCallable() {
        return this.stub.mutateSmartCampaignSettingsCallable();
    }

    public final void close() {
        this.stub.close();
    }

    public void shutdown() {
        this.stub.shutdown();
    }

    public boolean isShutdown() {
        return this.stub.isShutdown();
    }

    public boolean isTerminated() {
        return this.stub.isTerminated();
    }

    public void shutdownNow() {
        this.stub.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.stub.awaitTermination(duration, unit);
    }
}

