/*
 * Decompiled with CFR 0.152.
 */
package com.google.ads.googleads.v8.services.stub;

import com.google.ads.googleads.v8.resources.Ad;
import com.google.ads.googleads.v8.services.GetAdRequest;
import com.google.ads.googleads.v8.services.MutateAdsRequest;
import com.google.ads.googleads.v8.services.MutateAdsResponse;
import com.google.ads.googleads.v8.services.stub.AdServiceStub;
import com.google.ads.googleads.v8.services.stub.AdServiceStubSettings;
import com.google.ads.googleads.v8.services.stub.GrpcAdServiceCallableFactory;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.core.BackgroundResourceAggregation;
import com.google.api.gax.grpc.GrpcCallSettings;
import com.google.api.gax.grpc.GrpcStubCallableFactory;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.RequestParamsExtractor;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.common.collect.ImmutableMap;
import com.google.longrunning.stub.GrpcOperationsStub;
import com.google.protobuf.Message;
import io.grpc.MethodDescriptor;
import io.grpc.protobuf.ProtoUtils;
import java.io.IOException;
import java.util.Map;
import java.util.concurrent.TimeUnit;

public class GrpcAdServiceStub
extends AdServiceStub {
    private static final MethodDescriptor<GetAdRequest, Ad> getAdMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.ads.googleads.v8.services.AdService/GetAd").setRequestMarshaller(ProtoUtils.marshaller((Message)GetAdRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Ad.getDefaultInstance())).build();
    private static final MethodDescriptor<MutateAdsRequest, MutateAdsResponse> mutateAdsMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.ads.googleads.v8.services.AdService/MutateAds").setRequestMarshaller(ProtoUtils.marshaller((Message)MutateAdsRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)MutateAdsResponse.getDefaultInstance())).build();
    private final UnaryCallable<GetAdRequest, Ad> getAdCallable;
    private final UnaryCallable<MutateAdsRequest, MutateAdsResponse> mutateAdsCallable;
    private final BackgroundResource backgroundResources;
    private final GrpcOperationsStub operationsStub;
    private final GrpcStubCallableFactory callableFactory;

    public static final GrpcAdServiceStub create(AdServiceStubSettings settings) throws IOException {
        return new GrpcAdServiceStub(settings, ClientContext.create((StubSettings)settings));
    }

    public static final GrpcAdServiceStub create(ClientContext clientContext) throws IOException {
        return new GrpcAdServiceStub(AdServiceStubSettings.newBuilder().build(), clientContext);
    }

    public static final GrpcAdServiceStub create(ClientContext clientContext, GrpcStubCallableFactory callableFactory) throws IOException {
        return new GrpcAdServiceStub(AdServiceStubSettings.newBuilder().build(), clientContext, callableFactory);
    }

    protected GrpcAdServiceStub(AdServiceStubSettings settings, ClientContext clientContext) throws IOException {
        this(settings, clientContext, new GrpcAdServiceCallableFactory());
    }

    protected GrpcAdServiceStub(AdServiceStubSettings settings, ClientContext clientContext, GrpcStubCallableFactory callableFactory) throws IOException {
        this.callableFactory = callableFactory;
        this.operationsStub = GrpcOperationsStub.create((ClientContext)clientContext, (GrpcStubCallableFactory)callableFactory);
        GrpcCallSettings getAdTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(getAdMethodDescriptor).setParamsExtractor((RequestParamsExtractor)new RequestParamsExtractor<GetAdRequest>(){

            public Map<String, String> extract(GetAdRequest request) {
                ImmutableMap.Builder params = ImmutableMap.builder();
                params.put((Object)"resource_name", (Object)String.valueOf(request.getResourceName()));
                return params.build();
            }
        }).build();
        GrpcCallSettings mutateAdsTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(mutateAdsMethodDescriptor).setParamsExtractor((RequestParamsExtractor)new RequestParamsExtractor<MutateAdsRequest>(){

            public Map<String, String> extract(MutateAdsRequest request) {
                ImmutableMap.Builder params = ImmutableMap.builder();
                params.put((Object)"customer_id", (Object)String.valueOf(request.getCustomerId()));
                return params.build();
            }
        }).build();
        this.getAdCallable = callableFactory.createUnaryCallable(getAdTransportSettings, settings.getAdSettings(), clientContext);
        this.mutateAdsCallable = callableFactory.createUnaryCallable(mutateAdsTransportSettings, settings.mutateAdsSettings(), clientContext);
        this.backgroundResources = new BackgroundResourceAggregation(clientContext.getBackgroundResources());
    }

    public GrpcOperationsStub getOperationsStub() {
        return this.operationsStub;
    }

    @Override
    public UnaryCallable<GetAdRequest, Ad> getAdCallable() {
        return this.getAdCallable;
    }

    @Override
    public UnaryCallable<MutateAdsRequest, MutateAdsResponse> mutateAdsCallable() {
        return this.mutateAdsCallable;
    }

    @Override
    public final void close() {
        this.shutdown();
    }

    public void shutdown() {
        this.backgroundResources.shutdown();
    }

    public boolean isShutdown() {
        return this.backgroundResources.isShutdown();
    }

    public boolean isTerminated() {
        return this.backgroundResources.isTerminated();
    }

    public void shutdownNow() {
        this.backgroundResources.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.backgroundResources.awaitTermination(duration, unit);
    }
}

