/*
 * Decompiled with CFR 0.152.
 */
package com.google.ads.googleads.v8.services.stub;

import com.google.ads.googleads.v8.resources.Asset;
import com.google.ads.googleads.v8.services.GetAssetRequest;
import com.google.ads.googleads.v8.services.MutateAssetsRequest;
import com.google.ads.googleads.v8.services.MutateAssetsResponse;
import com.google.ads.googleads.v8.services.stub.AssetServiceStub;
import com.google.ads.googleads.v8.services.stub.AssetServiceStubSettings;
import com.google.ads.googleads.v8.services.stub.GrpcAssetServiceCallableFactory;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.core.BackgroundResourceAggregation;
import com.google.api.gax.grpc.GrpcCallSettings;
import com.google.api.gax.grpc.GrpcStubCallableFactory;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.RequestParamsExtractor;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.common.collect.ImmutableMap;
import com.google.longrunning.stub.GrpcOperationsStub;
import com.google.protobuf.Message;
import io.grpc.MethodDescriptor;
import io.grpc.protobuf.ProtoUtils;
import java.io.IOException;
import java.util.Map;
import java.util.concurrent.TimeUnit;

public class GrpcAssetServiceStub
extends AssetServiceStub {
    private static final MethodDescriptor<GetAssetRequest, Asset> getAssetMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.ads.googleads.v8.services.AssetService/GetAsset").setRequestMarshaller(ProtoUtils.marshaller((Message)GetAssetRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Asset.getDefaultInstance())).build();
    private static final MethodDescriptor<MutateAssetsRequest, MutateAssetsResponse> mutateAssetsMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.ads.googleads.v8.services.AssetService/MutateAssets").setRequestMarshaller(ProtoUtils.marshaller((Message)MutateAssetsRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)MutateAssetsResponse.getDefaultInstance())).build();
    private final UnaryCallable<GetAssetRequest, Asset> getAssetCallable;
    private final UnaryCallable<MutateAssetsRequest, MutateAssetsResponse> mutateAssetsCallable;
    private final BackgroundResource backgroundResources;
    private final GrpcOperationsStub operationsStub;
    private final GrpcStubCallableFactory callableFactory;

    public static final GrpcAssetServiceStub create(AssetServiceStubSettings settings) throws IOException {
        return new GrpcAssetServiceStub(settings, ClientContext.create((StubSettings)settings));
    }

    public static final GrpcAssetServiceStub create(ClientContext clientContext) throws IOException {
        return new GrpcAssetServiceStub(AssetServiceStubSettings.newBuilder().build(), clientContext);
    }

    public static final GrpcAssetServiceStub create(ClientContext clientContext, GrpcStubCallableFactory callableFactory) throws IOException {
        return new GrpcAssetServiceStub(AssetServiceStubSettings.newBuilder().build(), clientContext, callableFactory);
    }

    protected GrpcAssetServiceStub(AssetServiceStubSettings settings, ClientContext clientContext) throws IOException {
        this(settings, clientContext, new GrpcAssetServiceCallableFactory());
    }

    protected GrpcAssetServiceStub(AssetServiceStubSettings settings, ClientContext clientContext, GrpcStubCallableFactory callableFactory) throws IOException {
        this.callableFactory = callableFactory;
        this.operationsStub = GrpcOperationsStub.create((ClientContext)clientContext, (GrpcStubCallableFactory)callableFactory);
        GrpcCallSettings getAssetTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(getAssetMethodDescriptor).setParamsExtractor((RequestParamsExtractor)new RequestParamsExtractor<GetAssetRequest>(){

            public Map<String, String> extract(GetAssetRequest request) {
                ImmutableMap.Builder params = ImmutableMap.builder();
                params.put((Object)"resource_name", (Object)String.valueOf(request.getResourceName()));
                return params.build();
            }
        }).build();
        GrpcCallSettings mutateAssetsTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(mutateAssetsMethodDescriptor).setParamsExtractor((RequestParamsExtractor)new RequestParamsExtractor<MutateAssetsRequest>(){

            public Map<String, String> extract(MutateAssetsRequest request) {
                ImmutableMap.Builder params = ImmutableMap.builder();
                params.put((Object)"customer_id", (Object)String.valueOf(request.getCustomerId()));
                return params.build();
            }
        }).build();
        this.getAssetCallable = callableFactory.createUnaryCallable(getAssetTransportSettings, settings.getAssetSettings(), clientContext);
        this.mutateAssetsCallable = callableFactory.createUnaryCallable(mutateAssetsTransportSettings, settings.mutateAssetsSettings(), clientContext);
        this.backgroundResources = new BackgroundResourceAggregation(clientContext.getBackgroundResources());
    }

    public GrpcOperationsStub getOperationsStub() {
        return this.operationsStub;
    }

    @Override
    public UnaryCallable<GetAssetRequest, Asset> getAssetCallable() {
        return this.getAssetCallable;
    }

    @Override
    public UnaryCallable<MutateAssetsRequest, MutateAssetsResponse> mutateAssetsCallable() {
        return this.mutateAssetsCallable;
    }

    @Override
    public final void close() {
        this.shutdown();
    }

    public void shutdown() {
        this.backgroundResources.shutdown();
    }

    public boolean isShutdown() {
        return this.backgroundResources.isShutdown();
    }

    public boolean isTerminated() {
        return this.backgroundResources.isTerminated();
    }

    public void shutdownNow() {
        this.backgroundResources.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.backgroundResources.awaitTermination(duration, unit);
    }
}

