/*
 * Decompiled with CFR 0.152.
 */
package com.google.ads.googleads.v8.services.stub;

import com.google.ads.googleads.v8.resources.CustomerAsset;
import com.google.ads.googleads.v8.services.GetCustomerAssetRequest;
import com.google.ads.googleads.v8.services.MutateCustomerAssetsRequest;
import com.google.ads.googleads.v8.services.MutateCustomerAssetsResponse;
import com.google.ads.googleads.v8.services.stub.CustomerAssetServiceStub;
import com.google.ads.googleads.v8.services.stub.CustomerAssetServiceStubSettings;
import com.google.ads.googleads.v8.services.stub.GrpcCustomerAssetServiceCallableFactory;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.core.BackgroundResourceAggregation;
import com.google.api.gax.grpc.GrpcCallSettings;
import com.google.api.gax.grpc.GrpcStubCallableFactory;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.RequestParamsExtractor;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.common.collect.ImmutableMap;
import com.google.longrunning.stub.GrpcOperationsStub;
import com.google.protobuf.Message;
import io.grpc.MethodDescriptor;
import io.grpc.protobuf.ProtoUtils;
import java.io.IOException;
import java.util.Map;
import java.util.concurrent.TimeUnit;

public class GrpcCustomerAssetServiceStub
extends CustomerAssetServiceStub {
    private static final MethodDescriptor<GetCustomerAssetRequest, CustomerAsset> getCustomerAssetMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.ads.googleads.v8.services.CustomerAssetService/GetCustomerAsset").setRequestMarshaller(ProtoUtils.marshaller((Message)GetCustomerAssetRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)CustomerAsset.getDefaultInstance())).build();
    private static final MethodDescriptor<MutateCustomerAssetsRequest, MutateCustomerAssetsResponse> mutateCustomerAssetsMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.ads.googleads.v8.services.CustomerAssetService/MutateCustomerAssets").setRequestMarshaller(ProtoUtils.marshaller((Message)MutateCustomerAssetsRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)MutateCustomerAssetsResponse.getDefaultInstance())).build();
    private final UnaryCallable<GetCustomerAssetRequest, CustomerAsset> getCustomerAssetCallable;
    private final UnaryCallable<MutateCustomerAssetsRequest, MutateCustomerAssetsResponse> mutateCustomerAssetsCallable;
    private final BackgroundResource backgroundResources;
    private final GrpcOperationsStub operationsStub;
    private final GrpcStubCallableFactory callableFactory;

    public static final GrpcCustomerAssetServiceStub create(CustomerAssetServiceStubSettings settings) throws IOException {
        return new GrpcCustomerAssetServiceStub(settings, ClientContext.create((StubSettings)settings));
    }

    public static final GrpcCustomerAssetServiceStub create(ClientContext clientContext) throws IOException {
        return new GrpcCustomerAssetServiceStub(CustomerAssetServiceStubSettings.newBuilder().build(), clientContext);
    }

    public static final GrpcCustomerAssetServiceStub create(ClientContext clientContext, GrpcStubCallableFactory callableFactory) throws IOException {
        return new GrpcCustomerAssetServiceStub(CustomerAssetServiceStubSettings.newBuilder().build(), clientContext, callableFactory);
    }

    protected GrpcCustomerAssetServiceStub(CustomerAssetServiceStubSettings settings, ClientContext clientContext) throws IOException {
        this(settings, clientContext, new GrpcCustomerAssetServiceCallableFactory());
    }

    protected GrpcCustomerAssetServiceStub(CustomerAssetServiceStubSettings settings, ClientContext clientContext, GrpcStubCallableFactory callableFactory) throws IOException {
        this.callableFactory = callableFactory;
        this.operationsStub = GrpcOperationsStub.create((ClientContext)clientContext, (GrpcStubCallableFactory)callableFactory);
        GrpcCallSettings getCustomerAssetTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(getCustomerAssetMethodDescriptor).setParamsExtractor((RequestParamsExtractor)new RequestParamsExtractor<GetCustomerAssetRequest>(){

            public Map<String, String> extract(GetCustomerAssetRequest request) {
                ImmutableMap.Builder params = ImmutableMap.builder();
                params.put((Object)"resource_name", (Object)String.valueOf(request.getResourceName()));
                return params.build();
            }
        }).build();
        GrpcCallSettings mutateCustomerAssetsTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(mutateCustomerAssetsMethodDescriptor).setParamsExtractor((RequestParamsExtractor)new RequestParamsExtractor<MutateCustomerAssetsRequest>(){

            public Map<String, String> extract(MutateCustomerAssetsRequest request) {
                ImmutableMap.Builder params = ImmutableMap.builder();
                params.put((Object)"customer_id", (Object)String.valueOf(request.getCustomerId()));
                return params.build();
            }
        }).build();
        this.getCustomerAssetCallable = callableFactory.createUnaryCallable(getCustomerAssetTransportSettings, settings.getCustomerAssetSettings(), clientContext);
        this.mutateCustomerAssetsCallable = callableFactory.createUnaryCallable(mutateCustomerAssetsTransportSettings, settings.mutateCustomerAssetsSettings(), clientContext);
        this.backgroundResources = new BackgroundResourceAggregation(clientContext.getBackgroundResources());
    }

    public GrpcOperationsStub getOperationsStub() {
        return this.operationsStub;
    }

    @Override
    public UnaryCallable<GetCustomerAssetRequest, CustomerAsset> getCustomerAssetCallable() {
        return this.getCustomerAssetCallable;
    }

    @Override
    public UnaryCallable<MutateCustomerAssetsRequest, MutateCustomerAssetsResponse> mutateCustomerAssetsCallable() {
        return this.mutateCustomerAssetsCallable;
    }

    @Override
    public final void close() {
        this.shutdown();
    }

    public void shutdown() {
        this.backgroundResources.shutdown();
    }

    public boolean isShutdown() {
        return this.backgroundResources.isShutdown();
    }

    public boolean isTerminated() {
        return this.backgroundResources.isTerminated();
    }

    public void shutdownNow() {
        this.backgroundResources.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.backgroundResources.awaitTermination(duration, unit);
    }
}

