/*
 * Decompiled with CFR 0.152.
 */
package com.google.ads.googleads.v8.services.stub;

import com.google.ads.googleads.v8.resources.CustomerClientLink;
import com.google.ads.googleads.v8.services.GetCustomerClientLinkRequest;
import com.google.ads.googleads.v8.services.MutateCustomerClientLinkRequest;
import com.google.ads.googleads.v8.services.MutateCustomerClientLinkResponse;
import com.google.ads.googleads.v8.services.stub.CustomerClientLinkServiceStub;
import com.google.ads.googleads.v8.services.stub.CustomerClientLinkServiceStubSettings;
import com.google.ads.googleads.v8.services.stub.GrpcCustomerClientLinkServiceCallableFactory;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.core.BackgroundResourceAggregation;
import com.google.api.gax.grpc.GrpcCallSettings;
import com.google.api.gax.grpc.GrpcStubCallableFactory;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.RequestParamsExtractor;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.common.collect.ImmutableMap;
import com.google.longrunning.stub.GrpcOperationsStub;
import com.google.protobuf.Message;
import io.grpc.MethodDescriptor;
import io.grpc.protobuf.ProtoUtils;
import java.io.IOException;
import java.util.Map;
import java.util.concurrent.TimeUnit;

public class GrpcCustomerClientLinkServiceStub
extends CustomerClientLinkServiceStub {
    private static final MethodDescriptor<GetCustomerClientLinkRequest, CustomerClientLink> getCustomerClientLinkMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.ads.googleads.v8.services.CustomerClientLinkService/GetCustomerClientLink").setRequestMarshaller(ProtoUtils.marshaller((Message)GetCustomerClientLinkRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)CustomerClientLink.getDefaultInstance())).build();
    private static final MethodDescriptor<MutateCustomerClientLinkRequest, MutateCustomerClientLinkResponse> mutateCustomerClientLinkMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.ads.googleads.v8.services.CustomerClientLinkService/MutateCustomerClientLink").setRequestMarshaller(ProtoUtils.marshaller((Message)MutateCustomerClientLinkRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)MutateCustomerClientLinkResponse.getDefaultInstance())).build();
    private final UnaryCallable<GetCustomerClientLinkRequest, CustomerClientLink> getCustomerClientLinkCallable;
    private final UnaryCallable<MutateCustomerClientLinkRequest, MutateCustomerClientLinkResponse> mutateCustomerClientLinkCallable;
    private final BackgroundResource backgroundResources;
    private final GrpcOperationsStub operationsStub;
    private final GrpcStubCallableFactory callableFactory;

    public static final GrpcCustomerClientLinkServiceStub create(CustomerClientLinkServiceStubSettings settings) throws IOException {
        return new GrpcCustomerClientLinkServiceStub(settings, ClientContext.create((StubSettings)settings));
    }

    public static final GrpcCustomerClientLinkServiceStub create(ClientContext clientContext) throws IOException {
        return new GrpcCustomerClientLinkServiceStub(CustomerClientLinkServiceStubSettings.newBuilder().build(), clientContext);
    }

    public static final GrpcCustomerClientLinkServiceStub create(ClientContext clientContext, GrpcStubCallableFactory callableFactory) throws IOException {
        return new GrpcCustomerClientLinkServiceStub(CustomerClientLinkServiceStubSettings.newBuilder().build(), clientContext, callableFactory);
    }

    protected GrpcCustomerClientLinkServiceStub(CustomerClientLinkServiceStubSettings settings, ClientContext clientContext) throws IOException {
        this(settings, clientContext, new GrpcCustomerClientLinkServiceCallableFactory());
    }

    protected GrpcCustomerClientLinkServiceStub(CustomerClientLinkServiceStubSettings settings, ClientContext clientContext, GrpcStubCallableFactory callableFactory) throws IOException {
        this.callableFactory = callableFactory;
        this.operationsStub = GrpcOperationsStub.create((ClientContext)clientContext, (GrpcStubCallableFactory)callableFactory);
        GrpcCallSettings getCustomerClientLinkTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(getCustomerClientLinkMethodDescriptor).setParamsExtractor((RequestParamsExtractor)new RequestParamsExtractor<GetCustomerClientLinkRequest>(){

            public Map<String, String> extract(GetCustomerClientLinkRequest request) {
                ImmutableMap.Builder params = ImmutableMap.builder();
                params.put((Object)"resource_name", (Object)String.valueOf(request.getResourceName()));
                return params.build();
            }
        }).build();
        GrpcCallSettings mutateCustomerClientLinkTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(mutateCustomerClientLinkMethodDescriptor).setParamsExtractor((RequestParamsExtractor)new RequestParamsExtractor<MutateCustomerClientLinkRequest>(){

            public Map<String, String> extract(MutateCustomerClientLinkRequest request) {
                ImmutableMap.Builder params = ImmutableMap.builder();
                params.put((Object)"customer_id", (Object)String.valueOf(request.getCustomerId()));
                return params.build();
            }
        }).build();
        this.getCustomerClientLinkCallable = callableFactory.createUnaryCallable(getCustomerClientLinkTransportSettings, settings.getCustomerClientLinkSettings(), clientContext);
        this.mutateCustomerClientLinkCallable = callableFactory.createUnaryCallable(mutateCustomerClientLinkTransportSettings, settings.mutateCustomerClientLinkSettings(), clientContext);
        this.backgroundResources = new BackgroundResourceAggregation(clientContext.getBackgroundResources());
    }

    public GrpcOperationsStub getOperationsStub() {
        return this.operationsStub;
    }

    @Override
    public UnaryCallable<GetCustomerClientLinkRequest, CustomerClientLink> getCustomerClientLinkCallable() {
        return this.getCustomerClientLinkCallable;
    }

    @Override
    public UnaryCallable<MutateCustomerClientLinkRequest, MutateCustomerClientLinkResponse> mutateCustomerClientLinkCallable() {
        return this.mutateCustomerClientLinkCallable;
    }

    @Override
    public final void close() {
        this.shutdown();
    }

    public void shutdown() {
        this.backgroundResources.shutdown();
    }

    public boolean isShutdown() {
        return this.backgroundResources.isShutdown();
    }

    public boolean isTerminated() {
        return this.backgroundResources.isTerminated();
    }

    public void shutdownNow() {
        this.backgroundResources.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.backgroundResources.awaitTermination(duration, unit);
    }
}

