/*
 * Decompiled with CFR 0.152.
 */
package com.google.ads.googleads.v8.services.stub;

import com.google.ads.googleads.v8.resources.FeedItemSetLink;
import com.google.ads.googleads.v8.services.GetFeedItemSetLinkRequest;
import com.google.ads.googleads.v8.services.MutateFeedItemSetLinksRequest;
import com.google.ads.googleads.v8.services.MutateFeedItemSetLinksResponse;
import com.google.ads.googleads.v8.services.stub.FeedItemSetLinkServiceStub;
import com.google.ads.googleads.v8.services.stub.FeedItemSetLinkServiceStubSettings;
import com.google.ads.googleads.v8.services.stub.GrpcFeedItemSetLinkServiceCallableFactory;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.core.BackgroundResourceAggregation;
import com.google.api.gax.grpc.GrpcCallSettings;
import com.google.api.gax.grpc.GrpcStubCallableFactory;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.RequestParamsExtractor;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.common.collect.ImmutableMap;
import com.google.longrunning.stub.GrpcOperationsStub;
import com.google.protobuf.Message;
import io.grpc.MethodDescriptor;
import io.grpc.protobuf.ProtoUtils;
import java.io.IOException;
import java.util.Map;
import java.util.concurrent.TimeUnit;

public class GrpcFeedItemSetLinkServiceStub
extends FeedItemSetLinkServiceStub {
    private static final MethodDescriptor<GetFeedItemSetLinkRequest, FeedItemSetLink> getFeedItemSetLinkMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.ads.googleads.v8.services.FeedItemSetLinkService/GetFeedItemSetLink").setRequestMarshaller(ProtoUtils.marshaller((Message)GetFeedItemSetLinkRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)FeedItemSetLink.getDefaultInstance())).build();
    private static final MethodDescriptor<MutateFeedItemSetLinksRequest, MutateFeedItemSetLinksResponse> mutateFeedItemSetLinksMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.ads.googleads.v8.services.FeedItemSetLinkService/MutateFeedItemSetLinks").setRequestMarshaller(ProtoUtils.marshaller((Message)MutateFeedItemSetLinksRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)MutateFeedItemSetLinksResponse.getDefaultInstance())).build();
    private final UnaryCallable<GetFeedItemSetLinkRequest, FeedItemSetLink> getFeedItemSetLinkCallable;
    private final UnaryCallable<MutateFeedItemSetLinksRequest, MutateFeedItemSetLinksResponse> mutateFeedItemSetLinksCallable;
    private final BackgroundResource backgroundResources;
    private final GrpcOperationsStub operationsStub;
    private final GrpcStubCallableFactory callableFactory;

    public static final GrpcFeedItemSetLinkServiceStub create(FeedItemSetLinkServiceStubSettings settings) throws IOException {
        return new GrpcFeedItemSetLinkServiceStub(settings, ClientContext.create((StubSettings)settings));
    }

    public static final GrpcFeedItemSetLinkServiceStub create(ClientContext clientContext) throws IOException {
        return new GrpcFeedItemSetLinkServiceStub(FeedItemSetLinkServiceStubSettings.newBuilder().build(), clientContext);
    }

    public static final GrpcFeedItemSetLinkServiceStub create(ClientContext clientContext, GrpcStubCallableFactory callableFactory) throws IOException {
        return new GrpcFeedItemSetLinkServiceStub(FeedItemSetLinkServiceStubSettings.newBuilder().build(), clientContext, callableFactory);
    }

    protected GrpcFeedItemSetLinkServiceStub(FeedItemSetLinkServiceStubSettings settings, ClientContext clientContext) throws IOException {
        this(settings, clientContext, new GrpcFeedItemSetLinkServiceCallableFactory());
    }

    protected GrpcFeedItemSetLinkServiceStub(FeedItemSetLinkServiceStubSettings settings, ClientContext clientContext, GrpcStubCallableFactory callableFactory) throws IOException {
        this.callableFactory = callableFactory;
        this.operationsStub = GrpcOperationsStub.create((ClientContext)clientContext, (GrpcStubCallableFactory)callableFactory);
        GrpcCallSettings getFeedItemSetLinkTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(getFeedItemSetLinkMethodDescriptor).setParamsExtractor((RequestParamsExtractor)new RequestParamsExtractor<GetFeedItemSetLinkRequest>(){

            public Map<String, String> extract(GetFeedItemSetLinkRequest request) {
                ImmutableMap.Builder params = ImmutableMap.builder();
                params.put((Object)"resource_name", (Object)String.valueOf(request.getResourceName()));
                return params.build();
            }
        }).build();
        GrpcCallSettings mutateFeedItemSetLinksTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(mutateFeedItemSetLinksMethodDescriptor).setParamsExtractor((RequestParamsExtractor)new RequestParamsExtractor<MutateFeedItemSetLinksRequest>(){

            public Map<String, String> extract(MutateFeedItemSetLinksRequest request) {
                ImmutableMap.Builder params = ImmutableMap.builder();
                params.put((Object)"customer_id", (Object)String.valueOf(request.getCustomerId()));
                return params.build();
            }
        }).build();
        this.getFeedItemSetLinkCallable = callableFactory.createUnaryCallable(getFeedItemSetLinkTransportSettings, settings.getFeedItemSetLinkSettings(), clientContext);
        this.mutateFeedItemSetLinksCallable = callableFactory.createUnaryCallable(mutateFeedItemSetLinksTransportSettings, settings.mutateFeedItemSetLinksSettings(), clientContext);
        this.backgroundResources = new BackgroundResourceAggregation(clientContext.getBackgroundResources());
    }

    public GrpcOperationsStub getOperationsStub() {
        return this.operationsStub;
    }

    @Override
    public UnaryCallable<GetFeedItemSetLinkRequest, FeedItemSetLink> getFeedItemSetLinkCallable() {
        return this.getFeedItemSetLinkCallable;
    }

    @Override
    public UnaryCallable<MutateFeedItemSetLinksRequest, MutateFeedItemSetLinksResponse> mutateFeedItemSetLinksCallable() {
        return this.mutateFeedItemSetLinksCallable;
    }

    @Override
    public final void close() {
        this.shutdown();
    }

    public void shutdown() {
        this.backgroundResources.shutdown();
    }

    public boolean isShutdown() {
        return this.backgroundResources.isShutdown();
    }

    public boolean isTerminated() {
        return this.backgroundResources.isTerminated();
    }

    public void shutdownNow() {
        this.backgroundResources.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.backgroundResources.awaitTermination(duration, unit);
    }
}

