/*
 * Decompiled with CFR 0.152.
 */
package com.google.ads.googleads.v8.services.stub;

import com.google.ads.googleads.v8.resources.FeedItemTarget;
import com.google.ads.googleads.v8.services.GetFeedItemTargetRequest;
import com.google.ads.googleads.v8.services.MutateFeedItemTargetsRequest;
import com.google.ads.googleads.v8.services.MutateFeedItemTargetsResponse;
import com.google.ads.googleads.v8.services.stub.FeedItemTargetServiceStub;
import com.google.ads.googleads.v8.services.stub.FeedItemTargetServiceStubSettings;
import com.google.ads.googleads.v8.services.stub.GrpcFeedItemTargetServiceCallableFactory;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.core.BackgroundResourceAggregation;
import com.google.api.gax.grpc.GrpcCallSettings;
import com.google.api.gax.grpc.GrpcStubCallableFactory;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.RequestParamsExtractor;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.common.collect.ImmutableMap;
import com.google.longrunning.stub.GrpcOperationsStub;
import com.google.protobuf.Message;
import io.grpc.MethodDescriptor;
import io.grpc.protobuf.ProtoUtils;
import java.io.IOException;
import java.util.Map;
import java.util.concurrent.TimeUnit;

public class GrpcFeedItemTargetServiceStub
extends FeedItemTargetServiceStub {
    private static final MethodDescriptor<GetFeedItemTargetRequest, FeedItemTarget> getFeedItemTargetMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.ads.googleads.v8.services.FeedItemTargetService/GetFeedItemTarget").setRequestMarshaller(ProtoUtils.marshaller((Message)GetFeedItemTargetRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)FeedItemTarget.getDefaultInstance())).build();
    private static final MethodDescriptor<MutateFeedItemTargetsRequest, MutateFeedItemTargetsResponse> mutateFeedItemTargetsMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.ads.googleads.v8.services.FeedItemTargetService/MutateFeedItemTargets").setRequestMarshaller(ProtoUtils.marshaller((Message)MutateFeedItemTargetsRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)MutateFeedItemTargetsResponse.getDefaultInstance())).build();
    private final UnaryCallable<GetFeedItemTargetRequest, FeedItemTarget> getFeedItemTargetCallable;
    private final UnaryCallable<MutateFeedItemTargetsRequest, MutateFeedItemTargetsResponse> mutateFeedItemTargetsCallable;
    private final BackgroundResource backgroundResources;
    private final GrpcOperationsStub operationsStub;
    private final GrpcStubCallableFactory callableFactory;

    public static final GrpcFeedItemTargetServiceStub create(FeedItemTargetServiceStubSettings settings) throws IOException {
        return new GrpcFeedItemTargetServiceStub(settings, ClientContext.create((StubSettings)settings));
    }

    public static final GrpcFeedItemTargetServiceStub create(ClientContext clientContext) throws IOException {
        return new GrpcFeedItemTargetServiceStub(FeedItemTargetServiceStubSettings.newBuilder().build(), clientContext);
    }

    public static final GrpcFeedItemTargetServiceStub create(ClientContext clientContext, GrpcStubCallableFactory callableFactory) throws IOException {
        return new GrpcFeedItemTargetServiceStub(FeedItemTargetServiceStubSettings.newBuilder().build(), clientContext, callableFactory);
    }

    protected GrpcFeedItemTargetServiceStub(FeedItemTargetServiceStubSettings settings, ClientContext clientContext) throws IOException {
        this(settings, clientContext, new GrpcFeedItemTargetServiceCallableFactory());
    }

    protected GrpcFeedItemTargetServiceStub(FeedItemTargetServiceStubSettings settings, ClientContext clientContext, GrpcStubCallableFactory callableFactory) throws IOException {
        this.callableFactory = callableFactory;
        this.operationsStub = GrpcOperationsStub.create((ClientContext)clientContext, (GrpcStubCallableFactory)callableFactory);
        GrpcCallSettings getFeedItemTargetTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(getFeedItemTargetMethodDescriptor).setParamsExtractor((RequestParamsExtractor)new RequestParamsExtractor<GetFeedItemTargetRequest>(){

            public Map<String, String> extract(GetFeedItemTargetRequest request) {
                ImmutableMap.Builder params = ImmutableMap.builder();
                params.put((Object)"resource_name", (Object)String.valueOf(request.getResourceName()));
                return params.build();
            }
        }).build();
        GrpcCallSettings mutateFeedItemTargetsTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(mutateFeedItemTargetsMethodDescriptor).setParamsExtractor((RequestParamsExtractor)new RequestParamsExtractor<MutateFeedItemTargetsRequest>(){

            public Map<String, String> extract(MutateFeedItemTargetsRequest request) {
                ImmutableMap.Builder params = ImmutableMap.builder();
                params.put((Object)"customer_id", (Object)String.valueOf(request.getCustomerId()));
                return params.build();
            }
        }).build();
        this.getFeedItemTargetCallable = callableFactory.createUnaryCallable(getFeedItemTargetTransportSettings, settings.getFeedItemTargetSettings(), clientContext);
        this.mutateFeedItemTargetsCallable = callableFactory.createUnaryCallable(mutateFeedItemTargetsTransportSettings, settings.mutateFeedItemTargetsSettings(), clientContext);
        this.backgroundResources = new BackgroundResourceAggregation(clientContext.getBackgroundResources());
    }

    public GrpcOperationsStub getOperationsStub() {
        return this.operationsStub;
    }

    @Override
    public UnaryCallable<GetFeedItemTargetRequest, FeedItemTarget> getFeedItemTargetCallable() {
        return this.getFeedItemTargetCallable;
    }

    @Override
    public UnaryCallable<MutateFeedItemTargetsRequest, MutateFeedItemTargetsResponse> mutateFeedItemTargetsCallable() {
        return this.mutateFeedItemTargetsCallable;
    }

    @Override
    public final void close() {
        this.shutdown();
    }

    public void shutdown() {
        this.backgroundResources.shutdown();
    }

    public boolean isShutdown() {
        return this.backgroundResources.isShutdown();
    }

    public boolean isTerminated() {
        return this.backgroundResources.isTerminated();
    }

    public void shutdownNow() {
        this.backgroundResources.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.backgroundResources.awaitTermination(duration, unit);
    }
}

