/*
 * Decompiled with CFR 0.152.
 */
package com.google.ads.googleads.v8.services.stub;

import com.google.ads.googleads.v8.resources.KeywordView;
import com.google.ads.googleads.v8.services.GetKeywordViewRequest;
import com.google.ads.googleads.v8.services.stub.GrpcKeywordViewServiceCallableFactory;
import com.google.ads.googleads.v8.services.stub.KeywordViewServiceStub;
import com.google.ads.googleads.v8.services.stub.KeywordViewServiceStubSettings;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.core.BackgroundResourceAggregation;
import com.google.api.gax.grpc.GrpcCallSettings;
import com.google.api.gax.grpc.GrpcStubCallableFactory;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.RequestParamsExtractor;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.common.collect.ImmutableMap;
import com.google.longrunning.stub.GrpcOperationsStub;
import com.google.protobuf.Message;
import io.grpc.MethodDescriptor;
import io.grpc.protobuf.ProtoUtils;
import java.io.IOException;
import java.util.Map;
import java.util.concurrent.TimeUnit;

public class GrpcKeywordViewServiceStub
extends KeywordViewServiceStub {
    private static final MethodDescriptor<GetKeywordViewRequest, KeywordView> getKeywordViewMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.ads.googleads.v8.services.KeywordViewService/GetKeywordView").setRequestMarshaller(ProtoUtils.marshaller((Message)GetKeywordViewRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)KeywordView.getDefaultInstance())).build();
    private final UnaryCallable<GetKeywordViewRequest, KeywordView> getKeywordViewCallable;
    private final BackgroundResource backgroundResources;
    private final GrpcOperationsStub operationsStub;
    private final GrpcStubCallableFactory callableFactory;

    public static final GrpcKeywordViewServiceStub create(KeywordViewServiceStubSettings settings) throws IOException {
        return new GrpcKeywordViewServiceStub(settings, ClientContext.create((StubSettings)settings));
    }

    public static final GrpcKeywordViewServiceStub create(ClientContext clientContext) throws IOException {
        return new GrpcKeywordViewServiceStub(KeywordViewServiceStubSettings.newBuilder().build(), clientContext);
    }

    public static final GrpcKeywordViewServiceStub create(ClientContext clientContext, GrpcStubCallableFactory callableFactory) throws IOException {
        return new GrpcKeywordViewServiceStub(KeywordViewServiceStubSettings.newBuilder().build(), clientContext, callableFactory);
    }

    protected GrpcKeywordViewServiceStub(KeywordViewServiceStubSettings settings, ClientContext clientContext) throws IOException {
        this(settings, clientContext, new GrpcKeywordViewServiceCallableFactory());
    }

    protected GrpcKeywordViewServiceStub(KeywordViewServiceStubSettings settings, ClientContext clientContext, GrpcStubCallableFactory callableFactory) throws IOException {
        this.callableFactory = callableFactory;
        this.operationsStub = GrpcOperationsStub.create((ClientContext)clientContext, (GrpcStubCallableFactory)callableFactory);
        GrpcCallSettings getKeywordViewTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(getKeywordViewMethodDescriptor).setParamsExtractor((RequestParamsExtractor)new RequestParamsExtractor<GetKeywordViewRequest>(){

            public Map<String, String> extract(GetKeywordViewRequest request) {
                ImmutableMap.Builder params = ImmutableMap.builder();
                params.put((Object)"resource_name", (Object)String.valueOf(request.getResourceName()));
                return params.build();
            }
        }).build();
        this.getKeywordViewCallable = callableFactory.createUnaryCallable(getKeywordViewTransportSettings, settings.getKeywordViewSettings(), clientContext);
        this.backgroundResources = new BackgroundResourceAggregation(clientContext.getBackgroundResources());
    }

    public GrpcOperationsStub getOperationsStub() {
        return this.operationsStub;
    }

    @Override
    public UnaryCallable<GetKeywordViewRequest, KeywordView> getKeywordViewCallable() {
        return this.getKeywordViewCallable;
    }

    @Override
    public final void close() {
        this.shutdown();
    }

    public void shutdown() {
        this.backgroundResources.shutdown();
    }

    public boolean isShutdown() {
        return this.backgroundResources.isShutdown();
    }

    public boolean isTerminated() {
        return this.backgroundResources.isTerminated();
    }

    public void shutdownNow() {
        this.backgroundResources.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.backgroundResources.awaitTermination(duration, unit);
    }
}

