/*
 * Decompiled with CFR 0.152.
 */
package com.google.ads.googleads.v8.services.stub;

import com.google.ads.googleads.v8.resources.LocationView;
import com.google.ads.googleads.v8.services.GetLocationViewRequest;
import com.google.ads.googleads.v8.services.stub.GrpcLocationViewServiceCallableFactory;
import com.google.ads.googleads.v8.services.stub.LocationViewServiceStub;
import com.google.ads.googleads.v8.services.stub.LocationViewServiceStubSettings;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.core.BackgroundResourceAggregation;
import com.google.api.gax.grpc.GrpcCallSettings;
import com.google.api.gax.grpc.GrpcStubCallableFactory;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.RequestParamsExtractor;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.common.collect.ImmutableMap;
import com.google.longrunning.stub.GrpcOperationsStub;
import com.google.protobuf.Message;
import io.grpc.MethodDescriptor;
import io.grpc.protobuf.ProtoUtils;
import java.io.IOException;
import java.util.Map;
import java.util.concurrent.TimeUnit;

public class GrpcLocationViewServiceStub
extends LocationViewServiceStub {
    private static final MethodDescriptor<GetLocationViewRequest, LocationView> getLocationViewMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.ads.googleads.v8.services.LocationViewService/GetLocationView").setRequestMarshaller(ProtoUtils.marshaller((Message)GetLocationViewRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)LocationView.getDefaultInstance())).build();
    private final UnaryCallable<GetLocationViewRequest, LocationView> getLocationViewCallable;
    private final BackgroundResource backgroundResources;
    private final GrpcOperationsStub operationsStub;
    private final GrpcStubCallableFactory callableFactory;

    public static final GrpcLocationViewServiceStub create(LocationViewServiceStubSettings settings) throws IOException {
        return new GrpcLocationViewServiceStub(settings, ClientContext.create((StubSettings)settings));
    }

    public static final GrpcLocationViewServiceStub create(ClientContext clientContext) throws IOException {
        return new GrpcLocationViewServiceStub(LocationViewServiceStubSettings.newBuilder().build(), clientContext);
    }

    public static final GrpcLocationViewServiceStub create(ClientContext clientContext, GrpcStubCallableFactory callableFactory) throws IOException {
        return new GrpcLocationViewServiceStub(LocationViewServiceStubSettings.newBuilder().build(), clientContext, callableFactory);
    }

    protected GrpcLocationViewServiceStub(LocationViewServiceStubSettings settings, ClientContext clientContext) throws IOException {
        this(settings, clientContext, new GrpcLocationViewServiceCallableFactory());
    }

    protected GrpcLocationViewServiceStub(LocationViewServiceStubSettings settings, ClientContext clientContext, GrpcStubCallableFactory callableFactory) throws IOException {
        this.callableFactory = callableFactory;
        this.operationsStub = GrpcOperationsStub.create((ClientContext)clientContext, (GrpcStubCallableFactory)callableFactory);
        GrpcCallSettings getLocationViewTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(getLocationViewMethodDescriptor).setParamsExtractor((RequestParamsExtractor)new RequestParamsExtractor<GetLocationViewRequest>(){

            public Map<String, String> extract(GetLocationViewRequest request) {
                ImmutableMap.Builder params = ImmutableMap.builder();
                params.put((Object)"resource_name", (Object)String.valueOf(request.getResourceName()));
                return params.build();
            }
        }).build();
        this.getLocationViewCallable = callableFactory.createUnaryCallable(getLocationViewTransportSettings, settings.getLocationViewSettings(), clientContext);
        this.backgroundResources = new BackgroundResourceAggregation(clientContext.getBackgroundResources());
    }

    public GrpcOperationsStub getOperationsStub() {
        return this.operationsStub;
    }

    @Override
    public UnaryCallable<GetLocationViewRequest, LocationView> getLocationViewCallable() {
        return this.getLocationViewCallable;
    }

    @Override
    public final void close() {
        this.shutdown();
    }

    public void shutdown() {
        this.backgroundResources.shutdown();
    }

    public boolean isShutdown() {
        return this.backgroundResources.isShutdown();
    }

    public boolean isTerminated() {
        return this.backgroundResources.isTerminated();
    }

    public void shutdownNow() {
        this.backgroundResources.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.backgroundResources.awaitTermination(duration, unit);
    }
}

