/*
 * Decompiled with CFR 0.152.
 */
package com.google.ads.googleads.v8.services.stub;

import com.google.ads.googleads.v8.services.GenerateProductMixIdeasRequest;
import com.google.ads.googleads.v8.services.GenerateProductMixIdeasResponse;
import com.google.ads.googleads.v8.services.GenerateReachForecastRequest;
import com.google.ads.googleads.v8.services.GenerateReachForecastResponse;
import com.google.ads.googleads.v8.services.ListPlannableLocationsRequest;
import com.google.ads.googleads.v8.services.ListPlannableLocationsResponse;
import com.google.ads.googleads.v8.services.ListPlannableProductsRequest;
import com.google.ads.googleads.v8.services.ListPlannableProductsResponse;
import com.google.ads.googleads.v8.services.stub.GrpcReachPlanServiceCallableFactory;
import com.google.ads.googleads.v8.services.stub.ReachPlanServiceStub;
import com.google.ads.googleads.v8.services.stub.ReachPlanServiceStubSettings;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.core.BackgroundResourceAggregation;
import com.google.api.gax.grpc.GrpcCallSettings;
import com.google.api.gax.grpc.GrpcStubCallableFactory;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.RequestParamsExtractor;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.common.collect.ImmutableMap;
import com.google.longrunning.stub.GrpcOperationsStub;
import com.google.protobuf.Message;
import io.grpc.MethodDescriptor;
import io.grpc.protobuf.ProtoUtils;
import java.io.IOException;
import java.util.Map;
import java.util.concurrent.TimeUnit;

public class GrpcReachPlanServiceStub
extends ReachPlanServiceStub {
    private static final MethodDescriptor<ListPlannableLocationsRequest, ListPlannableLocationsResponse> listPlannableLocationsMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.ads.googleads.v8.services.ReachPlanService/ListPlannableLocations").setRequestMarshaller(ProtoUtils.marshaller((Message)ListPlannableLocationsRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)ListPlannableLocationsResponse.getDefaultInstance())).build();
    private static final MethodDescriptor<ListPlannableProductsRequest, ListPlannableProductsResponse> listPlannableProductsMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.ads.googleads.v8.services.ReachPlanService/ListPlannableProducts").setRequestMarshaller(ProtoUtils.marshaller((Message)ListPlannableProductsRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)ListPlannableProductsResponse.getDefaultInstance())).build();
    private static final MethodDescriptor<GenerateProductMixIdeasRequest, GenerateProductMixIdeasResponse> generateProductMixIdeasMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.ads.googleads.v8.services.ReachPlanService/GenerateProductMixIdeas").setRequestMarshaller(ProtoUtils.marshaller((Message)GenerateProductMixIdeasRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)GenerateProductMixIdeasResponse.getDefaultInstance())).build();
    private static final MethodDescriptor<GenerateReachForecastRequest, GenerateReachForecastResponse> generateReachForecastMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.ads.googleads.v8.services.ReachPlanService/GenerateReachForecast").setRequestMarshaller(ProtoUtils.marshaller((Message)GenerateReachForecastRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)GenerateReachForecastResponse.getDefaultInstance())).build();
    private final UnaryCallable<ListPlannableLocationsRequest, ListPlannableLocationsResponse> listPlannableLocationsCallable;
    private final UnaryCallable<ListPlannableProductsRequest, ListPlannableProductsResponse> listPlannableProductsCallable;
    private final UnaryCallable<GenerateProductMixIdeasRequest, GenerateProductMixIdeasResponse> generateProductMixIdeasCallable;
    private final UnaryCallable<GenerateReachForecastRequest, GenerateReachForecastResponse> generateReachForecastCallable;
    private final BackgroundResource backgroundResources;
    private final GrpcOperationsStub operationsStub;
    private final GrpcStubCallableFactory callableFactory;

    public static final GrpcReachPlanServiceStub create(ReachPlanServiceStubSettings settings) throws IOException {
        return new GrpcReachPlanServiceStub(settings, ClientContext.create((StubSettings)settings));
    }

    public static final GrpcReachPlanServiceStub create(ClientContext clientContext) throws IOException {
        return new GrpcReachPlanServiceStub(ReachPlanServiceStubSettings.newBuilder().build(), clientContext);
    }

    public static final GrpcReachPlanServiceStub create(ClientContext clientContext, GrpcStubCallableFactory callableFactory) throws IOException {
        return new GrpcReachPlanServiceStub(ReachPlanServiceStubSettings.newBuilder().build(), clientContext, callableFactory);
    }

    protected GrpcReachPlanServiceStub(ReachPlanServiceStubSettings settings, ClientContext clientContext) throws IOException {
        this(settings, clientContext, new GrpcReachPlanServiceCallableFactory());
    }

    protected GrpcReachPlanServiceStub(ReachPlanServiceStubSettings settings, ClientContext clientContext, GrpcStubCallableFactory callableFactory) throws IOException {
        this.callableFactory = callableFactory;
        this.operationsStub = GrpcOperationsStub.create((ClientContext)clientContext, (GrpcStubCallableFactory)callableFactory);
        GrpcCallSettings listPlannableLocationsTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(listPlannableLocationsMethodDescriptor).build();
        GrpcCallSettings listPlannableProductsTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(listPlannableProductsMethodDescriptor).build();
        GrpcCallSettings generateProductMixIdeasTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(generateProductMixIdeasMethodDescriptor).setParamsExtractor((RequestParamsExtractor)new RequestParamsExtractor<GenerateProductMixIdeasRequest>(){

            public Map<String, String> extract(GenerateProductMixIdeasRequest request) {
                ImmutableMap.Builder params = ImmutableMap.builder();
                params.put((Object)"customer_id", (Object)String.valueOf(request.getCustomerId()));
                return params.build();
            }
        }).build();
        GrpcCallSettings generateReachForecastTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(generateReachForecastMethodDescriptor).setParamsExtractor((RequestParamsExtractor)new RequestParamsExtractor<GenerateReachForecastRequest>(){

            public Map<String, String> extract(GenerateReachForecastRequest request) {
                ImmutableMap.Builder params = ImmutableMap.builder();
                params.put((Object)"customer_id", (Object)String.valueOf(request.getCustomerId()));
                return params.build();
            }
        }).build();
        this.listPlannableLocationsCallable = callableFactory.createUnaryCallable(listPlannableLocationsTransportSettings, settings.listPlannableLocationsSettings(), clientContext);
        this.listPlannableProductsCallable = callableFactory.createUnaryCallable(listPlannableProductsTransportSettings, settings.listPlannableProductsSettings(), clientContext);
        this.generateProductMixIdeasCallable = callableFactory.createUnaryCallable(generateProductMixIdeasTransportSettings, settings.generateProductMixIdeasSettings(), clientContext);
        this.generateReachForecastCallable = callableFactory.createUnaryCallable(generateReachForecastTransportSettings, settings.generateReachForecastSettings(), clientContext);
        this.backgroundResources = new BackgroundResourceAggregation(clientContext.getBackgroundResources());
    }

    public GrpcOperationsStub getOperationsStub() {
        return this.operationsStub;
    }

    @Override
    public UnaryCallable<ListPlannableLocationsRequest, ListPlannableLocationsResponse> listPlannableLocationsCallable() {
        return this.listPlannableLocationsCallable;
    }

    @Override
    public UnaryCallable<ListPlannableProductsRequest, ListPlannableProductsResponse> listPlannableProductsCallable() {
        return this.listPlannableProductsCallable;
    }

    @Override
    public UnaryCallable<GenerateProductMixIdeasRequest, GenerateProductMixIdeasResponse> generateProductMixIdeasCallable() {
        return this.generateProductMixIdeasCallable;
    }

    @Override
    public UnaryCallable<GenerateReachForecastRequest, GenerateReachForecastResponse> generateReachForecastCallable() {
        return this.generateReachForecastCallable;
    }

    @Override
    public final void close() {
        this.shutdown();
    }

    public void shutdown() {
        this.backgroundResources.shutdown();
    }

    public boolean isShutdown() {
        return this.backgroundResources.isShutdown();
    }

    public boolean isTerminated() {
        return this.backgroundResources.isTerminated();
    }

    public void shutdownNow() {
        this.backgroundResources.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.backgroundResources.awaitTermination(duration, unit);
    }
}

