/*
 * Decompiled with CFR 0.152.
 */
package com.google.ads.googleads.v8.services.stub;

import com.google.ads.googleads.v8.resources.UserLocationView;
import com.google.ads.googleads.v8.services.GetUserLocationViewRequest;
import com.google.ads.googleads.v8.services.stub.GrpcUserLocationViewServiceCallableFactory;
import com.google.ads.googleads.v8.services.stub.UserLocationViewServiceStub;
import com.google.ads.googleads.v8.services.stub.UserLocationViewServiceStubSettings;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.core.BackgroundResourceAggregation;
import com.google.api.gax.grpc.GrpcCallSettings;
import com.google.api.gax.grpc.GrpcStubCallableFactory;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.RequestParamsExtractor;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.common.collect.ImmutableMap;
import com.google.longrunning.stub.GrpcOperationsStub;
import com.google.protobuf.Message;
import io.grpc.MethodDescriptor;
import io.grpc.protobuf.ProtoUtils;
import java.io.IOException;
import java.util.Map;
import java.util.concurrent.TimeUnit;

public class GrpcUserLocationViewServiceStub
extends UserLocationViewServiceStub {
    private static final MethodDescriptor<GetUserLocationViewRequest, UserLocationView> getUserLocationViewMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.ads.googleads.v8.services.UserLocationViewService/GetUserLocationView").setRequestMarshaller(ProtoUtils.marshaller((Message)GetUserLocationViewRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)UserLocationView.getDefaultInstance())).build();
    private final UnaryCallable<GetUserLocationViewRequest, UserLocationView> getUserLocationViewCallable;
    private final BackgroundResource backgroundResources;
    private final GrpcOperationsStub operationsStub;
    private final GrpcStubCallableFactory callableFactory;

    public static final GrpcUserLocationViewServiceStub create(UserLocationViewServiceStubSettings settings) throws IOException {
        return new GrpcUserLocationViewServiceStub(settings, ClientContext.create((StubSettings)settings));
    }

    public static final GrpcUserLocationViewServiceStub create(ClientContext clientContext) throws IOException {
        return new GrpcUserLocationViewServiceStub(UserLocationViewServiceStubSettings.newBuilder().build(), clientContext);
    }

    public static final GrpcUserLocationViewServiceStub create(ClientContext clientContext, GrpcStubCallableFactory callableFactory) throws IOException {
        return new GrpcUserLocationViewServiceStub(UserLocationViewServiceStubSettings.newBuilder().build(), clientContext, callableFactory);
    }

    protected GrpcUserLocationViewServiceStub(UserLocationViewServiceStubSettings settings, ClientContext clientContext) throws IOException {
        this(settings, clientContext, new GrpcUserLocationViewServiceCallableFactory());
    }

    protected GrpcUserLocationViewServiceStub(UserLocationViewServiceStubSettings settings, ClientContext clientContext, GrpcStubCallableFactory callableFactory) throws IOException {
        this.callableFactory = callableFactory;
        this.operationsStub = GrpcOperationsStub.create((ClientContext)clientContext, (GrpcStubCallableFactory)callableFactory);
        GrpcCallSettings getUserLocationViewTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(getUserLocationViewMethodDescriptor).setParamsExtractor((RequestParamsExtractor)new RequestParamsExtractor<GetUserLocationViewRequest>(){

            public Map<String, String> extract(GetUserLocationViewRequest request) {
                ImmutableMap.Builder params = ImmutableMap.builder();
                params.put((Object)"resource_name", (Object)String.valueOf(request.getResourceName()));
                return params.build();
            }
        }).build();
        this.getUserLocationViewCallable = callableFactory.createUnaryCallable(getUserLocationViewTransportSettings, settings.getUserLocationViewSettings(), clientContext);
        this.backgroundResources = new BackgroundResourceAggregation(clientContext.getBackgroundResources());
    }

    public GrpcOperationsStub getOperationsStub() {
        return this.operationsStub;
    }

    @Override
    public UnaryCallable<GetUserLocationViewRequest, UserLocationView> getUserLocationViewCallable() {
        return this.getUserLocationViewCallable;
    }

    @Override
    public final void close() {
        this.shutdown();
    }

    public void shutdown() {
        this.backgroundResources.shutdown();
    }

    public boolean isShutdown() {
        return this.backgroundResources.isShutdown();
    }

    public boolean isTerminated() {
        return this.backgroundResources.isTerminated();
    }

    public void shutdownNow() {
        this.backgroundResources.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.backgroundResources.awaitTermination(duration, unit);
    }
}

