/*
 * Decompiled with CFR 0.152.
 */
package com.google.ads.googleads.v8.services.stub;

import com.google.ads.googleads.v8.resources.Video;
import com.google.ads.googleads.v8.services.GetVideoRequest;
import com.google.ads.googleads.v8.services.stub.GrpcVideoServiceCallableFactory;
import com.google.ads.googleads.v8.services.stub.VideoServiceStub;
import com.google.ads.googleads.v8.services.stub.VideoServiceStubSettings;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.core.BackgroundResourceAggregation;
import com.google.api.gax.grpc.GrpcCallSettings;
import com.google.api.gax.grpc.GrpcStubCallableFactory;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.RequestParamsExtractor;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.common.collect.ImmutableMap;
import com.google.longrunning.stub.GrpcOperationsStub;
import com.google.protobuf.Message;
import io.grpc.MethodDescriptor;
import io.grpc.protobuf.ProtoUtils;
import java.io.IOException;
import java.util.Map;
import java.util.concurrent.TimeUnit;

public class GrpcVideoServiceStub
extends VideoServiceStub {
    private static final MethodDescriptor<GetVideoRequest, Video> getVideoMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.ads.googleads.v8.services.VideoService/GetVideo").setRequestMarshaller(ProtoUtils.marshaller((Message)GetVideoRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Video.getDefaultInstance())).build();
    private final UnaryCallable<GetVideoRequest, Video> getVideoCallable;
    private final BackgroundResource backgroundResources;
    private final GrpcOperationsStub operationsStub;
    private final GrpcStubCallableFactory callableFactory;

    public static final GrpcVideoServiceStub create(VideoServiceStubSettings settings) throws IOException {
        return new GrpcVideoServiceStub(settings, ClientContext.create((StubSettings)settings));
    }

    public static final GrpcVideoServiceStub create(ClientContext clientContext) throws IOException {
        return new GrpcVideoServiceStub(VideoServiceStubSettings.newBuilder().build(), clientContext);
    }

    public static final GrpcVideoServiceStub create(ClientContext clientContext, GrpcStubCallableFactory callableFactory) throws IOException {
        return new GrpcVideoServiceStub(VideoServiceStubSettings.newBuilder().build(), clientContext, callableFactory);
    }

    protected GrpcVideoServiceStub(VideoServiceStubSettings settings, ClientContext clientContext) throws IOException {
        this(settings, clientContext, new GrpcVideoServiceCallableFactory());
    }

    protected GrpcVideoServiceStub(VideoServiceStubSettings settings, ClientContext clientContext, GrpcStubCallableFactory callableFactory) throws IOException {
        this.callableFactory = callableFactory;
        this.operationsStub = GrpcOperationsStub.create((ClientContext)clientContext, (GrpcStubCallableFactory)callableFactory);
        GrpcCallSettings getVideoTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(getVideoMethodDescriptor).setParamsExtractor((RequestParamsExtractor)new RequestParamsExtractor<GetVideoRequest>(){

            public Map<String, String> extract(GetVideoRequest request) {
                ImmutableMap.Builder params = ImmutableMap.builder();
                params.put((Object)"resource_name", (Object)String.valueOf(request.getResourceName()));
                return params.build();
            }
        }).build();
        this.getVideoCallable = callableFactory.createUnaryCallable(getVideoTransportSettings, settings.getVideoSettings(), clientContext);
        this.backgroundResources = new BackgroundResourceAggregation(clientContext.getBackgroundResources());
    }

    public GrpcOperationsStub getOperationsStub() {
        return this.operationsStub;
    }

    @Override
    public UnaryCallable<GetVideoRequest, Video> getVideoCallable() {
        return this.getVideoCallable;
    }

    @Override
    public final void close() {
        this.shutdown();
    }

    public void shutdown() {
        this.backgroundResources.shutdown();
    }

    public boolean isShutdown() {
        return this.backgroundResources.isShutdown();
    }

    public boolean isTerminated() {
        return this.backgroundResources.isTerminated();
    }

    public void shutdownNow() {
        this.backgroundResources.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.backgroundResources.awaitTermination(duration, unit);
    }
}

