// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/ads/googleads/v8/resources/click_view.proto

package com.google.ads.googleads.v8.resources;

/**
 * <pre>
 * A click view with metrics aggregated at each click level, including both
 * valid and invalid clicks. For non-Search campaigns, metrics.clicks
 * represents the number of valid and invalid interactions.
 * Queries including ClickView must have a filter limiting the results to one
 * day and can be requested for dates back to 90 days before the time of the
 * request.
 * </pre>
 *
 * Protobuf type {@code google.ads.googleads.v8.resources.ClickView}
 */
public final class ClickView extends
    com.google.protobuf.GeneratedMessageV3 implements
    // @@protoc_insertion_point(message_implements:google.ads.googleads.v8.resources.ClickView)
    ClickViewOrBuilder {
private static final long serialVersionUID = 0L;
  // Use ClickView.newBuilder() to construct.
  private ClickView(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }
  private ClickView() {
    resourceName_ = "";
    gclid_ = "";
    adGroupAd_ = "";
    campaignLocationTarget_ = "";
    userList_ = "";
    keyword_ = "";
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(
      UnusedPrivateParameter unused) {
    return new ClickView();
  }

  @java.lang.Override
  public final com.google.protobuf.UnknownFieldSet
  getUnknownFields() {
    return this.unknownFields;
  }
  private ClickView(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    this();
    if (extensionRegistry == null) {
      throw new java.lang.NullPointerException();
    }
    int mutable_bitField0_ = 0;
    com.google.protobuf.UnknownFieldSet.Builder unknownFields =
        com.google.protobuf.UnknownFieldSet.newBuilder();
    try {
      boolean done = false;
      while (!done) {
        int tag = input.readTag();
        switch (tag) {
          case 0:
            done = true;
            break;
          case 10: {
            java.lang.String s = input.readStringRequireUtf8();

            resourceName_ = s;
            break;
          }
          case 26: {
            com.google.ads.googleads.v8.common.ClickLocation.Builder subBuilder = null;
            if (areaOfInterest_ != null) {
              subBuilder = areaOfInterest_.toBuilder();
            }
            areaOfInterest_ = input.readMessage(com.google.ads.googleads.v8.common.ClickLocation.parser(), extensionRegistry);
            if (subBuilder != null) {
              subBuilder.mergeFrom(areaOfInterest_);
              areaOfInterest_ = subBuilder.buildPartial();
            }

            break;
          }
          case 34: {
            com.google.ads.googleads.v8.common.ClickLocation.Builder subBuilder = null;
            if (locationOfPresence_ != null) {
              subBuilder = locationOfPresence_.toBuilder();
            }
            locationOfPresence_ = input.readMessage(com.google.ads.googleads.v8.common.ClickLocation.parser(), extensionRegistry);
            if (subBuilder != null) {
              subBuilder.mergeFrom(locationOfPresence_);
              locationOfPresence_ = subBuilder.buildPartial();
            }

            break;
          }
          case 66: {
            java.lang.String s = input.readStringRequireUtf8();
            bitField0_ |= 0x00000001;
            gclid_ = s;
            break;
          }
          case 72: {
            bitField0_ |= 0x00000002;
            pageNumber_ = input.readInt64();
            break;
          }
          case 82: {
            java.lang.String s = input.readStringRequireUtf8();
            bitField0_ |= 0x00000004;
            adGroupAd_ = s;
            break;
          }
          case 90: {
            java.lang.String s = input.readStringRequireUtf8();
            bitField0_ |= 0x00000008;
            campaignLocationTarget_ = s;
            break;
          }
          case 98: {
            java.lang.String s = input.readStringRequireUtf8();
            bitField0_ |= 0x00000010;
            userList_ = s;
            break;
          }
          case 106: {
            java.lang.String s = input.readStringRequireUtf8();

            keyword_ = s;
            break;
          }
          case 114: {
            com.google.ads.googleads.v8.common.KeywordInfo.Builder subBuilder = null;
            if (keywordInfo_ != null) {
              subBuilder = keywordInfo_.toBuilder();
            }
            keywordInfo_ = input.readMessage(com.google.ads.googleads.v8.common.KeywordInfo.parser(), extensionRegistry);
            if (subBuilder != null) {
              subBuilder.mergeFrom(keywordInfo_);
              keywordInfo_ = subBuilder.buildPartial();
            }

            break;
          }
          default: {
            if (!parseUnknownField(
                input, unknownFields, extensionRegistry, tag)) {
              done = true;
            }
            break;
          }
        }
      }
    } catch (com.google.protobuf.InvalidProtocolBufferException e) {
      throw e.setUnfinishedMessage(this);
    } catch (java.io.IOException e) {
      throw new com.google.protobuf.InvalidProtocolBufferException(
          e).setUnfinishedMessage(this);
    } finally {
      this.unknownFields = unknownFields.build();
      makeExtensionsImmutable();
    }
  }
  public static final com.google.protobuf.Descriptors.Descriptor
      getDescriptor() {
    return com.google.ads.googleads.v8.resources.ClickViewProto.internal_static_google_ads_googleads_v8_resources_ClickView_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.ads.googleads.v8.resources.ClickViewProto.internal_static_google_ads_googleads_v8_resources_ClickView_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.ads.googleads.v8.resources.ClickView.class, com.google.ads.googleads.v8.resources.ClickView.Builder.class);
  }

  private int bitField0_;
  public static final int RESOURCE_NAME_FIELD_NUMBER = 1;
  private volatile java.lang.Object resourceName_;
  /**
   * <pre>
   * Output only. The resource name of the click view.
   * Click view resource names have the form:
   * `customers/{customer_id}/clickViews/{date (yyyy-MM-dd)}~{gclid}`
   * </pre>
   *
   * <code>string resource_name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.resource_reference) = { ... }</code>
   * @return The resourceName.
   */
  @java.lang.Override
  public java.lang.String getResourceName() {
    java.lang.Object ref = resourceName_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = 
          (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      resourceName_ = s;
      return s;
    }
  }
  /**
   * <pre>
   * Output only. The resource name of the click view.
   * Click view resource names have the form:
   * `customers/{customer_id}/clickViews/{date (yyyy-MM-dd)}~{gclid}`
   * </pre>
   *
   * <code>string resource_name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.resource_reference) = { ... }</code>
   * @return The bytes for resourceName.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString
      getResourceNameBytes() {
    java.lang.Object ref = resourceName_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b = 
          com.google.protobuf.ByteString.copyFromUtf8(
              (java.lang.String) ref);
      resourceName_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int GCLID_FIELD_NUMBER = 8;
  private volatile java.lang.Object gclid_;
  /**
   * <pre>
   * Output only. The Google Click ID.
   * </pre>
   *
   * <code>string gclid = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   * @return Whether the gclid field is set.
   */
  @java.lang.Override
  public boolean hasGclid() {
    return ((bitField0_ & 0x00000001) != 0);
  }
  /**
   * <pre>
   * Output only. The Google Click ID.
   * </pre>
   *
   * <code>string gclid = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   * @return The gclid.
   */
  @java.lang.Override
  public java.lang.String getGclid() {
    java.lang.Object ref = gclid_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = 
          (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      gclid_ = s;
      return s;
    }
  }
  /**
   * <pre>
   * Output only. The Google Click ID.
   * </pre>
   *
   * <code>string gclid = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   * @return The bytes for gclid.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString
      getGclidBytes() {
    java.lang.Object ref = gclid_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b = 
          com.google.protobuf.ByteString.copyFromUtf8(
              (java.lang.String) ref);
      gclid_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int AREA_OF_INTEREST_FIELD_NUMBER = 3;
  private com.google.ads.googleads.v8.common.ClickLocation areaOfInterest_;
  /**
   * <pre>
   * Output only. The location criteria matching the area of interest associated with the
   * impression.
   * </pre>
   *
   * <code>.google.ads.googleads.v8.common.ClickLocation area_of_interest = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   * @return Whether the areaOfInterest field is set.
   */
  @java.lang.Override
  public boolean hasAreaOfInterest() {
    return areaOfInterest_ != null;
  }
  /**
   * <pre>
   * Output only. The location criteria matching the area of interest associated with the
   * impression.
   * </pre>
   *
   * <code>.google.ads.googleads.v8.common.ClickLocation area_of_interest = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   * @return The areaOfInterest.
   */
  @java.lang.Override
  public com.google.ads.googleads.v8.common.ClickLocation getAreaOfInterest() {
    return areaOfInterest_ == null ? com.google.ads.googleads.v8.common.ClickLocation.getDefaultInstance() : areaOfInterest_;
  }
  /**
   * <pre>
   * Output only. The location criteria matching the area of interest associated with the
   * impression.
   * </pre>
   *
   * <code>.google.ads.googleads.v8.common.ClickLocation area_of_interest = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   */
  @java.lang.Override
  public com.google.ads.googleads.v8.common.ClickLocationOrBuilder getAreaOfInterestOrBuilder() {
    return getAreaOfInterest();
  }

  public static final int LOCATION_OF_PRESENCE_FIELD_NUMBER = 4;
  private com.google.ads.googleads.v8.common.ClickLocation locationOfPresence_;
  /**
   * <pre>
   * Output only. The location criteria matching the location of presence associated with the
   * impression.
   * </pre>
   *
   * <code>.google.ads.googleads.v8.common.ClickLocation location_of_presence = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   * @return Whether the locationOfPresence field is set.
   */
  @java.lang.Override
  public boolean hasLocationOfPresence() {
    return locationOfPresence_ != null;
  }
  /**
   * <pre>
   * Output only. The location criteria matching the location of presence associated with the
   * impression.
   * </pre>
   *
   * <code>.google.ads.googleads.v8.common.ClickLocation location_of_presence = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   * @return The locationOfPresence.
   */
  @java.lang.Override
  public com.google.ads.googleads.v8.common.ClickLocation getLocationOfPresence() {
    return locationOfPresence_ == null ? com.google.ads.googleads.v8.common.ClickLocation.getDefaultInstance() : locationOfPresence_;
  }
  /**
   * <pre>
   * Output only. The location criteria matching the location of presence associated with the
   * impression.
   * </pre>
   *
   * <code>.google.ads.googleads.v8.common.ClickLocation location_of_presence = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   */
  @java.lang.Override
  public com.google.ads.googleads.v8.common.ClickLocationOrBuilder getLocationOfPresenceOrBuilder() {
    return getLocationOfPresence();
  }

  public static final int PAGE_NUMBER_FIELD_NUMBER = 9;
  private long pageNumber_;
  /**
   * <pre>
   * Output only. Page number in search results where the ad was shown.
   * </pre>
   *
   * <code>int64 page_number = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   * @return Whether the pageNumber field is set.
   */
  @java.lang.Override
  public boolean hasPageNumber() {
    return ((bitField0_ & 0x00000002) != 0);
  }
  /**
   * <pre>
   * Output only. Page number in search results where the ad was shown.
   * </pre>
   *
   * <code>int64 page_number = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   * @return The pageNumber.
   */
  @java.lang.Override
  public long getPageNumber() {
    return pageNumber_;
  }

  public static final int AD_GROUP_AD_FIELD_NUMBER = 10;
  private volatile java.lang.Object adGroupAd_;
  /**
   * <pre>
   * Output only. The associated ad.
   * </pre>
   *
   * <code>string ad_group_ad = 10 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.resource_reference) = { ... }</code>
   * @return Whether the adGroupAd field is set.
   */
  @java.lang.Override
  public boolean hasAdGroupAd() {
    return ((bitField0_ & 0x00000004) != 0);
  }
  /**
   * <pre>
   * Output only. The associated ad.
   * </pre>
   *
   * <code>string ad_group_ad = 10 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.resource_reference) = { ... }</code>
   * @return The adGroupAd.
   */
  @java.lang.Override
  public java.lang.String getAdGroupAd() {
    java.lang.Object ref = adGroupAd_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = 
          (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      adGroupAd_ = s;
      return s;
    }
  }
  /**
   * <pre>
   * Output only. The associated ad.
   * </pre>
   *
   * <code>string ad_group_ad = 10 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.resource_reference) = { ... }</code>
   * @return The bytes for adGroupAd.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString
      getAdGroupAdBytes() {
    java.lang.Object ref = adGroupAd_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b = 
          com.google.protobuf.ByteString.copyFromUtf8(
              (java.lang.String) ref);
      adGroupAd_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int CAMPAIGN_LOCATION_TARGET_FIELD_NUMBER = 11;
  private volatile java.lang.Object campaignLocationTarget_;
  /**
   * <pre>
   * Output only. The associated campaign location target, if one exists.
   * </pre>
   *
   * <code>string campaign_location_target = 11 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.resource_reference) = { ... }</code>
   * @return Whether the campaignLocationTarget field is set.
   */
  @java.lang.Override
  public boolean hasCampaignLocationTarget() {
    return ((bitField0_ & 0x00000008) != 0);
  }
  /**
   * <pre>
   * Output only. The associated campaign location target, if one exists.
   * </pre>
   *
   * <code>string campaign_location_target = 11 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.resource_reference) = { ... }</code>
   * @return The campaignLocationTarget.
   */
  @java.lang.Override
  public java.lang.String getCampaignLocationTarget() {
    java.lang.Object ref = campaignLocationTarget_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = 
          (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      campaignLocationTarget_ = s;
      return s;
    }
  }
  /**
   * <pre>
   * Output only. The associated campaign location target, if one exists.
   * </pre>
   *
   * <code>string campaign_location_target = 11 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.resource_reference) = { ... }</code>
   * @return The bytes for campaignLocationTarget.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString
      getCampaignLocationTargetBytes() {
    java.lang.Object ref = campaignLocationTarget_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b = 
          com.google.protobuf.ByteString.copyFromUtf8(
              (java.lang.String) ref);
      campaignLocationTarget_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int USER_LIST_FIELD_NUMBER = 12;
  private volatile java.lang.Object userList_;
  /**
   * <pre>
   * Output only. The associated user list, if one exists.
   * </pre>
   *
   * <code>string user_list = 12 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.resource_reference) = { ... }</code>
   * @return Whether the userList field is set.
   */
  @java.lang.Override
  public boolean hasUserList() {
    return ((bitField0_ & 0x00000010) != 0);
  }
  /**
   * <pre>
   * Output only. The associated user list, if one exists.
   * </pre>
   *
   * <code>string user_list = 12 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.resource_reference) = { ... }</code>
   * @return The userList.
   */
  @java.lang.Override
  public java.lang.String getUserList() {
    java.lang.Object ref = userList_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = 
          (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      userList_ = s;
      return s;
    }
  }
  /**
   * <pre>
   * Output only. The associated user list, if one exists.
   * </pre>
   *
   * <code>string user_list = 12 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.resource_reference) = { ... }</code>
   * @return The bytes for userList.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString
      getUserListBytes() {
    java.lang.Object ref = userList_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b = 
          com.google.protobuf.ByteString.copyFromUtf8(
              (java.lang.String) ref);
      userList_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int KEYWORD_FIELD_NUMBER = 13;
  private volatile java.lang.Object keyword_;
  /**
   * <pre>
   * Output only. The associated keyword, if one exists and the click corresponds to the
   * SEARCH channel.
   * </pre>
   *
   * <code>string keyword = 13 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.resource_reference) = { ... }</code>
   * @return The keyword.
   */
  @java.lang.Override
  public java.lang.String getKeyword() {
    java.lang.Object ref = keyword_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = 
          (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      keyword_ = s;
      return s;
    }
  }
  /**
   * <pre>
   * Output only. The associated keyword, if one exists and the click corresponds to the
   * SEARCH channel.
   * </pre>
   *
   * <code>string keyword = 13 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.resource_reference) = { ... }</code>
   * @return The bytes for keyword.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString
      getKeywordBytes() {
    java.lang.Object ref = keyword_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b = 
          com.google.protobuf.ByteString.copyFromUtf8(
              (java.lang.String) ref);
      keyword_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int KEYWORD_INFO_FIELD_NUMBER = 14;
  private com.google.ads.googleads.v8.common.KeywordInfo keywordInfo_;
  /**
   * <pre>
   * Output only. Basic information about the associated keyword, if it exists.
   * </pre>
   *
   * <code>.google.ads.googleads.v8.common.KeywordInfo keyword_info = 14 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   * @return Whether the keywordInfo field is set.
   */
  @java.lang.Override
  public boolean hasKeywordInfo() {
    return keywordInfo_ != null;
  }
  /**
   * <pre>
   * Output only. Basic information about the associated keyword, if it exists.
   * </pre>
   *
   * <code>.google.ads.googleads.v8.common.KeywordInfo keyword_info = 14 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   * @return The keywordInfo.
   */
  @java.lang.Override
  public com.google.ads.googleads.v8.common.KeywordInfo getKeywordInfo() {
    return keywordInfo_ == null ? com.google.ads.googleads.v8.common.KeywordInfo.getDefaultInstance() : keywordInfo_;
  }
  /**
   * <pre>
   * Output only. Basic information about the associated keyword, if it exists.
   * </pre>
   *
   * <code>.google.ads.googleads.v8.common.KeywordInfo keyword_info = 14 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   */
  @java.lang.Override
  public com.google.ads.googleads.v8.common.KeywordInfoOrBuilder getKeywordInfoOrBuilder() {
    return getKeywordInfo();
  }

  private byte memoizedIsInitialized = -1;
  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output)
                      throws java.io.IOException {
    if (!getResourceNameBytes().isEmpty()) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, resourceName_);
    }
    if (areaOfInterest_ != null) {
      output.writeMessage(3, getAreaOfInterest());
    }
    if (locationOfPresence_ != null) {
      output.writeMessage(4, getLocationOfPresence());
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 8, gclid_);
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      output.writeInt64(9, pageNumber_);
    }
    if (((bitField0_ & 0x00000004) != 0)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 10, adGroupAd_);
    }
    if (((bitField0_ & 0x00000008) != 0)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 11, campaignLocationTarget_);
    }
    if (((bitField0_ & 0x00000010) != 0)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 12, userList_);
    }
    if (!getKeywordBytes().isEmpty()) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 13, keyword_);
    }
    if (keywordInfo_ != null) {
      output.writeMessage(14, getKeywordInfo());
    }
    unknownFields.writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!getResourceNameBytes().isEmpty()) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, resourceName_);
    }
    if (areaOfInterest_ != null) {
      size += com.google.protobuf.CodedOutputStream
        .computeMessageSize(3, getAreaOfInterest());
    }
    if (locationOfPresence_ != null) {
      size += com.google.protobuf.CodedOutputStream
        .computeMessageSize(4, getLocationOfPresence());
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(8, gclid_);
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      size += com.google.protobuf.CodedOutputStream
        .computeInt64Size(9, pageNumber_);
    }
    if (((bitField0_ & 0x00000004) != 0)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(10, adGroupAd_);
    }
    if (((bitField0_ & 0x00000008) != 0)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(11, campaignLocationTarget_);
    }
    if (((bitField0_ & 0x00000010) != 0)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(12, userList_);
    }
    if (!getKeywordBytes().isEmpty()) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(13, keyword_);
    }
    if (keywordInfo_ != null) {
      size += com.google.protobuf.CodedOutputStream
        .computeMessageSize(14, getKeywordInfo());
    }
    size += unknownFields.getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
     return true;
    }
    if (!(obj instanceof com.google.ads.googleads.v8.resources.ClickView)) {
      return super.equals(obj);
    }
    com.google.ads.googleads.v8.resources.ClickView other = (com.google.ads.googleads.v8.resources.ClickView) obj;

    if (!getResourceName()
        .equals(other.getResourceName())) return false;
    if (hasGclid() != other.hasGclid()) return false;
    if (hasGclid()) {
      if (!getGclid()
          .equals(other.getGclid())) return false;
    }
    if (hasAreaOfInterest() != other.hasAreaOfInterest()) return false;
    if (hasAreaOfInterest()) {
      if (!getAreaOfInterest()
          .equals(other.getAreaOfInterest())) return false;
    }
    if (hasLocationOfPresence() != other.hasLocationOfPresence()) return false;
    if (hasLocationOfPresence()) {
      if (!getLocationOfPresence()
          .equals(other.getLocationOfPresence())) return false;
    }
    if (hasPageNumber() != other.hasPageNumber()) return false;
    if (hasPageNumber()) {
      if (getPageNumber()
          != other.getPageNumber()) return false;
    }
    if (hasAdGroupAd() != other.hasAdGroupAd()) return false;
    if (hasAdGroupAd()) {
      if (!getAdGroupAd()
          .equals(other.getAdGroupAd())) return false;
    }
    if (hasCampaignLocationTarget() != other.hasCampaignLocationTarget()) return false;
    if (hasCampaignLocationTarget()) {
      if (!getCampaignLocationTarget()
          .equals(other.getCampaignLocationTarget())) return false;
    }
    if (hasUserList() != other.hasUserList()) return false;
    if (hasUserList()) {
      if (!getUserList()
          .equals(other.getUserList())) return false;
    }
    if (!getKeyword()
        .equals(other.getKeyword())) return false;
    if (hasKeywordInfo() != other.hasKeywordInfo()) return false;
    if (hasKeywordInfo()) {
      if (!getKeywordInfo()
          .equals(other.getKeywordInfo())) return false;
    }
    if (!unknownFields.equals(other.unknownFields)) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + RESOURCE_NAME_FIELD_NUMBER;
    hash = (53 * hash) + getResourceName().hashCode();
    if (hasGclid()) {
      hash = (37 * hash) + GCLID_FIELD_NUMBER;
      hash = (53 * hash) + getGclid().hashCode();
    }
    if (hasAreaOfInterest()) {
      hash = (37 * hash) + AREA_OF_INTEREST_FIELD_NUMBER;
      hash = (53 * hash) + getAreaOfInterest().hashCode();
    }
    if (hasLocationOfPresence()) {
      hash = (37 * hash) + LOCATION_OF_PRESENCE_FIELD_NUMBER;
      hash = (53 * hash) + getLocationOfPresence().hashCode();
    }
    if (hasPageNumber()) {
      hash = (37 * hash) + PAGE_NUMBER_FIELD_NUMBER;
      hash = (53 * hash) + com.google.protobuf.Internal.hashLong(
          getPageNumber());
    }
    if (hasAdGroupAd()) {
      hash = (37 * hash) + AD_GROUP_AD_FIELD_NUMBER;
      hash = (53 * hash) + getAdGroupAd().hashCode();
    }
    if (hasCampaignLocationTarget()) {
      hash = (37 * hash) + CAMPAIGN_LOCATION_TARGET_FIELD_NUMBER;
      hash = (53 * hash) + getCampaignLocationTarget().hashCode();
    }
    if (hasUserList()) {
      hash = (37 * hash) + USER_LIST_FIELD_NUMBER;
      hash = (53 * hash) + getUserList().hashCode();
    }
    hash = (37 * hash) + KEYWORD_FIELD_NUMBER;
    hash = (53 * hash) + getKeyword().hashCode();
    if (hasKeywordInfo()) {
      hash = (37 * hash) + KEYWORD_INFO_FIELD_NUMBER;
      hash = (53 * hash) + getKeywordInfo().hashCode();
    }
    hash = (29 * hash) + unknownFields.hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.ads.googleads.v8.resources.ClickView parseFrom(
      java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }
  public static com.google.ads.googleads.v8.resources.ClickView parseFrom(
      java.nio.ByteBuffer data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }
  public static com.google.ads.googleads.v8.resources.ClickView parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }
  public static com.google.ads.googleads.v8.resources.ClickView parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }
  public static com.google.ads.googleads.v8.resources.ClickView parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }
  public static com.google.ads.googleads.v8.resources.ClickView parseFrom(
      byte[] data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }
  public static com.google.ads.googleads.v8.resources.ClickView parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3
        .parseWithIOException(PARSER, input);
  }
  public static com.google.ads.googleads.v8.resources.ClickView parseFrom(
      java.io.InputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3
        .parseWithIOException(PARSER, input, extensionRegistry);
  }
  public static com.google.ads.googleads.v8.resources.ClickView parseDelimitedFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3
        .parseDelimitedWithIOException(PARSER, input);
  }
  public static com.google.ads.googleads.v8.resources.ClickView parseDelimitedFrom(
      java.io.InputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3
        .parseDelimitedWithIOException(PARSER, input, extensionRegistry);
  }
  public static com.google.ads.googleads.v8.resources.ClickView parseFrom(
      com.google.protobuf.CodedInputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3
        .parseWithIOException(PARSER, input);
  }
  public static com.google.ads.googleads.v8.resources.ClickView parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3
        .parseWithIOException(PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() { return newBuilder(); }
  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }
  public static Builder newBuilder(com.google.ads.googleads.v8.resources.ClickView prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }
  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE
        ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(
      com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   * <pre>
   * A click view with metrics aggregated at each click level, including both
   * valid and invalid clicks. For non-Search campaigns, metrics.clicks
   * represents the number of valid and invalid interactions.
   * Queries including ClickView must have a filter limiting the results to one
   * day and can be requested for dates back to 90 days before the time of the
   * request.
   * </pre>
   *
   * Protobuf type {@code google.ads.googleads.v8.resources.ClickView}
   */
  public static final class Builder extends
      com.google.protobuf.GeneratedMessageV3.Builder<Builder> implements
      // @@protoc_insertion_point(builder_implements:google.ads.googleads.v8.resources.ClickView)
      com.google.ads.googleads.v8.resources.ClickViewOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor
        getDescriptor() {
      return com.google.ads.googleads.v8.resources.ClickViewProto.internal_static_google_ads_googleads_v8_resources_ClickView_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.ads.googleads.v8.resources.ClickViewProto.internal_static_google_ads_googleads_v8_resources_ClickView_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.ads.googleads.v8.resources.ClickView.class, com.google.ads.googleads.v8.resources.ClickView.Builder.class);
    }

    // Construct using com.google.ads.googleads.v8.resources.ClickView.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }
    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3
              .alwaysUseFieldBuilders) {
      }
    }
    @java.lang.Override
    public Builder clear() {
      super.clear();
      resourceName_ = "";

      gclid_ = "";
      bitField0_ = (bitField0_ & ~0x00000001);
      if (areaOfInterestBuilder_ == null) {
        areaOfInterest_ = null;
      } else {
        areaOfInterest_ = null;
        areaOfInterestBuilder_ = null;
      }
      if (locationOfPresenceBuilder_ == null) {
        locationOfPresence_ = null;
      } else {
        locationOfPresence_ = null;
        locationOfPresenceBuilder_ = null;
      }
      pageNumber_ = 0L;
      bitField0_ = (bitField0_ & ~0x00000002);
      adGroupAd_ = "";
      bitField0_ = (bitField0_ & ~0x00000004);
      campaignLocationTarget_ = "";
      bitField0_ = (bitField0_ & ~0x00000008);
      userList_ = "";
      bitField0_ = (bitField0_ & ~0x00000010);
      keyword_ = "";

      if (keywordInfoBuilder_ == null) {
        keywordInfo_ = null;
      } else {
        keywordInfo_ = null;
        keywordInfoBuilder_ = null;
      }
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor
        getDescriptorForType() {
      return com.google.ads.googleads.v8.resources.ClickViewProto.internal_static_google_ads_googleads_v8_resources_ClickView_descriptor;
    }

    @java.lang.Override
    public com.google.ads.googleads.v8.resources.ClickView getDefaultInstanceForType() {
      return com.google.ads.googleads.v8.resources.ClickView.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.ads.googleads.v8.resources.ClickView build() {
      com.google.ads.googleads.v8.resources.ClickView result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.ads.googleads.v8.resources.ClickView buildPartial() {
      com.google.ads.googleads.v8.resources.ClickView result = new com.google.ads.googleads.v8.resources.ClickView(this);
      int from_bitField0_ = bitField0_;
      int to_bitField0_ = 0;
      result.resourceName_ = resourceName_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        to_bitField0_ |= 0x00000001;
      }
      result.gclid_ = gclid_;
      if (areaOfInterestBuilder_ == null) {
        result.areaOfInterest_ = areaOfInterest_;
      } else {
        result.areaOfInterest_ = areaOfInterestBuilder_.build();
      }
      if (locationOfPresenceBuilder_ == null) {
        result.locationOfPresence_ = locationOfPresence_;
      } else {
        result.locationOfPresence_ = locationOfPresenceBuilder_.build();
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.pageNumber_ = pageNumber_;
        to_bitField0_ |= 0x00000002;
      }
      if (((from_bitField0_ & 0x00000004) != 0)) {
        to_bitField0_ |= 0x00000004;
      }
      result.adGroupAd_ = adGroupAd_;
      if (((from_bitField0_ & 0x00000008) != 0)) {
        to_bitField0_ |= 0x00000008;
      }
      result.campaignLocationTarget_ = campaignLocationTarget_;
      if (((from_bitField0_ & 0x00000010) != 0)) {
        to_bitField0_ |= 0x00000010;
      }
      result.userList_ = userList_;
      result.keyword_ = keyword_;
      if (keywordInfoBuilder_ == null) {
        result.keywordInfo_ = keywordInfo_;
      } else {
        result.keywordInfo_ = keywordInfoBuilder_.build();
      }
      result.bitField0_ = to_bitField0_;
      onBuilt();
      return result;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }
    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field,
        java.lang.Object value) {
      return super.setField(field, value);
    }
    @java.lang.Override
    public Builder clearField(
        com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }
    @java.lang.Override
    public Builder clearOneof(
        com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }
    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field,
        int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }
    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field,
        java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }
    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.ads.googleads.v8.resources.ClickView) {
        return mergeFrom((com.google.ads.googleads.v8.resources.ClickView)other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.ads.googleads.v8.resources.ClickView other) {
      if (other == com.google.ads.googleads.v8.resources.ClickView.getDefaultInstance()) return this;
      if (!other.getResourceName().isEmpty()) {
        resourceName_ = other.resourceName_;
        onChanged();
      }
      if (other.hasGclid()) {
        bitField0_ |= 0x00000001;
        gclid_ = other.gclid_;
        onChanged();
      }
      if (other.hasAreaOfInterest()) {
        mergeAreaOfInterest(other.getAreaOfInterest());
      }
      if (other.hasLocationOfPresence()) {
        mergeLocationOfPresence(other.getLocationOfPresence());
      }
      if (other.hasPageNumber()) {
        setPageNumber(other.getPageNumber());
      }
      if (other.hasAdGroupAd()) {
        bitField0_ |= 0x00000004;
        adGroupAd_ = other.adGroupAd_;
        onChanged();
      }
      if (other.hasCampaignLocationTarget()) {
        bitField0_ |= 0x00000008;
        campaignLocationTarget_ = other.campaignLocationTarget_;
        onChanged();
      }
      if (other.hasUserList()) {
        bitField0_ |= 0x00000010;
        userList_ = other.userList_;
        onChanged();
      }
      if (!other.getKeyword().isEmpty()) {
        keyword_ = other.keyword_;
        onChanged();
      }
      if (other.hasKeywordInfo()) {
        mergeKeywordInfo(other.getKeywordInfo());
      }
      this.mergeUnknownFields(other.unknownFields);
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      com.google.ads.googleads.v8.resources.ClickView parsedMessage = null;
      try {
        parsedMessage = PARSER.parsePartialFrom(input, extensionRegistry);
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        parsedMessage = (com.google.ads.googleads.v8.resources.ClickView) e.getUnfinishedMessage();
        throw e.unwrapIOException();
      } finally {
        if (parsedMessage != null) {
          mergeFrom(parsedMessage);
        }
      }
      return this;
    }
    private int bitField0_;

    private java.lang.Object resourceName_ = "";
    /**
     * <pre>
     * Output only. The resource name of the click view.
     * Click view resource names have the form:
     * `customers/{customer_id}/clickViews/{date (yyyy-MM-dd)}~{gclid}`
     * </pre>
     *
     * <code>string resource_name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.resource_reference) = { ... }</code>
     * @return The resourceName.
     */
    public java.lang.String getResourceName() {
      java.lang.Object ref = resourceName_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs =
            (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        resourceName_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     * <pre>
     * Output only. The resource name of the click view.
     * Click view resource names have the form:
     * `customers/{customer_id}/clickViews/{date (yyyy-MM-dd)}~{gclid}`
     * </pre>
     *
     * <code>string resource_name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.resource_reference) = { ... }</code>
     * @return The bytes for resourceName.
     */
    public com.google.protobuf.ByteString
        getResourceNameBytes() {
      java.lang.Object ref = resourceName_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b = 
            com.google.protobuf.ByteString.copyFromUtf8(
                (java.lang.String) ref);
        resourceName_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     * <pre>
     * Output only. The resource name of the click view.
     * Click view resource names have the form:
     * `customers/{customer_id}/clickViews/{date (yyyy-MM-dd)}~{gclid}`
     * </pre>
     *
     * <code>string resource_name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.resource_reference) = { ... }</code>
     * @param value The resourceName to set.
     * @return This builder for chaining.
     */
    public Builder setResourceName(
        java.lang.String value) {
      if (value == null) {
    throw new NullPointerException();
  }
  
      resourceName_ = value;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Output only. The resource name of the click view.
     * Click view resource names have the form:
     * `customers/{customer_id}/clickViews/{date (yyyy-MM-dd)}~{gclid}`
     * </pre>
     *
     * <code>string resource_name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.resource_reference) = { ... }</code>
     * @return This builder for chaining.
     */
    public Builder clearResourceName() {
      
      resourceName_ = getDefaultInstance().getResourceName();
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Output only. The resource name of the click view.
     * Click view resource names have the form:
     * `customers/{customer_id}/clickViews/{date (yyyy-MM-dd)}~{gclid}`
     * </pre>
     *
     * <code>string resource_name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.resource_reference) = { ... }</code>
     * @param value The bytes for resourceName to set.
     * @return This builder for chaining.
     */
    public Builder setResourceNameBytes(
        com.google.protobuf.ByteString value) {
      if (value == null) {
    throw new NullPointerException();
  }
  checkByteStringIsUtf8(value);
      
      resourceName_ = value;
      onChanged();
      return this;
    }

    private java.lang.Object gclid_ = "";
    /**
     * <pre>
     * Output only. The Google Click ID.
     * </pre>
     *
     * <code>string gclid = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return Whether the gclid field is set.
     */
    public boolean hasGclid() {
      return ((bitField0_ & 0x00000001) != 0);
    }
    /**
     * <pre>
     * Output only. The Google Click ID.
     * </pre>
     *
     * <code>string gclid = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return The gclid.
     */
    public java.lang.String getGclid() {
      java.lang.Object ref = gclid_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs =
            (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        gclid_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     * <pre>
     * Output only. The Google Click ID.
     * </pre>
     *
     * <code>string gclid = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return The bytes for gclid.
     */
    public com.google.protobuf.ByteString
        getGclidBytes() {
      java.lang.Object ref = gclid_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b = 
            com.google.protobuf.ByteString.copyFromUtf8(
                (java.lang.String) ref);
        gclid_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     * <pre>
     * Output only. The Google Click ID.
     * </pre>
     *
     * <code>string gclid = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param value The gclid to set.
     * @return This builder for chaining.
     */
    public Builder setGclid(
        java.lang.String value) {
      if (value == null) {
    throw new NullPointerException();
  }
  bitField0_ |= 0x00000001;
      gclid_ = value;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Output only. The Google Click ID.
     * </pre>
     *
     * <code>string gclid = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return This builder for chaining.
     */
    public Builder clearGclid() {
      bitField0_ = (bitField0_ & ~0x00000001);
      gclid_ = getDefaultInstance().getGclid();
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Output only. The Google Click ID.
     * </pre>
     *
     * <code>string gclid = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param value The bytes for gclid to set.
     * @return This builder for chaining.
     */
    public Builder setGclidBytes(
        com.google.protobuf.ByteString value) {
      if (value == null) {
    throw new NullPointerException();
  }
  checkByteStringIsUtf8(value);
      bitField0_ |= 0x00000001;
      gclid_ = value;
      onChanged();
      return this;
    }

    private com.google.ads.googleads.v8.common.ClickLocation areaOfInterest_;
    private com.google.protobuf.SingleFieldBuilderV3<
        com.google.ads.googleads.v8.common.ClickLocation, com.google.ads.googleads.v8.common.ClickLocation.Builder, com.google.ads.googleads.v8.common.ClickLocationOrBuilder> areaOfInterestBuilder_;
    /**
     * <pre>
     * Output only. The location criteria matching the area of interest associated with the
     * impression.
     * </pre>
     *
     * <code>.google.ads.googleads.v8.common.ClickLocation area_of_interest = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return Whether the areaOfInterest field is set.
     */
    public boolean hasAreaOfInterest() {
      return areaOfInterestBuilder_ != null || areaOfInterest_ != null;
    }
    /**
     * <pre>
     * Output only. The location criteria matching the area of interest associated with the
     * impression.
     * </pre>
     *
     * <code>.google.ads.googleads.v8.common.ClickLocation area_of_interest = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return The areaOfInterest.
     */
    public com.google.ads.googleads.v8.common.ClickLocation getAreaOfInterest() {
      if (areaOfInterestBuilder_ == null) {
        return areaOfInterest_ == null ? com.google.ads.googleads.v8.common.ClickLocation.getDefaultInstance() : areaOfInterest_;
      } else {
        return areaOfInterestBuilder_.getMessage();
      }
    }
    /**
     * <pre>
     * Output only. The location criteria matching the area of interest associated with the
     * impression.
     * </pre>
     *
     * <code>.google.ads.googleads.v8.common.ClickLocation area_of_interest = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    public Builder setAreaOfInterest(com.google.ads.googleads.v8.common.ClickLocation value) {
      if (areaOfInterestBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        areaOfInterest_ = value;
        onChanged();
      } else {
        areaOfInterestBuilder_.setMessage(value);
      }

      return this;
    }
    /**
     * <pre>
     * Output only. The location criteria matching the area of interest associated with the
     * impression.
     * </pre>
     *
     * <code>.google.ads.googleads.v8.common.ClickLocation area_of_interest = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    public Builder setAreaOfInterest(
        com.google.ads.googleads.v8.common.ClickLocation.Builder builderForValue) {
      if (areaOfInterestBuilder_ == null) {
        areaOfInterest_ = builderForValue.build();
        onChanged();
      } else {
        areaOfInterestBuilder_.setMessage(builderForValue.build());
      }

      return this;
    }
    /**
     * <pre>
     * Output only. The location criteria matching the area of interest associated with the
     * impression.
     * </pre>
     *
     * <code>.google.ads.googleads.v8.common.ClickLocation area_of_interest = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    public Builder mergeAreaOfInterest(com.google.ads.googleads.v8.common.ClickLocation value) {
      if (areaOfInterestBuilder_ == null) {
        if (areaOfInterest_ != null) {
          areaOfInterest_ =
            com.google.ads.googleads.v8.common.ClickLocation.newBuilder(areaOfInterest_).mergeFrom(value).buildPartial();
        } else {
          areaOfInterest_ = value;
        }
        onChanged();
      } else {
        areaOfInterestBuilder_.mergeFrom(value);
      }

      return this;
    }
    /**
     * <pre>
     * Output only. The location criteria matching the area of interest associated with the
     * impression.
     * </pre>
     *
     * <code>.google.ads.googleads.v8.common.ClickLocation area_of_interest = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    public Builder clearAreaOfInterest() {
      if (areaOfInterestBuilder_ == null) {
        areaOfInterest_ = null;
        onChanged();
      } else {
        areaOfInterest_ = null;
        areaOfInterestBuilder_ = null;
      }

      return this;
    }
    /**
     * <pre>
     * Output only. The location criteria matching the area of interest associated with the
     * impression.
     * </pre>
     *
     * <code>.google.ads.googleads.v8.common.ClickLocation area_of_interest = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    public com.google.ads.googleads.v8.common.ClickLocation.Builder getAreaOfInterestBuilder() {
      
      onChanged();
      return getAreaOfInterestFieldBuilder().getBuilder();
    }
    /**
     * <pre>
     * Output only. The location criteria matching the area of interest associated with the
     * impression.
     * </pre>
     *
     * <code>.google.ads.googleads.v8.common.ClickLocation area_of_interest = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    public com.google.ads.googleads.v8.common.ClickLocationOrBuilder getAreaOfInterestOrBuilder() {
      if (areaOfInterestBuilder_ != null) {
        return areaOfInterestBuilder_.getMessageOrBuilder();
      } else {
        return areaOfInterest_ == null ?
            com.google.ads.googleads.v8.common.ClickLocation.getDefaultInstance() : areaOfInterest_;
      }
    }
    /**
     * <pre>
     * Output only. The location criteria matching the area of interest associated with the
     * impression.
     * </pre>
     *
     * <code>.google.ads.googleads.v8.common.ClickLocation area_of_interest = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
        com.google.ads.googleads.v8.common.ClickLocation, com.google.ads.googleads.v8.common.ClickLocation.Builder, com.google.ads.googleads.v8.common.ClickLocationOrBuilder> 
        getAreaOfInterestFieldBuilder() {
      if (areaOfInterestBuilder_ == null) {
        areaOfInterestBuilder_ = new com.google.protobuf.SingleFieldBuilderV3<
            com.google.ads.googleads.v8.common.ClickLocation, com.google.ads.googleads.v8.common.ClickLocation.Builder, com.google.ads.googleads.v8.common.ClickLocationOrBuilder>(
                getAreaOfInterest(),
                getParentForChildren(),
                isClean());
        areaOfInterest_ = null;
      }
      return areaOfInterestBuilder_;
    }

    private com.google.ads.googleads.v8.common.ClickLocation locationOfPresence_;
    private com.google.protobuf.SingleFieldBuilderV3<
        com.google.ads.googleads.v8.common.ClickLocation, com.google.ads.googleads.v8.common.ClickLocation.Builder, com.google.ads.googleads.v8.common.ClickLocationOrBuilder> locationOfPresenceBuilder_;
    /**
     * <pre>
     * Output only. The location criteria matching the location of presence associated with the
     * impression.
     * </pre>
     *
     * <code>.google.ads.googleads.v8.common.ClickLocation location_of_presence = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return Whether the locationOfPresence field is set.
     */
    public boolean hasLocationOfPresence() {
      return locationOfPresenceBuilder_ != null || locationOfPresence_ != null;
    }
    /**
     * <pre>
     * Output only. The location criteria matching the location of presence associated with the
     * impression.
     * </pre>
     *
     * <code>.google.ads.googleads.v8.common.ClickLocation location_of_presence = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return The locationOfPresence.
     */
    public com.google.ads.googleads.v8.common.ClickLocation getLocationOfPresence() {
      if (locationOfPresenceBuilder_ == null) {
        return locationOfPresence_ == null ? com.google.ads.googleads.v8.common.ClickLocation.getDefaultInstance() : locationOfPresence_;
      } else {
        return locationOfPresenceBuilder_.getMessage();
      }
    }
    /**
     * <pre>
     * Output only. The location criteria matching the location of presence associated with the
     * impression.
     * </pre>
     *
     * <code>.google.ads.googleads.v8.common.ClickLocation location_of_presence = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    public Builder setLocationOfPresence(com.google.ads.googleads.v8.common.ClickLocation value) {
      if (locationOfPresenceBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        locationOfPresence_ = value;
        onChanged();
      } else {
        locationOfPresenceBuilder_.setMessage(value);
      }

      return this;
    }
    /**
     * <pre>
     * Output only. The location criteria matching the location of presence associated with the
     * impression.
     * </pre>
     *
     * <code>.google.ads.googleads.v8.common.ClickLocation location_of_presence = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    public Builder setLocationOfPresence(
        com.google.ads.googleads.v8.common.ClickLocation.Builder builderForValue) {
      if (locationOfPresenceBuilder_ == null) {
        locationOfPresence_ = builderForValue.build();
        onChanged();
      } else {
        locationOfPresenceBuilder_.setMessage(builderForValue.build());
      }

      return this;
    }
    /**
     * <pre>
     * Output only. The location criteria matching the location of presence associated with the
     * impression.
     * </pre>
     *
     * <code>.google.ads.googleads.v8.common.ClickLocation location_of_presence = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    public Builder mergeLocationOfPresence(com.google.ads.googleads.v8.common.ClickLocation value) {
      if (locationOfPresenceBuilder_ == null) {
        if (locationOfPresence_ != null) {
          locationOfPresence_ =
            com.google.ads.googleads.v8.common.ClickLocation.newBuilder(locationOfPresence_).mergeFrom(value).buildPartial();
        } else {
          locationOfPresence_ = value;
        }
        onChanged();
      } else {
        locationOfPresenceBuilder_.mergeFrom(value);
      }

      return this;
    }
    /**
     * <pre>
     * Output only. The location criteria matching the location of presence associated with the
     * impression.
     * </pre>
     *
     * <code>.google.ads.googleads.v8.common.ClickLocation location_of_presence = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    public Builder clearLocationOfPresence() {
      if (locationOfPresenceBuilder_ == null) {
        locationOfPresence_ = null;
        onChanged();
      } else {
        locationOfPresence_ = null;
        locationOfPresenceBuilder_ = null;
      }

      return this;
    }
    /**
     * <pre>
     * Output only. The location criteria matching the location of presence associated with the
     * impression.
     * </pre>
     *
     * <code>.google.ads.googleads.v8.common.ClickLocation location_of_presence = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    public com.google.ads.googleads.v8.common.ClickLocation.Builder getLocationOfPresenceBuilder() {
      
      onChanged();
      return getLocationOfPresenceFieldBuilder().getBuilder();
    }
    /**
     * <pre>
     * Output only. The location criteria matching the location of presence associated with the
     * impression.
     * </pre>
     *
     * <code>.google.ads.googleads.v8.common.ClickLocation location_of_presence = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    public com.google.ads.googleads.v8.common.ClickLocationOrBuilder getLocationOfPresenceOrBuilder() {
      if (locationOfPresenceBuilder_ != null) {
        return locationOfPresenceBuilder_.getMessageOrBuilder();
      } else {
        return locationOfPresence_ == null ?
            com.google.ads.googleads.v8.common.ClickLocation.getDefaultInstance() : locationOfPresence_;
      }
    }
    /**
     * <pre>
     * Output only. The location criteria matching the location of presence associated with the
     * impression.
     * </pre>
     *
     * <code>.google.ads.googleads.v8.common.ClickLocation location_of_presence = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
        com.google.ads.googleads.v8.common.ClickLocation, com.google.ads.googleads.v8.common.ClickLocation.Builder, com.google.ads.googleads.v8.common.ClickLocationOrBuilder> 
        getLocationOfPresenceFieldBuilder() {
      if (locationOfPresenceBuilder_ == null) {
        locationOfPresenceBuilder_ = new com.google.protobuf.SingleFieldBuilderV3<
            com.google.ads.googleads.v8.common.ClickLocation, com.google.ads.googleads.v8.common.ClickLocation.Builder, com.google.ads.googleads.v8.common.ClickLocationOrBuilder>(
                getLocationOfPresence(),
                getParentForChildren(),
                isClean());
        locationOfPresence_ = null;
      }
      return locationOfPresenceBuilder_;
    }

    private long pageNumber_ ;
    /**
     * <pre>
     * Output only. Page number in search results where the ad was shown.
     * </pre>
     *
     * <code>int64 page_number = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return Whether the pageNumber field is set.
     */
    @java.lang.Override
    public boolean hasPageNumber() {
      return ((bitField0_ & 0x00000002) != 0);
    }
    /**
     * <pre>
     * Output only. Page number in search results where the ad was shown.
     * </pre>
     *
     * <code>int64 page_number = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return The pageNumber.
     */
    @java.lang.Override
    public long getPageNumber() {
      return pageNumber_;
    }
    /**
     * <pre>
     * Output only. Page number in search results where the ad was shown.
     * </pre>
     *
     * <code>int64 page_number = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param value The pageNumber to set.
     * @return This builder for chaining.
     */
    public Builder setPageNumber(long value) {
      bitField0_ |= 0x00000002;
      pageNumber_ = value;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Output only. Page number in search results where the ad was shown.
     * </pre>
     *
     * <code>int64 page_number = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return This builder for chaining.
     */
    public Builder clearPageNumber() {
      bitField0_ = (bitField0_ & ~0x00000002);
      pageNumber_ = 0L;
      onChanged();
      return this;
    }

    private java.lang.Object adGroupAd_ = "";
    /**
     * <pre>
     * Output only. The associated ad.
     * </pre>
     *
     * <code>string ad_group_ad = 10 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.resource_reference) = { ... }</code>
     * @return Whether the adGroupAd field is set.
     */
    public boolean hasAdGroupAd() {
      return ((bitField0_ & 0x00000004) != 0);
    }
    /**
     * <pre>
     * Output only. The associated ad.
     * </pre>
     *
     * <code>string ad_group_ad = 10 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.resource_reference) = { ... }</code>
     * @return The adGroupAd.
     */
    public java.lang.String getAdGroupAd() {
      java.lang.Object ref = adGroupAd_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs =
            (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        adGroupAd_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     * <pre>
     * Output only. The associated ad.
     * </pre>
     *
     * <code>string ad_group_ad = 10 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.resource_reference) = { ... }</code>
     * @return The bytes for adGroupAd.
     */
    public com.google.protobuf.ByteString
        getAdGroupAdBytes() {
      java.lang.Object ref = adGroupAd_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b = 
            com.google.protobuf.ByteString.copyFromUtf8(
                (java.lang.String) ref);
        adGroupAd_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     * <pre>
     * Output only. The associated ad.
     * </pre>
     *
     * <code>string ad_group_ad = 10 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.resource_reference) = { ... }</code>
     * @param value The adGroupAd to set.
     * @return This builder for chaining.
     */
    public Builder setAdGroupAd(
        java.lang.String value) {
      if (value == null) {
    throw new NullPointerException();
  }
  bitField0_ |= 0x00000004;
      adGroupAd_ = value;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Output only. The associated ad.
     * </pre>
     *
     * <code>string ad_group_ad = 10 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.resource_reference) = { ... }</code>
     * @return This builder for chaining.
     */
    public Builder clearAdGroupAd() {
      bitField0_ = (bitField0_ & ~0x00000004);
      adGroupAd_ = getDefaultInstance().getAdGroupAd();
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Output only. The associated ad.
     * </pre>
     *
     * <code>string ad_group_ad = 10 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.resource_reference) = { ... }</code>
     * @param value The bytes for adGroupAd to set.
     * @return This builder for chaining.
     */
    public Builder setAdGroupAdBytes(
        com.google.protobuf.ByteString value) {
      if (value == null) {
    throw new NullPointerException();
  }
  checkByteStringIsUtf8(value);
      bitField0_ |= 0x00000004;
      adGroupAd_ = value;
      onChanged();
      return this;
    }

    private java.lang.Object campaignLocationTarget_ = "";
    /**
     * <pre>
     * Output only. The associated campaign location target, if one exists.
     * </pre>
     *
     * <code>string campaign_location_target = 11 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.resource_reference) = { ... }</code>
     * @return Whether the campaignLocationTarget field is set.
     */
    public boolean hasCampaignLocationTarget() {
      return ((bitField0_ & 0x00000008) != 0);
    }
    /**
     * <pre>
     * Output only. The associated campaign location target, if one exists.
     * </pre>
     *
     * <code>string campaign_location_target = 11 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.resource_reference) = { ... }</code>
     * @return The campaignLocationTarget.
     */
    public java.lang.String getCampaignLocationTarget() {
      java.lang.Object ref = campaignLocationTarget_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs =
            (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        campaignLocationTarget_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     * <pre>
     * Output only. The associated campaign location target, if one exists.
     * </pre>
     *
     * <code>string campaign_location_target = 11 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.resource_reference) = { ... }</code>
     * @return The bytes for campaignLocationTarget.
     */
    public com.google.protobuf.ByteString
        getCampaignLocationTargetBytes() {
      java.lang.Object ref = campaignLocationTarget_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b = 
            com.google.protobuf.ByteString.copyFromUtf8(
                (java.lang.String) ref);
        campaignLocationTarget_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     * <pre>
     * Output only. The associated campaign location target, if one exists.
     * </pre>
     *
     * <code>string campaign_location_target = 11 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.resource_reference) = { ... }</code>
     * @param value The campaignLocationTarget to set.
     * @return This builder for chaining.
     */
    public Builder setCampaignLocationTarget(
        java.lang.String value) {
      if (value == null) {
    throw new NullPointerException();
  }
  bitField0_ |= 0x00000008;
      campaignLocationTarget_ = value;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Output only. The associated campaign location target, if one exists.
     * </pre>
     *
     * <code>string campaign_location_target = 11 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.resource_reference) = { ... }</code>
     * @return This builder for chaining.
     */
    public Builder clearCampaignLocationTarget() {
      bitField0_ = (bitField0_ & ~0x00000008);
      campaignLocationTarget_ = getDefaultInstance().getCampaignLocationTarget();
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Output only. The associated campaign location target, if one exists.
     * </pre>
     *
     * <code>string campaign_location_target = 11 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.resource_reference) = { ... }</code>
     * @param value The bytes for campaignLocationTarget to set.
     * @return This builder for chaining.
     */
    public Builder setCampaignLocationTargetBytes(
        com.google.protobuf.ByteString value) {
      if (value == null) {
    throw new NullPointerException();
  }
  checkByteStringIsUtf8(value);
      bitField0_ |= 0x00000008;
      campaignLocationTarget_ = value;
      onChanged();
      return this;
    }

    private java.lang.Object userList_ = "";
    /**
     * <pre>
     * Output only. The associated user list, if one exists.
     * </pre>
     *
     * <code>string user_list = 12 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.resource_reference) = { ... }</code>
     * @return Whether the userList field is set.
     */
    public boolean hasUserList() {
      return ((bitField0_ & 0x00000010) != 0);
    }
    /**
     * <pre>
     * Output only. The associated user list, if one exists.
     * </pre>
     *
     * <code>string user_list = 12 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.resource_reference) = { ... }</code>
     * @return The userList.
     */
    public java.lang.String getUserList() {
      java.lang.Object ref = userList_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs =
            (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        userList_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     * <pre>
     * Output only. The associated user list, if one exists.
     * </pre>
     *
     * <code>string user_list = 12 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.resource_reference) = { ... }</code>
     * @return The bytes for userList.
     */
    public com.google.protobuf.ByteString
        getUserListBytes() {
      java.lang.Object ref = userList_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b = 
            com.google.protobuf.ByteString.copyFromUtf8(
                (java.lang.String) ref);
        userList_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     * <pre>
     * Output only. The associated user list, if one exists.
     * </pre>
     *
     * <code>string user_list = 12 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.resource_reference) = { ... }</code>
     * @param value The userList to set.
     * @return This builder for chaining.
     */
    public Builder setUserList(
        java.lang.String value) {
      if (value == null) {
    throw new NullPointerException();
  }
  bitField0_ |= 0x00000010;
      userList_ = value;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Output only. The associated user list, if one exists.
     * </pre>
     *
     * <code>string user_list = 12 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.resource_reference) = { ... }</code>
     * @return This builder for chaining.
     */
    public Builder clearUserList() {
      bitField0_ = (bitField0_ & ~0x00000010);
      userList_ = getDefaultInstance().getUserList();
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Output only. The associated user list, if one exists.
     * </pre>
     *
     * <code>string user_list = 12 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.resource_reference) = { ... }</code>
     * @param value The bytes for userList to set.
     * @return This builder for chaining.
     */
    public Builder setUserListBytes(
        com.google.protobuf.ByteString value) {
      if (value == null) {
    throw new NullPointerException();
  }
  checkByteStringIsUtf8(value);
      bitField0_ |= 0x00000010;
      userList_ = value;
      onChanged();
      return this;
    }

    private java.lang.Object keyword_ = "";
    /**
     * <pre>
     * Output only. The associated keyword, if one exists and the click corresponds to the
     * SEARCH channel.
     * </pre>
     *
     * <code>string keyword = 13 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.resource_reference) = { ... }</code>
     * @return The keyword.
     */
    public java.lang.String getKeyword() {
      java.lang.Object ref = keyword_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs =
            (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        keyword_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     * <pre>
     * Output only. The associated keyword, if one exists and the click corresponds to the
     * SEARCH channel.
     * </pre>
     *
     * <code>string keyword = 13 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.resource_reference) = { ... }</code>
     * @return The bytes for keyword.
     */
    public com.google.protobuf.ByteString
        getKeywordBytes() {
      java.lang.Object ref = keyword_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b = 
            com.google.protobuf.ByteString.copyFromUtf8(
                (java.lang.String) ref);
        keyword_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     * <pre>
     * Output only. The associated keyword, if one exists and the click corresponds to the
     * SEARCH channel.
     * </pre>
     *
     * <code>string keyword = 13 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.resource_reference) = { ... }</code>
     * @param value The keyword to set.
     * @return This builder for chaining.
     */
    public Builder setKeyword(
        java.lang.String value) {
      if (value == null) {
    throw new NullPointerException();
  }
  
      keyword_ = value;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Output only. The associated keyword, if one exists and the click corresponds to the
     * SEARCH channel.
     * </pre>
     *
     * <code>string keyword = 13 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.resource_reference) = { ... }</code>
     * @return This builder for chaining.
     */
    public Builder clearKeyword() {
      
      keyword_ = getDefaultInstance().getKeyword();
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Output only. The associated keyword, if one exists and the click corresponds to the
     * SEARCH channel.
     * </pre>
     *
     * <code>string keyword = 13 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.resource_reference) = { ... }</code>
     * @param value The bytes for keyword to set.
     * @return This builder for chaining.
     */
    public Builder setKeywordBytes(
        com.google.protobuf.ByteString value) {
      if (value == null) {
    throw new NullPointerException();
  }
  checkByteStringIsUtf8(value);
      
      keyword_ = value;
      onChanged();
      return this;
    }

    private com.google.ads.googleads.v8.common.KeywordInfo keywordInfo_;
    private com.google.protobuf.SingleFieldBuilderV3<
        com.google.ads.googleads.v8.common.KeywordInfo, com.google.ads.googleads.v8.common.KeywordInfo.Builder, com.google.ads.googleads.v8.common.KeywordInfoOrBuilder> keywordInfoBuilder_;
    /**
     * <pre>
     * Output only. Basic information about the associated keyword, if it exists.
     * </pre>
     *
     * <code>.google.ads.googleads.v8.common.KeywordInfo keyword_info = 14 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return Whether the keywordInfo field is set.
     */
    public boolean hasKeywordInfo() {
      return keywordInfoBuilder_ != null || keywordInfo_ != null;
    }
    /**
     * <pre>
     * Output only. Basic information about the associated keyword, if it exists.
     * </pre>
     *
     * <code>.google.ads.googleads.v8.common.KeywordInfo keyword_info = 14 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return The keywordInfo.
     */
    public com.google.ads.googleads.v8.common.KeywordInfo getKeywordInfo() {
      if (keywordInfoBuilder_ == null) {
        return keywordInfo_ == null ? com.google.ads.googleads.v8.common.KeywordInfo.getDefaultInstance() : keywordInfo_;
      } else {
        return keywordInfoBuilder_.getMessage();
      }
    }
    /**
     * <pre>
     * Output only. Basic information about the associated keyword, if it exists.
     * </pre>
     *
     * <code>.google.ads.googleads.v8.common.KeywordInfo keyword_info = 14 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    public Builder setKeywordInfo(com.google.ads.googleads.v8.common.KeywordInfo value) {
      if (keywordInfoBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        keywordInfo_ = value;
        onChanged();
      } else {
        keywordInfoBuilder_.setMessage(value);
      }

      return this;
    }
    /**
     * <pre>
     * Output only. Basic information about the associated keyword, if it exists.
     * </pre>
     *
     * <code>.google.ads.googleads.v8.common.KeywordInfo keyword_info = 14 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    public Builder setKeywordInfo(
        com.google.ads.googleads.v8.common.KeywordInfo.Builder builderForValue) {
      if (keywordInfoBuilder_ == null) {
        keywordInfo_ = builderForValue.build();
        onChanged();
      } else {
        keywordInfoBuilder_.setMessage(builderForValue.build());
      }

      return this;
    }
    /**
     * <pre>
     * Output only. Basic information about the associated keyword, if it exists.
     * </pre>
     *
     * <code>.google.ads.googleads.v8.common.KeywordInfo keyword_info = 14 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    public Builder mergeKeywordInfo(com.google.ads.googleads.v8.common.KeywordInfo value) {
      if (keywordInfoBuilder_ == null) {
        if (keywordInfo_ != null) {
          keywordInfo_ =
            com.google.ads.googleads.v8.common.KeywordInfo.newBuilder(keywordInfo_).mergeFrom(value).buildPartial();
        } else {
          keywordInfo_ = value;
        }
        onChanged();
      } else {
        keywordInfoBuilder_.mergeFrom(value);
      }

      return this;
    }
    /**
     * <pre>
     * Output only. Basic information about the associated keyword, if it exists.
     * </pre>
     *
     * <code>.google.ads.googleads.v8.common.KeywordInfo keyword_info = 14 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    public Builder clearKeywordInfo() {
      if (keywordInfoBuilder_ == null) {
        keywordInfo_ = null;
        onChanged();
      } else {
        keywordInfo_ = null;
        keywordInfoBuilder_ = null;
      }

      return this;
    }
    /**
     * <pre>
     * Output only. Basic information about the associated keyword, if it exists.
     * </pre>
     *
     * <code>.google.ads.googleads.v8.common.KeywordInfo keyword_info = 14 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    public com.google.ads.googleads.v8.common.KeywordInfo.Builder getKeywordInfoBuilder() {
      
      onChanged();
      return getKeywordInfoFieldBuilder().getBuilder();
    }
    /**
     * <pre>
     * Output only. Basic information about the associated keyword, if it exists.
     * </pre>
     *
     * <code>.google.ads.googleads.v8.common.KeywordInfo keyword_info = 14 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    public com.google.ads.googleads.v8.common.KeywordInfoOrBuilder getKeywordInfoOrBuilder() {
      if (keywordInfoBuilder_ != null) {
        return keywordInfoBuilder_.getMessageOrBuilder();
      } else {
        return keywordInfo_ == null ?
            com.google.ads.googleads.v8.common.KeywordInfo.getDefaultInstance() : keywordInfo_;
      }
    }
    /**
     * <pre>
     * Output only. Basic information about the associated keyword, if it exists.
     * </pre>
     *
     * <code>.google.ads.googleads.v8.common.KeywordInfo keyword_info = 14 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
        com.google.ads.googleads.v8.common.KeywordInfo, com.google.ads.googleads.v8.common.KeywordInfo.Builder, com.google.ads.googleads.v8.common.KeywordInfoOrBuilder> 
        getKeywordInfoFieldBuilder() {
      if (keywordInfoBuilder_ == null) {
        keywordInfoBuilder_ = new com.google.protobuf.SingleFieldBuilderV3<
            com.google.ads.googleads.v8.common.KeywordInfo, com.google.ads.googleads.v8.common.KeywordInfo.Builder, com.google.ads.googleads.v8.common.KeywordInfoOrBuilder>(
                getKeywordInfo(),
                getParentForChildren(),
                isClean());
        keywordInfo_ = null;
      }
      return keywordInfoBuilder_;
    }
    @java.lang.Override
    public final Builder setUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }


    // @@protoc_insertion_point(builder_scope:google.ads.googleads.v8.resources.ClickView)
  }

  // @@protoc_insertion_point(class_scope:google.ads.googleads.v8.resources.ClickView)
  private static final com.google.ads.googleads.v8.resources.ClickView DEFAULT_INSTANCE;
  static {
    DEFAULT_INSTANCE = new com.google.ads.googleads.v8.resources.ClickView();
  }

  public static com.google.ads.googleads.v8.resources.ClickView getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<ClickView>
      PARSER = new com.google.protobuf.AbstractParser<ClickView>() {
    @java.lang.Override
    public ClickView parsePartialFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return new ClickView(input, extensionRegistry);
    }
  };

  public static com.google.protobuf.Parser<ClickView> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<ClickView> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.ads.googleads.v8.resources.ClickView getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }

}

