// Copyright 2020 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
package com.google.ads.googleads.lib.catalog;

import com.google.ads.googleads.lib.GoogleAdsAllVersions;
import com.google.ads.googleads.v14.services.MediaFileServiceClient;
import com.google.ads.googleads.v14.services.MediaFileServiceSettings;
import com.google.ads.googleads.v14.services.MerchantCenterLinkServiceClient;
import com.google.ads.googleads.v14.services.MerchantCenterLinkServiceSettings;
import com.google.ads.googleads.v16.services.AccountBudgetProposalServiceClient;
import com.google.ads.googleads.v16.services.AccountBudgetProposalServiceSettings;
import com.google.ads.googleads.v16.services.AccountLinkServiceClient;
import com.google.ads.googleads.v16.services.AccountLinkServiceSettings;
import com.google.ads.googleads.v16.services.AdGroupAdLabelServiceClient;
import com.google.ads.googleads.v16.services.AdGroupAdLabelServiceSettings;
import com.google.ads.googleads.v16.services.AdGroupAdServiceClient;
import com.google.ads.googleads.v16.services.AdGroupAdServiceSettings;
import com.google.ads.googleads.v16.services.AdGroupAssetServiceClient;
import com.google.ads.googleads.v16.services.AdGroupAssetServiceSettings;
import com.google.ads.googleads.v16.services.AdGroupAssetSetServiceClient;
import com.google.ads.googleads.v16.services.AdGroupAssetSetServiceSettings;
import com.google.ads.googleads.v16.services.AdGroupBidModifierServiceClient;
import com.google.ads.googleads.v16.services.AdGroupBidModifierServiceSettings;
import com.google.ads.googleads.v16.services.AdGroupCriterionCustomizerServiceClient;
import com.google.ads.googleads.v16.services.AdGroupCriterionCustomizerServiceSettings;
import com.google.ads.googleads.v16.services.AdGroupCriterionLabelServiceClient;
import com.google.ads.googleads.v16.services.AdGroupCriterionLabelServiceSettings;
import com.google.ads.googleads.v16.services.AdGroupCriterionServiceClient;
import com.google.ads.googleads.v16.services.AdGroupCriterionServiceSettings;
import com.google.ads.googleads.v16.services.AdGroupCustomizerServiceClient;
import com.google.ads.googleads.v16.services.AdGroupCustomizerServiceSettings;
import com.google.ads.googleads.v16.services.AdGroupExtensionSettingServiceClient;
import com.google.ads.googleads.v16.services.AdGroupExtensionSettingServiceSettings;
import com.google.ads.googleads.v16.services.AdGroupFeedServiceClient;
import com.google.ads.googleads.v16.services.AdGroupFeedServiceSettings;
import com.google.ads.googleads.v16.services.AdGroupLabelServiceClient;
import com.google.ads.googleads.v16.services.AdGroupLabelServiceSettings;
import com.google.ads.googleads.v16.services.AdGroupServiceClient;
import com.google.ads.googleads.v16.services.AdGroupServiceSettings;
import com.google.ads.googleads.v16.services.AdParameterServiceClient;
import com.google.ads.googleads.v16.services.AdParameterServiceSettings;
import com.google.ads.googleads.v16.services.AdServiceClient;
import com.google.ads.googleads.v16.services.AdServiceSettings;
import com.google.ads.googleads.v16.services.AssetGroupAssetServiceClient;
import com.google.ads.googleads.v16.services.AssetGroupAssetServiceSettings;
import com.google.ads.googleads.v16.services.AssetGroupListingGroupFilterServiceClient;
import com.google.ads.googleads.v16.services.AssetGroupListingGroupFilterServiceSettings;
import com.google.ads.googleads.v16.services.AssetGroupServiceClient;
import com.google.ads.googleads.v16.services.AssetGroupServiceSettings;
import com.google.ads.googleads.v16.services.AssetGroupSignalServiceClient;
import com.google.ads.googleads.v16.services.AssetGroupSignalServiceSettings;
import com.google.ads.googleads.v16.services.AssetServiceClient;
import com.google.ads.googleads.v16.services.AssetServiceSettings;
import com.google.ads.googleads.v16.services.AssetSetAssetServiceClient;
import com.google.ads.googleads.v16.services.AssetSetAssetServiceSettings;
import com.google.ads.googleads.v16.services.AssetSetServiceClient;
import com.google.ads.googleads.v16.services.AssetSetServiceSettings;
import com.google.ads.googleads.v16.services.AudienceInsightsServiceClient;
import com.google.ads.googleads.v16.services.AudienceInsightsServiceSettings;
import com.google.ads.googleads.v16.services.AudienceServiceClient;
import com.google.ads.googleads.v16.services.AudienceServiceSettings;
import com.google.ads.googleads.v16.services.BatchJobServiceClient;
import com.google.ads.googleads.v16.services.BatchJobServiceSettings;
import com.google.ads.googleads.v16.services.BiddingDataExclusionServiceClient;
import com.google.ads.googleads.v16.services.BiddingDataExclusionServiceSettings;
import com.google.ads.googleads.v16.services.BiddingSeasonalityAdjustmentServiceClient;
import com.google.ads.googleads.v16.services.BiddingSeasonalityAdjustmentServiceSettings;
import com.google.ads.googleads.v16.services.BiddingStrategyServiceClient;
import com.google.ads.googleads.v16.services.BiddingStrategyServiceSettings;
import com.google.ads.googleads.v16.services.BillingSetupServiceClient;
import com.google.ads.googleads.v16.services.BillingSetupServiceSettings;
import com.google.ads.googleads.v16.services.BrandSuggestionServiceClient;
import com.google.ads.googleads.v16.services.BrandSuggestionServiceSettings;
import com.google.ads.googleads.v16.services.CampaignAssetServiceClient;
import com.google.ads.googleads.v16.services.CampaignAssetServiceSettings;
import com.google.ads.googleads.v16.services.CampaignAssetSetServiceClient;
import com.google.ads.googleads.v16.services.CampaignAssetSetServiceSettings;
import com.google.ads.googleads.v16.services.CampaignBidModifierServiceClient;
import com.google.ads.googleads.v16.services.CampaignBidModifierServiceSettings;
import com.google.ads.googleads.v16.services.CampaignBudgetServiceClient;
import com.google.ads.googleads.v16.services.CampaignBudgetServiceSettings;
import com.google.ads.googleads.v16.services.CampaignConversionGoalServiceClient;
import com.google.ads.googleads.v16.services.CampaignConversionGoalServiceSettings;
import com.google.ads.googleads.v16.services.CampaignCriterionServiceClient;
import com.google.ads.googleads.v16.services.CampaignCriterionServiceSettings;
import com.google.ads.googleads.v16.services.CampaignCustomizerServiceClient;
import com.google.ads.googleads.v16.services.CampaignCustomizerServiceSettings;
import com.google.ads.googleads.v16.services.CampaignDraftServiceClient;
import com.google.ads.googleads.v16.services.CampaignDraftServiceSettings;
import com.google.ads.googleads.v16.services.CampaignExtensionSettingServiceClient;
import com.google.ads.googleads.v16.services.CampaignExtensionSettingServiceSettings;
import com.google.ads.googleads.v16.services.CampaignFeedServiceClient;
import com.google.ads.googleads.v16.services.CampaignFeedServiceSettings;
import com.google.ads.googleads.v16.services.CampaignGroupServiceClient;
import com.google.ads.googleads.v16.services.CampaignGroupServiceSettings;
import com.google.ads.googleads.v16.services.CampaignLabelServiceClient;
import com.google.ads.googleads.v16.services.CampaignLabelServiceSettings;
import com.google.ads.googleads.v16.services.CampaignLifecycleGoalServiceClient;
import com.google.ads.googleads.v16.services.CampaignLifecycleGoalServiceSettings;
import com.google.ads.googleads.v16.services.CampaignServiceClient;
import com.google.ads.googleads.v16.services.CampaignServiceSettings;
import com.google.ads.googleads.v16.services.CampaignSharedSetServiceClient;
import com.google.ads.googleads.v16.services.CampaignSharedSetServiceSettings;
import com.google.ads.googleads.v16.services.ConversionActionServiceClient;
import com.google.ads.googleads.v16.services.ConversionActionServiceSettings;
import com.google.ads.googleads.v16.services.ConversionAdjustmentUploadServiceClient;
import com.google.ads.googleads.v16.services.ConversionAdjustmentUploadServiceSettings;
import com.google.ads.googleads.v16.services.ConversionCustomVariableServiceClient;
import com.google.ads.googleads.v16.services.ConversionCustomVariableServiceSettings;
import com.google.ads.googleads.v16.services.ConversionGoalCampaignConfigServiceClient;
import com.google.ads.googleads.v16.services.ConversionGoalCampaignConfigServiceSettings;
import com.google.ads.googleads.v16.services.ConversionUploadServiceClient;
import com.google.ads.googleads.v16.services.ConversionUploadServiceSettings;
import com.google.ads.googleads.v16.services.ConversionValueRuleServiceClient;
import com.google.ads.googleads.v16.services.ConversionValueRuleServiceSettings;
import com.google.ads.googleads.v16.services.ConversionValueRuleSetServiceClient;
import com.google.ads.googleads.v16.services.ConversionValueRuleSetServiceSettings;
import com.google.ads.googleads.v16.services.CustomAudienceServiceClient;
import com.google.ads.googleads.v16.services.CustomAudienceServiceSettings;
import com.google.ads.googleads.v16.services.CustomConversionGoalServiceClient;
import com.google.ads.googleads.v16.services.CustomConversionGoalServiceSettings;
import com.google.ads.googleads.v16.services.CustomInterestServiceClient;
import com.google.ads.googleads.v16.services.CustomInterestServiceSettings;
import com.google.ads.googleads.v16.services.CustomerAssetServiceClient;
import com.google.ads.googleads.v16.services.CustomerAssetServiceSettings;
import com.google.ads.googleads.v16.services.CustomerAssetSetServiceClient;
import com.google.ads.googleads.v16.services.CustomerAssetSetServiceSettings;
import com.google.ads.googleads.v16.services.CustomerClientLinkServiceClient;
import com.google.ads.googleads.v16.services.CustomerClientLinkServiceSettings;
import com.google.ads.googleads.v16.services.CustomerConversionGoalServiceClient;
import com.google.ads.googleads.v16.services.CustomerConversionGoalServiceSettings;
import com.google.ads.googleads.v16.services.CustomerCustomizerServiceClient;
import com.google.ads.googleads.v16.services.CustomerCustomizerServiceSettings;
import com.google.ads.googleads.v16.services.CustomerExtensionSettingServiceClient;
import com.google.ads.googleads.v16.services.CustomerExtensionSettingServiceSettings;
import com.google.ads.googleads.v16.services.CustomerFeedServiceClient;
import com.google.ads.googleads.v16.services.CustomerFeedServiceSettings;
import com.google.ads.googleads.v16.services.CustomerLabelServiceClient;
import com.google.ads.googleads.v16.services.CustomerLabelServiceSettings;
import com.google.ads.googleads.v16.services.CustomerLifecycleGoalServiceClient;
import com.google.ads.googleads.v16.services.CustomerLifecycleGoalServiceSettings;
import com.google.ads.googleads.v16.services.CustomerManagerLinkServiceClient;
import com.google.ads.googleads.v16.services.CustomerManagerLinkServiceSettings;
import com.google.ads.googleads.v16.services.CustomerNegativeCriterionServiceClient;
import com.google.ads.googleads.v16.services.CustomerNegativeCriterionServiceSettings;
import com.google.ads.googleads.v16.services.CustomerServiceClient;
import com.google.ads.googleads.v16.services.CustomerServiceSettings;
import com.google.ads.googleads.v16.services.CustomerSkAdNetworkConversionValueSchemaServiceClient;
import com.google.ads.googleads.v16.services.CustomerSkAdNetworkConversionValueSchemaServiceSettings;
import com.google.ads.googleads.v16.services.CustomerUserAccessInvitationServiceClient;
import com.google.ads.googleads.v16.services.CustomerUserAccessInvitationServiceSettings;
import com.google.ads.googleads.v16.services.CustomerUserAccessServiceClient;
import com.google.ads.googleads.v16.services.CustomerUserAccessServiceSettings;
import com.google.ads.googleads.v16.services.CustomizerAttributeServiceClient;
import com.google.ads.googleads.v16.services.CustomizerAttributeServiceSettings;
import com.google.ads.googleads.v16.services.ExperimentArmServiceClient;
import com.google.ads.googleads.v16.services.ExperimentArmServiceSettings;
import com.google.ads.googleads.v16.services.ExperimentServiceClient;
import com.google.ads.googleads.v16.services.ExperimentServiceSettings;
import com.google.ads.googleads.v16.services.ExtensionFeedItemServiceClient;
import com.google.ads.googleads.v16.services.ExtensionFeedItemServiceSettings;
import com.google.ads.googleads.v16.services.FeedItemServiceClient;
import com.google.ads.googleads.v16.services.FeedItemServiceSettings;
import com.google.ads.googleads.v16.services.FeedItemSetLinkServiceClient;
import com.google.ads.googleads.v16.services.FeedItemSetLinkServiceSettings;
import com.google.ads.googleads.v16.services.FeedItemSetServiceClient;
import com.google.ads.googleads.v16.services.FeedItemSetServiceSettings;
import com.google.ads.googleads.v16.services.FeedItemTargetServiceClient;
import com.google.ads.googleads.v16.services.FeedItemTargetServiceSettings;
import com.google.ads.googleads.v16.services.FeedMappingServiceClient;
import com.google.ads.googleads.v16.services.FeedMappingServiceSettings;
import com.google.ads.googleads.v16.services.FeedServiceClient;
import com.google.ads.googleads.v16.services.FeedServiceSettings;
import com.google.ads.googleads.v16.services.GeoTargetConstantServiceClient;
import com.google.ads.googleads.v16.services.GeoTargetConstantServiceSettings;
import com.google.ads.googleads.v16.services.GoogleAdsFieldServiceClient;
import com.google.ads.googleads.v16.services.GoogleAdsFieldServiceSettings;
import com.google.ads.googleads.v16.services.GoogleAdsServiceClient;
import com.google.ads.googleads.v16.services.GoogleAdsServiceSettings;
import com.google.ads.googleads.v16.services.GoogleAdsVersion;
import com.google.ads.googleads.v16.services.IdentityVerificationServiceClient;
import com.google.ads.googleads.v16.services.IdentityVerificationServiceSettings;
import com.google.ads.googleads.v16.services.InvoiceServiceClient;
import com.google.ads.googleads.v16.services.InvoiceServiceSettings;
import com.google.ads.googleads.v16.services.KeywordPlanAdGroupKeywordServiceClient;
import com.google.ads.googleads.v16.services.KeywordPlanAdGroupKeywordServiceSettings;
import com.google.ads.googleads.v16.services.KeywordPlanAdGroupServiceClient;
import com.google.ads.googleads.v16.services.KeywordPlanAdGroupServiceSettings;
import com.google.ads.googleads.v16.services.KeywordPlanCampaignKeywordServiceClient;
import com.google.ads.googleads.v16.services.KeywordPlanCampaignKeywordServiceSettings;
import com.google.ads.googleads.v16.services.KeywordPlanCampaignServiceClient;
import com.google.ads.googleads.v16.services.KeywordPlanCampaignServiceSettings;
import com.google.ads.googleads.v16.services.KeywordPlanIdeaServiceClient;
import com.google.ads.googleads.v16.services.KeywordPlanIdeaServiceSettings;
import com.google.ads.googleads.v16.services.KeywordPlanServiceClient;
import com.google.ads.googleads.v16.services.KeywordPlanServiceSettings;
import com.google.ads.googleads.v16.services.KeywordThemeConstantServiceClient;
import com.google.ads.googleads.v16.services.KeywordThemeConstantServiceSettings;
import com.google.ads.googleads.v16.services.LabelServiceClient;
import com.google.ads.googleads.v16.services.LabelServiceSettings;
import com.google.ads.googleads.v16.services.OfflineUserDataJobServiceClient;
import com.google.ads.googleads.v16.services.OfflineUserDataJobServiceSettings;
import com.google.ads.googleads.v16.services.PaymentsAccountServiceClient;
import com.google.ads.googleads.v16.services.PaymentsAccountServiceSettings;
import com.google.ads.googleads.v16.services.ProductLinkInvitationServiceClient;
import com.google.ads.googleads.v16.services.ProductLinkInvitationServiceSettings;
import com.google.ads.googleads.v16.services.ProductLinkServiceClient;
import com.google.ads.googleads.v16.services.ProductLinkServiceSettings;
import com.google.ads.googleads.v16.services.ReachPlanServiceClient;
import com.google.ads.googleads.v16.services.ReachPlanServiceSettings;
import com.google.ads.googleads.v16.services.RecommendationServiceClient;
import com.google.ads.googleads.v16.services.RecommendationServiceSettings;
import com.google.ads.googleads.v16.services.RecommendationSubscriptionServiceClient;
import com.google.ads.googleads.v16.services.RecommendationSubscriptionServiceSettings;
import com.google.ads.googleads.v16.services.RemarketingActionServiceClient;
import com.google.ads.googleads.v16.services.RemarketingActionServiceSettings;
import com.google.ads.googleads.v16.services.SharedCriterionServiceClient;
import com.google.ads.googleads.v16.services.SharedCriterionServiceSettings;
import com.google.ads.googleads.v16.services.SharedSetServiceClient;
import com.google.ads.googleads.v16.services.SharedSetServiceSettings;
import com.google.ads.googleads.v16.services.SmartCampaignSettingServiceClient;
import com.google.ads.googleads.v16.services.SmartCampaignSettingServiceSettings;
import com.google.ads.googleads.v16.services.SmartCampaignSuggestServiceClient;
import com.google.ads.googleads.v16.services.SmartCampaignSuggestServiceSettings;
import com.google.ads.googleads.v16.services.ThirdPartyAppAnalyticsLinkServiceClient;
import com.google.ads.googleads.v16.services.ThirdPartyAppAnalyticsLinkServiceSettings;
import com.google.ads.googleads.v16.services.TravelAssetSuggestionServiceClient;
import com.google.ads.googleads.v16.services.TravelAssetSuggestionServiceSettings;
import com.google.ads.googleads.v16.services.UserDataServiceClient;
import com.google.ads.googleads.v16.services.UserDataServiceSettings;
import com.google.ads.googleads.v16.services.UserListServiceClient;
import com.google.ads.googleads.v16.services.UserListServiceSettings;
import com.google.api.gax.core.FixedCredentialsProvider;
import com.google.api.gax.rpc.TransportChannelProvider;
import com.google.auth.Credentials;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableSortedSet;
import java.io.IOException;
import java.util.SortedSet;
import javax.annotation.Generated;

@Generated("GoogleAdsCatalogAnnotationProcessor")
public class GeneratedCatalog implements ApiCatalog {
  private static GeneratedCatalog instance;

  static {
    try {
      instance = new GeneratedCatalog(VersionFactory.getVersions());
    } catch (IllegalAccessException e) {
      throw new RuntimeException(e);
    } catch (InstantiationException e) {
      throw new RuntimeException(e);
    }
  }

  private final ImmutableSortedSet<Version> supportedVersions;

  /**
   * Creates a new constant catalog from a known collection of versions. */
  public GeneratedCatalog(ImmutableSet<Version> versions) {
    supportedVersions = ImmutableSortedSet.copyOf(versions);
  }

  public static GeneratedCatalog getDefault() {
    return instance;
  }

  public SortedSet<Version> getSupportedVersions() {
    return supportedVersions;
  }

  public Version getLatestVersion() {
    return getSupportedVersions().first();
  }

  public GoogleAdsAllVersions createAllVersionsClient(TransportChannelProvider provider,
      Credentials credentials) {
    return new GoogleAdsAllVersions() {
      @Override
      public GoogleAdsVersion getVersion16() {
        return new V16Client(provider, credentials);
      }

      @Override
      public com.google.ads.googleads.v14.services.GoogleAdsVersion getVersion14() {
        return new V14Client(provider, credentials);
      }

      @Override
      public com.google.ads.googleads.v15.services.GoogleAdsVersion getVersion15() {
        return new V15Client(provider, credentials);
      }

      @Override
      public GoogleAdsVersion getLatestVersion() {
        return getVersion16();
      }
    };
  }

  private static class V16Client implements GoogleAdsVersion {
    private final TransportChannelProvider provider;

    private final Credentials credentials;

    public V16Client(TransportChannelProvider provider, Credentials credentials) {
      this.provider = provider;
      this.credentials = credentials;
    }

    @Override
    public AccountBudgetProposalServiceClient createAccountBudgetProposalServiceClient() {
      try {
        AccountBudgetProposalServiceSettings settings =
          AccountBudgetProposalServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return AccountBudgetProposalServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public AccountLinkServiceClient createAccountLinkServiceClient() {
      try {
        AccountLinkServiceSettings settings =
          AccountLinkServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return AccountLinkServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public AdGroupAdLabelServiceClient createAdGroupAdLabelServiceClient() {
      try {
        AdGroupAdLabelServiceSettings settings =
          AdGroupAdLabelServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return AdGroupAdLabelServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public AdGroupAdServiceClient createAdGroupAdServiceClient() {
      try {
        AdGroupAdServiceSettings settings =
          AdGroupAdServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return AdGroupAdServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public AdGroupAssetServiceClient createAdGroupAssetServiceClient() {
      try {
        AdGroupAssetServiceSettings settings =
          AdGroupAssetServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return AdGroupAssetServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public AdGroupAssetSetServiceClient createAdGroupAssetSetServiceClient() {
      try {
        AdGroupAssetSetServiceSettings settings =
          AdGroupAssetSetServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return AdGroupAssetSetServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public AdGroupBidModifierServiceClient createAdGroupBidModifierServiceClient() {
      try {
        AdGroupBidModifierServiceSettings settings =
          AdGroupBidModifierServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return AdGroupBidModifierServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public AdGroupCriterionCustomizerServiceClient createAdGroupCriterionCustomizerServiceClient() {
      try {
        AdGroupCriterionCustomizerServiceSettings settings =
          AdGroupCriterionCustomizerServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return AdGroupCriterionCustomizerServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public AdGroupCriterionLabelServiceClient createAdGroupCriterionLabelServiceClient() {
      try {
        AdGroupCriterionLabelServiceSettings settings =
          AdGroupCriterionLabelServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return AdGroupCriterionLabelServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public AdGroupCriterionServiceClient createAdGroupCriterionServiceClient() {
      try {
        AdGroupCriterionServiceSettings settings =
          AdGroupCriterionServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return AdGroupCriterionServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public AdGroupCustomizerServiceClient createAdGroupCustomizerServiceClient() {
      try {
        AdGroupCustomizerServiceSettings settings =
          AdGroupCustomizerServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return AdGroupCustomizerServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public AdGroupExtensionSettingServiceClient createAdGroupExtensionSettingServiceClient() {
      try {
        AdGroupExtensionSettingServiceSettings settings =
          AdGroupExtensionSettingServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return AdGroupExtensionSettingServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public AdGroupFeedServiceClient createAdGroupFeedServiceClient() {
      try {
        AdGroupFeedServiceSettings settings =
          AdGroupFeedServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return AdGroupFeedServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public AdGroupLabelServiceClient createAdGroupLabelServiceClient() {
      try {
        AdGroupLabelServiceSettings settings =
          AdGroupLabelServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return AdGroupLabelServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public AdGroupServiceClient createAdGroupServiceClient() {
      try {
        AdGroupServiceSettings settings =
          AdGroupServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return AdGroupServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public AdParameterServiceClient createAdParameterServiceClient() {
      try {
        AdParameterServiceSettings settings =
          AdParameterServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return AdParameterServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public AdServiceClient createAdServiceClient() {
      try {
        AdServiceSettings settings =
          AdServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return AdServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public AssetGroupAssetServiceClient createAssetGroupAssetServiceClient() {
      try {
        AssetGroupAssetServiceSettings settings =
          AssetGroupAssetServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return AssetGroupAssetServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public AssetGroupListingGroupFilterServiceClient createAssetGroupListingGroupFilterServiceClient(
        ) {
      try {
        AssetGroupListingGroupFilterServiceSettings settings =
          AssetGroupListingGroupFilterServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return AssetGroupListingGroupFilterServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public AssetGroupServiceClient createAssetGroupServiceClient() {
      try {
        AssetGroupServiceSettings settings =
          AssetGroupServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return AssetGroupServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public AssetGroupSignalServiceClient createAssetGroupSignalServiceClient() {
      try {
        AssetGroupSignalServiceSettings settings =
          AssetGroupSignalServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return AssetGroupSignalServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public AssetServiceClient createAssetServiceClient() {
      try {
        AssetServiceSettings settings =
          AssetServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return AssetServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public AssetSetAssetServiceClient createAssetSetAssetServiceClient() {
      try {
        AssetSetAssetServiceSettings settings =
          AssetSetAssetServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return AssetSetAssetServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public AssetSetServiceClient createAssetSetServiceClient() {
      try {
        AssetSetServiceSettings settings =
          AssetSetServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return AssetSetServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public AudienceInsightsServiceClient createAudienceInsightsServiceClient() {
      try {
        AudienceInsightsServiceSettings settings =
          AudienceInsightsServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return AudienceInsightsServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public AudienceServiceClient createAudienceServiceClient() {
      try {
        AudienceServiceSettings settings =
          AudienceServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return AudienceServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public BatchJobServiceClient createBatchJobServiceClient() {
      try {
        BatchJobServiceSettings settings =
          BatchJobServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return BatchJobServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public BiddingDataExclusionServiceClient createBiddingDataExclusionServiceClient() {
      try {
        BiddingDataExclusionServiceSettings settings =
          BiddingDataExclusionServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return BiddingDataExclusionServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public BiddingSeasonalityAdjustmentServiceClient createBiddingSeasonalityAdjustmentServiceClient(
        ) {
      try {
        BiddingSeasonalityAdjustmentServiceSettings settings =
          BiddingSeasonalityAdjustmentServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return BiddingSeasonalityAdjustmentServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public BiddingStrategyServiceClient createBiddingStrategyServiceClient() {
      try {
        BiddingStrategyServiceSettings settings =
          BiddingStrategyServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return BiddingStrategyServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public BillingSetupServiceClient createBillingSetupServiceClient() {
      try {
        BillingSetupServiceSettings settings =
          BillingSetupServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return BillingSetupServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public CampaignAssetServiceClient createCampaignAssetServiceClient() {
      try {
        CampaignAssetServiceSettings settings =
          CampaignAssetServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return CampaignAssetServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public CampaignAssetSetServiceClient createCampaignAssetSetServiceClient() {
      try {
        CampaignAssetSetServiceSettings settings =
          CampaignAssetSetServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return CampaignAssetSetServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public CampaignBidModifierServiceClient createCampaignBidModifierServiceClient() {
      try {
        CampaignBidModifierServiceSettings settings =
          CampaignBidModifierServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return CampaignBidModifierServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public CampaignBudgetServiceClient createCampaignBudgetServiceClient() {
      try {
        CampaignBudgetServiceSettings settings =
          CampaignBudgetServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return CampaignBudgetServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public CampaignConversionGoalServiceClient createCampaignConversionGoalServiceClient() {
      try {
        CampaignConversionGoalServiceSettings settings =
          CampaignConversionGoalServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return CampaignConversionGoalServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public CampaignCriterionServiceClient createCampaignCriterionServiceClient() {
      try {
        CampaignCriterionServiceSettings settings =
          CampaignCriterionServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return CampaignCriterionServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public CampaignCustomizerServiceClient createCampaignCustomizerServiceClient() {
      try {
        CampaignCustomizerServiceSettings settings =
          CampaignCustomizerServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return CampaignCustomizerServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public CampaignDraftServiceClient createCampaignDraftServiceClient() {
      try {
        CampaignDraftServiceSettings settings =
          CampaignDraftServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return CampaignDraftServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public CampaignExtensionSettingServiceClient createCampaignExtensionSettingServiceClient() {
      try {
        CampaignExtensionSettingServiceSettings settings =
          CampaignExtensionSettingServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return CampaignExtensionSettingServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public CampaignFeedServiceClient createCampaignFeedServiceClient() {
      try {
        CampaignFeedServiceSettings settings =
          CampaignFeedServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return CampaignFeedServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public CampaignGroupServiceClient createCampaignGroupServiceClient() {
      try {
        CampaignGroupServiceSettings settings =
          CampaignGroupServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return CampaignGroupServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public CampaignLabelServiceClient createCampaignLabelServiceClient() {
      try {
        CampaignLabelServiceSettings settings =
          CampaignLabelServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return CampaignLabelServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public CampaignServiceClient createCampaignServiceClient() {
      try {
        CampaignServiceSettings settings =
          CampaignServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return CampaignServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public CampaignSharedSetServiceClient createCampaignSharedSetServiceClient() {
      try {
        CampaignSharedSetServiceSettings settings =
          CampaignSharedSetServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return CampaignSharedSetServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public ConversionActionServiceClient createConversionActionServiceClient() {
      try {
        ConversionActionServiceSettings settings =
          ConversionActionServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return ConversionActionServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public ConversionAdjustmentUploadServiceClient createConversionAdjustmentUploadServiceClient() {
      try {
        ConversionAdjustmentUploadServiceSettings settings =
          ConversionAdjustmentUploadServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return ConversionAdjustmentUploadServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public ConversionCustomVariableServiceClient createConversionCustomVariableServiceClient() {
      try {
        ConversionCustomVariableServiceSettings settings =
          ConversionCustomVariableServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return ConversionCustomVariableServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public ConversionGoalCampaignConfigServiceClient createConversionGoalCampaignConfigServiceClient(
        ) {
      try {
        ConversionGoalCampaignConfigServiceSettings settings =
          ConversionGoalCampaignConfigServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return ConversionGoalCampaignConfigServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public ConversionUploadServiceClient createConversionUploadServiceClient() {
      try {
        ConversionUploadServiceSettings settings =
          ConversionUploadServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return ConversionUploadServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public ConversionValueRuleServiceClient createConversionValueRuleServiceClient() {
      try {
        ConversionValueRuleServiceSettings settings =
          ConversionValueRuleServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return ConversionValueRuleServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public ConversionValueRuleSetServiceClient createConversionValueRuleSetServiceClient() {
      try {
        ConversionValueRuleSetServiceSettings settings =
          ConversionValueRuleSetServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return ConversionValueRuleSetServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public CustomAudienceServiceClient createCustomAudienceServiceClient() {
      try {
        CustomAudienceServiceSettings settings =
          CustomAudienceServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return CustomAudienceServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public CustomConversionGoalServiceClient createCustomConversionGoalServiceClient() {
      try {
        CustomConversionGoalServiceSettings settings =
          CustomConversionGoalServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return CustomConversionGoalServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public CustomInterestServiceClient createCustomInterestServiceClient() {
      try {
        CustomInterestServiceSettings settings =
          CustomInterestServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return CustomInterestServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public CustomerAssetServiceClient createCustomerAssetServiceClient() {
      try {
        CustomerAssetServiceSettings settings =
          CustomerAssetServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return CustomerAssetServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public CustomerAssetSetServiceClient createCustomerAssetSetServiceClient() {
      try {
        CustomerAssetSetServiceSettings settings =
          CustomerAssetSetServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return CustomerAssetSetServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public CustomerClientLinkServiceClient createCustomerClientLinkServiceClient() {
      try {
        CustomerClientLinkServiceSettings settings =
          CustomerClientLinkServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return CustomerClientLinkServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public CustomerConversionGoalServiceClient createCustomerConversionGoalServiceClient() {
      try {
        CustomerConversionGoalServiceSettings settings =
          CustomerConversionGoalServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return CustomerConversionGoalServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public CustomerCustomizerServiceClient createCustomerCustomizerServiceClient() {
      try {
        CustomerCustomizerServiceSettings settings =
          CustomerCustomizerServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return CustomerCustomizerServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public CustomerExtensionSettingServiceClient createCustomerExtensionSettingServiceClient() {
      try {
        CustomerExtensionSettingServiceSettings settings =
          CustomerExtensionSettingServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return CustomerExtensionSettingServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public CustomerFeedServiceClient createCustomerFeedServiceClient() {
      try {
        CustomerFeedServiceSettings settings =
          CustomerFeedServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return CustomerFeedServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public CustomerLabelServiceClient createCustomerLabelServiceClient() {
      try {
        CustomerLabelServiceSettings settings =
          CustomerLabelServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return CustomerLabelServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public CustomerManagerLinkServiceClient createCustomerManagerLinkServiceClient() {
      try {
        CustomerManagerLinkServiceSettings settings =
          CustomerManagerLinkServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return CustomerManagerLinkServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public CustomerNegativeCriterionServiceClient createCustomerNegativeCriterionServiceClient() {
      try {
        CustomerNegativeCriterionServiceSettings settings =
          CustomerNegativeCriterionServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return CustomerNegativeCriterionServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public CustomerServiceClient createCustomerServiceClient() {
      try {
        CustomerServiceSettings settings =
          CustomerServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return CustomerServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public CustomerSkAdNetworkConversionValueSchemaServiceClient createCustomerSkAdNetworkConversionValueSchemaServiceClient(
        ) {
      try {
        CustomerSkAdNetworkConversionValueSchemaServiceSettings settings =
          CustomerSkAdNetworkConversionValueSchemaServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return CustomerSkAdNetworkConversionValueSchemaServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public CustomerUserAccessInvitationServiceClient createCustomerUserAccessInvitationServiceClient(
        ) {
      try {
        CustomerUserAccessInvitationServiceSettings settings =
          CustomerUserAccessInvitationServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return CustomerUserAccessInvitationServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public CustomerUserAccessServiceClient createCustomerUserAccessServiceClient() {
      try {
        CustomerUserAccessServiceSettings settings =
          CustomerUserAccessServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return CustomerUserAccessServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public CustomizerAttributeServiceClient createCustomizerAttributeServiceClient() {
      try {
        CustomizerAttributeServiceSettings settings =
          CustomizerAttributeServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return CustomizerAttributeServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public ExperimentArmServiceClient createExperimentArmServiceClient() {
      try {
        ExperimentArmServiceSettings settings =
          ExperimentArmServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return ExperimentArmServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public ExperimentServiceClient createExperimentServiceClient() {
      try {
        ExperimentServiceSettings settings =
          ExperimentServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return ExperimentServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public ExtensionFeedItemServiceClient createExtensionFeedItemServiceClient() {
      try {
        ExtensionFeedItemServiceSettings settings =
          ExtensionFeedItemServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return ExtensionFeedItemServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public FeedItemServiceClient createFeedItemServiceClient() {
      try {
        FeedItemServiceSettings settings =
          FeedItemServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return FeedItemServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public FeedItemSetLinkServiceClient createFeedItemSetLinkServiceClient() {
      try {
        FeedItemSetLinkServiceSettings settings =
          FeedItemSetLinkServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return FeedItemSetLinkServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public FeedItemSetServiceClient createFeedItemSetServiceClient() {
      try {
        FeedItemSetServiceSettings settings =
          FeedItemSetServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return FeedItemSetServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public FeedItemTargetServiceClient createFeedItemTargetServiceClient() {
      try {
        FeedItemTargetServiceSettings settings =
          FeedItemTargetServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return FeedItemTargetServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public FeedMappingServiceClient createFeedMappingServiceClient() {
      try {
        FeedMappingServiceSettings settings =
          FeedMappingServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return FeedMappingServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public FeedServiceClient createFeedServiceClient() {
      try {
        FeedServiceSettings settings =
          FeedServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return FeedServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public GeoTargetConstantServiceClient createGeoTargetConstantServiceClient() {
      try {
        GeoTargetConstantServiceSettings settings =
          GeoTargetConstantServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return GeoTargetConstantServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public GoogleAdsFieldServiceClient createGoogleAdsFieldServiceClient() {
      try {
        GoogleAdsFieldServiceSettings settings =
          GoogleAdsFieldServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return GoogleAdsFieldServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public GoogleAdsServiceClient createGoogleAdsServiceClient() {
      try {
        GoogleAdsServiceSettings settings =
          GoogleAdsServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return GoogleAdsServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public InvoiceServiceClient createInvoiceServiceClient() {
      try {
        InvoiceServiceSettings settings =
          InvoiceServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return InvoiceServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public KeywordPlanAdGroupKeywordServiceClient createKeywordPlanAdGroupKeywordServiceClient() {
      try {
        KeywordPlanAdGroupKeywordServiceSettings settings =
          KeywordPlanAdGroupKeywordServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return KeywordPlanAdGroupKeywordServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public KeywordPlanAdGroupServiceClient createKeywordPlanAdGroupServiceClient() {
      try {
        KeywordPlanAdGroupServiceSettings settings =
          KeywordPlanAdGroupServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return KeywordPlanAdGroupServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public KeywordPlanCampaignKeywordServiceClient createKeywordPlanCampaignKeywordServiceClient() {
      try {
        KeywordPlanCampaignKeywordServiceSettings settings =
          KeywordPlanCampaignKeywordServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return KeywordPlanCampaignKeywordServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public KeywordPlanCampaignServiceClient createKeywordPlanCampaignServiceClient() {
      try {
        KeywordPlanCampaignServiceSettings settings =
          KeywordPlanCampaignServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return KeywordPlanCampaignServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public KeywordPlanIdeaServiceClient createKeywordPlanIdeaServiceClient() {
      try {
        KeywordPlanIdeaServiceSettings settings =
          KeywordPlanIdeaServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return KeywordPlanIdeaServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public KeywordPlanServiceClient createKeywordPlanServiceClient() {
      try {
        KeywordPlanServiceSettings settings =
          KeywordPlanServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return KeywordPlanServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public KeywordThemeConstantServiceClient createKeywordThemeConstantServiceClient() {
      try {
        KeywordThemeConstantServiceSettings settings =
          KeywordThemeConstantServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return KeywordThemeConstantServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public LabelServiceClient createLabelServiceClient() {
      try {
        LabelServiceSettings settings =
          LabelServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return LabelServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public OfflineUserDataJobServiceClient createOfflineUserDataJobServiceClient() {
      try {
        OfflineUserDataJobServiceSettings settings =
          OfflineUserDataJobServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return OfflineUserDataJobServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public PaymentsAccountServiceClient createPaymentsAccountServiceClient() {
      try {
        PaymentsAccountServiceSettings settings =
          PaymentsAccountServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return PaymentsAccountServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public ProductLinkServiceClient createProductLinkServiceClient() {
      try {
        ProductLinkServiceSettings settings =
          ProductLinkServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return ProductLinkServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public ReachPlanServiceClient createReachPlanServiceClient() {
      try {
        ReachPlanServiceSettings settings =
          ReachPlanServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return ReachPlanServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public RecommendationServiceClient createRecommendationServiceClient() {
      try {
        RecommendationServiceSettings settings =
          RecommendationServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return RecommendationServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public RemarketingActionServiceClient createRemarketingActionServiceClient() {
      try {
        RemarketingActionServiceSettings settings =
          RemarketingActionServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return RemarketingActionServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public SharedCriterionServiceClient createSharedCriterionServiceClient() {
      try {
        SharedCriterionServiceSettings settings =
          SharedCriterionServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return SharedCriterionServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public SharedSetServiceClient createSharedSetServiceClient() {
      try {
        SharedSetServiceSettings settings =
          SharedSetServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return SharedSetServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public SmartCampaignSettingServiceClient createSmartCampaignSettingServiceClient() {
      try {
        SmartCampaignSettingServiceSettings settings =
          SmartCampaignSettingServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return SmartCampaignSettingServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public SmartCampaignSuggestServiceClient createSmartCampaignSuggestServiceClient() {
      try {
        SmartCampaignSuggestServiceSettings settings =
          SmartCampaignSuggestServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return SmartCampaignSuggestServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public ThirdPartyAppAnalyticsLinkServiceClient createThirdPartyAppAnalyticsLinkServiceClient() {
      try {
        ThirdPartyAppAnalyticsLinkServiceSettings settings =
          ThirdPartyAppAnalyticsLinkServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return ThirdPartyAppAnalyticsLinkServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public TravelAssetSuggestionServiceClient createTravelAssetSuggestionServiceClient() {
      try {
        TravelAssetSuggestionServiceSettings settings =
          TravelAssetSuggestionServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return TravelAssetSuggestionServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public UserDataServiceClient createUserDataServiceClient() {
      try {
        UserDataServiceSettings settings =
          UserDataServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return UserDataServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public UserListServiceClient createUserListServiceClient() {
      try {
        UserListServiceSettings settings =
          UserListServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return UserListServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public BrandSuggestionServiceClient createBrandSuggestionServiceClient() {
      try {
        BrandSuggestionServiceSettings settings =
          BrandSuggestionServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return BrandSuggestionServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public CampaignLifecycleGoalServiceClient createCampaignLifecycleGoalServiceClient() {
      try {
        CampaignLifecycleGoalServiceSettings settings =
          CampaignLifecycleGoalServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return CampaignLifecycleGoalServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public CustomerLifecycleGoalServiceClient createCustomerLifecycleGoalServiceClient() {
      try {
        CustomerLifecycleGoalServiceSettings settings =
          CustomerLifecycleGoalServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return CustomerLifecycleGoalServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public ProductLinkInvitationServiceClient createProductLinkInvitationServiceClient() {
      try {
        ProductLinkInvitationServiceSettings settings =
          ProductLinkInvitationServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return ProductLinkInvitationServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public RecommendationSubscriptionServiceClient createRecommendationSubscriptionServiceClient() {
      try {
        RecommendationSubscriptionServiceSettings settings =
          RecommendationSubscriptionServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return RecommendationSubscriptionServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public IdentityVerificationServiceClient createIdentityVerificationServiceClient() {
      try {
        IdentityVerificationServiceSettings settings =
          IdentityVerificationServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return IdentityVerificationServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }
  }

  private static class V14Client implements com.google.ads.googleads.v14.services.GoogleAdsVersion {
    private final TransportChannelProvider provider;

    private final Credentials credentials;

    public V14Client(TransportChannelProvider provider, Credentials credentials) {
      this.provider = provider;
      this.credentials = credentials;
    }

    @Override
    public com.google.ads.googleads.v14.services.AccountBudgetProposalServiceClient createAccountBudgetProposalServiceClient(
        ) {
      try {
        com.google.ads.googleads.v14.services.AccountBudgetProposalServiceSettings settings =
          com.google.ads.googleads.v14.services.AccountBudgetProposalServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v14.services.AccountBudgetProposalServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v14.services.AccountLinkServiceClient createAccountLinkServiceClient(
        ) {
      try {
        com.google.ads.googleads.v14.services.AccountLinkServiceSettings settings =
          com.google.ads.googleads.v14.services.AccountLinkServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v14.services.AccountLinkServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v14.services.AdGroupAdLabelServiceClient createAdGroupAdLabelServiceClient(
        ) {
      try {
        com.google.ads.googleads.v14.services.AdGroupAdLabelServiceSettings settings =
          com.google.ads.googleads.v14.services.AdGroupAdLabelServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v14.services.AdGroupAdLabelServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v14.services.AdGroupAdServiceClient createAdGroupAdServiceClient(
        ) {
      try {
        com.google.ads.googleads.v14.services.AdGroupAdServiceSettings settings =
          com.google.ads.googleads.v14.services.AdGroupAdServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v14.services.AdGroupAdServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v14.services.AdGroupAssetServiceClient createAdGroupAssetServiceClient(
        ) {
      try {
        com.google.ads.googleads.v14.services.AdGroupAssetServiceSettings settings =
          com.google.ads.googleads.v14.services.AdGroupAssetServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v14.services.AdGroupAssetServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v14.services.AdGroupAssetSetServiceClient createAdGroupAssetSetServiceClient(
        ) {
      try {
        com.google.ads.googleads.v14.services.AdGroupAssetSetServiceSettings settings =
          com.google.ads.googleads.v14.services.AdGroupAssetSetServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v14.services.AdGroupAssetSetServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v14.services.AdGroupBidModifierServiceClient createAdGroupBidModifierServiceClient(
        ) {
      try {
        com.google.ads.googleads.v14.services.AdGroupBidModifierServiceSettings settings =
          com.google.ads.googleads.v14.services.AdGroupBidModifierServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v14.services.AdGroupBidModifierServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v14.services.AdGroupCriterionCustomizerServiceClient createAdGroupCriterionCustomizerServiceClient(
        ) {
      try {
        com.google.ads.googleads.v14.services.AdGroupCriterionCustomizerServiceSettings settings =
          com.google.ads.googleads.v14.services.AdGroupCriterionCustomizerServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v14.services.AdGroupCriterionCustomizerServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v14.services.AdGroupCriterionLabelServiceClient createAdGroupCriterionLabelServiceClient(
        ) {
      try {
        com.google.ads.googleads.v14.services.AdGroupCriterionLabelServiceSettings settings =
          com.google.ads.googleads.v14.services.AdGroupCriterionLabelServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v14.services.AdGroupCriterionLabelServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v14.services.AdGroupCriterionServiceClient createAdGroupCriterionServiceClient(
        ) {
      try {
        com.google.ads.googleads.v14.services.AdGroupCriterionServiceSettings settings =
          com.google.ads.googleads.v14.services.AdGroupCriterionServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v14.services.AdGroupCriterionServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v14.services.AdGroupCustomizerServiceClient createAdGroupCustomizerServiceClient(
        ) {
      try {
        com.google.ads.googleads.v14.services.AdGroupCustomizerServiceSettings settings =
          com.google.ads.googleads.v14.services.AdGroupCustomizerServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v14.services.AdGroupCustomizerServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v14.services.AdGroupExtensionSettingServiceClient createAdGroupExtensionSettingServiceClient(
        ) {
      try {
        com.google.ads.googleads.v14.services.AdGroupExtensionSettingServiceSettings settings =
          com.google.ads.googleads.v14.services.AdGroupExtensionSettingServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v14.services.AdGroupExtensionSettingServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v14.services.AdGroupFeedServiceClient createAdGroupFeedServiceClient(
        ) {
      try {
        com.google.ads.googleads.v14.services.AdGroupFeedServiceSettings settings =
          com.google.ads.googleads.v14.services.AdGroupFeedServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v14.services.AdGroupFeedServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v14.services.AdGroupLabelServiceClient createAdGroupLabelServiceClient(
        ) {
      try {
        com.google.ads.googleads.v14.services.AdGroupLabelServiceSettings settings =
          com.google.ads.googleads.v14.services.AdGroupLabelServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v14.services.AdGroupLabelServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v14.services.AdGroupServiceClient createAdGroupServiceClient() {
      try {
        com.google.ads.googleads.v14.services.AdGroupServiceSettings settings =
          com.google.ads.googleads.v14.services.AdGroupServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v14.services.AdGroupServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v14.services.AdParameterServiceClient createAdParameterServiceClient(
        ) {
      try {
        com.google.ads.googleads.v14.services.AdParameterServiceSettings settings =
          com.google.ads.googleads.v14.services.AdParameterServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v14.services.AdParameterServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v14.services.AdServiceClient createAdServiceClient() {
      try {
        com.google.ads.googleads.v14.services.AdServiceSettings settings =
          com.google.ads.googleads.v14.services.AdServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v14.services.AdServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v14.services.AssetGroupAssetServiceClient createAssetGroupAssetServiceClient(
        ) {
      try {
        com.google.ads.googleads.v14.services.AssetGroupAssetServiceSettings settings =
          com.google.ads.googleads.v14.services.AssetGroupAssetServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v14.services.AssetGroupAssetServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v14.services.AssetGroupListingGroupFilterServiceClient createAssetGroupListingGroupFilterServiceClient(
        ) {
      try {
        com.google.ads.googleads.v14.services.AssetGroupListingGroupFilterServiceSettings settings =
          com.google.ads.googleads.v14.services.AssetGroupListingGroupFilterServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v14.services.AssetGroupListingGroupFilterServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v14.services.AssetGroupServiceClient createAssetGroupServiceClient(
        ) {
      try {
        com.google.ads.googleads.v14.services.AssetGroupServiceSettings settings =
          com.google.ads.googleads.v14.services.AssetGroupServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v14.services.AssetGroupServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v14.services.AssetGroupSignalServiceClient createAssetGroupSignalServiceClient(
        ) {
      try {
        com.google.ads.googleads.v14.services.AssetGroupSignalServiceSettings settings =
          com.google.ads.googleads.v14.services.AssetGroupSignalServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v14.services.AssetGroupSignalServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v14.services.AssetServiceClient createAssetServiceClient() {
      try {
        com.google.ads.googleads.v14.services.AssetServiceSettings settings =
          com.google.ads.googleads.v14.services.AssetServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v14.services.AssetServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v14.services.AssetSetAssetServiceClient createAssetSetAssetServiceClient(
        ) {
      try {
        com.google.ads.googleads.v14.services.AssetSetAssetServiceSettings settings =
          com.google.ads.googleads.v14.services.AssetSetAssetServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v14.services.AssetSetAssetServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v14.services.AssetSetServiceClient createAssetSetServiceClient(
        ) {
      try {
        com.google.ads.googleads.v14.services.AssetSetServiceSettings settings =
          com.google.ads.googleads.v14.services.AssetSetServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v14.services.AssetSetServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v14.services.AudienceInsightsServiceClient createAudienceInsightsServiceClient(
        ) {
      try {
        com.google.ads.googleads.v14.services.AudienceInsightsServiceSettings settings =
          com.google.ads.googleads.v14.services.AudienceInsightsServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v14.services.AudienceInsightsServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v14.services.AudienceServiceClient createAudienceServiceClient(
        ) {
      try {
        com.google.ads.googleads.v14.services.AudienceServiceSettings settings =
          com.google.ads.googleads.v14.services.AudienceServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v14.services.AudienceServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v14.services.BatchJobServiceClient createBatchJobServiceClient(
        ) {
      try {
        com.google.ads.googleads.v14.services.BatchJobServiceSettings settings =
          com.google.ads.googleads.v14.services.BatchJobServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v14.services.BatchJobServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v14.services.BiddingDataExclusionServiceClient createBiddingDataExclusionServiceClient(
        ) {
      try {
        com.google.ads.googleads.v14.services.BiddingDataExclusionServiceSettings settings =
          com.google.ads.googleads.v14.services.BiddingDataExclusionServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v14.services.BiddingDataExclusionServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v14.services.BiddingSeasonalityAdjustmentServiceClient createBiddingSeasonalityAdjustmentServiceClient(
        ) {
      try {
        com.google.ads.googleads.v14.services.BiddingSeasonalityAdjustmentServiceSettings settings =
          com.google.ads.googleads.v14.services.BiddingSeasonalityAdjustmentServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v14.services.BiddingSeasonalityAdjustmentServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v14.services.BiddingStrategyServiceClient createBiddingStrategyServiceClient(
        ) {
      try {
        com.google.ads.googleads.v14.services.BiddingStrategyServiceSettings settings =
          com.google.ads.googleads.v14.services.BiddingStrategyServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v14.services.BiddingStrategyServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v14.services.BillingSetupServiceClient createBillingSetupServiceClient(
        ) {
      try {
        com.google.ads.googleads.v14.services.BillingSetupServiceSettings settings =
          com.google.ads.googleads.v14.services.BillingSetupServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v14.services.BillingSetupServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v14.services.CampaignAssetServiceClient createCampaignAssetServiceClient(
        ) {
      try {
        com.google.ads.googleads.v14.services.CampaignAssetServiceSettings settings =
          com.google.ads.googleads.v14.services.CampaignAssetServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v14.services.CampaignAssetServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v14.services.CampaignAssetSetServiceClient createCampaignAssetSetServiceClient(
        ) {
      try {
        com.google.ads.googleads.v14.services.CampaignAssetSetServiceSettings settings =
          com.google.ads.googleads.v14.services.CampaignAssetSetServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v14.services.CampaignAssetSetServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v14.services.CampaignBidModifierServiceClient createCampaignBidModifierServiceClient(
        ) {
      try {
        com.google.ads.googleads.v14.services.CampaignBidModifierServiceSettings settings =
          com.google.ads.googleads.v14.services.CampaignBidModifierServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v14.services.CampaignBidModifierServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v14.services.CampaignBudgetServiceClient createCampaignBudgetServiceClient(
        ) {
      try {
        com.google.ads.googleads.v14.services.CampaignBudgetServiceSettings settings =
          com.google.ads.googleads.v14.services.CampaignBudgetServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v14.services.CampaignBudgetServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v14.services.CampaignConversionGoalServiceClient createCampaignConversionGoalServiceClient(
        ) {
      try {
        com.google.ads.googleads.v14.services.CampaignConversionGoalServiceSettings settings =
          com.google.ads.googleads.v14.services.CampaignConversionGoalServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v14.services.CampaignConversionGoalServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v14.services.CampaignCriterionServiceClient createCampaignCriterionServiceClient(
        ) {
      try {
        com.google.ads.googleads.v14.services.CampaignCriterionServiceSettings settings =
          com.google.ads.googleads.v14.services.CampaignCriterionServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v14.services.CampaignCriterionServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v14.services.CampaignCustomizerServiceClient createCampaignCustomizerServiceClient(
        ) {
      try {
        com.google.ads.googleads.v14.services.CampaignCustomizerServiceSettings settings =
          com.google.ads.googleads.v14.services.CampaignCustomizerServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v14.services.CampaignCustomizerServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v14.services.CampaignDraftServiceClient createCampaignDraftServiceClient(
        ) {
      try {
        com.google.ads.googleads.v14.services.CampaignDraftServiceSettings settings =
          com.google.ads.googleads.v14.services.CampaignDraftServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v14.services.CampaignDraftServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v14.services.CampaignExtensionSettingServiceClient createCampaignExtensionSettingServiceClient(
        ) {
      try {
        com.google.ads.googleads.v14.services.CampaignExtensionSettingServiceSettings settings =
          com.google.ads.googleads.v14.services.CampaignExtensionSettingServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v14.services.CampaignExtensionSettingServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v14.services.CampaignFeedServiceClient createCampaignFeedServiceClient(
        ) {
      try {
        com.google.ads.googleads.v14.services.CampaignFeedServiceSettings settings =
          com.google.ads.googleads.v14.services.CampaignFeedServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v14.services.CampaignFeedServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v14.services.CampaignGroupServiceClient createCampaignGroupServiceClient(
        ) {
      try {
        com.google.ads.googleads.v14.services.CampaignGroupServiceSettings settings =
          com.google.ads.googleads.v14.services.CampaignGroupServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v14.services.CampaignGroupServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v14.services.CampaignLabelServiceClient createCampaignLabelServiceClient(
        ) {
      try {
        com.google.ads.googleads.v14.services.CampaignLabelServiceSettings settings =
          com.google.ads.googleads.v14.services.CampaignLabelServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v14.services.CampaignLabelServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v14.services.CampaignServiceClient createCampaignServiceClient(
        ) {
      try {
        com.google.ads.googleads.v14.services.CampaignServiceSettings settings =
          com.google.ads.googleads.v14.services.CampaignServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v14.services.CampaignServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v14.services.CampaignSharedSetServiceClient createCampaignSharedSetServiceClient(
        ) {
      try {
        com.google.ads.googleads.v14.services.CampaignSharedSetServiceSettings settings =
          com.google.ads.googleads.v14.services.CampaignSharedSetServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v14.services.CampaignSharedSetServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v14.services.ConversionActionServiceClient createConversionActionServiceClient(
        ) {
      try {
        com.google.ads.googleads.v14.services.ConversionActionServiceSettings settings =
          com.google.ads.googleads.v14.services.ConversionActionServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v14.services.ConversionActionServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v14.services.ConversionAdjustmentUploadServiceClient createConversionAdjustmentUploadServiceClient(
        ) {
      try {
        com.google.ads.googleads.v14.services.ConversionAdjustmentUploadServiceSettings settings =
          com.google.ads.googleads.v14.services.ConversionAdjustmentUploadServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v14.services.ConversionAdjustmentUploadServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v14.services.ConversionCustomVariableServiceClient createConversionCustomVariableServiceClient(
        ) {
      try {
        com.google.ads.googleads.v14.services.ConversionCustomVariableServiceSettings settings =
          com.google.ads.googleads.v14.services.ConversionCustomVariableServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v14.services.ConversionCustomVariableServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v14.services.ConversionGoalCampaignConfigServiceClient createConversionGoalCampaignConfigServiceClient(
        ) {
      try {
        com.google.ads.googleads.v14.services.ConversionGoalCampaignConfigServiceSettings settings =
          com.google.ads.googleads.v14.services.ConversionGoalCampaignConfigServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v14.services.ConversionGoalCampaignConfigServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v14.services.ConversionUploadServiceClient createConversionUploadServiceClient(
        ) {
      try {
        com.google.ads.googleads.v14.services.ConversionUploadServiceSettings settings =
          com.google.ads.googleads.v14.services.ConversionUploadServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v14.services.ConversionUploadServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v14.services.ConversionValueRuleServiceClient createConversionValueRuleServiceClient(
        ) {
      try {
        com.google.ads.googleads.v14.services.ConversionValueRuleServiceSettings settings =
          com.google.ads.googleads.v14.services.ConversionValueRuleServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v14.services.ConversionValueRuleServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v14.services.ConversionValueRuleSetServiceClient createConversionValueRuleSetServiceClient(
        ) {
      try {
        com.google.ads.googleads.v14.services.ConversionValueRuleSetServiceSettings settings =
          com.google.ads.googleads.v14.services.ConversionValueRuleSetServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v14.services.ConversionValueRuleSetServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v14.services.CustomAudienceServiceClient createCustomAudienceServiceClient(
        ) {
      try {
        com.google.ads.googleads.v14.services.CustomAudienceServiceSettings settings =
          com.google.ads.googleads.v14.services.CustomAudienceServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v14.services.CustomAudienceServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v14.services.CustomConversionGoalServiceClient createCustomConversionGoalServiceClient(
        ) {
      try {
        com.google.ads.googleads.v14.services.CustomConversionGoalServiceSettings settings =
          com.google.ads.googleads.v14.services.CustomConversionGoalServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v14.services.CustomConversionGoalServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v14.services.CustomInterestServiceClient createCustomInterestServiceClient(
        ) {
      try {
        com.google.ads.googleads.v14.services.CustomInterestServiceSettings settings =
          com.google.ads.googleads.v14.services.CustomInterestServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v14.services.CustomInterestServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v14.services.CustomerAssetServiceClient createCustomerAssetServiceClient(
        ) {
      try {
        com.google.ads.googleads.v14.services.CustomerAssetServiceSettings settings =
          com.google.ads.googleads.v14.services.CustomerAssetServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v14.services.CustomerAssetServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v14.services.CustomerAssetSetServiceClient createCustomerAssetSetServiceClient(
        ) {
      try {
        com.google.ads.googleads.v14.services.CustomerAssetSetServiceSettings settings =
          com.google.ads.googleads.v14.services.CustomerAssetSetServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v14.services.CustomerAssetSetServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v14.services.CustomerClientLinkServiceClient createCustomerClientLinkServiceClient(
        ) {
      try {
        com.google.ads.googleads.v14.services.CustomerClientLinkServiceSettings settings =
          com.google.ads.googleads.v14.services.CustomerClientLinkServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v14.services.CustomerClientLinkServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v14.services.CustomerConversionGoalServiceClient createCustomerConversionGoalServiceClient(
        ) {
      try {
        com.google.ads.googleads.v14.services.CustomerConversionGoalServiceSettings settings =
          com.google.ads.googleads.v14.services.CustomerConversionGoalServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v14.services.CustomerConversionGoalServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v14.services.CustomerCustomizerServiceClient createCustomerCustomizerServiceClient(
        ) {
      try {
        com.google.ads.googleads.v14.services.CustomerCustomizerServiceSettings settings =
          com.google.ads.googleads.v14.services.CustomerCustomizerServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v14.services.CustomerCustomizerServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v14.services.CustomerExtensionSettingServiceClient createCustomerExtensionSettingServiceClient(
        ) {
      try {
        com.google.ads.googleads.v14.services.CustomerExtensionSettingServiceSettings settings =
          com.google.ads.googleads.v14.services.CustomerExtensionSettingServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v14.services.CustomerExtensionSettingServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v14.services.CustomerFeedServiceClient createCustomerFeedServiceClient(
        ) {
      try {
        com.google.ads.googleads.v14.services.CustomerFeedServiceSettings settings =
          com.google.ads.googleads.v14.services.CustomerFeedServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v14.services.CustomerFeedServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v14.services.CustomerLabelServiceClient createCustomerLabelServiceClient(
        ) {
      try {
        com.google.ads.googleads.v14.services.CustomerLabelServiceSettings settings =
          com.google.ads.googleads.v14.services.CustomerLabelServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v14.services.CustomerLabelServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v14.services.CustomerManagerLinkServiceClient createCustomerManagerLinkServiceClient(
        ) {
      try {
        com.google.ads.googleads.v14.services.CustomerManagerLinkServiceSettings settings =
          com.google.ads.googleads.v14.services.CustomerManagerLinkServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v14.services.CustomerManagerLinkServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v14.services.CustomerNegativeCriterionServiceClient createCustomerNegativeCriterionServiceClient(
        ) {
      try {
        com.google.ads.googleads.v14.services.CustomerNegativeCriterionServiceSettings settings =
          com.google.ads.googleads.v14.services.CustomerNegativeCriterionServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v14.services.CustomerNegativeCriterionServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v14.services.CustomerServiceClient createCustomerServiceClient(
        ) {
      try {
        com.google.ads.googleads.v14.services.CustomerServiceSettings settings =
          com.google.ads.googleads.v14.services.CustomerServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v14.services.CustomerServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v14.services.CustomerSkAdNetworkConversionValueSchemaServiceClient createCustomerSkAdNetworkConversionValueSchemaServiceClient(
        ) {
      try {
        com.google.ads.googleads.v14.services.CustomerSkAdNetworkConversionValueSchemaServiceSettings settings =
          com.google.ads.googleads.v14.services.CustomerSkAdNetworkConversionValueSchemaServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v14.services.CustomerSkAdNetworkConversionValueSchemaServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v14.services.CustomerUserAccessInvitationServiceClient createCustomerUserAccessInvitationServiceClient(
        ) {
      try {
        com.google.ads.googleads.v14.services.CustomerUserAccessInvitationServiceSettings settings =
          com.google.ads.googleads.v14.services.CustomerUserAccessInvitationServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v14.services.CustomerUserAccessInvitationServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v14.services.CustomerUserAccessServiceClient createCustomerUserAccessServiceClient(
        ) {
      try {
        com.google.ads.googleads.v14.services.CustomerUserAccessServiceSettings settings =
          com.google.ads.googleads.v14.services.CustomerUserAccessServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v14.services.CustomerUserAccessServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v14.services.CustomizerAttributeServiceClient createCustomizerAttributeServiceClient(
        ) {
      try {
        com.google.ads.googleads.v14.services.CustomizerAttributeServiceSettings settings =
          com.google.ads.googleads.v14.services.CustomizerAttributeServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v14.services.CustomizerAttributeServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v14.services.ExperimentArmServiceClient createExperimentArmServiceClient(
        ) {
      try {
        com.google.ads.googleads.v14.services.ExperimentArmServiceSettings settings =
          com.google.ads.googleads.v14.services.ExperimentArmServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v14.services.ExperimentArmServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v14.services.ExperimentServiceClient createExperimentServiceClient(
        ) {
      try {
        com.google.ads.googleads.v14.services.ExperimentServiceSettings settings =
          com.google.ads.googleads.v14.services.ExperimentServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v14.services.ExperimentServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v14.services.ExtensionFeedItemServiceClient createExtensionFeedItemServiceClient(
        ) {
      try {
        com.google.ads.googleads.v14.services.ExtensionFeedItemServiceSettings settings =
          com.google.ads.googleads.v14.services.ExtensionFeedItemServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v14.services.ExtensionFeedItemServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v14.services.FeedItemServiceClient createFeedItemServiceClient(
        ) {
      try {
        com.google.ads.googleads.v14.services.FeedItemServiceSettings settings =
          com.google.ads.googleads.v14.services.FeedItemServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v14.services.FeedItemServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v14.services.FeedItemSetLinkServiceClient createFeedItemSetLinkServiceClient(
        ) {
      try {
        com.google.ads.googleads.v14.services.FeedItemSetLinkServiceSettings settings =
          com.google.ads.googleads.v14.services.FeedItemSetLinkServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v14.services.FeedItemSetLinkServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v14.services.FeedItemSetServiceClient createFeedItemSetServiceClient(
        ) {
      try {
        com.google.ads.googleads.v14.services.FeedItemSetServiceSettings settings =
          com.google.ads.googleads.v14.services.FeedItemSetServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v14.services.FeedItemSetServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v14.services.FeedItemTargetServiceClient createFeedItemTargetServiceClient(
        ) {
      try {
        com.google.ads.googleads.v14.services.FeedItemTargetServiceSettings settings =
          com.google.ads.googleads.v14.services.FeedItemTargetServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v14.services.FeedItemTargetServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v14.services.FeedMappingServiceClient createFeedMappingServiceClient(
        ) {
      try {
        com.google.ads.googleads.v14.services.FeedMappingServiceSettings settings =
          com.google.ads.googleads.v14.services.FeedMappingServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v14.services.FeedMappingServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v14.services.FeedServiceClient createFeedServiceClient() {
      try {
        com.google.ads.googleads.v14.services.FeedServiceSettings settings =
          com.google.ads.googleads.v14.services.FeedServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v14.services.FeedServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v14.services.GeoTargetConstantServiceClient createGeoTargetConstantServiceClient(
        ) {
      try {
        com.google.ads.googleads.v14.services.GeoTargetConstantServiceSettings settings =
          com.google.ads.googleads.v14.services.GeoTargetConstantServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v14.services.GeoTargetConstantServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v14.services.GoogleAdsFieldServiceClient createGoogleAdsFieldServiceClient(
        ) {
      try {
        com.google.ads.googleads.v14.services.GoogleAdsFieldServiceSettings settings =
          com.google.ads.googleads.v14.services.GoogleAdsFieldServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v14.services.GoogleAdsFieldServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v14.services.GoogleAdsServiceClient createGoogleAdsServiceClient(
        ) {
      try {
        com.google.ads.googleads.v14.services.GoogleAdsServiceSettings settings =
          com.google.ads.googleads.v14.services.GoogleAdsServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v14.services.GoogleAdsServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v14.services.InvoiceServiceClient createInvoiceServiceClient() {
      try {
        com.google.ads.googleads.v14.services.InvoiceServiceSettings settings =
          com.google.ads.googleads.v14.services.InvoiceServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v14.services.InvoiceServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v14.services.KeywordPlanAdGroupKeywordServiceClient createKeywordPlanAdGroupKeywordServiceClient(
        ) {
      try {
        com.google.ads.googleads.v14.services.KeywordPlanAdGroupKeywordServiceSettings settings =
          com.google.ads.googleads.v14.services.KeywordPlanAdGroupKeywordServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v14.services.KeywordPlanAdGroupKeywordServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v14.services.KeywordPlanAdGroupServiceClient createKeywordPlanAdGroupServiceClient(
        ) {
      try {
        com.google.ads.googleads.v14.services.KeywordPlanAdGroupServiceSettings settings =
          com.google.ads.googleads.v14.services.KeywordPlanAdGroupServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v14.services.KeywordPlanAdGroupServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v14.services.KeywordPlanCampaignKeywordServiceClient createKeywordPlanCampaignKeywordServiceClient(
        ) {
      try {
        com.google.ads.googleads.v14.services.KeywordPlanCampaignKeywordServiceSettings settings =
          com.google.ads.googleads.v14.services.KeywordPlanCampaignKeywordServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v14.services.KeywordPlanCampaignKeywordServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v14.services.KeywordPlanCampaignServiceClient createKeywordPlanCampaignServiceClient(
        ) {
      try {
        com.google.ads.googleads.v14.services.KeywordPlanCampaignServiceSettings settings =
          com.google.ads.googleads.v14.services.KeywordPlanCampaignServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v14.services.KeywordPlanCampaignServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v14.services.KeywordPlanIdeaServiceClient createKeywordPlanIdeaServiceClient(
        ) {
      try {
        com.google.ads.googleads.v14.services.KeywordPlanIdeaServiceSettings settings =
          com.google.ads.googleads.v14.services.KeywordPlanIdeaServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v14.services.KeywordPlanIdeaServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v14.services.KeywordPlanServiceClient createKeywordPlanServiceClient(
        ) {
      try {
        com.google.ads.googleads.v14.services.KeywordPlanServiceSettings settings =
          com.google.ads.googleads.v14.services.KeywordPlanServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v14.services.KeywordPlanServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v14.services.KeywordThemeConstantServiceClient createKeywordThemeConstantServiceClient(
        ) {
      try {
        com.google.ads.googleads.v14.services.KeywordThemeConstantServiceSettings settings =
          com.google.ads.googleads.v14.services.KeywordThemeConstantServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v14.services.KeywordThemeConstantServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v14.services.LabelServiceClient createLabelServiceClient() {
      try {
        com.google.ads.googleads.v14.services.LabelServiceSettings settings =
          com.google.ads.googleads.v14.services.LabelServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v14.services.LabelServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public MediaFileServiceClient createMediaFileServiceClient() {
      try {
        MediaFileServiceSettings settings =
          MediaFileServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return MediaFileServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public MerchantCenterLinkServiceClient createMerchantCenterLinkServiceClient() {
      try {
        MerchantCenterLinkServiceSettings settings =
          MerchantCenterLinkServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return MerchantCenterLinkServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v14.services.OfflineUserDataJobServiceClient createOfflineUserDataJobServiceClient(
        ) {
      try {
        com.google.ads.googleads.v14.services.OfflineUserDataJobServiceSettings settings =
          com.google.ads.googleads.v14.services.OfflineUserDataJobServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v14.services.OfflineUserDataJobServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v14.services.PaymentsAccountServiceClient createPaymentsAccountServiceClient(
        ) {
      try {
        com.google.ads.googleads.v14.services.PaymentsAccountServiceSettings settings =
          com.google.ads.googleads.v14.services.PaymentsAccountServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v14.services.PaymentsAccountServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v14.services.ProductLinkServiceClient createProductLinkServiceClient(
        ) {
      try {
        com.google.ads.googleads.v14.services.ProductLinkServiceSettings settings =
          com.google.ads.googleads.v14.services.ProductLinkServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v14.services.ProductLinkServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v14.services.ReachPlanServiceClient createReachPlanServiceClient(
        ) {
      try {
        com.google.ads.googleads.v14.services.ReachPlanServiceSettings settings =
          com.google.ads.googleads.v14.services.ReachPlanServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v14.services.ReachPlanServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v14.services.RecommendationServiceClient createRecommendationServiceClient(
        ) {
      try {
        com.google.ads.googleads.v14.services.RecommendationServiceSettings settings =
          com.google.ads.googleads.v14.services.RecommendationServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v14.services.RecommendationServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v14.services.RemarketingActionServiceClient createRemarketingActionServiceClient(
        ) {
      try {
        com.google.ads.googleads.v14.services.RemarketingActionServiceSettings settings =
          com.google.ads.googleads.v14.services.RemarketingActionServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v14.services.RemarketingActionServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v14.services.SharedCriterionServiceClient createSharedCriterionServiceClient(
        ) {
      try {
        com.google.ads.googleads.v14.services.SharedCriterionServiceSettings settings =
          com.google.ads.googleads.v14.services.SharedCriterionServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v14.services.SharedCriterionServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v14.services.SharedSetServiceClient createSharedSetServiceClient(
        ) {
      try {
        com.google.ads.googleads.v14.services.SharedSetServiceSettings settings =
          com.google.ads.googleads.v14.services.SharedSetServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v14.services.SharedSetServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v14.services.SmartCampaignSettingServiceClient createSmartCampaignSettingServiceClient(
        ) {
      try {
        com.google.ads.googleads.v14.services.SmartCampaignSettingServiceSettings settings =
          com.google.ads.googleads.v14.services.SmartCampaignSettingServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v14.services.SmartCampaignSettingServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v14.services.SmartCampaignSuggestServiceClient createSmartCampaignSuggestServiceClient(
        ) {
      try {
        com.google.ads.googleads.v14.services.SmartCampaignSuggestServiceSettings settings =
          com.google.ads.googleads.v14.services.SmartCampaignSuggestServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v14.services.SmartCampaignSuggestServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v14.services.ThirdPartyAppAnalyticsLinkServiceClient createThirdPartyAppAnalyticsLinkServiceClient(
        ) {
      try {
        com.google.ads.googleads.v14.services.ThirdPartyAppAnalyticsLinkServiceSettings settings =
          com.google.ads.googleads.v14.services.ThirdPartyAppAnalyticsLinkServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v14.services.ThirdPartyAppAnalyticsLinkServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v14.services.TravelAssetSuggestionServiceClient createTravelAssetSuggestionServiceClient(
        ) {
      try {
        com.google.ads.googleads.v14.services.TravelAssetSuggestionServiceSettings settings =
          com.google.ads.googleads.v14.services.TravelAssetSuggestionServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v14.services.TravelAssetSuggestionServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v14.services.UserDataServiceClient createUserDataServiceClient(
        ) {
      try {
        com.google.ads.googleads.v14.services.UserDataServiceSettings settings =
          com.google.ads.googleads.v14.services.UserDataServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v14.services.UserDataServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v14.services.UserListServiceClient createUserListServiceClient(
        ) {
      try {
        com.google.ads.googleads.v14.services.UserListServiceSettings settings =
          com.google.ads.googleads.v14.services.UserListServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v14.services.UserListServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }
  }

  private static class V15Client implements com.google.ads.googleads.v15.services.GoogleAdsVersion {
    private final TransportChannelProvider provider;

    private final Credentials credentials;

    public V15Client(TransportChannelProvider provider, Credentials credentials) {
      this.provider = provider;
      this.credentials = credentials;
    }

    @Override
    public com.google.ads.googleads.v15.services.AccountBudgetProposalServiceClient createAccountBudgetProposalServiceClient(
        ) {
      try {
        com.google.ads.googleads.v15.services.AccountBudgetProposalServiceSettings settings =
          com.google.ads.googleads.v15.services.AccountBudgetProposalServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v15.services.AccountBudgetProposalServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v15.services.AccountLinkServiceClient createAccountLinkServiceClient(
        ) {
      try {
        com.google.ads.googleads.v15.services.AccountLinkServiceSettings settings =
          com.google.ads.googleads.v15.services.AccountLinkServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v15.services.AccountLinkServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v15.services.AdGroupAdLabelServiceClient createAdGroupAdLabelServiceClient(
        ) {
      try {
        com.google.ads.googleads.v15.services.AdGroupAdLabelServiceSettings settings =
          com.google.ads.googleads.v15.services.AdGroupAdLabelServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v15.services.AdGroupAdLabelServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v15.services.AdGroupAdServiceClient createAdGroupAdServiceClient(
        ) {
      try {
        com.google.ads.googleads.v15.services.AdGroupAdServiceSettings settings =
          com.google.ads.googleads.v15.services.AdGroupAdServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v15.services.AdGroupAdServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v15.services.AdGroupAssetServiceClient createAdGroupAssetServiceClient(
        ) {
      try {
        com.google.ads.googleads.v15.services.AdGroupAssetServiceSettings settings =
          com.google.ads.googleads.v15.services.AdGroupAssetServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v15.services.AdGroupAssetServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v15.services.AdGroupAssetSetServiceClient createAdGroupAssetSetServiceClient(
        ) {
      try {
        com.google.ads.googleads.v15.services.AdGroupAssetSetServiceSettings settings =
          com.google.ads.googleads.v15.services.AdGroupAssetSetServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v15.services.AdGroupAssetSetServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v15.services.AdGroupBidModifierServiceClient createAdGroupBidModifierServiceClient(
        ) {
      try {
        com.google.ads.googleads.v15.services.AdGroupBidModifierServiceSettings settings =
          com.google.ads.googleads.v15.services.AdGroupBidModifierServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v15.services.AdGroupBidModifierServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v15.services.AdGroupCriterionCustomizerServiceClient createAdGroupCriterionCustomizerServiceClient(
        ) {
      try {
        com.google.ads.googleads.v15.services.AdGroupCriterionCustomizerServiceSettings settings =
          com.google.ads.googleads.v15.services.AdGroupCriterionCustomizerServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v15.services.AdGroupCriterionCustomizerServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v15.services.AdGroupCriterionLabelServiceClient createAdGroupCriterionLabelServiceClient(
        ) {
      try {
        com.google.ads.googleads.v15.services.AdGroupCriterionLabelServiceSettings settings =
          com.google.ads.googleads.v15.services.AdGroupCriterionLabelServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v15.services.AdGroupCriterionLabelServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v15.services.AdGroupCriterionServiceClient createAdGroupCriterionServiceClient(
        ) {
      try {
        com.google.ads.googleads.v15.services.AdGroupCriterionServiceSettings settings =
          com.google.ads.googleads.v15.services.AdGroupCriterionServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v15.services.AdGroupCriterionServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v15.services.AdGroupCustomizerServiceClient createAdGroupCustomizerServiceClient(
        ) {
      try {
        com.google.ads.googleads.v15.services.AdGroupCustomizerServiceSettings settings =
          com.google.ads.googleads.v15.services.AdGroupCustomizerServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v15.services.AdGroupCustomizerServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v15.services.AdGroupExtensionSettingServiceClient createAdGroupExtensionSettingServiceClient(
        ) {
      try {
        com.google.ads.googleads.v15.services.AdGroupExtensionSettingServiceSettings settings =
          com.google.ads.googleads.v15.services.AdGroupExtensionSettingServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v15.services.AdGroupExtensionSettingServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v15.services.AdGroupFeedServiceClient createAdGroupFeedServiceClient(
        ) {
      try {
        com.google.ads.googleads.v15.services.AdGroupFeedServiceSettings settings =
          com.google.ads.googleads.v15.services.AdGroupFeedServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v15.services.AdGroupFeedServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v15.services.AdGroupLabelServiceClient createAdGroupLabelServiceClient(
        ) {
      try {
        com.google.ads.googleads.v15.services.AdGroupLabelServiceSettings settings =
          com.google.ads.googleads.v15.services.AdGroupLabelServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v15.services.AdGroupLabelServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v15.services.AdGroupServiceClient createAdGroupServiceClient() {
      try {
        com.google.ads.googleads.v15.services.AdGroupServiceSettings settings =
          com.google.ads.googleads.v15.services.AdGroupServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v15.services.AdGroupServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v15.services.AdParameterServiceClient createAdParameterServiceClient(
        ) {
      try {
        com.google.ads.googleads.v15.services.AdParameterServiceSettings settings =
          com.google.ads.googleads.v15.services.AdParameterServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v15.services.AdParameterServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v15.services.AdServiceClient createAdServiceClient() {
      try {
        com.google.ads.googleads.v15.services.AdServiceSettings settings =
          com.google.ads.googleads.v15.services.AdServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v15.services.AdServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v15.services.AssetGroupAssetServiceClient createAssetGroupAssetServiceClient(
        ) {
      try {
        com.google.ads.googleads.v15.services.AssetGroupAssetServiceSettings settings =
          com.google.ads.googleads.v15.services.AssetGroupAssetServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v15.services.AssetGroupAssetServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v15.services.AssetGroupListingGroupFilterServiceClient createAssetGroupListingGroupFilterServiceClient(
        ) {
      try {
        com.google.ads.googleads.v15.services.AssetGroupListingGroupFilterServiceSettings settings =
          com.google.ads.googleads.v15.services.AssetGroupListingGroupFilterServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v15.services.AssetGroupListingGroupFilterServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v15.services.AssetGroupServiceClient createAssetGroupServiceClient(
        ) {
      try {
        com.google.ads.googleads.v15.services.AssetGroupServiceSettings settings =
          com.google.ads.googleads.v15.services.AssetGroupServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v15.services.AssetGroupServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v15.services.AssetGroupSignalServiceClient createAssetGroupSignalServiceClient(
        ) {
      try {
        com.google.ads.googleads.v15.services.AssetGroupSignalServiceSettings settings =
          com.google.ads.googleads.v15.services.AssetGroupSignalServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v15.services.AssetGroupSignalServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v15.services.AssetServiceClient createAssetServiceClient() {
      try {
        com.google.ads.googleads.v15.services.AssetServiceSettings settings =
          com.google.ads.googleads.v15.services.AssetServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v15.services.AssetServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v15.services.AssetSetAssetServiceClient createAssetSetAssetServiceClient(
        ) {
      try {
        com.google.ads.googleads.v15.services.AssetSetAssetServiceSettings settings =
          com.google.ads.googleads.v15.services.AssetSetAssetServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v15.services.AssetSetAssetServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v15.services.AssetSetServiceClient createAssetSetServiceClient(
        ) {
      try {
        com.google.ads.googleads.v15.services.AssetSetServiceSettings settings =
          com.google.ads.googleads.v15.services.AssetSetServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v15.services.AssetSetServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v15.services.AudienceInsightsServiceClient createAudienceInsightsServiceClient(
        ) {
      try {
        com.google.ads.googleads.v15.services.AudienceInsightsServiceSettings settings =
          com.google.ads.googleads.v15.services.AudienceInsightsServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v15.services.AudienceInsightsServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v15.services.AudienceServiceClient createAudienceServiceClient(
        ) {
      try {
        com.google.ads.googleads.v15.services.AudienceServiceSettings settings =
          com.google.ads.googleads.v15.services.AudienceServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v15.services.AudienceServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v15.services.BatchJobServiceClient createBatchJobServiceClient(
        ) {
      try {
        com.google.ads.googleads.v15.services.BatchJobServiceSettings settings =
          com.google.ads.googleads.v15.services.BatchJobServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v15.services.BatchJobServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v15.services.BiddingDataExclusionServiceClient createBiddingDataExclusionServiceClient(
        ) {
      try {
        com.google.ads.googleads.v15.services.BiddingDataExclusionServiceSettings settings =
          com.google.ads.googleads.v15.services.BiddingDataExclusionServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v15.services.BiddingDataExclusionServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v15.services.BiddingSeasonalityAdjustmentServiceClient createBiddingSeasonalityAdjustmentServiceClient(
        ) {
      try {
        com.google.ads.googleads.v15.services.BiddingSeasonalityAdjustmentServiceSettings settings =
          com.google.ads.googleads.v15.services.BiddingSeasonalityAdjustmentServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v15.services.BiddingSeasonalityAdjustmentServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v15.services.BiddingStrategyServiceClient createBiddingStrategyServiceClient(
        ) {
      try {
        com.google.ads.googleads.v15.services.BiddingStrategyServiceSettings settings =
          com.google.ads.googleads.v15.services.BiddingStrategyServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v15.services.BiddingStrategyServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v15.services.BillingSetupServiceClient createBillingSetupServiceClient(
        ) {
      try {
        com.google.ads.googleads.v15.services.BillingSetupServiceSettings settings =
          com.google.ads.googleads.v15.services.BillingSetupServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v15.services.BillingSetupServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v15.services.CampaignAssetServiceClient createCampaignAssetServiceClient(
        ) {
      try {
        com.google.ads.googleads.v15.services.CampaignAssetServiceSettings settings =
          com.google.ads.googleads.v15.services.CampaignAssetServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v15.services.CampaignAssetServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v15.services.CampaignAssetSetServiceClient createCampaignAssetSetServiceClient(
        ) {
      try {
        com.google.ads.googleads.v15.services.CampaignAssetSetServiceSettings settings =
          com.google.ads.googleads.v15.services.CampaignAssetSetServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v15.services.CampaignAssetSetServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v15.services.CampaignBidModifierServiceClient createCampaignBidModifierServiceClient(
        ) {
      try {
        com.google.ads.googleads.v15.services.CampaignBidModifierServiceSettings settings =
          com.google.ads.googleads.v15.services.CampaignBidModifierServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v15.services.CampaignBidModifierServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v15.services.CampaignBudgetServiceClient createCampaignBudgetServiceClient(
        ) {
      try {
        com.google.ads.googleads.v15.services.CampaignBudgetServiceSettings settings =
          com.google.ads.googleads.v15.services.CampaignBudgetServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v15.services.CampaignBudgetServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v15.services.CampaignConversionGoalServiceClient createCampaignConversionGoalServiceClient(
        ) {
      try {
        com.google.ads.googleads.v15.services.CampaignConversionGoalServiceSettings settings =
          com.google.ads.googleads.v15.services.CampaignConversionGoalServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v15.services.CampaignConversionGoalServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v15.services.CampaignCriterionServiceClient createCampaignCriterionServiceClient(
        ) {
      try {
        com.google.ads.googleads.v15.services.CampaignCriterionServiceSettings settings =
          com.google.ads.googleads.v15.services.CampaignCriterionServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v15.services.CampaignCriterionServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v15.services.CampaignCustomizerServiceClient createCampaignCustomizerServiceClient(
        ) {
      try {
        com.google.ads.googleads.v15.services.CampaignCustomizerServiceSettings settings =
          com.google.ads.googleads.v15.services.CampaignCustomizerServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v15.services.CampaignCustomizerServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v15.services.CampaignDraftServiceClient createCampaignDraftServiceClient(
        ) {
      try {
        com.google.ads.googleads.v15.services.CampaignDraftServiceSettings settings =
          com.google.ads.googleads.v15.services.CampaignDraftServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v15.services.CampaignDraftServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v15.services.CampaignExtensionSettingServiceClient createCampaignExtensionSettingServiceClient(
        ) {
      try {
        com.google.ads.googleads.v15.services.CampaignExtensionSettingServiceSettings settings =
          com.google.ads.googleads.v15.services.CampaignExtensionSettingServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v15.services.CampaignExtensionSettingServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v15.services.CampaignFeedServiceClient createCampaignFeedServiceClient(
        ) {
      try {
        com.google.ads.googleads.v15.services.CampaignFeedServiceSettings settings =
          com.google.ads.googleads.v15.services.CampaignFeedServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v15.services.CampaignFeedServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v15.services.CampaignGroupServiceClient createCampaignGroupServiceClient(
        ) {
      try {
        com.google.ads.googleads.v15.services.CampaignGroupServiceSettings settings =
          com.google.ads.googleads.v15.services.CampaignGroupServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v15.services.CampaignGroupServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v15.services.CampaignLabelServiceClient createCampaignLabelServiceClient(
        ) {
      try {
        com.google.ads.googleads.v15.services.CampaignLabelServiceSettings settings =
          com.google.ads.googleads.v15.services.CampaignLabelServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v15.services.CampaignLabelServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v15.services.CampaignServiceClient createCampaignServiceClient(
        ) {
      try {
        com.google.ads.googleads.v15.services.CampaignServiceSettings settings =
          com.google.ads.googleads.v15.services.CampaignServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v15.services.CampaignServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v15.services.CampaignSharedSetServiceClient createCampaignSharedSetServiceClient(
        ) {
      try {
        com.google.ads.googleads.v15.services.CampaignSharedSetServiceSettings settings =
          com.google.ads.googleads.v15.services.CampaignSharedSetServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v15.services.CampaignSharedSetServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v15.services.ConversionActionServiceClient createConversionActionServiceClient(
        ) {
      try {
        com.google.ads.googleads.v15.services.ConversionActionServiceSettings settings =
          com.google.ads.googleads.v15.services.ConversionActionServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v15.services.ConversionActionServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v15.services.ConversionAdjustmentUploadServiceClient createConversionAdjustmentUploadServiceClient(
        ) {
      try {
        com.google.ads.googleads.v15.services.ConversionAdjustmentUploadServiceSettings settings =
          com.google.ads.googleads.v15.services.ConversionAdjustmentUploadServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v15.services.ConversionAdjustmentUploadServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v15.services.ConversionCustomVariableServiceClient createConversionCustomVariableServiceClient(
        ) {
      try {
        com.google.ads.googleads.v15.services.ConversionCustomVariableServiceSettings settings =
          com.google.ads.googleads.v15.services.ConversionCustomVariableServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v15.services.ConversionCustomVariableServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v15.services.ConversionGoalCampaignConfigServiceClient createConversionGoalCampaignConfigServiceClient(
        ) {
      try {
        com.google.ads.googleads.v15.services.ConversionGoalCampaignConfigServiceSettings settings =
          com.google.ads.googleads.v15.services.ConversionGoalCampaignConfigServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v15.services.ConversionGoalCampaignConfigServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v15.services.ConversionUploadServiceClient createConversionUploadServiceClient(
        ) {
      try {
        com.google.ads.googleads.v15.services.ConversionUploadServiceSettings settings =
          com.google.ads.googleads.v15.services.ConversionUploadServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v15.services.ConversionUploadServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v15.services.ConversionValueRuleServiceClient createConversionValueRuleServiceClient(
        ) {
      try {
        com.google.ads.googleads.v15.services.ConversionValueRuleServiceSettings settings =
          com.google.ads.googleads.v15.services.ConversionValueRuleServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v15.services.ConversionValueRuleServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v15.services.ConversionValueRuleSetServiceClient createConversionValueRuleSetServiceClient(
        ) {
      try {
        com.google.ads.googleads.v15.services.ConversionValueRuleSetServiceSettings settings =
          com.google.ads.googleads.v15.services.ConversionValueRuleSetServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v15.services.ConversionValueRuleSetServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v15.services.CustomAudienceServiceClient createCustomAudienceServiceClient(
        ) {
      try {
        com.google.ads.googleads.v15.services.CustomAudienceServiceSettings settings =
          com.google.ads.googleads.v15.services.CustomAudienceServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v15.services.CustomAudienceServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v15.services.CustomConversionGoalServiceClient createCustomConversionGoalServiceClient(
        ) {
      try {
        com.google.ads.googleads.v15.services.CustomConversionGoalServiceSettings settings =
          com.google.ads.googleads.v15.services.CustomConversionGoalServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v15.services.CustomConversionGoalServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v15.services.CustomInterestServiceClient createCustomInterestServiceClient(
        ) {
      try {
        com.google.ads.googleads.v15.services.CustomInterestServiceSettings settings =
          com.google.ads.googleads.v15.services.CustomInterestServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v15.services.CustomInterestServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v15.services.CustomerAssetServiceClient createCustomerAssetServiceClient(
        ) {
      try {
        com.google.ads.googleads.v15.services.CustomerAssetServiceSettings settings =
          com.google.ads.googleads.v15.services.CustomerAssetServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v15.services.CustomerAssetServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v15.services.CustomerAssetSetServiceClient createCustomerAssetSetServiceClient(
        ) {
      try {
        com.google.ads.googleads.v15.services.CustomerAssetSetServiceSettings settings =
          com.google.ads.googleads.v15.services.CustomerAssetSetServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v15.services.CustomerAssetSetServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v15.services.CustomerClientLinkServiceClient createCustomerClientLinkServiceClient(
        ) {
      try {
        com.google.ads.googleads.v15.services.CustomerClientLinkServiceSettings settings =
          com.google.ads.googleads.v15.services.CustomerClientLinkServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v15.services.CustomerClientLinkServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v15.services.CustomerConversionGoalServiceClient createCustomerConversionGoalServiceClient(
        ) {
      try {
        com.google.ads.googleads.v15.services.CustomerConversionGoalServiceSettings settings =
          com.google.ads.googleads.v15.services.CustomerConversionGoalServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v15.services.CustomerConversionGoalServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v15.services.CustomerCustomizerServiceClient createCustomerCustomizerServiceClient(
        ) {
      try {
        com.google.ads.googleads.v15.services.CustomerCustomizerServiceSettings settings =
          com.google.ads.googleads.v15.services.CustomerCustomizerServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v15.services.CustomerCustomizerServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v15.services.CustomerExtensionSettingServiceClient createCustomerExtensionSettingServiceClient(
        ) {
      try {
        com.google.ads.googleads.v15.services.CustomerExtensionSettingServiceSettings settings =
          com.google.ads.googleads.v15.services.CustomerExtensionSettingServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v15.services.CustomerExtensionSettingServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v15.services.CustomerFeedServiceClient createCustomerFeedServiceClient(
        ) {
      try {
        com.google.ads.googleads.v15.services.CustomerFeedServiceSettings settings =
          com.google.ads.googleads.v15.services.CustomerFeedServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v15.services.CustomerFeedServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v15.services.CustomerLabelServiceClient createCustomerLabelServiceClient(
        ) {
      try {
        com.google.ads.googleads.v15.services.CustomerLabelServiceSettings settings =
          com.google.ads.googleads.v15.services.CustomerLabelServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v15.services.CustomerLabelServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v15.services.CustomerManagerLinkServiceClient createCustomerManagerLinkServiceClient(
        ) {
      try {
        com.google.ads.googleads.v15.services.CustomerManagerLinkServiceSettings settings =
          com.google.ads.googleads.v15.services.CustomerManagerLinkServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v15.services.CustomerManagerLinkServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v15.services.CustomerNegativeCriterionServiceClient createCustomerNegativeCriterionServiceClient(
        ) {
      try {
        com.google.ads.googleads.v15.services.CustomerNegativeCriterionServiceSettings settings =
          com.google.ads.googleads.v15.services.CustomerNegativeCriterionServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v15.services.CustomerNegativeCriterionServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v15.services.CustomerServiceClient createCustomerServiceClient(
        ) {
      try {
        com.google.ads.googleads.v15.services.CustomerServiceSettings settings =
          com.google.ads.googleads.v15.services.CustomerServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v15.services.CustomerServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v15.services.CustomerSkAdNetworkConversionValueSchemaServiceClient createCustomerSkAdNetworkConversionValueSchemaServiceClient(
        ) {
      try {
        com.google.ads.googleads.v15.services.CustomerSkAdNetworkConversionValueSchemaServiceSettings settings =
          com.google.ads.googleads.v15.services.CustomerSkAdNetworkConversionValueSchemaServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v15.services.CustomerSkAdNetworkConversionValueSchemaServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v15.services.CustomerUserAccessInvitationServiceClient createCustomerUserAccessInvitationServiceClient(
        ) {
      try {
        com.google.ads.googleads.v15.services.CustomerUserAccessInvitationServiceSettings settings =
          com.google.ads.googleads.v15.services.CustomerUserAccessInvitationServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v15.services.CustomerUserAccessInvitationServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v15.services.CustomerUserAccessServiceClient createCustomerUserAccessServiceClient(
        ) {
      try {
        com.google.ads.googleads.v15.services.CustomerUserAccessServiceSettings settings =
          com.google.ads.googleads.v15.services.CustomerUserAccessServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v15.services.CustomerUserAccessServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v15.services.CustomizerAttributeServiceClient createCustomizerAttributeServiceClient(
        ) {
      try {
        com.google.ads.googleads.v15.services.CustomizerAttributeServiceSettings settings =
          com.google.ads.googleads.v15.services.CustomizerAttributeServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v15.services.CustomizerAttributeServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v15.services.ExperimentArmServiceClient createExperimentArmServiceClient(
        ) {
      try {
        com.google.ads.googleads.v15.services.ExperimentArmServiceSettings settings =
          com.google.ads.googleads.v15.services.ExperimentArmServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v15.services.ExperimentArmServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v15.services.ExperimentServiceClient createExperimentServiceClient(
        ) {
      try {
        com.google.ads.googleads.v15.services.ExperimentServiceSettings settings =
          com.google.ads.googleads.v15.services.ExperimentServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v15.services.ExperimentServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v15.services.ExtensionFeedItemServiceClient createExtensionFeedItemServiceClient(
        ) {
      try {
        com.google.ads.googleads.v15.services.ExtensionFeedItemServiceSettings settings =
          com.google.ads.googleads.v15.services.ExtensionFeedItemServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v15.services.ExtensionFeedItemServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v15.services.FeedItemServiceClient createFeedItemServiceClient(
        ) {
      try {
        com.google.ads.googleads.v15.services.FeedItemServiceSettings settings =
          com.google.ads.googleads.v15.services.FeedItemServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v15.services.FeedItemServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v15.services.FeedItemSetLinkServiceClient createFeedItemSetLinkServiceClient(
        ) {
      try {
        com.google.ads.googleads.v15.services.FeedItemSetLinkServiceSettings settings =
          com.google.ads.googleads.v15.services.FeedItemSetLinkServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v15.services.FeedItemSetLinkServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v15.services.FeedItemSetServiceClient createFeedItemSetServiceClient(
        ) {
      try {
        com.google.ads.googleads.v15.services.FeedItemSetServiceSettings settings =
          com.google.ads.googleads.v15.services.FeedItemSetServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v15.services.FeedItemSetServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v15.services.FeedItemTargetServiceClient createFeedItemTargetServiceClient(
        ) {
      try {
        com.google.ads.googleads.v15.services.FeedItemTargetServiceSettings settings =
          com.google.ads.googleads.v15.services.FeedItemTargetServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v15.services.FeedItemTargetServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v15.services.FeedMappingServiceClient createFeedMappingServiceClient(
        ) {
      try {
        com.google.ads.googleads.v15.services.FeedMappingServiceSettings settings =
          com.google.ads.googleads.v15.services.FeedMappingServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v15.services.FeedMappingServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v15.services.FeedServiceClient createFeedServiceClient() {
      try {
        com.google.ads.googleads.v15.services.FeedServiceSettings settings =
          com.google.ads.googleads.v15.services.FeedServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v15.services.FeedServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v15.services.GeoTargetConstantServiceClient createGeoTargetConstantServiceClient(
        ) {
      try {
        com.google.ads.googleads.v15.services.GeoTargetConstantServiceSettings settings =
          com.google.ads.googleads.v15.services.GeoTargetConstantServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v15.services.GeoTargetConstantServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v15.services.GoogleAdsFieldServiceClient createGoogleAdsFieldServiceClient(
        ) {
      try {
        com.google.ads.googleads.v15.services.GoogleAdsFieldServiceSettings settings =
          com.google.ads.googleads.v15.services.GoogleAdsFieldServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v15.services.GoogleAdsFieldServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v15.services.GoogleAdsServiceClient createGoogleAdsServiceClient(
        ) {
      try {
        com.google.ads.googleads.v15.services.GoogleAdsServiceSettings settings =
          com.google.ads.googleads.v15.services.GoogleAdsServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v15.services.GoogleAdsServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v15.services.InvoiceServiceClient createInvoiceServiceClient() {
      try {
        com.google.ads.googleads.v15.services.InvoiceServiceSettings settings =
          com.google.ads.googleads.v15.services.InvoiceServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v15.services.InvoiceServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v15.services.KeywordPlanAdGroupKeywordServiceClient createKeywordPlanAdGroupKeywordServiceClient(
        ) {
      try {
        com.google.ads.googleads.v15.services.KeywordPlanAdGroupKeywordServiceSettings settings =
          com.google.ads.googleads.v15.services.KeywordPlanAdGroupKeywordServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v15.services.KeywordPlanAdGroupKeywordServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v15.services.KeywordPlanAdGroupServiceClient createKeywordPlanAdGroupServiceClient(
        ) {
      try {
        com.google.ads.googleads.v15.services.KeywordPlanAdGroupServiceSettings settings =
          com.google.ads.googleads.v15.services.KeywordPlanAdGroupServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v15.services.KeywordPlanAdGroupServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v15.services.KeywordPlanCampaignKeywordServiceClient createKeywordPlanCampaignKeywordServiceClient(
        ) {
      try {
        com.google.ads.googleads.v15.services.KeywordPlanCampaignKeywordServiceSettings settings =
          com.google.ads.googleads.v15.services.KeywordPlanCampaignKeywordServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v15.services.KeywordPlanCampaignKeywordServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v15.services.KeywordPlanCampaignServiceClient createKeywordPlanCampaignServiceClient(
        ) {
      try {
        com.google.ads.googleads.v15.services.KeywordPlanCampaignServiceSettings settings =
          com.google.ads.googleads.v15.services.KeywordPlanCampaignServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v15.services.KeywordPlanCampaignServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v15.services.KeywordPlanIdeaServiceClient createKeywordPlanIdeaServiceClient(
        ) {
      try {
        com.google.ads.googleads.v15.services.KeywordPlanIdeaServiceSettings settings =
          com.google.ads.googleads.v15.services.KeywordPlanIdeaServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v15.services.KeywordPlanIdeaServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v15.services.KeywordPlanServiceClient createKeywordPlanServiceClient(
        ) {
      try {
        com.google.ads.googleads.v15.services.KeywordPlanServiceSettings settings =
          com.google.ads.googleads.v15.services.KeywordPlanServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v15.services.KeywordPlanServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v15.services.KeywordThemeConstantServiceClient createKeywordThemeConstantServiceClient(
        ) {
      try {
        com.google.ads.googleads.v15.services.KeywordThemeConstantServiceSettings settings =
          com.google.ads.googleads.v15.services.KeywordThemeConstantServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v15.services.KeywordThemeConstantServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v15.services.LabelServiceClient createLabelServiceClient() {
      try {
        com.google.ads.googleads.v15.services.LabelServiceSettings settings =
          com.google.ads.googleads.v15.services.LabelServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v15.services.LabelServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v15.services.OfflineUserDataJobServiceClient createOfflineUserDataJobServiceClient(
        ) {
      try {
        com.google.ads.googleads.v15.services.OfflineUserDataJobServiceSettings settings =
          com.google.ads.googleads.v15.services.OfflineUserDataJobServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v15.services.OfflineUserDataJobServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v15.services.PaymentsAccountServiceClient createPaymentsAccountServiceClient(
        ) {
      try {
        com.google.ads.googleads.v15.services.PaymentsAccountServiceSettings settings =
          com.google.ads.googleads.v15.services.PaymentsAccountServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v15.services.PaymentsAccountServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v15.services.ProductLinkServiceClient createProductLinkServiceClient(
        ) {
      try {
        com.google.ads.googleads.v15.services.ProductLinkServiceSettings settings =
          com.google.ads.googleads.v15.services.ProductLinkServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v15.services.ProductLinkServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v15.services.ReachPlanServiceClient createReachPlanServiceClient(
        ) {
      try {
        com.google.ads.googleads.v15.services.ReachPlanServiceSettings settings =
          com.google.ads.googleads.v15.services.ReachPlanServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v15.services.ReachPlanServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v15.services.RecommendationServiceClient createRecommendationServiceClient(
        ) {
      try {
        com.google.ads.googleads.v15.services.RecommendationServiceSettings settings =
          com.google.ads.googleads.v15.services.RecommendationServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v15.services.RecommendationServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v15.services.RemarketingActionServiceClient createRemarketingActionServiceClient(
        ) {
      try {
        com.google.ads.googleads.v15.services.RemarketingActionServiceSettings settings =
          com.google.ads.googleads.v15.services.RemarketingActionServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v15.services.RemarketingActionServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v15.services.SharedCriterionServiceClient createSharedCriterionServiceClient(
        ) {
      try {
        com.google.ads.googleads.v15.services.SharedCriterionServiceSettings settings =
          com.google.ads.googleads.v15.services.SharedCriterionServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v15.services.SharedCriterionServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v15.services.SharedSetServiceClient createSharedSetServiceClient(
        ) {
      try {
        com.google.ads.googleads.v15.services.SharedSetServiceSettings settings =
          com.google.ads.googleads.v15.services.SharedSetServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v15.services.SharedSetServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v15.services.SmartCampaignSettingServiceClient createSmartCampaignSettingServiceClient(
        ) {
      try {
        com.google.ads.googleads.v15.services.SmartCampaignSettingServiceSettings settings =
          com.google.ads.googleads.v15.services.SmartCampaignSettingServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v15.services.SmartCampaignSettingServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v15.services.SmartCampaignSuggestServiceClient createSmartCampaignSuggestServiceClient(
        ) {
      try {
        com.google.ads.googleads.v15.services.SmartCampaignSuggestServiceSettings settings =
          com.google.ads.googleads.v15.services.SmartCampaignSuggestServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v15.services.SmartCampaignSuggestServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v15.services.ThirdPartyAppAnalyticsLinkServiceClient createThirdPartyAppAnalyticsLinkServiceClient(
        ) {
      try {
        com.google.ads.googleads.v15.services.ThirdPartyAppAnalyticsLinkServiceSettings settings =
          com.google.ads.googleads.v15.services.ThirdPartyAppAnalyticsLinkServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v15.services.ThirdPartyAppAnalyticsLinkServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v15.services.TravelAssetSuggestionServiceClient createTravelAssetSuggestionServiceClient(
        ) {
      try {
        com.google.ads.googleads.v15.services.TravelAssetSuggestionServiceSettings settings =
          com.google.ads.googleads.v15.services.TravelAssetSuggestionServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v15.services.TravelAssetSuggestionServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v15.services.UserDataServiceClient createUserDataServiceClient(
        ) {
      try {
        com.google.ads.googleads.v15.services.UserDataServiceSettings settings =
          com.google.ads.googleads.v15.services.UserDataServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v15.services.UserDataServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v15.services.UserListServiceClient createUserListServiceClient(
        ) {
      try {
        com.google.ads.googleads.v15.services.UserListServiceSettings settings =
          com.google.ads.googleads.v15.services.UserListServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v15.services.UserListServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v15.services.BrandSuggestionServiceClient createBrandSuggestionServiceClient(
        ) {
      try {
        com.google.ads.googleads.v15.services.BrandSuggestionServiceSettings settings =
          com.google.ads.googleads.v15.services.BrandSuggestionServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v15.services.BrandSuggestionServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v15.services.CampaignLifecycleGoalServiceClient createCampaignLifecycleGoalServiceClient(
        ) {
      try {
        com.google.ads.googleads.v15.services.CampaignLifecycleGoalServiceSettings settings =
          com.google.ads.googleads.v15.services.CampaignLifecycleGoalServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v15.services.CampaignLifecycleGoalServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v15.services.CustomerLifecycleGoalServiceClient createCustomerLifecycleGoalServiceClient(
        ) {
      try {
        com.google.ads.googleads.v15.services.CustomerLifecycleGoalServiceSettings settings =
          com.google.ads.googleads.v15.services.CustomerLifecycleGoalServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v15.services.CustomerLifecycleGoalServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v15.services.ProductLinkInvitationServiceClient createProductLinkInvitationServiceClient(
        ) {
      try {
        com.google.ads.googleads.v15.services.ProductLinkInvitationServiceSettings settings =
          com.google.ads.googleads.v15.services.ProductLinkInvitationServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v15.services.ProductLinkInvitationServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v15.services.RecommendationSubscriptionServiceClient createRecommendationSubscriptionServiceClient(
        ) {
      try {
        com.google.ads.googleads.v15.services.RecommendationSubscriptionServiceSettings settings =
          com.google.ads.googleads.v15.services.RecommendationSubscriptionServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v15.services.RecommendationSubscriptionServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }
  }
}
