/*
 * Decompiled with CFR 0.152.
 */
package com.google.ads.googleads.lib.catalog;

import com.google.ads.googleads.lib.catalog.DefaultPrimer;
import com.google.auth.Credentials;
import com.google.common.annotations.Beta;
import java.util.Optional;

@Beta
public abstract class Primer {
    private static final Optional<Primer> INSTANCE = Primer.isEnabled() ? Optional.of(new DefaultPrimer()) : Optional.empty();
    static final String ENABLE_PRIMER_SYSTEM_PROPERTY = "GOOGLE_ADS_ALPHA_ENABLE_PRIMER";

    public static Optional<Primer> getInstance() {
        return INSTANCE;
    }

    public static boolean isEnabled() {
        return Boolean.getBoolean(ENABLE_PRIMER_SYSTEM_PROPERTY);
    }

    public static void primeBasicsIfEnabled() {
        if (Primer.isEnabled()) {
            Primer.getInstance().ifPresent(p -> {
                p.primeGrpcAsync();
                p.primeProtobufAsync();
                p.primeAllVersionsAsync();
            });
        }
    }

    public abstract void primeGrpcAsync();

    public abstract void primeProtobufAsync();

    public abstract void primeAllVersionsAsync();

    public abstract void primeCredentialsAsync(Credentials var1);
}

