/*
 * Decompiled with CFR 0.152.
 */
package com.google.ads.googleads.lib.logging;

import com.google.ads.googleads.lib.logging.Event;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.protobuf.InvalidProtocolBufferException;
import com.google.protobuf.Message;
import java.util.function.Supplier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.event.Level;

public class RequestLogger {
    @VisibleForTesting
    static final String TRUNCATE_MESSAGE = "\n... TRUNCATED. See README.md to configure/disable log truncation.";
    private static final Logger libraryLogger = LoggerFactory.getLogger(RequestLogger.class);
    private static final String LOG_LENGTH_LIMIT_KEY = "api.googleads.maxLogMessageLength";
    private static final int DEFAULT_LOG_LENGTH_LIMIT = 1000;
    private final Logger detailLogger;
    private final Logger summaryLogger;
    private final int logLengthLimit;

    public RequestLogger() {
        this(LoggerFactory.getLogger((String)"com.google.ads.googleads.lib.request.summary"), LoggerFactory.getLogger((String)"com.google.ads.googleads.lib.request.detail"), () -> System.getProperties().containsKey(LOG_LENGTH_LIMIT_KEY) ? RequestLogger.parseLogLengthLimit(System.getProperty(LOG_LENGTH_LIMIT_KEY)) : 1000);
    }

    @VisibleForTesting
    RequestLogger(Logger summaryLogger, Logger detailLogger, Supplier<Integer> logLengthLimitSupplier) {
        this.summaryLogger = summaryLogger;
        this.detailLogger = detailLogger;
        this.logLengthLimit = logLengthLimitSupplier.get();
        Preconditions.checkArgument((this.logLengthLimit >= -1 ? 1 : 0) != 0, (Object)"api.googleads.maxLogMessageLength must be >= -1");
    }

    public boolean isDetailEnabled(Level level) {
        return RequestLogger.isLevelEnabled(level, this.detailLogger);
    }

    public boolean isSummaryEnabled(Level level) {
        return RequestLogger.isLevelEnabled(level, this.summaryLogger);
    }

    public void logSummary(Level level, Event.Summary event) {
        RequestLogger.logAtLevel(this.summaryLogger, level, "{} REQUEST SUMMARY. Method: {}, Endpoint: {}, CustomerID: {}, RequestID: {}, ResponseCode: {}, Fault: {}.", event.isSuccess() ? "SUCCESS" : "FAILURE", event.getMethodName(), event.getEndpoint(), event.getCustomerId(), event.getRequestId(), event.getResponseCode(), event.getResponseDescription());
    }

    public void logDetail(Level level, Event.Detail event) {
        RequestLogger.logAtLevel(this.detailLogger, level, "{} REQUEST DETAIL.\nRequest\n-------\nMethodName: {}\nEndpoint: {}\nHeaders: {}\nBody: {}\n\nResponse\n--------\nHeaders: {}\nBody: {}\nFailure message: {}\nStatus: {}.", event.isSuccess() ? "SUCCESS" : "FAILURE", event.getMethodName(), event.getEndpoint(), event.getScrubbedRequestHeaders(), event.getRequest(), event.getResponseHeaderMetadata(), this.truncate(event.getResponseAsText()), RequestLogger.getDeserializedFailureMessage(event), event.getResponseStatus());
    }

    private String truncate(String responseMsg) {
        if (responseMsg == null) {
            return null;
        }
        if (this.logLengthLimit > -1 && responseMsg.length() > this.logLengthLimit) {
            responseMsg = responseMsg.substring(0, this.logLengthLimit) + TRUNCATE_MESSAGE;
        }
        return responseMsg;
    }

    private static Integer parseLogLengthLimit(String propertyValue) {
        try {
            return Integer.parseInt(propertyValue);
        }
        catch (NumberFormatException ex) {
            throw new IllegalArgumentException("Invalid api.googleads.maxLogMessageLength supplied, must be a number: " + propertyValue);
        }
    }

    private static void logAtLevel(Logger logger, Level level, String format, Object ... argList) {
        if (level == Level.INFO) {
            logger.info(format, argList);
        } else if (level == Level.WARN) {
            logger.warn(format, argList);
        } else if (level == Level.DEBUG) {
            logger.debug(format, argList);
        } else {
            throw new IllegalStateException("Unexpected log level: " + level);
        }
    }

    private static boolean isLevelEnabled(Level logLevel, Logger logger) {
        return logLevel == Level.INFO && logger.isInfoEnabled() || logLevel == Level.WARN && logger.isWarnEnabled() || logLevel == Level.DEBUG && logger.isDebugEnabled();
    }

    private static Message getDeserializedFailureMessage(Event.Detail event) {
        try {
            return event.deserializeFailureMessage().orElse(null);
        }
        catch (InvalidProtocolBufferException e) {
            libraryLogger.debug("GoogleAdsFailure message was present but not readable.", (Throwable)e);
            return null;
        }
    }
}

