// Copyright 2020 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
package com.google.ads.googleads.lib.catalog;

import com.google.ads.googleads.lib.GoogleAdsAllVersions;
import com.google.ads.googleads.v18.services.AccountBudgetProposalServiceClient;
import com.google.ads.googleads.v18.services.AccountBudgetProposalServiceSettings;
import com.google.ads.googleads.v18.services.AccountLinkServiceClient;
import com.google.ads.googleads.v18.services.AccountLinkServiceSettings;
import com.google.ads.googleads.v18.services.AdGroupAdLabelServiceClient;
import com.google.ads.googleads.v18.services.AdGroupAdLabelServiceSettings;
import com.google.ads.googleads.v18.services.AdGroupAdServiceClient;
import com.google.ads.googleads.v18.services.AdGroupAdServiceSettings;
import com.google.ads.googleads.v18.services.AdGroupAssetServiceClient;
import com.google.ads.googleads.v18.services.AdGroupAssetServiceSettings;
import com.google.ads.googleads.v18.services.AdGroupAssetSetServiceClient;
import com.google.ads.googleads.v18.services.AdGroupAssetSetServiceSettings;
import com.google.ads.googleads.v18.services.AdGroupBidModifierServiceClient;
import com.google.ads.googleads.v18.services.AdGroupBidModifierServiceSettings;
import com.google.ads.googleads.v18.services.AdGroupCriterionCustomizerServiceClient;
import com.google.ads.googleads.v18.services.AdGroupCriterionCustomizerServiceSettings;
import com.google.ads.googleads.v18.services.AdGroupCriterionLabelServiceClient;
import com.google.ads.googleads.v18.services.AdGroupCriterionLabelServiceSettings;
import com.google.ads.googleads.v18.services.AdGroupCriterionServiceClient;
import com.google.ads.googleads.v18.services.AdGroupCriterionServiceSettings;
import com.google.ads.googleads.v18.services.AdGroupCustomizerServiceClient;
import com.google.ads.googleads.v18.services.AdGroupCustomizerServiceSettings;
import com.google.ads.googleads.v18.services.AdGroupExtensionSettingServiceClient;
import com.google.ads.googleads.v18.services.AdGroupExtensionSettingServiceSettings;
import com.google.ads.googleads.v18.services.AdGroupFeedServiceClient;
import com.google.ads.googleads.v18.services.AdGroupFeedServiceSettings;
import com.google.ads.googleads.v18.services.AdGroupLabelServiceClient;
import com.google.ads.googleads.v18.services.AdGroupLabelServiceSettings;
import com.google.ads.googleads.v18.services.AdGroupServiceClient;
import com.google.ads.googleads.v18.services.AdGroupServiceSettings;
import com.google.ads.googleads.v18.services.AdParameterServiceClient;
import com.google.ads.googleads.v18.services.AdParameterServiceSettings;
import com.google.ads.googleads.v18.services.AdServiceClient;
import com.google.ads.googleads.v18.services.AdServiceSettings;
import com.google.ads.googleads.v18.services.AssetGroupAssetServiceClient;
import com.google.ads.googleads.v18.services.AssetGroupAssetServiceSettings;
import com.google.ads.googleads.v18.services.AssetGroupListingGroupFilterServiceClient;
import com.google.ads.googleads.v18.services.AssetGroupListingGroupFilterServiceSettings;
import com.google.ads.googleads.v18.services.AssetGroupServiceClient;
import com.google.ads.googleads.v18.services.AssetGroupServiceSettings;
import com.google.ads.googleads.v18.services.AssetGroupSignalServiceClient;
import com.google.ads.googleads.v18.services.AssetGroupSignalServiceSettings;
import com.google.ads.googleads.v18.services.AssetServiceClient;
import com.google.ads.googleads.v18.services.AssetServiceSettings;
import com.google.ads.googleads.v18.services.AssetSetAssetServiceClient;
import com.google.ads.googleads.v18.services.AssetSetAssetServiceSettings;
import com.google.ads.googleads.v18.services.AssetSetServiceClient;
import com.google.ads.googleads.v18.services.AssetSetServiceSettings;
import com.google.ads.googleads.v18.services.AudienceInsightsServiceClient;
import com.google.ads.googleads.v18.services.AudienceInsightsServiceSettings;
import com.google.ads.googleads.v18.services.AudienceServiceClient;
import com.google.ads.googleads.v18.services.AudienceServiceSettings;
import com.google.ads.googleads.v18.services.BatchJobServiceClient;
import com.google.ads.googleads.v18.services.BatchJobServiceSettings;
import com.google.ads.googleads.v18.services.BiddingDataExclusionServiceClient;
import com.google.ads.googleads.v18.services.BiddingDataExclusionServiceSettings;
import com.google.ads.googleads.v18.services.BiddingSeasonalityAdjustmentServiceClient;
import com.google.ads.googleads.v18.services.BiddingSeasonalityAdjustmentServiceSettings;
import com.google.ads.googleads.v18.services.BiddingStrategyServiceClient;
import com.google.ads.googleads.v18.services.BiddingStrategyServiceSettings;
import com.google.ads.googleads.v18.services.BillingSetupServiceClient;
import com.google.ads.googleads.v18.services.BillingSetupServiceSettings;
import com.google.ads.googleads.v18.services.BrandSuggestionServiceClient;
import com.google.ads.googleads.v18.services.BrandSuggestionServiceSettings;
import com.google.ads.googleads.v18.services.CampaignAssetServiceClient;
import com.google.ads.googleads.v18.services.CampaignAssetServiceSettings;
import com.google.ads.googleads.v18.services.CampaignAssetSetServiceClient;
import com.google.ads.googleads.v18.services.CampaignAssetSetServiceSettings;
import com.google.ads.googleads.v18.services.CampaignBidModifierServiceClient;
import com.google.ads.googleads.v18.services.CampaignBidModifierServiceSettings;
import com.google.ads.googleads.v18.services.CampaignBudgetServiceClient;
import com.google.ads.googleads.v18.services.CampaignBudgetServiceSettings;
import com.google.ads.googleads.v18.services.CampaignConversionGoalServiceClient;
import com.google.ads.googleads.v18.services.CampaignConversionGoalServiceSettings;
import com.google.ads.googleads.v18.services.CampaignCriterionServiceClient;
import com.google.ads.googleads.v18.services.CampaignCriterionServiceSettings;
import com.google.ads.googleads.v18.services.CampaignCustomizerServiceClient;
import com.google.ads.googleads.v18.services.CampaignCustomizerServiceSettings;
import com.google.ads.googleads.v18.services.CampaignDraftServiceClient;
import com.google.ads.googleads.v18.services.CampaignDraftServiceSettings;
import com.google.ads.googleads.v18.services.CampaignExtensionSettingServiceClient;
import com.google.ads.googleads.v18.services.CampaignExtensionSettingServiceSettings;
import com.google.ads.googleads.v18.services.CampaignFeedServiceClient;
import com.google.ads.googleads.v18.services.CampaignFeedServiceSettings;
import com.google.ads.googleads.v18.services.CampaignGroupServiceClient;
import com.google.ads.googleads.v18.services.CampaignGroupServiceSettings;
import com.google.ads.googleads.v18.services.CampaignLabelServiceClient;
import com.google.ads.googleads.v18.services.CampaignLabelServiceSettings;
import com.google.ads.googleads.v18.services.CampaignLifecycleGoalServiceClient;
import com.google.ads.googleads.v18.services.CampaignLifecycleGoalServiceSettings;
import com.google.ads.googleads.v18.services.CampaignServiceClient;
import com.google.ads.googleads.v18.services.CampaignServiceSettings;
import com.google.ads.googleads.v18.services.CampaignSharedSetServiceClient;
import com.google.ads.googleads.v18.services.CampaignSharedSetServiceSettings;
import com.google.ads.googleads.v18.services.ContentCreatorInsightsServiceClient;
import com.google.ads.googleads.v18.services.ContentCreatorInsightsServiceSettings;
import com.google.ads.googleads.v18.services.ConversionActionServiceClient;
import com.google.ads.googleads.v18.services.ConversionActionServiceSettings;
import com.google.ads.googleads.v18.services.ConversionAdjustmentUploadServiceClient;
import com.google.ads.googleads.v18.services.ConversionAdjustmentUploadServiceSettings;
import com.google.ads.googleads.v18.services.ConversionCustomVariableServiceClient;
import com.google.ads.googleads.v18.services.ConversionCustomVariableServiceSettings;
import com.google.ads.googleads.v18.services.ConversionGoalCampaignConfigServiceClient;
import com.google.ads.googleads.v18.services.ConversionGoalCampaignConfigServiceSettings;
import com.google.ads.googleads.v18.services.ConversionUploadServiceClient;
import com.google.ads.googleads.v18.services.ConversionUploadServiceSettings;
import com.google.ads.googleads.v18.services.ConversionValueRuleServiceClient;
import com.google.ads.googleads.v18.services.ConversionValueRuleServiceSettings;
import com.google.ads.googleads.v18.services.ConversionValueRuleSetServiceClient;
import com.google.ads.googleads.v18.services.ConversionValueRuleSetServiceSettings;
import com.google.ads.googleads.v18.services.CustomAudienceServiceClient;
import com.google.ads.googleads.v18.services.CustomAudienceServiceSettings;
import com.google.ads.googleads.v18.services.CustomConversionGoalServiceClient;
import com.google.ads.googleads.v18.services.CustomConversionGoalServiceSettings;
import com.google.ads.googleads.v18.services.CustomInterestServiceClient;
import com.google.ads.googleads.v18.services.CustomInterestServiceSettings;
import com.google.ads.googleads.v18.services.CustomerAssetServiceClient;
import com.google.ads.googleads.v18.services.CustomerAssetServiceSettings;
import com.google.ads.googleads.v18.services.CustomerAssetSetServiceClient;
import com.google.ads.googleads.v18.services.CustomerAssetSetServiceSettings;
import com.google.ads.googleads.v18.services.CustomerClientLinkServiceClient;
import com.google.ads.googleads.v18.services.CustomerClientLinkServiceSettings;
import com.google.ads.googleads.v18.services.CustomerConversionGoalServiceClient;
import com.google.ads.googleads.v18.services.CustomerConversionGoalServiceSettings;
import com.google.ads.googleads.v18.services.CustomerCustomizerServiceClient;
import com.google.ads.googleads.v18.services.CustomerCustomizerServiceSettings;
import com.google.ads.googleads.v18.services.CustomerExtensionSettingServiceClient;
import com.google.ads.googleads.v18.services.CustomerExtensionSettingServiceSettings;
import com.google.ads.googleads.v18.services.CustomerFeedServiceClient;
import com.google.ads.googleads.v18.services.CustomerFeedServiceSettings;
import com.google.ads.googleads.v18.services.CustomerLabelServiceClient;
import com.google.ads.googleads.v18.services.CustomerLabelServiceSettings;
import com.google.ads.googleads.v18.services.CustomerLifecycleGoalServiceClient;
import com.google.ads.googleads.v18.services.CustomerLifecycleGoalServiceSettings;
import com.google.ads.googleads.v18.services.CustomerManagerLinkServiceClient;
import com.google.ads.googleads.v18.services.CustomerManagerLinkServiceSettings;
import com.google.ads.googleads.v18.services.CustomerNegativeCriterionServiceClient;
import com.google.ads.googleads.v18.services.CustomerNegativeCriterionServiceSettings;
import com.google.ads.googleads.v18.services.CustomerServiceClient;
import com.google.ads.googleads.v18.services.CustomerServiceSettings;
import com.google.ads.googleads.v18.services.CustomerSkAdNetworkConversionValueSchemaServiceClient;
import com.google.ads.googleads.v18.services.CustomerSkAdNetworkConversionValueSchemaServiceSettings;
import com.google.ads.googleads.v18.services.CustomerUserAccessInvitationServiceClient;
import com.google.ads.googleads.v18.services.CustomerUserAccessInvitationServiceSettings;
import com.google.ads.googleads.v18.services.CustomerUserAccessServiceClient;
import com.google.ads.googleads.v18.services.CustomerUserAccessServiceSettings;
import com.google.ads.googleads.v18.services.CustomizerAttributeServiceClient;
import com.google.ads.googleads.v18.services.CustomizerAttributeServiceSettings;
import com.google.ads.googleads.v18.services.DataLinkServiceClient;
import com.google.ads.googleads.v18.services.DataLinkServiceSettings;
import com.google.ads.googleads.v18.services.ExperimentArmServiceClient;
import com.google.ads.googleads.v18.services.ExperimentArmServiceSettings;
import com.google.ads.googleads.v18.services.ExperimentServiceClient;
import com.google.ads.googleads.v18.services.ExperimentServiceSettings;
import com.google.ads.googleads.v18.services.ExtensionFeedItemServiceClient;
import com.google.ads.googleads.v18.services.ExtensionFeedItemServiceSettings;
import com.google.ads.googleads.v18.services.FeedItemServiceClient;
import com.google.ads.googleads.v18.services.FeedItemServiceSettings;
import com.google.ads.googleads.v18.services.FeedItemSetLinkServiceClient;
import com.google.ads.googleads.v18.services.FeedItemSetLinkServiceSettings;
import com.google.ads.googleads.v18.services.FeedItemSetServiceClient;
import com.google.ads.googleads.v18.services.FeedItemSetServiceSettings;
import com.google.ads.googleads.v18.services.FeedItemTargetServiceClient;
import com.google.ads.googleads.v18.services.FeedItemTargetServiceSettings;
import com.google.ads.googleads.v18.services.FeedMappingServiceClient;
import com.google.ads.googleads.v18.services.FeedMappingServiceSettings;
import com.google.ads.googleads.v18.services.FeedServiceClient;
import com.google.ads.googleads.v18.services.FeedServiceSettings;
import com.google.ads.googleads.v18.services.GeoTargetConstantServiceClient;
import com.google.ads.googleads.v18.services.GeoTargetConstantServiceSettings;
import com.google.ads.googleads.v18.services.GoogleAdsFieldServiceClient;
import com.google.ads.googleads.v18.services.GoogleAdsFieldServiceSettings;
import com.google.ads.googleads.v18.services.GoogleAdsServiceClient;
import com.google.ads.googleads.v18.services.GoogleAdsServiceSettings;
import com.google.ads.googleads.v18.services.GoogleAdsVersion;
import com.google.ads.googleads.v18.services.IdentityVerificationServiceClient;
import com.google.ads.googleads.v18.services.IdentityVerificationServiceSettings;
import com.google.ads.googleads.v18.services.InvoiceServiceClient;
import com.google.ads.googleads.v18.services.InvoiceServiceSettings;
import com.google.ads.googleads.v18.services.KeywordPlanAdGroupKeywordServiceClient;
import com.google.ads.googleads.v18.services.KeywordPlanAdGroupKeywordServiceSettings;
import com.google.ads.googleads.v18.services.KeywordPlanAdGroupServiceClient;
import com.google.ads.googleads.v18.services.KeywordPlanAdGroupServiceSettings;
import com.google.ads.googleads.v18.services.KeywordPlanCampaignKeywordServiceClient;
import com.google.ads.googleads.v18.services.KeywordPlanCampaignKeywordServiceSettings;
import com.google.ads.googleads.v18.services.KeywordPlanCampaignServiceClient;
import com.google.ads.googleads.v18.services.KeywordPlanCampaignServiceSettings;
import com.google.ads.googleads.v18.services.KeywordPlanIdeaServiceClient;
import com.google.ads.googleads.v18.services.KeywordPlanIdeaServiceSettings;
import com.google.ads.googleads.v18.services.KeywordPlanServiceClient;
import com.google.ads.googleads.v18.services.KeywordPlanServiceSettings;
import com.google.ads.googleads.v18.services.KeywordThemeConstantServiceClient;
import com.google.ads.googleads.v18.services.KeywordThemeConstantServiceSettings;
import com.google.ads.googleads.v18.services.LabelServiceClient;
import com.google.ads.googleads.v18.services.LabelServiceSettings;
import com.google.ads.googleads.v18.services.LocalServicesLeadServiceClient;
import com.google.ads.googleads.v18.services.LocalServicesLeadServiceSettings;
import com.google.ads.googleads.v18.services.OfflineUserDataJobServiceClient;
import com.google.ads.googleads.v18.services.OfflineUserDataJobServiceSettings;
import com.google.ads.googleads.v18.services.PaymentsAccountServiceClient;
import com.google.ads.googleads.v18.services.PaymentsAccountServiceSettings;
import com.google.ads.googleads.v18.services.ProductLinkInvitationServiceClient;
import com.google.ads.googleads.v18.services.ProductLinkInvitationServiceSettings;
import com.google.ads.googleads.v18.services.ProductLinkServiceClient;
import com.google.ads.googleads.v18.services.ProductLinkServiceSettings;
import com.google.ads.googleads.v18.services.ReachPlanServiceClient;
import com.google.ads.googleads.v18.services.ReachPlanServiceSettings;
import com.google.ads.googleads.v18.services.RecommendationServiceClient;
import com.google.ads.googleads.v18.services.RecommendationServiceSettings;
import com.google.ads.googleads.v18.services.RecommendationSubscriptionServiceClient;
import com.google.ads.googleads.v18.services.RecommendationSubscriptionServiceSettings;
import com.google.ads.googleads.v18.services.RemarketingActionServiceClient;
import com.google.ads.googleads.v18.services.RemarketingActionServiceSettings;
import com.google.ads.googleads.v18.services.ShareablePreviewServiceClient;
import com.google.ads.googleads.v18.services.ShareablePreviewServiceSettings;
import com.google.ads.googleads.v18.services.SharedCriterionServiceClient;
import com.google.ads.googleads.v18.services.SharedCriterionServiceSettings;
import com.google.ads.googleads.v18.services.SharedSetServiceClient;
import com.google.ads.googleads.v18.services.SharedSetServiceSettings;
import com.google.ads.googleads.v18.services.SmartCampaignSettingServiceClient;
import com.google.ads.googleads.v18.services.SmartCampaignSettingServiceSettings;
import com.google.ads.googleads.v18.services.SmartCampaignSuggestServiceClient;
import com.google.ads.googleads.v18.services.SmartCampaignSuggestServiceSettings;
import com.google.ads.googleads.v18.services.ThirdPartyAppAnalyticsLinkServiceClient;
import com.google.ads.googleads.v18.services.ThirdPartyAppAnalyticsLinkServiceSettings;
import com.google.ads.googleads.v18.services.TravelAssetSuggestionServiceClient;
import com.google.ads.googleads.v18.services.TravelAssetSuggestionServiceSettings;
import com.google.ads.googleads.v18.services.UserDataServiceClient;
import com.google.ads.googleads.v18.services.UserDataServiceSettings;
import com.google.ads.googleads.v18.services.UserListCustomerTypeServiceClient;
import com.google.ads.googleads.v18.services.UserListCustomerTypeServiceSettings;
import com.google.ads.googleads.v18.services.UserListServiceClient;
import com.google.ads.googleads.v18.services.UserListServiceSettings;
import com.google.api.gax.core.FixedCredentialsProvider;
import com.google.api.gax.rpc.TransportChannelProvider;
import com.google.auth.Credentials;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableSortedSet;
import java.io.IOException;
import java.util.SortedSet;
import javax.annotation.Generated;

@Generated("GoogleAdsCatalogAnnotationProcessor")
public class GeneratedCatalog implements ApiCatalog {
  private static GeneratedCatalog instance;

  static {
    try {
      instance = new GeneratedCatalog(VersionFactory.getVersions());
    } catch (IllegalAccessException e) {
      throw new RuntimeException(e);
    } catch (InstantiationException e) {
      throw new RuntimeException(e);
    }
  }

  private final ImmutableSortedSet<Version> supportedVersions;

  /**
   * Creates a new constant catalog from a known collection of versions. */
  public GeneratedCatalog(ImmutableSet<Version> versions) {
    supportedVersions = ImmutableSortedSet.copyOf(versions);
  }

  public static GeneratedCatalog getDefault() {
    return instance;
  }

  public SortedSet<Version> getSupportedVersions() {
    return supportedVersions;
  }

  public Version getLatestVersion() {
    return getSupportedVersions().first();
  }

  public GoogleAdsAllVersions createAllVersionsClient(TransportChannelProvider provider,
      Credentials credentials) {
    return new GoogleAdsAllVersions() {
      @Override
      public GoogleAdsVersion getVersion18() {
        return new V18Client(provider, credentials);
      }

      @Override
      public com.google.ads.googleads.v19.services.GoogleAdsVersion getVersion19() {
        return new V19Client(provider, credentials);
      }

      @Override
      public com.google.ads.googleads.v20.services.GoogleAdsVersion getVersion20() {
        return new V20Client(provider, credentials);
      }

      @Override
      public com.google.ads.googleads.v20.services.GoogleAdsVersion getLatestVersion() {
        return getVersion20();
      }
    };
  }

  private static class V18Client implements GoogleAdsVersion {
    private final TransportChannelProvider provider;

    private final Credentials credentials;

    public V18Client(TransportChannelProvider provider, Credentials credentials) {
      this.provider = provider;
      this.credentials = credentials;
    }

    @Override
    public AccountBudgetProposalServiceClient createAccountBudgetProposalServiceClient() {
      try {
        AccountBudgetProposalServiceSettings settings =
          AccountBudgetProposalServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return AccountBudgetProposalServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public AccountLinkServiceClient createAccountLinkServiceClient() {
      try {
        AccountLinkServiceSettings settings =
          AccountLinkServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return AccountLinkServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public AdGroupAdLabelServiceClient createAdGroupAdLabelServiceClient() {
      try {
        AdGroupAdLabelServiceSettings settings =
          AdGroupAdLabelServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return AdGroupAdLabelServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public AdGroupAdServiceClient createAdGroupAdServiceClient() {
      try {
        AdGroupAdServiceSettings settings =
          AdGroupAdServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return AdGroupAdServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public AdGroupAssetServiceClient createAdGroupAssetServiceClient() {
      try {
        AdGroupAssetServiceSettings settings =
          AdGroupAssetServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return AdGroupAssetServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public AdGroupAssetSetServiceClient createAdGroupAssetSetServiceClient() {
      try {
        AdGroupAssetSetServiceSettings settings =
          AdGroupAssetSetServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return AdGroupAssetSetServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public AdGroupBidModifierServiceClient createAdGroupBidModifierServiceClient() {
      try {
        AdGroupBidModifierServiceSettings settings =
          AdGroupBidModifierServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return AdGroupBidModifierServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public AdGroupCriterionCustomizerServiceClient createAdGroupCriterionCustomizerServiceClient() {
      try {
        AdGroupCriterionCustomizerServiceSettings settings =
          AdGroupCriterionCustomizerServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return AdGroupCriterionCustomizerServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public AdGroupCriterionLabelServiceClient createAdGroupCriterionLabelServiceClient() {
      try {
        AdGroupCriterionLabelServiceSettings settings =
          AdGroupCriterionLabelServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return AdGroupCriterionLabelServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public AdGroupCriterionServiceClient createAdGroupCriterionServiceClient() {
      try {
        AdGroupCriterionServiceSettings settings =
          AdGroupCriterionServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return AdGroupCriterionServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public AdGroupCustomizerServiceClient createAdGroupCustomizerServiceClient() {
      try {
        AdGroupCustomizerServiceSettings settings =
          AdGroupCustomizerServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return AdGroupCustomizerServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public AdGroupExtensionSettingServiceClient createAdGroupExtensionSettingServiceClient() {
      try {
        AdGroupExtensionSettingServiceSettings settings =
          AdGroupExtensionSettingServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return AdGroupExtensionSettingServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public AdGroupFeedServiceClient createAdGroupFeedServiceClient() {
      try {
        AdGroupFeedServiceSettings settings =
          AdGroupFeedServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return AdGroupFeedServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public AdGroupLabelServiceClient createAdGroupLabelServiceClient() {
      try {
        AdGroupLabelServiceSettings settings =
          AdGroupLabelServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return AdGroupLabelServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public AdGroupServiceClient createAdGroupServiceClient() {
      try {
        AdGroupServiceSettings settings =
          AdGroupServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return AdGroupServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public AdParameterServiceClient createAdParameterServiceClient() {
      try {
        AdParameterServiceSettings settings =
          AdParameterServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return AdParameterServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public AdServiceClient createAdServiceClient() {
      try {
        AdServiceSettings settings =
          AdServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return AdServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public AssetGroupAssetServiceClient createAssetGroupAssetServiceClient() {
      try {
        AssetGroupAssetServiceSettings settings =
          AssetGroupAssetServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return AssetGroupAssetServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public AssetGroupListingGroupFilterServiceClient createAssetGroupListingGroupFilterServiceClient(
        ) {
      try {
        AssetGroupListingGroupFilterServiceSettings settings =
          AssetGroupListingGroupFilterServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return AssetGroupListingGroupFilterServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public AssetGroupServiceClient createAssetGroupServiceClient() {
      try {
        AssetGroupServiceSettings settings =
          AssetGroupServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return AssetGroupServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public AssetGroupSignalServiceClient createAssetGroupSignalServiceClient() {
      try {
        AssetGroupSignalServiceSettings settings =
          AssetGroupSignalServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return AssetGroupSignalServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public AssetServiceClient createAssetServiceClient() {
      try {
        AssetServiceSettings settings =
          AssetServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return AssetServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public AssetSetAssetServiceClient createAssetSetAssetServiceClient() {
      try {
        AssetSetAssetServiceSettings settings =
          AssetSetAssetServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return AssetSetAssetServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public AssetSetServiceClient createAssetSetServiceClient() {
      try {
        AssetSetServiceSettings settings =
          AssetSetServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return AssetSetServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public AudienceInsightsServiceClient createAudienceInsightsServiceClient() {
      try {
        AudienceInsightsServiceSettings settings =
          AudienceInsightsServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return AudienceInsightsServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public AudienceServiceClient createAudienceServiceClient() {
      try {
        AudienceServiceSettings settings =
          AudienceServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return AudienceServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public BatchJobServiceClient createBatchJobServiceClient() {
      try {
        BatchJobServiceSettings settings =
          BatchJobServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return BatchJobServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public BiddingDataExclusionServiceClient createBiddingDataExclusionServiceClient() {
      try {
        BiddingDataExclusionServiceSettings settings =
          BiddingDataExclusionServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return BiddingDataExclusionServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public BiddingSeasonalityAdjustmentServiceClient createBiddingSeasonalityAdjustmentServiceClient(
        ) {
      try {
        BiddingSeasonalityAdjustmentServiceSettings settings =
          BiddingSeasonalityAdjustmentServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return BiddingSeasonalityAdjustmentServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public BiddingStrategyServiceClient createBiddingStrategyServiceClient() {
      try {
        BiddingStrategyServiceSettings settings =
          BiddingStrategyServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return BiddingStrategyServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public BillingSetupServiceClient createBillingSetupServiceClient() {
      try {
        BillingSetupServiceSettings settings =
          BillingSetupServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return BillingSetupServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public BrandSuggestionServiceClient createBrandSuggestionServiceClient() {
      try {
        BrandSuggestionServiceSettings settings =
          BrandSuggestionServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return BrandSuggestionServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public CampaignAssetServiceClient createCampaignAssetServiceClient() {
      try {
        CampaignAssetServiceSettings settings =
          CampaignAssetServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return CampaignAssetServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public CampaignAssetSetServiceClient createCampaignAssetSetServiceClient() {
      try {
        CampaignAssetSetServiceSettings settings =
          CampaignAssetSetServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return CampaignAssetSetServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public CampaignBidModifierServiceClient createCampaignBidModifierServiceClient() {
      try {
        CampaignBidModifierServiceSettings settings =
          CampaignBidModifierServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return CampaignBidModifierServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public CampaignBudgetServiceClient createCampaignBudgetServiceClient() {
      try {
        CampaignBudgetServiceSettings settings =
          CampaignBudgetServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return CampaignBudgetServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public CampaignConversionGoalServiceClient createCampaignConversionGoalServiceClient() {
      try {
        CampaignConversionGoalServiceSettings settings =
          CampaignConversionGoalServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return CampaignConversionGoalServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public CampaignCriterionServiceClient createCampaignCriterionServiceClient() {
      try {
        CampaignCriterionServiceSettings settings =
          CampaignCriterionServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return CampaignCriterionServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public CampaignCustomizerServiceClient createCampaignCustomizerServiceClient() {
      try {
        CampaignCustomizerServiceSettings settings =
          CampaignCustomizerServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return CampaignCustomizerServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public CampaignDraftServiceClient createCampaignDraftServiceClient() {
      try {
        CampaignDraftServiceSettings settings =
          CampaignDraftServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return CampaignDraftServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public CampaignExtensionSettingServiceClient createCampaignExtensionSettingServiceClient() {
      try {
        CampaignExtensionSettingServiceSettings settings =
          CampaignExtensionSettingServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return CampaignExtensionSettingServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public CampaignFeedServiceClient createCampaignFeedServiceClient() {
      try {
        CampaignFeedServiceSettings settings =
          CampaignFeedServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return CampaignFeedServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public CampaignGroupServiceClient createCampaignGroupServiceClient() {
      try {
        CampaignGroupServiceSettings settings =
          CampaignGroupServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return CampaignGroupServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public CampaignLabelServiceClient createCampaignLabelServiceClient() {
      try {
        CampaignLabelServiceSettings settings =
          CampaignLabelServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return CampaignLabelServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public CampaignLifecycleGoalServiceClient createCampaignLifecycleGoalServiceClient() {
      try {
        CampaignLifecycleGoalServiceSettings settings =
          CampaignLifecycleGoalServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return CampaignLifecycleGoalServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public CampaignServiceClient createCampaignServiceClient() {
      try {
        CampaignServiceSettings settings =
          CampaignServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return CampaignServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public CampaignSharedSetServiceClient createCampaignSharedSetServiceClient() {
      try {
        CampaignSharedSetServiceSettings settings =
          CampaignSharedSetServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return CampaignSharedSetServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public ContentCreatorInsightsServiceClient createContentCreatorInsightsServiceClient() {
      try {
        ContentCreatorInsightsServiceSettings settings =
          ContentCreatorInsightsServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return ContentCreatorInsightsServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public ConversionActionServiceClient createConversionActionServiceClient() {
      try {
        ConversionActionServiceSettings settings =
          ConversionActionServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return ConversionActionServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public ConversionAdjustmentUploadServiceClient createConversionAdjustmentUploadServiceClient() {
      try {
        ConversionAdjustmentUploadServiceSettings settings =
          ConversionAdjustmentUploadServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return ConversionAdjustmentUploadServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public ConversionCustomVariableServiceClient createConversionCustomVariableServiceClient() {
      try {
        ConversionCustomVariableServiceSettings settings =
          ConversionCustomVariableServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return ConversionCustomVariableServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public ConversionGoalCampaignConfigServiceClient createConversionGoalCampaignConfigServiceClient(
        ) {
      try {
        ConversionGoalCampaignConfigServiceSettings settings =
          ConversionGoalCampaignConfigServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return ConversionGoalCampaignConfigServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public ConversionUploadServiceClient createConversionUploadServiceClient() {
      try {
        ConversionUploadServiceSettings settings =
          ConversionUploadServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return ConversionUploadServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public ConversionValueRuleServiceClient createConversionValueRuleServiceClient() {
      try {
        ConversionValueRuleServiceSettings settings =
          ConversionValueRuleServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return ConversionValueRuleServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public ConversionValueRuleSetServiceClient createConversionValueRuleSetServiceClient() {
      try {
        ConversionValueRuleSetServiceSettings settings =
          ConversionValueRuleSetServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return ConversionValueRuleSetServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public CustomAudienceServiceClient createCustomAudienceServiceClient() {
      try {
        CustomAudienceServiceSettings settings =
          CustomAudienceServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return CustomAudienceServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public CustomConversionGoalServiceClient createCustomConversionGoalServiceClient() {
      try {
        CustomConversionGoalServiceSettings settings =
          CustomConversionGoalServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return CustomConversionGoalServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public CustomInterestServiceClient createCustomInterestServiceClient() {
      try {
        CustomInterestServiceSettings settings =
          CustomInterestServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return CustomInterestServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public CustomerAssetServiceClient createCustomerAssetServiceClient() {
      try {
        CustomerAssetServiceSettings settings =
          CustomerAssetServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return CustomerAssetServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public CustomerAssetSetServiceClient createCustomerAssetSetServiceClient() {
      try {
        CustomerAssetSetServiceSettings settings =
          CustomerAssetSetServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return CustomerAssetSetServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public CustomerClientLinkServiceClient createCustomerClientLinkServiceClient() {
      try {
        CustomerClientLinkServiceSettings settings =
          CustomerClientLinkServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return CustomerClientLinkServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public CustomerConversionGoalServiceClient createCustomerConversionGoalServiceClient() {
      try {
        CustomerConversionGoalServiceSettings settings =
          CustomerConversionGoalServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return CustomerConversionGoalServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public CustomerCustomizerServiceClient createCustomerCustomizerServiceClient() {
      try {
        CustomerCustomizerServiceSettings settings =
          CustomerCustomizerServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return CustomerCustomizerServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public CustomerExtensionSettingServiceClient createCustomerExtensionSettingServiceClient() {
      try {
        CustomerExtensionSettingServiceSettings settings =
          CustomerExtensionSettingServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return CustomerExtensionSettingServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public CustomerFeedServiceClient createCustomerFeedServiceClient() {
      try {
        CustomerFeedServiceSettings settings =
          CustomerFeedServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return CustomerFeedServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public CustomerLabelServiceClient createCustomerLabelServiceClient() {
      try {
        CustomerLabelServiceSettings settings =
          CustomerLabelServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return CustomerLabelServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public CustomerLifecycleGoalServiceClient createCustomerLifecycleGoalServiceClient() {
      try {
        CustomerLifecycleGoalServiceSettings settings =
          CustomerLifecycleGoalServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return CustomerLifecycleGoalServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public CustomerManagerLinkServiceClient createCustomerManagerLinkServiceClient() {
      try {
        CustomerManagerLinkServiceSettings settings =
          CustomerManagerLinkServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return CustomerManagerLinkServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public CustomerNegativeCriterionServiceClient createCustomerNegativeCriterionServiceClient() {
      try {
        CustomerNegativeCriterionServiceSettings settings =
          CustomerNegativeCriterionServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return CustomerNegativeCriterionServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public CustomerServiceClient createCustomerServiceClient() {
      try {
        CustomerServiceSettings settings =
          CustomerServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return CustomerServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public CustomerSkAdNetworkConversionValueSchemaServiceClient createCustomerSkAdNetworkConversionValueSchemaServiceClient(
        ) {
      try {
        CustomerSkAdNetworkConversionValueSchemaServiceSettings settings =
          CustomerSkAdNetworkConversionValueSchemaServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return CustomerSkAdNetworkConversionValueSchemaServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public CustomerUserAccessInvitationServiceClient createCustomerUserAccessInvitationServiceClient(
        ) {
      try {
        CustomerUserAccessInvitationServiceSettings settings =
          CustomerUserAccessInvitationServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return CustomerUserAccessInvitationServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public CustomerUserAccessServiceClient createCustomerUserAccessServiceClient() {
      try {
        CustomerUserAccessServiceSettings settings =
          CustomerUserAccessServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return CustomerUserAccessServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public CustomizerAttributeServiceClient createCustomizerAttributeServiceClient() {
      try {
        CustomizerAttributeServiceSettings settings =
          CustomizerAttributeServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return CustomizerAttributeServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public DataLinkServiceClient createDataLinkServiceClient() {
      try {
        DataLinkServiceSettings settings =
          DataLinkServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return DataLinkServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public ExperimentArmServiceClient createExperimentArmServiceClient() {
      try {
        ExperimentArmServiceSettings settings =
          ExperimentArmServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return ExperimentArmServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public ExperimentServiceClient createExperimentServiceClient() {
      try {
        ExperimentServiceSettings settings =
          ExperimentServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return ExperimentServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public ExtensionFeedItemServiceClient createExtensionFeedItemServiceClient() {
      try {
        ExtensionFeedItemServiceSettings settings =
          ExtensionFeedItemServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return ExtensionFeedItemServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public FeedItemServiceClient createFeedItemServiceClient() {
      try {
        FeedItemServiceSettings settings =
          FeedItemServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return FeedItemServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public FeedItemSetLinkServiceClient createFeedItemSetLinkServiceClient() {
      try {
        FeedItemSetLinkServiceSettings settings =
          FeedItemSetLinkServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return FeedItemSetLinkServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public FeedItemSetServiceClient createFeedItemSetServiceClient() {
      try {
        FeedItemSetServiceSettings settings =
          FeedItemSetServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return FeedItemSetServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public FeedItemTargetServiceClient createFeedItemTargetServiceClient() {
      try {
        FeedItemTargetServiceSettings settings =
          FeedItemTargetServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return FeedItemTargetServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public FeedMappingServiceClient createFeedMappingServiceClient() {
      try {
        FeedMappingServiceSettings settings =
          FeedMappingServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return FeedMappingServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public FeedServiceClient createFeedServiceClient() {
      try {
        FeedServiceSettings settings =
          FeedServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return FeedServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public GeoTargetConstantServiceClient createGeoTargetConstantServiceClient() {
      try {
        GeoTargetConstantServiceSettings settings =
          GeoTargetConstantServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return GeoTargetConstantServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public GoogleAdsFieldServiceClient createGoogleAdsFieldServiceClient() {
      try {
        GoogleAdsFieldServiceSettings settings =
          GoogleAdsFieldServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return GoogleAdsFieldServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public GoogleAdsServiceClient createGoogleAdsServiceClient() {
      try {
        GoogleAdsServiceSettings settings =
          GoogleAdsServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return GoogleAdsServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public IdentityVerificationServiceClient createIdentityVerificationServiceClient() {
      try {
        IdentityVerificationServiceSettings settings =
          IdentityVerificationServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return IdentityVerificationServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public InvoiceServiceClient createInvoiceServiceClient() {
      try {
        InvoiceServiceSettings settings =
          InvoiceServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return InvoiceServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public KeywordPlanAdGroupKeywordServiceClient createKeywordPlanAdGroupKeywordServiceClient() {
      try {
        KeywordPlanAdGroupKeywordServiceSettings settings =
          KeywordPlanAdGroupKeywordServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return KeywordPlanAdGroupKeywordServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public KeywordPlanAdGroupServiceClient createKeywordPlanAdGroupServiceClient() {
      try {
        KeywordPlanAdGroupServiceSettings settings =
          KeywordPlanAdGroupServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return KeywordPlanAdGroupServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public KeywordPlanCampaignKeywordServiceClient createKeywordPlanCampaignKeywordServiceClient() {
      try {
        KeywordPlanCampaignKeywordServiceSettings settings =
          KeywordPlanCampaignKeywordServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return KeywordPlanCampaignKeywordServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public KeywordPlanCampaignServiceClient createKeywordPlanCampaignServiceClient() {
      try {
        KeywordPlanCampaignServiceSettings settings =
          KeywordPlanCampaignServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return KeywordPlanCampaignServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public KeywordPlanIdeaServiceClient createKeywordPlanIdeaServiceClient() {
      try {
        KeywordPlanIdeaServiceSettings settings =
          KeywordPlanIdeaServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return KeywordPlanIdeaServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public KeywordPlanServiceClient createKeywordPlanServiceClient() {
      try {
        KeywordPlanServiceSettings settings =
          KeywordPlanServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return KeywordPlanServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public KeywordThemeConstantServiceClient createKeywordThemeConstantServiceClient() {
      try {
        KeywordThemeConstantServiceSettings settings =
          KeywordThemeConstantServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return KeywordThemeConstantServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public LabelServiceClient createLabelServiceClient() {
      try {
        LabelServiceSettings settings =
          LabelServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return LabelServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public LocalServicesLeadServiceClient createLocalServicesLeadServiceClient() {
      try {
        LocalServicesLeadServiceSettings settings =
          LocalServicesLeadServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return LocalServicesLeadServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public OfflineUserDataJobServiceClient createOfflineUserDataJobServiceClient() {
      try {
        OfflineUserDataJobServiceSettings settings =
          OfflineUserDataJobServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return OfflineUserDataJobServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public PaymentsAccountServiceClient createPaymentsAccountServiceClient() {
      try {
        PaymentsAccountServiceSettings settings =
          PaymentsAccountServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return PaymentsAccountServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public ProductLinkInvitationServiceClient createProductLinkInvitationServiceClient() {
      try {
        ProductLinkInvitationServiceSettings settings =
          ProductLinkInvitationServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return ProductLinkInvitationServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public ProductLinkServiceClient createProductLinkServiceClient() {
      try {
        ProductLinkServiceSettings settings =
          ProductLinkServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return ProductLinkServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public ReachPlanServiceClient createReachPlanServiceClient() {
      try {
        ReachPlanServiceSettings settings =
          ReachPlanServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return ReachPlanServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public RecommendationServiceClient createRecommendationServiceClient() {
      try {
        RecommendationServiceSettings settings =
          RecommendationServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return RecommendationServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public RecommendationSubscriptionServiceClient createRecommendationSubscriptionServiceClient() {
      try {
        RecommendationSubscriptionServiceSettings settings =
          RecommendationSubscriptionServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return RecommendationSubscriptionServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public RemarketingActionServiceClient createRemarketingActionServiceClient() {
      try {
        RemarketingActionServiceSettings settings =
          RemarketingActionServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return RemarketingActionServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public ShareablePreviewServiceClient createShareablePreviewServiceClient() {
      try {
        ShareablePreviewServiceSettings settings =
          ShareablePreviewServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return ShareablePreviewServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public SharedCriterionServiceClient createSharedCriterionServiceClient() {
      try {
        SharedCriterionServiceSettings settings =
          SharedCriterionServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return SharedCriterionServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public SharedSetServiceClient createSharedSetServiceClient() {
      try {
        SharedSetServiceSettings settings =
          SharedSetServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return SharedSetServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public SmartCampaignSettingServiceClient createSmartCampaignSettingServiceClient() {
      try {
        SmartCampaignSettingServiceSettings settings =
          SmartCampaignSettingServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return SmartCampaignSettingServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public SmartCampaignSuggestServiceClient createSmartCampaignSuggestServiceClient() {
      try {
        SmartCampaignSuggestServiceSettings settings =
          SmartCampaignSuggestServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return SmartCampaignSuggestServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public ThirdPartyAppAnalyticsLinkServiceClient createThirdPartyAppAnalyticsLinkServiceClient() {
      try {
        ThirdPartyAppAnalyticsLinkServiceSettings settings =
          ThirdPartyAppAnalyticsLinkServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return ThirdPartyAppAnalyticsLinkServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public TravelAssetSuggestionServiceClient createTravelAssetSuggestionServiceClient() {
      try {
        TravelAssetSuggestionServiceSettings settings =
          TravelAssetSuggestionServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return TravelAssetSuggestionServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public UserDataServiceClient createUserDataServiceClient() {
      try {
        UserDataServiceSettings settings =
          UserDataServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return UserDataServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public UserListCustomerTypeServiceClient createUserListCustomerTypeServiceClient() {
      try {
        UserListCustomerTypeServiceSettings settings =
          UserListCustomerTypeServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return UserListCustomerTypeServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public UserListServiceClient createUserListServiceClient() {
      try {
        UserListServiceSettings settings =
          UserListServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return UserListServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }
  }

  private static class V19Client implements com.google.ads.googleads.v19.services.GoogleAdsVersion {
    private final TransportChannelProvider provider;

    private final Credentials credentials;

    public V19Client(TransportChannelProvider provider, Credentials credentials) {
      this.provider = provider;
      this.credentials = credentials;
    }

    @Override
    public com.google.ads.googleads.v19.services.AccountBudgetProposalServiceClient createAccountBudgetProposalServiceClient(
        ) {
      try {
        com.google.ads.googleads.v19.services.AccountBudgetProposalServiceSettings settings =
          com.google.ads.googleads.v19.services.AccountBudgetProposalServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v19.services.AccountBudgetProposalServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v19.services.AccountLinkServiceClient createAccountLinkServiceClient(
        ) {
      try {
        com.google.ads.googleads.v19.services.AccountLinkServiceSettings settings =
          com.google.ads.googleads.v19.services.AccountLinkServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v19.services.AccountLinkServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v19.services.AdGroupAdLabelServiceClient createAdGroupAdLabelServiceClient(
        ) {
      try {
        com.google.ads.googleads.v19.services.AdGroupAdLabelServiceSettings settings =
          com.google.ads.googleads.v19.services.AdGroupAdLabelServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v19.services.AdGroupAdLabelServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v19.services.AdGroupAdServiceClient createAdGroupAdServiceClient(
        ) {
      try {
        com.google.ads.googleads.v19.services.AdGroupAdServiceSettings settings =
          com.google.ads.googleads.v19.services.AdGroupAdServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v19.services.AdGroupAdServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v19.services.AdGroupAssetServiceClient createAdGroupAssetServiceClient(
        ) {
      try {
        com.google.ads.googleads.v19.services.AdGroupAssetServiceSettings settings =
          com.google.ads.googleads.v19.services.AdGroupAssetServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v19.services.AdGroupAssetServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v19.services.AdGroupAssetSetServiceClient createAdGroupAssetSetServiceClient(
        ) {
      try {
        com.google.ads.googleads.v19.services.AdGroupAssetSetServiceSettings settings =
          com.google.ads.googleads.v19.services.AdGroupAssetSetServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v19.services.AdGroupAssetSetServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v19.services.AdGroupBidModifierServiceClient createAdGroupBidModifierServiceClient(
        ) {
      try {
        com.google.ads.googleads.v19.services.AdGroupBidModifierServiceSettings settings =
          com.google.ads.googleads.v19.services.AdGroupBidModifierServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v19.services.AdGroupBidModifierServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v19.services.AdGroupCriterionCustomizerServiceClient createAdGroupCriterionCustomizerServiceClient(
        ) {
      try {
        com.google.ads.googleads.v19.services.AdGroupCriterionCustomizerServiceSettings settings =
          com.google.ads.googleads.v19.services.AdGroupCriterionCustomizerServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v19.services.AdGroupCriterionCustomizerServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v19.services.AdGroupCriterionLabelServiceClient createAdGroupCriterionLabelServiceClient(
        ) {
      try {
        com.google.ads.googleads.v19.services.AdGroupCriterionLabelServiceSettings settings =
          com.google.ads.googleads.v19.services.AdGroupCriterionLabelServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v19.services.AdGroupCriterionLabelServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v19.services.AdGroupCriterionServiceClient createAdGroupCriterionServiceClient(
        ) {
      try {
        com.google.ads.googleads.v19.services.AdGroupCriterionServiceSettings settings =
          com.google.ads.googleads.v19.services.AdGroupCriterionServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v19.services.AdGroupCriterionServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v19.services.AdGroupCustomizerServiceClient createAdGroupCustomizerServiceClient(
        ) {
      try {
        com.google.ads.googleads.v19.services.AdGroupCustomizerServiceSettings settings =
          com.google.ads.googleads.v19.services.AdGroupCustomizerServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v19.services.AdGroupCustomizerServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v19.services.AdGroupLabelServiceClient createAdGroupLabelServiceClient(
        ) {
      try {
        com.google.ads.googleads.v19.services.AdGroupLabelServiceSettings settings =
          com.google.ads.googleads.v19.services.AdGroupLabelServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v19.services.AdGroupLabelServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v19.services.AdGroupServiceClient createAdGroupServiceClient() {
      try {
        com.google.ads.googleads.v19.services.AdGroupServiceSettings settings =
          com.google.ads.googleads.v19.services.AdGroupServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v19.services.AdGroupServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v19.services.AdParameterServiceClient createAdParameterServiceClient(
        ) {
      try {
        com.google.ads.googleads.v19.services.AdParameterServiceSettings settings =
          com.google.ads.googleads.v19.services.AdParameterServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v19.services.AdParameterServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v19.services.AdServiceClient createAdServiceClient() {
      try {
        com.google.ads.googleads.v19.services.AdServiceSettings settings =
          com.google.ads.googleads.v19.services.AdServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v19.services.AdServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v19.services.AssetGroupAssetServiceClient createAssetGroupAssetServiceClient(
        ) {
      try {
        com.google.ads.googleads.v19.services.AssetGroupAssetServiceSettings settings =
          com.google.ads.googleads.v19.services.AssetGroupAssetServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v19.services.AssetGroupAssetServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v19.services.AssetGroupListingGroupFilterServiceClient createAssetGroupListingGroupFilterServiceClient(
        ) {
      try {
        com.google.ads.googleads.v19.services.AssetGroupListingGroupFilterServiceSettings settings =
          com.google.ads.googleads.v19.services.AssetGroupListingGroupFilterServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v19.services.AssetGroupListingGroupFilterServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v19.services.AssetGroupServiceClient createAssetGroupServiceClient(
        ) {
      try {
        com.google.ads.googleads.v19.services.AssetGroupServiceSettings settings =
          com.google.ads.googleads.v19.services.AssetGroupServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v19.services.AssetGroupServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v19.services.AssetGroupSignalServiceClient createAssetGroupSignalServiceClient(
        ) {
      try {
        com.google.ads.googleads.v19.services.AssetGroupSignalServiceSettings settings =
          com.google.ads.googleads.v19.services.AssetGroupSignalServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v19.services.AssetGroupSignalServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v19.services.AssetServiceClient createAssetServiceClient() {
      try {
        com.google.ads.googleads.v19.services.AssetServiceSettings settings =
          com.google.ads.googleads.v19.services.AssetServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v19.services.AssetServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v19.services.AssetSetAssetServiceClient createAssetSetAssetServiceClient(
        ) {
      try {
        com.google.ads.googleads.v19.services.AssetSetAssetServiceSettings settings =
          com.google.ads.googleads.v19.services.AssetSetAssetServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v19.services.AssetSetAssetServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v19.services.AssetSetServiceClient createAssetSetServiceClient(
        ) {
      try {
        com.google.ads.googleads.v19.services.AssetSetServiceSettings settings =
          com.google.ads.googleads.v19.services.AssetSetServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v19.services.AssetSetServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v19.services.AudienceInsightsServiceClient createAudienceInsightsServiceClient(
        ) {
      try {
        com.google.ads.googleads.v19.services.AudienceInsightsServiceSettings settings =
          com.google.ads.googleads.v19.services.AudienceInsightsServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v19.services.AudienceInsightsServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v19.services.AudienceServiceClient createAudienceServiceClient(
        ) {
      try {
        com.google.ads.googleads.v19.services.AudienceServiceSettings settings =
          com.google.ads.googleads.v19.services.AudienceServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v19.services.AudienceServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v19.services.BatchJobServiceClient createBatchJobServiceClient(
        ) {
      try {
        com.google.ads.googleads.v19.services.BatchJobServiceSettings settings =
          com.google.ads.googleads.v19.services.BatchJobServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v19.services.BatchJobServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v19.services.BiddingDataExclusionServiceClient createBiddingDataExclusionServiceClient(
        ) {
      try {
        com.google.ads.googleads.v19.services.BiddingDataExclusionServiceSettings settings =
          com.google.ads.googleads.v19.services.BiddingDataExclusionServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v19.services.BiddingDataExclusionServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v19.services.BiddingSeasonalityAdjustmentServiceClient createBiddingSeasonalityAdjustmentServiceClient(
        ) {
      try {
        com.google.ads.googleads.v19.services.BiddingSeasonalityAdjustmentServiceSettings settings =
          com.google.ads.googleads.v19.services.BiddingSeasonalityAdjustmentServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v19.services.BiddingSeasonalityAdjustmentServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v19.services.BiddingStrategyServiceClient createBiddingStrategyServiceClient(
        ) {
      try {
        com.google.ads.googleads.v19.services.BiddingStrategyServiceSettings settings =
          com.google.ads.googleads.v19.services.BiddingStrategyServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v19.services.BiddingStrategyServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v19.services.BillingSetupServiceClient createBillingSetupServiceClient(
        ) {
      try {
        com.google.ads.googleads.v19.services.BillingSetupServiceSettings settings =
          com.google.ads.googleads.v19.services.BillingSetupServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v19.services.BillingSetupServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v19.services.BrandSuggestionServiceClient createBrandSuggestionServiceClient(
        ) {
      try {
        com.google.ads.googleads.v19.services.BrandSuggestionServiceSettings settings =
          com.google.ads.googleads.v19.services.BrandSuggestionServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v19.services.BrandSuggestionServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v19.services.CampaignAssetServiceClient createCampaignAssetServiceClient(
        ) {
      try {
        com.google.ads.googleads.v19.services.CampaignAssetServiceSettings settings =
          com.google.ads.googleads.v19.services.CampaignAssetServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v19.services.CampaignAssetServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v19.services.CampaignAssetSetServiceClient createCampaignAssetSetServiceClient(
        ) {
      try {
        com.google.ads.googleads.v19.services.CampaignAssetSetServiceSettings settings =
          com.google.ads.googleads.v19.services.CampaignAssetSetServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v19.services.CampaignAssetSetServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v19.services.CampaignBidModifierServiceClient createCampaignBidModifierServiceClient(
        ) {
      try {
        com.google.ads.googleads.v19.services.CampaignBidModifierServiceSettings settings =
          com.google.ads.googleads.v19.services.CampaignBidModifierServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v19.services.CampaignBidModifierServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v19.services.CampaignBudgetServiceClient createCampaignBudgetServiceClient(
        ) {
      try {
        com.google.ads.googleads.v19.services.CampaignBudgetServiceSettings settings =
          com.google.ads.googleads.v19.services.CampaignBudgetServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v19.services.CampaignBudgetServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v19.services.CampaignConversionGoalServiceClient createCampaignConversionGoalServiceClient(
        ) {
      try {
        com.google.ads.googleads.v19.services.CampaignConversionGoalServiceSettings settings =
          com.google.ads.googleads.v19.services.CampaignConversionGoalServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v19.services.CampaignConversionGoalServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v19.services.CampaignCriterionServiceClient createCampaignCriterionServiceClient(
        ) {
      try {
        com.google.ads.googleads.v19.services.CampaignCriterionServiceSettings settings =
          com.google.ads.googleads.v19.services.CampaignCriterionServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v19.services.CampaignCriterionServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v19.services.CampaignCustomizerServiceClient createCampaignCustomizerServiceClient(
        ) {
      try {
        com.google.ads.googleads.v19.services.CampaignCustomizerServiceSettings settings =
          com.google.ads.googleads.v19.services.CampaignCustomizerServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v19.services.CampaignCustomizerServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v19.services.CampaignDraftServiceClient createCampaignDraftServiceClient(
        ) {
      try {
        com.google.ads.googleads.v19.services.CampaignDraftServiceSettings settings =
          com.google.ads.googleads.v19.services.CampaignDraftServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v19.services.CampaignDraftServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v19.services.CampaignGroupServiceClient createCampaignGroupServiceClient(
        ) {
      try {
        com.google.ads.googleads.v19.services.CampaignGroupServiceSettings settings =
          com.google.ads.googleads.v19.services.CampaignGroupServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v19.services.CampaignGroupServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v19.services.CampaignLabelServiceClient createCampaignLabelServiceClient(
        ) {
      try {
        com.google.ads.googleads.v19.services.CampaignLabelServiceSettings settings =
          com.google.ads.googleads.v19.services.CampaignLabelServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v19.services.CampaignLabelServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v19.services.CampaignLifecycleGoalServiceClient createCampaignLifecycleGoalServiceClient(
        ) {
      try {
        com.google.ads.googleads.v19.services.CampaignLifecycleGoalServiceSettings settings =
          com.google.ads.googleads.v19.services.CampaignLifecycleGoalServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v19.services.CampaignLifecycleGoalServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v19.services.CampaignServiceClient createCampaignServiceClient(
        ) {
      try {
        com.google.ads.googleads.v19.services.CampaignServiceSettings settings =
          com.google.ads.googleads.v19.services.CampaignServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v19.services.CampaignServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v19.services.CampaignSharedSetServiceClient createCampaignSharedSetServiceClient(
        ) {
      try {
        com.google.ads.googleads.v19.services.CampaignSharedSetServiceSettings settings =
          com.google.ads.googleads.v19.services.CampaignSharedSetServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v19.services.CampaignSharedSetServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v19.services.ContentCreatorInsightsServiceClient createContentCreatorInsightsServiceClient(
        ) {
      try {
        com.google.ads.googleads.v19.services.ContentCreatorInsightsServiceSettings settings =
          com.google.ads.googleads.v19.services.ContentCreatorInsightsServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v19.services.ContentCreatorInsightsServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v19.services.ConversionActionServiceClient createConversionActionServiceClient(
        ) {
      try {
        com.google.ads.googleads.v19.services.ConversionActionServiceSettings settings =
          com.google.ads.googleads.v19.services.ConversionActionServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v19.services.ConversionActionServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v19.services.ConversionAdjustmentUploadServiceClient createConversionAdjustmentUploadServiceClient(
        ) {
      try {
        com.google.ads.googleads.v19.services.ConversionAdjustmentUploadServiceSettings settings =
          com.google.ads.googleads.v19.services.ConversionAdjustmentUploadServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v19.services.ConversionAdjustmentUploadServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v19.services.ConversionCustomVariableServiceClient createConversionCustomVariableServiceClient(
        ) {
      try {
        com.google.ads.googleads.v19.services.ConversionCustomVariableServiceSettings settings =
          com.google.ads.googleads.v19.services.ConversionCustomVariableServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v19.services.ConversionCustomVariableServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v19.services.ConversionGoalCampaignConfigServiceClient createConversionGoalCampaignConfigServiceClient(
        ) {
      try {
        com.google.ads.googleads.v19.services.ConversionGoalCampaignConfigServiceSettings settings =
          com.google.ads.googleads.v19.services.ConversionGoalCampaignConfigServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v19.services.ConversionGoalCampaignConfigServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v19.services.ConversionUploadServiceClient createConversionUploadServiceClient(
        ) {
      try {
        com.google.ads.googleads.v19.services.ConversionUploadServiceSettings settings =
          com.google.ads.googleads.v19.services.ConversionUploadServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v19.services.ConversionUploadServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v19.services.ConversionValueRuleServiceClient createConversionValueRuleServiceClient(
        ) {
      try {
        com.google.ads.googleads.v19.services.ConversionValueRuleServiceSettings settings =
          com.google.ads.googleads.v19.services.ConversionValueRuleServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v19.services.ConversionValueRuleServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v19.services.ConversionValueRuleSetServiceClient createConversionValueRuleSetServiceClient(
        ) {
      try {
        com.google.ads.googleads.v19.services.ConversionValueRuleSetServiceSettings settings =
          com.google.ads.googleads.v19.services.ConversionValueRuleSetServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v19.services.ConversionValueRuleSetServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v19.services.CustomAudienceServiceClient createCustomAudienceServiceClient(
        ) {
      try {
        com.google.ads.googleads.v19.services.CustomAudienceServiceSettings settings =
          com.google.ads.googleads.v19.services.CustomAudienceServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v19.services.CustomAudienceServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v19.services.CustomConversionGoalServiceClient createCustomConversionGoalServiceClient(
        ) {
      try {
        com.google.ads.googleads.v19.services.CustomConversionGoalServiceSettings settings =
          com.google.ads.googleads.v19.services.CustomConversionGoalServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v19.services.CustomConversionGoalServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v19.services.CustomInterestServiceClient createCustomInterestServiceClient(
        ) {
      try {
        com.google.ads.googleads.v19.services.CustomInterestServiceSettings settings =
          com.google.ads.googleads.v19.services.CustomInterestServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v19.services.CustomInterestServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v19.services.CustomerAssetServiceClient createCustomerAssetServiceClient(
        ) {
      try {
        com.google.ads.googleads.v19.services.CustomerAssetServiceSettings settings =
          com.google.ads.googleads.v19.services.CustomerAssetServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v19.services.CustomerAssetServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v19.services.CustomerAssetSetServiceClient createCustomerAssetSetServiceClient(
        ) {
      try {
        com.google.ads.googleads.v19.services.CustomerAssetSetServiceSettings settings =
          com.google.ads.googleads.v19.services.CustomerAssetSetServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v19.services.CustomerAssetSetServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v19.services.CustomerClientLinkServiceClient createCustomerClientLinkServiceClient(
        ) {
      try {
        com.google.ads.googleads.v19.services.CustomerClientLinkServiceSettings settings =
          com.google.ads.googleads.v19.services.CustomerClientLinkServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v19.services.CustomerClientLinkServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v19.services.CustomerConversionGoalServiceClient createCustomerConversionGoalServiceClient(
        ) {
      try {
        com.google.ads.googleads.v19.services.CustomerConversionGoalServiceSettings settings =
          com.google.ads.googleads.v19.services.CustomerConversionGoalServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v19.services.CustomerConversionGoalServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v19.services.CustomerCustomizerServiceClient createCustomerCustomizerServiceClient(
        ) {
      try {
        com.google.ads.googleads.v19.services.CustomerCustomizerServiceSettings settings =
          com.google.ads.googleads.v19.services.CustomerCustomizerServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v19.services.CustomerCustomizerServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v19.services.CustomerLabelServiceClient createCustomerLabelServiceClient(
        ) {
      try {
        com.google.ads.googleads.v19.services.CustomerLabelServiceSettings settings =
          com.google.ads.googleads.v19.services.CustomerLabelServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v19.services.CustomerLabelServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v19.services.CustomerLifecycleGoalServiceClient createCustomerLifecycleGoalServiceClient(
        ) {
      try {
        com.google.ads.googleads.v19.services.CustomerLifecycleGoalServiceSettings settings =
          com.google.ads.googleads.v19.services.CustomerLifecycleGoalServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v19.services.CustomerLifecycleGoalServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v19.services.CustomerManagerLinkServiceClient createCustomerManagerLinkServiceClient(
        ) {
      try {
        com.google.ads.googleads.v19.services.CustomerManagerLinkServiceSettings settings =
          com.google.ads.googleads.v19.services.CustomerManagerLinkServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v19.services.CustomerManagerLinkServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v19.services.CustomerNegativeCriterionServiceClient createCustomerNegativeCriterionServiceClient(
        ) {
      try {
        com.google.ads.googleads.v19.services.CustomerNegativeCriterionServiceSettings settings =
          com.google.ads.googleads.v19.services.CustomerNegativeCriterionServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v19.services.CustomerNegativeCriterionServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v19.services.CustomerServiceClient createCustomerServiceClient(
        ) {
      try {
        com.google.ads.googleads.v19.services.CustomerServiceSettings settings =
          com.google.ads.googleads.v19.services.CustomerServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v19.services.CustomerServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v19.services.CustomerSkAdNetworkConversionValueSchemaServiceClient createCustomerSkAdNetworkConversionValueSchemaServiceClient(
        ) {
      try {
        com.google.ads.googleads.v19.services.CustomerSkAdNetworkConversionValueSchemaServiceSettings settings =
          com.google.ads.googleads.v19.services.CustomerSkAdNetworkConversionValueSchemaServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v19.services.CustomerSkAdNetworkConversionValueSchemaServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v19.services.CustomerUserAccessInvitationServiceClient createCustomerUserAccessInvitationServiceClient(
        ) {
      try {
        com.google.ads.googleads.v19.services.CustomerUserAccessInvitationServiceSettings settings =
          com.google.ads.googleads.v19.services.CustomerUserAccessInvitationServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v19.services.CustomerUserAccessInvitationServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v19.services.CustomerUserAccessServiceClient createCustomerUserAccessServiceClient(
        ) {
      try {
        com.google.ads.googleads.v19.services.CustomerUserAccessServiceSettings settings =
          com.google.ads.googleads.v19.services.CustomerUserAccessServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v19.services.CustomerUserAccessServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v19.services.CustomizerAttributeServiceClient createCustomizerAttributeServiceClient(
        ) {
      try {
        com.google.ads.googleads.v19.services.CustomizerAttributeServiceSettings settings =
          com.google.ads.googleads.v19.services.CustomizerAttributeServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v19.services.CustomizerAttributeServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v19.services.DataLinkServiceClient createDataLinkServiceClient(
        ) {
      try {
        com.google.ads.googleads.v19.services.DataLinkServiceSettings settings =
          com.google.ads.googleads.v19.services.DataLinkServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v19.services.DataLinkServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v19.services.ExperimentArmServiceClient createExperimentArmServiceClient(
        ) {
      try {
        com.google.ads.googleads.v19.services.ExperimentArmServiceSettings settings =
          com.google.ads.googleads.v19.services.ExperimentArmServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v19.services.ExperimentArmServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v19.services.ExperimentServiceClient createExperimentServiceClient(
        ) {
      try {
        com.google.ads.googleads.v19.services.ExperimentServiceSettings settings =
          com.google.ads.googleads.v19.services.ExperimentServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v19.services.ExperimentServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v19.services.GeoTargetConstantServiceClient createGeoTargetConstantServiceClient(
        ) {
      try {
        com.google.ads.googleads.v19.services.GeoTargetConstantServiceSettings settings =
          com.google.ads.googleads.v19.services.GeoTargetConstantServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v19.services.GeoTargetConstantServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v19.services.GoogleAdsFieldServiceClient createGoogleAdsFieldServiceClient(
        ) {
      try {
        com.google.ads.googleads.v19.services.GoogleAdsFieldServiceSettings settings =
          com.google.ads.googleads.v19.services.GoogleAdsFieldServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v19.services.GoogleAdsFieldServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v19.services.GoogleAdsServiceClient createGoogleAdsServiceClient(
        ) {
      try {
        com.google.ads.googleads.v19.services.GoogleAdsServiceSettings settings =
          com.google.ads.googleads.v19.services.GoogleAdsServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v19.services.GoogleAdsServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v19.services.IdentityVerificationServiceClient createIdentityVerificationServiceClient(
        ) {
      try {
        com.google.ads.googleads.v19.services.IdentityVerificationServiceSettings settings =
          com.google.ads.googleads.v19.services.IdentityVerificationServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v19.services.IdentityVerificationServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v19.services.InvoiceServiceClient createInvoiceServiceClient() {
      try {
        com.google.ads.googleads.v19.services.InvoiceServiceSettings settings =
          com.google.ads.googleads.v19.services.InvoiceServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v19.services.InvoiceServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v19.services.KeywordPlanAdGroupKeywordServiceClient createKeywordPlanAdGroupKeywordServiceClient(
        ) {
      try {
        com.google.ads.googleads.v19.services.KeywordPlanAdGroupKeywordServiceSettings settings =
          com.google.ads.googleads.v19.services.KeywordPlanAdGroupKeywordServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v19.services.KeywordPlanAdGroupKeywordServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v19.services.KeywordPlanAdGroupServiceClient createKeywordPlanAdGroupServiceClient(
        ) {
      try {
        com.google.ads.googleads.v19.services.KeywordPlanAdGroupServiceSettings settings =
          com.google.ads.googleads.v19.services.KeywordPlanAdGroupServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v19.services.KeywordPlanAdGroupServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v19.services.KeywordPlanCampaignKeywordServiceClient createKeywordPlanCampaignKeywordServiceClient(
        ) {
      try {
        com.google.ads.googleads.v19.services.KeywordPlanCampaignKeywordServiceSettings settings =
          com.google.ads.googleads.v19.services.KeywordPlanCampaignKeywordServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v19.services.KeywordPlanCampaignKeywordServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v19.services.KeywordPlanCampaignServiceClient createKeywordPlanCampaignServiceClient(
        ) {
      try {
        com.google.ads.googleads.v19.services.KeywordPlanCampaignServiceSettings settings =
          com.google.ads.googleads.v19.services.KeywordPlanCampaignServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v19.services.KeywordPlanCampaignServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v19.services.KeywordPlanIdeaServiceClient createKeywordPlanIdeaServiceClient(
        ) {
      try {
        com.google.ads.googleads.v19.services.KeywordPlanIdeaServiceSettings settings =
          com.google.ads.googleads.v19.services.KeywordPlanIdeaServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v19.services.KeywordPlanIdeaServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v19.services.KeywordPlanServiceClient createKeywordPlanServiceClient(
        ) {
      try {
        com.google.ads.googleads.v19.services.KeywordPlanServiceSettings settings =
          com.google.ads.googleads.v19.services.KeywordPlanServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v19.services.KeywordPlanServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v19.services.KeywordThemeConstantServiceClient createKeywordThemeConstantServiceClient(
        ) {
      try {
        com.google.ads.googleads.v19.services.KeywordThemeConstantServiceSettings settings =
          com.google.ads.googleads.v19.services.KeywordThemeConstantServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v19.services.KeywordThemeConstantServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v19.services.LabelServiceClient createLabelServiceClient() {
      try {
        com.google.ads.googleads.v19.services.LabelServiceSettings settings =
          com.google.ads.googleads.v19.services.LabelServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v19.services.LabelServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v19.services.LocalServicesLeadServiceClient createLocalServicesLeadServiceClient(
        ) {
      try {
        com.google.ads.googleads.v19.services.LocalServicesLeadServiceSettings settings =
          com.google.ads.googleads.v19.services.LocalServicesLeadServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v19.services.LocalServicesLeadServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v19.services.OfflineUserDataJobServiceClient createOfflineUserDataJobServiceClient(
        ) {
      try {
        com.google.ads.googleads.v19.services.OfflineUserDataJobServiceSettings settings =
          com.google.ads.googleads.v19.services.OfflineUserDataJobServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v19.services.OfflineUserDataJobServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v19.services.PaymentsAccountServiceClient createPaymentsAccountServiceClient(
        ) {
      try {
        com.google.ads.googleads.v19.services.PaymentsAccountServiceSettings settings =
          com.google.ads.googleads.v19.services.PaymentsAccountServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v19.services.PaymentsAccountServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v19.services.ProductLinkInvitationServiceClient createProductLinkInvitationServiceClient(
        ) {
      try {
        com.google.ads.googleads.v19.services.ProductLinkInvitationServiceSettings settings =
          com.google.ads.googleads.v19.services.ProductLinkInvitationServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v19.services.ProductLinkInvitationServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v19.services.ProductLinkServiceClient createProductLinkServiceClient(
        ) {
      try {
        com.google.ads.googleads.v19.services.ProductLinkServiceSettings settings =
          com.google.ads.googleads.v19.services.ProductLinkServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v19.services.ProductLinkServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v19.services.ReachPlanServiceClient createReachPlanServiceClient(
        ) {
      try {
        com.google.ads.googleads.v19.services.ReachPlanServiceSettings settings =
          com.google.ads.googleads.v19.services.ReachPlanServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v19.services.ReachPlanServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v19.services.RecommendationServiceClient createRecommendationServiceClient(
        ) {
      try {
        com.google.ads.googleads.v19.services.RecommendationServiceSettings settings =
          com.google.ads.googleads.v19.services.RecommendationServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v19.services.RecommendationServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v19.services.RecommendationSubscriptionServiceClient createRecommendationSubscriptionServiceClient(
        ) {
      try {
        com.google.ads.googleads.v19.services.RecommendationSubscriptionServiceSettings settings =
          com.google.ads.googleads.v19.services.RecommendationSubscriptionServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v19.services.RecommendationSubscriptionServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v19.services.RemarketingActionServiceClient createRemarketingActionServiceClient(
        ) {
      try {
        com.google.ads.googleads.v19.services.RemarketingActionServiceSettings settings =
          com.google.ads.googleads.v19.services.RemarketingActionServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v19.services.RemarketingActionServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v19.services.ShareablePreviewServiceClient createShareablePreviewServiceClient(
        ) {
      try {
        com.google.ads.googleads.v19.services.ShareablePreviewServiceSettings settings =
          com.google.ads.googleads.v19.services.ShareablePreviewServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v19.services.ShareablePreviewServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v19.services.SharedCriterionServiceClient createSharedCriterionServiceClient(
        ) {
      try {
        com.google.ads.googleads.v19.services.SharedCriterionServiceSettings settings =
          com.google.ads.googleads.v19.services.SharedCriterionServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v19.services.SharedCriterionServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v19.services.SharedSetServiceClient createSharedSetServiceClient(
        ) {
      try {
        com.google.ads.googleads.v19.services.SharedSetServiceSettings settings =
          com.google.ads.googleads.v19.services.SharedSetServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v19.services.SharedSetServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v19.services.SmartCampaignSettingServiceClient createSmartCampaignSettingServiceClient(
        ) {
      try {
        com.google.ads.googleads.v19.services.SmartCampaignSettingServiceSettings settings =
          com.google.ads.googleads.v19.services.SmartCampaignSettingServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v19.services.SmartCampaignSettingServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v19.services.SmartCampaignSuggestServiceClient createSmartCampaignSuggestServiceClient(
        ) {
      try {
        com.google.ads.googleads.v19.services.SmartCampaignSuggestServiceSettings settings =
          com.google.ads.googleads.v19.services.SmartCampaignSuggestServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v19.services.SmartCampaignSuggestServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v19.services.ThirdPartyAppAnalyticsLinkServiceClient createThirdPartyAppAnalyticsLinkServiceClient(
        ) {
      try {
        com.google.ads.googleads.v19.services.ThirdPartyAppAnalyticsLinkServiceSettings settings =
          com.google.ads.googleads.v19.services.ThirdPartyAppAnalyticsLinkServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v19.services.ThirdPartyAppAnalyticsLinkServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v19.services.TravelAssetSuggestionServiceClient createTravelAssetSuggestionServiceClient(
        ) {
      try {
        com.google.ads.googleads.v19.services.TravelAssetSuggestionServiceSettings settings =
          com.google.ads.googleads.v19.services.TravelAssetSuggestionServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v19.services.TravelAssetSuggestionServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v19.services.UserDataServiceClient createUserDataServiceClient(
        ) {
      try {
        com.google.ads.googleads.v19.services.UserDataServiceSettings settings =
          com.google.ads.googleads.v19.services.UserDataServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v19.services.UserDataServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v19.services.UserListCustomerTypeServiceClient createUserListCustomerTypeServiceClient(
        ) {
      try {
        com.google.ads.googleads.v19.services.UserListCustomerTypeServiceSettings settings =
          com.google.ads.googleads.v19.services.UserListCustomerTypeServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v19.services.UserListCustomerTypeServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v19.services.UserListServiceClient createUserListServiceClient(
        ) {
      try {
        com.google.ads.googleads.v19.services.UserListServiceSettings settings =
          com.google.ads.googleads.v19.services.UserListServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v19.services.UserListServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }
  }

  private static class V20Client implements com.google.ads.googleads.v20.services.GoogleAdsVersion {
    private final TransportChannelProvider provider;

    private final Credentials credentials;

    public V20Client(TransportChannelProvider provider, Credentials credentials) {
      this.provider = provider;
      this.credentials = credentials;
    }

    @Override
    public com.google.ads.googleads.v20.services.AccountBudgetProposalServiceClient createAccountBudgetProposalServiceClient(
        ) {
      try {
        com.google.ads.googleads.v20.services.AccountBudgetProposalServiceSettings settings =
          com.google.ads.googleads.v20.services.AccountBudgetProposalServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v20.services.AccountBudgetProposalServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v20.services.AccountLinkServiceClient createAccountLinkServiceClient(
        ) {
      try {
        com.google.ads.googleads.v20.services.AccountLinkServiceSettings settings =
          com.google.ads.googleads.v20.services.AccountLinkServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v20.services.AccountLinkServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v20.services.AdGroupAdLabelServiceClient createAdGroupAdLabelServiceClient(
        ) {
      try {
        com.google.ads.googleads.v20.services.AdGroupAdLabelServiceSettings settings =
          com.google.ads.googleads.v20.services.AdGroupAdLabelServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v20.services.AdGroupAdLabelServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v20.services.AdGroupAdServiceClient createAdGroupAdServiceClient(
        ) {
      try {
        com.google.ads.googleads.v20.services.AdGroupAdServiceSettings settings =
          com.google.ads.googleads.v20.services.AdGroupAdServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v20.services.AdGroupAdServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v20.services.AdGroupAssetServiceClient createAdGroupAssetServiceClient(
        ) {
      try {
        com.google.ads.googleads.v20.services.AdGroupAssetServiceSettings settings =
          com.google.ads.googleads.v20.services.AdGroupAssetServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v20.services.AdGroupAssetServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v20.services.AdGroupAssetSetServiceClient createAdGroupAssetSetServiceClient(
        ) {
      try {
        com.google.ads.googleads.v20.services.AdGroupAssetSetServiceSettings settings =
          com.google.ads.googleads.v20.services.AdGroupAssetSetServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v20.services.AdGroupAssetSetServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v20.services.AdGroupBidModifierServiceClient createAdGroupBidModifierServiceClient(
        ) {
      try {
        com.google.ads.googleads.v20.services.AdGroupBidModifierServiceSettings settings =
          com.google.ads.googleads.v20.services.AdGroupBidModifierServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v20.services.AdGroupBidModifierServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v20.services.AdGroupCriterionCustomizerServiceClient createAdGroupCriterionCustomizerServiceClient(
        ) {
      try {
        com.google.ads.googleads.v20.services.AdGroupCriterionCustomizerServiceSettings settings =
          com.google.ads.googleads.v20.services.AdGroupCriterionCustomizerServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v20.services.AdGroupCriterionCustomizerServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v20.services.AdGroupCriterionLabelServiceClient createAdGroupCriterionLabelServiceClient(
        ) {
      try {
        com.google.ads.googleads.v20.services.AdGroupCriterionLabelServiceSettings settings =
          com.google.ads.googleads.v20.services.AdGroupCriterionLabelServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v20.services.AdGroupCriterionLabelServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v20.services.AdGroupCriterionServiceClient createAdGroupCriterionServiceClient(
        ) {
      try {
        com.google.ads.googleads.v20.services.AdGroupCriterionServiceSettings settings =
          com.google.ads.googleads.v20.services.AdGroupCriterionServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v20.services.AdGroupCriterionServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v20.services.AdGroupCustomizerServiceClient createAdGroupCustomizerServiceClient(
        ) {
      try {
        com.google.ads.googleads.v20.services.AdGroupCustomizerServiceSettings settings =
          com.google.ads.googleads.v20.services.AdGroupCustomizerServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v20.services.AdGroupCustomizerServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v20.services.AdGroupLabelServiceClient createAdGroupLabelServiceClient(
        ) {
      try {
        com.google.ads.googleads.v20.services.AdGroupLabelServiceSettings settings =
          com.google.ads.googleads.v20.services.AdGroupLabelServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v20.services.AdGroupLabelServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v20.services.AdGroupServiceClient createAdGroupServiceClient() {
      try {
        com.google.ads.googleads.v20.services.AdGroupServiceSettings settings =
          com.google.ads.googleads.v20.services.AdGroupServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v20.services.AdGroupServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v20.services.AdParameterServiceClient createAdParameterServiceClient(
        ) {
      try {
        com.google.ads.googleads.v20.services.AdParameterServiceSettings settings =
          com.google.ads.googleads.v20.services.AdParameterServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v20.services.AdParameterServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v20.services.AdServiceClient createAdServiceClient() {
      try {
        com.google.ads.googleads.v20.services.AdServiceSettings settings =
          com.google.ads.googleads.v20.services.AdServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v20.services.AdServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v20.services.AssetGroupAssetServiceClient createAssetGroupAssetServiceClient(
        ) {
      try {
        com.google.ads.googleads.v20.services.AssetGroupAssetServiceSettings settings =
          com.google.ads.googleads.v20.services.AssetGroupAssetServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v20.services.AssetGroupAssetServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v20.services.AssetGroupListingGroupFilterServiceClient createAssetGroupListingGroupFilterServiceClient(
        ) {
      try {
        com.google.ads.googleads.v20.services.AssetGroupListingGroupFilterServiceSettings settings =
          com.google.ads.googleads.v20.services.AssetGroupListingGroupFilterServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v20.services.AssetGroupListingGroupFilterServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v20.services.AssetGroupServiceClient createAssetGroupServiceClient(
        ) {
      try {
        com.google.ads.googleads.v20.services.AssetGroupServiceSettings settings =
          com.google.ads.googleads.v20.services.AssetGroupServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v20.services.AssetGroupServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v20.services.AssetGroupSignalServiceClient createAssetGroupSignalServiceClient(
        ) {
      try {
        com.google.ads.googleads.v20.services.AssetGroupSignalServiceSettings settings =
          com.google.ads.googleads.v20.services.AssetGroupSignalServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v20.services.AssetGroupSignalServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v20.services.AssetServiceClient createAssetServiceClient() {
      try {
        com.google.ads.googleads.v20.services.AssetServiceSettings settings =
          com.google.ads.googleads.v20.services.AssetServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v20.services.AssetServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v20.services.AssetSetAssetServiceClient createAssetSetAssetServiceClient(
        ) {
      try {
        com.google.ads.googleads.v20.services.AssetSetAssetServiceSettings settings =
          com.google.ads.googleads.v20.services.AssetSetAssetServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v20.services.AssetSetAssetServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v20.services.AssetSetServiceClient createAssetSetServiceClient(
        ) {
      try {
        com.google.ads.googleads.v20.services.AssetSetServiceSettings settings =
          com.google.ads.googleads.v20.services.AssetSetServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v20.services.AssetSetServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v20.services.AudienceInsightsServiceClient createAudienceInsightsServiceClient(
        ) {
      try {
        com.google.ads.googleads.v20.services.AudienceInsightsServiceSettings settings =
          com.google.ads.googleads.v20.services.AudienceInsightsServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v20.services.AudienceInsightsServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v20.services.AudienceServiceClient createAudienceServiceClient(
        ) {
      try {
        com.google.ads.googleads.v20.services.AudienceServiceSettings settings =
          com.google.ads.googleads.v20.services.AudienceServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v20.services.AudienceServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v20.services.BatchJobServiceClient createBatchJobServiceClient(
        ) {
      try {
        com.google.ads.googleads.v20.services.BatchJobServiceSettings settings =
          com.google.ads.googleads.v20.services.BatchJobServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v20.services.BatchJobServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v20.services.BiddingDataExclusionServiceClient createBiddingDataExclusionServiceClient(
        ) {
      try {
        com.google.ads.googleads.v20.services.BiddingDataExclusionServiceSettings settings =
          com.google.ads.googleads.v20.services.BiddingDataExclusionServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v20.services.BiddingDataExclusionServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v20.services.BiddingSeasonalityAdjustmentServiceClient createBiddingSeasonalityAdjustmentServiceClient(
        ) {
      try {
        com.google.ads.googleads.v20.services.BiddingSeasonalityAdjustmentServiceSettings settings =
          com.google.ads.googleads.v20.services.BiddingSeasonalityAdjustmentServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v20.services.BiddingSeasonalityAdjustmentServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v20.services.BiddingStrategyServiceClient createBiddingStrategyServiceClient(
        ) {
      try {
        com.google.ads.googleads.v20.services.BiddingStrategyServiceSettings settings =
          com.google.ads.googleads.v20.services.BiddingStrategyServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v20.services.BiddingStrategyServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v20.services.BillingSetupServiceClient createBillingSetupServiceClient(
        ) {
      try {
        com.google.ads.googleads.v20.services.BillingSetupServiceSettings settings =
          com.google.ads.googleads.v20.services.BillingSetupServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v20.services.BillingSetupServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v20.services.BrandSuggestionServiceClient createBrandSuggestionServiceClient(
        ) {
      try {
        com.google.ads.googleads.v20.services.BrandSuggestionServiceSettings settings =
          com.google.ads.googleads.v20.services.BrandSuggestionServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v20.services.BrandSuggestionServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v20.services.CampaignAssetServiceClient createCampaignAssetServiceClient(
        ) {
      try {
        com.google.ads.googleads.v20.services.CampaignAssetServiceSettings settings =
          com.google.ads.googleads.v20.services.CampaignAssetServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v20.services.CampaignAssetServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v20.services.CampaignAssetSetServiceClient createCampaignAssetSetServiceClient(
        ) {
      try {
        com.google.ads.googleads.v20.services.CampaignAssetSetServiceSettings settings =
          com.google.ads.googleads.v20.services.CampaignAssetSetServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v20.services.CampaignAssetSetServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v20.services.CampaignBidModifierServiceClient createCampaignBidModifierServiceClient(
        ) {
      try {
        com.google.ads.googleads.v20.services.CampaignBidModifierServiceSettings settings =
          com.google.ads.googleads.v20.services.CampaignBidModifierServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v20.services.CampaignBidModifierServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v20.services.CampaignBudgetServiceClient createCampaignBudgetServiceClient(
        ) {
      try {
        com.google.ads.googleads.v20.services.CampaignBudgetServiceSettings settings =
          com.google.ads.googleads.v20.services.CampaignBudgetServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v20.services.CampaignBudgetServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v20.services.CampaignConversionGoalServiceClient createCampaignConversionGoalServiceClient(
        ) {
      try {
        com.google.ads.googleads.v20.services.CampaignConversionGoalServiceSettings settings =
          com.google.ads.googleads.v20.services.CampaignConversionGoalServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v20.services.CampaignConversionGoalServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v20.services.CampaignCriterionServiceClient createCampaignCriterionServiceClient(
        ) {
      try {
        com.google.ads.googleads.v20.services.CampaignCriterionServiceSettings settings =
          com.google.ads.googleads.v20.services.CampaignCriterionServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v20.services.CampaignCriterionServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v20.services.CampaignCustomizerServiceClient createCampaignCustomizerServiceClient(
        ) {
      try {
        com.google.ads.googleads.v20.services.CampaignCustomizerServiceSettings settings =
          com.google.ads.googleads.v20.services.CampaignCustomizerServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v20.services.CampaignCustomizerServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v20.services.CampaignDraftServiceClient createCampaignDraftServiceClient(
        ) {
      try {
        com.google.ads.googleads.v20.services.CampaignDraftServiceSettings settings =
          com.google.ads.googleads.v20.services.CampaignDraftServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v20.services.CampaignDraftServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v20.services.CampaignGroupServiceClient createCampaignGroupServiceClient(
        ) {
      try {
        com.google.ads.googleads.v20.services.CampaignGroupServiceSettings settings =
          com.google.ads.googleads.v20.services.CampaignGroupServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v20.services.CampaignGroupServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v20.services.CampaignLabelServiceClient createCampaignLabelServiceClient(
        ) {
      try {
        com.google.ads.googleads.v20.services.CampaignLabelServiceSettings settings =
          com.google.ads.googleads.v20.services.CampaignLabelServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v20.services.CampaignLabelServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v20.services.CampaignLifecycleGoalServiceClient createCampaignLifecycleGoalServiceClient(
        ) {
      try {
        com.google.ads.googleads.v20.services.CampaignLifecycleGoalServiceSettings settings =
          com.google.ads.googleads.v20.services.CampaignLifecycleGoalServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v20.services.CampaignLifecycleGoalServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v20.services.CampaignServiceClient createCampaignServiceClient(
        ) {
      try {
        com.google.ads.googleads.v20.services.CampaignServiceSettings settings =
          com.google.ads.googleads.v20.services.CampaignServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v20.services.CampaignServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v20.services.CampaignSharedSetServiceClient createCampaignSharedSetServiceClient(
        ) {
      try {
        com.google.ads.googleads.v20.services.CampaignSharedSetServiceSettings settings =
          com.google.ads.googleads.v20.services.CampaignSharedSetServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v20.services.CampaignSharedSetServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v20.services.ContentCreatorInsightsServiceClient createContentCreatorInsightsServiceClient(
        ) {
      try {
        com.google.ads.googleads.v20.services.ContentCreatorInsightsServiceSettings settings =
          com.google.ads.googleads.v20.services.ContentCreatorInsightsServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v20.services.ContentCreatorInsightsServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v20.services.ConversionActionServiceClient createConversionActionServiceClient(
        ) {
      try {
        com.google.ads.googleads.v20.services.ConversionActionServiceSettings settings =
          com.google.ads.googleads.v20.services.ConversionActionServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v20.services.ConversionActionServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v20.services.ConversionAdjustmentUploadServiceClient createConversionAdjustmentUploadServiceClient(
        ) {
      try {
        com.google.ads.googleads.v20.services.ConversionAdjustmentUploadServiceSettings settings =
          com.google.ads.googleads.v20.services.ConversionAdjustmentUploadServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v20.services.ConversionAdjustmentUploadServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v20.services.ConversionCustomVariableServiceClient createConversionCustomVariableServiceClient(
        ) {
      try {
        com.google.ads.googleads.v20.services.ConversionCustomVariableServiceSettings settings =
          com.google.ads.googleads.v20.services.ConversionCustomVariableServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v20.services.ConversionCustomVariableServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v20.services.ConversionGoalCampaignConfigServiceClient createConversionGoalCampaignConfigServiceClient(
        ) {
      try {
        com.google.ads.googleads.v20.services.ConversionGoalCampaignConfigServiceSettings settings =
          com.google.ads.googleads.v20.services.ConversionGoalCampaignConfigServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v20.services.ConversionGoalCampaignConfigServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v20.services.ConversionUploadServiceClient createConversionUploadServiceClient(
        ) {
      try {
        com.google.ads.googleads.v20.services.ConversionUploadServiceSettings settings =
          com.google.ads.googleads.v20.services.ConversionUploadServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v20.services.ConversionUploadServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v20.services.ConversionValueRuleServiceClient createConversionValueRuleServiceClient(
        ) {
      try {
        com.google.ads.googleads.v20.services.ConversionValueRuleServiceSettings settings =
          com.google.ads.googleads.v20.services.ConversionValueRuleServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v20.services.ConversionValueRuleServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v20.services.ConversionValueRuleSetServiceClient createConversionValueRuleSetServiceClient(
        ) {
      try {
        com.google.ads.googleads.v20.services.ConversionValueRuleSetServiceSettings settings =
          com.google.ads.googleads.v20.services.ConversionValueRuleSetServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v20.services.ConversionValueRuleSetServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v20.services.CustomAudienceServiceClient createCustomAudienceServiceClient(
        ) {
      try {
        com.google.ads.googleads.v20.services.CustomAudienceServiceSettings settings =
          com.google.ads.googleads.v20.services.CustomAudienceServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v20.services.CustomAudienceServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v20.services.CustomConversionGoalServiceClient createCustomConversionGoalServiceClient(
        ) {
      try {
        com.google.ads.googleads.v20.services.CustomConversionGoalServiceSettings settings =
          com.google.ads.googleads.v20.services.CustomConversionGoalServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v20.services.CustomConversionGoalServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v20.services.CustomInterestServiceClient createCustomInterestServiceClient(
        ) {
      try {
        com.google.ads.googleads.v20.services.CustomInterestServiceSettings settings =
          com.google.ads.googleads.v20.services.CustomInterestServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v20.services.CustomInterestServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v20.services.CustomerAssetServiceClient createCustomerAssetServiceClient(
        ) {
      try {
        com.google.ads.googleads.v20.services.CustomerAssetServiceSettings settings =
          com.google.ads.googleads.v20.services.CustomerAssetServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v20.services.CustomerAssetServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v20.services.CustomerAssetSetServiceClient createCustomerAssetSetServiceClient(
        ) {
      try {
        com.google.ads.googleads.v20.services.CustomerAssetSetServiceSettings settings =
          com.google.ads.googleads.v20.services.CustomerAssetSetServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v20.services.CustomerAssetSetServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v20.services.CustomerClientLinkServiceClient createCustomerClientLinkServiceClient(
        ) {
      try {
        com.google.ads.googleads.v20.services.CustomerClientLinkServiceSettings settings =
          com.google.ads.googleads.v20.services.CustomerClientLinkServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v20.services.CustomerClientLinkServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v20.services.CustomerConversionGoalServiceClient createCustomerConversionGoalServiceClient(
        ) {
      try {
        com.google.ads.googleads.v20.services.CustomerConversionGoalServiceSettings settings =
          com.google.ads.googleads.v20.services.CustomerConversionGoalServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v20.services.CustomerConversionGoalServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v20.services.CustomerCustomizerServiceClient createCustomerCustomizerServiceClient(
        ) {
      try {
        com.google.ads.googleads.v20.services.CustomerCustomizerServiceSettings settings =
          com.google.ads.googleads.v20.services.CustomerCustomizerServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v20.services.CustomerCustomizerServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v20.services.CustomerLabelServiceClient createCustomerLabelServiceClient(
        ) {
      try {
        com.google.ads.googleads.v20.services.CustomerLabelServiceSettings settings =
          com.google.ads.googleads.v20.services.CustomerLabelServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v20.services.CustomerLabelServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v20.services.CustomerLifecycleGoalServiceClient createCustomerLifecycleGoalServiceClient(
        ) {
      try {
        com.google.ads.googleads.v20.services.CustomerLifecycleGoalServiceSettings settings =
          com.google.ads.googleads.v20.services.CustomerLifecycleGoalServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v20.services.CustomerLifecycleGoalServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v20.services.CustomerManagerLinkServiceClient createCustomerManagerLinkServiceClient(
        ) {
      try {
        com.google.ads.googleads.v20.services.CustomerManagerLinkServiceSettings settings =
          com.google.ads.googleads.v20.services.CustomerManagerLinkServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v20.services.CustomerManagerLinkServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v20.services.CustomerNegativeCriterionServiceClient createCustomerNegativeCriterionServiceClient(
        ) {
      try {
        com.google.ads.googleads.v20.services.CustomerNegativeCriterionServiceSettings settings =
          com.google.ads.googleads.v20.services.CustomerNegativeCriterionServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v20.services.CustomerNegativeCriterionServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v20.services.CustomerServiceClient createCustomerServiceClient(
        ) {
      try {
        com.google.ads.googleads.v20.services.CustomerServiceSettings settings =
          com.google.ads.googleads.v20.services.CustomerServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v20.services.CustomerServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v20.services.CustomerSkAdNetworkConversionValueSchemaServiceClient createCustomerSkAdNetworkConversionValueSchemaServiceClient(
        ) {
      try {
        com.google.ads.googleads.v20.services.CustomerSkAdNetworkConversionValueSchemaServiceSettings settings =
          com.google.ads.googleads.v20.services.CustomerSkAdNetworkConversionValueSchemaServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v20.services.CustomerSkAdNetworkConversionValueSchemaServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v20.services.CustomerUserAccessInvitationServiceClient createCustomerUserAccessInvitationServiceClient(
        ) {
      try {
        com.google.ads.googleads.v20.services.CustomerUserAccessInvitationServiceSettings settings =
          com.google.ads.googleads.v20.services.CustomerUserAccessInvitationServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v20.services.CustomerUserAccessInvitationServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v20.services.CustomerUserAccessServiceClient createCustomerUserAccessServiceClient(
        ) {
      try {
        com.google.ads.googleads.v20.services.CustomerUserAccessServiceSettings settings =
          com.google.ads.googleads.v20.services.CustomerUserAccessServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v20.services.CustomerUserAccessServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v20.services.CustomizerAttributeServiceClient createCustomizerAttributeServiceClient(
        ) {
      try {
        com.google.ads.googleads.v20.services.CustomizerAttributeServiceSettings settings =
          com.google.ads.googleads.v20.services.CustomizerAttributeServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v20.services.CustomizerAttributeServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v20.services.DataLinkServiceClient createDataLinkServiceClient(
        ) {
      try {
        com.google.ads.googleads.v20.services.DataLinkServiceSettings settings =
          com.google.ads.googleads.v20.services.DataLinkServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v20.services.DataLinkServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v20.services.ExperimentArmServiceClient createExperimentArmServiceClient(
        ) {
      try {
        com.google.ads.googleads.v20.services.ExperimentArmServiceSettings settings =
          com.google.ads.googleads.v20.services.ExperimentArmServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v20.services.ExperimentArmServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v20.services.ExperimentServiceClient createExperimentServiceClient(
        ) {
      try {
        com.google.ads.googleads.v20.services.ExperimentServiceSettings settings =
          com.google.ads.googleads.v20.services.ExperimentServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v20.services.ExperimentServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v20.services.GeoTargetConstantServiceClient createGeoTargetConstantServiceClient(
        ) {
      try {
        com.google.ads.googleads.v20.services.GeoTargetConstantServiceSettings settings =
          com.google.ads.googleads.v20.services.GeoTargetConstantServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v20.services.GeoTargetConstantServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v20.services.GoogleAdsFieldServiceClient createGoogleAdsFieldServiceClient(
        ) {
      try {
        com.google.ads.googleads.v20.services.GoogleAdsFieldServiceSettings settings =
          com.google.ads.googleads.v20.services.GoogleAdsFieldServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v20.services.GoogleAdsFieldServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v20.services.GoogleAdsServiceClient createGoogleAdsServiceClient(
        ) {
      try {
        com.google.ads.googleads.v20.services.GoogleAdsServiceSettings settings =
          com.google.ads.googleads.v20.services.GoogleAdsServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v20.services.GoogleAdsServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v20.services.IdentityVerificationServiceClient createIdentityVerificationServiceClient(
        ) {
      try {
        com.google.ads.googleads.v20.services.IdentityVerificationServiceSettings settings =
          com.google.ads.googleads.v20.services.IdentityVerificationServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v20.services.IdentityVerificationServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v20.services.InvoiceServiceClient createInvoiceServiceClient() {
      try {
        com.google.ads.googleads.v20.services.InvoiceServiceSettings settings =
          com.google.ads.googleads.v20.services.InvoiceServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v20.services.InvoiceServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v20.services.KeywordPlanAdGroupKeywordServiceClient createKeywordPlanAdGroupKeywordServiceClient(
        ) {
      try {
        com.google.ads.googleads.v20.services.KeywordPlanAdGroupKeywordServiceSettings settings =
          com.google.ads.googleads.v20.services.KeywordPlanAdGroupKeywordServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v20.services.KeywordPlanAdGroupKeywordServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v20.services.KeywordPlanAdGroupServiceClient createKeywordPlanAdGroupServiceClient(
        ) {
      try {
        com.google.ads.googleads.v20.services.KeywordPlanAdGroupServiceSettings settings =
          com.google.ads.googleads.v20.services.KeywordPlanAdGroupServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v20.services.KeywordPlanAdGroupServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v20.services.KeywordPlanCampaignKeywordServiceClient createKeywordPlanCampaignKeywordServiceClient(
        ) {
      try {
        com.google.ads.googleads.v20.services.KeywordPlanCampaignKeywordServiceSettings settings =
          com.google.ads.googleads.v20.services.KeywordPlanCampaignKeywordServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v20.services.KeywordPlanCampaignKeywordServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v20.services.KeywordPlanCampaignServiceClient createKeywordPlanCampaignServiceClient(
        ) {
      try {
        com.google.ads.googleads.v20.services.KeywordPlanCampaignServiceSettings settings =
          com.google.ads.googleads.v20.services.KeywordPlanCampaignServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v20.services.KeywordPlanCampaignServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v20.services.KeywordPlanIdeaServiceClient createKeywordPlanIdeaServiceClient(
        ) {
      try {
        com.google.ads.googleads.v20.services.KeywordPlanIdeaServiceSettings settings =
          com.google.ads.googleads.v20.services.KeywordPlanIdeaServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v20.services.KeywordPlanIdeaServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v20.services.KeywordPlanServiceClient createKeywordPlanServiceClient(
        ) {
      try {
        com.google.ads.googleads.v20.services.KeywordPlanServiceSettings settings =
          com.google.ads.googleads.v20.services.KeywordPlanServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v20.services.KeywordPlanServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v20.services.KeywordThemeConstantServiceClient createKeywordThemeConstantServiceClient(
        ) {
      try {
        com.google.ads.googleads.v20.services.KeywordThemeConstantServiceSettings settings =
          com.google.ads.googleads.v20.services.KeywordThemeConstantServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v20.services.KeywordThemeConstantServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v20.services.LabelServiceClient createLabelServiceClient() {
      try {
        com.google.ads.googleads.v20.services.LabelServiceSettings settings =
          com.google.ads.googleads.v20.services.LabelServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v20.services.LabelServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v20.services.LocalServicesLeadServiceClient createLocalServicesLeadServiceClient(
        ) {
      try {
        com.google.ads.googleads.v20.services.LocalServicesLeadServiceSettings settings =
          com.google.ads.googleads.v20.services.LocalServicesLeadServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v20.services.LocalServicesLeadServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v20.services.OfflineUserDataJobServiceClient createOfflineUserDataJobServiceClient(
        ) {
      try {
        com.google.ads.googleads.v20.services.OfflineUserDataJobServiceSettings settings =
          com.google.ads.googleads.v20.services.OfflineUserDataJobServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v20.services.OfflineUserDataJobServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v20.services.PaymentsAccountServiceClient createPaymentsAccountServiceClient(
        ) {
      try {
        com.google.ads.googleads.v20.services.PaymentsAccountServiceSettings settings =
          com.google.ads.googleads.v20.services.PaymentsAccountServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v20.services.PaymentsAccountServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v20.services.ProductLinkInvitationServiceClient createProductLinkInvitationServiceClient(
        ) {
      try {
        com.google.ads.googleads.v20.services.ProductLinkInvitationServiceSettings settings =
          com.google.ads.googleads.v20.services.ProductLinkInvitationServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v20.services.ProductLinkInvitationServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v20.services.ProductLinkServiceClient createProductLinkServiceClient(
        ) {
      try {
        com.google.ads.googleads.v20.services.ProductLinkServiceSettings settings =
          com.google.ads.googleads.v20.services.ProductLinkServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v20.services.ProductLinkServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v20.services.ReachPlanServiceClient createReachPlanServiceClient(
        ) {
      try {
        com.google.ads.googleads.v20.services.ReachPlanServiceSettings settings =
          com.google.ads.googleads.v20.services.ReachPlanServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v20.services.ReachPlanServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v20.services.RecommendationServiceClient createRecommendationServiceClient(
        ) {
      try {
        com.google.ads.googleads.v20.services.RecommendationServiceSettings settings =
          com.google.ads.googleads.v20.services.RecommendationServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v20.services.RecommendationServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v20.services.RecommendationSubscriptionServiceClient createRecommendationSubscriptionServiceClient(
        ) {
      try {
        com.google.ads.googleads.v20.services.RecommendationSubscriptionServiceSettings settings =
          com.google.ads.googleads.v20.services.RecommendationSubscriptionServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v20.services.RecommendationSubscriptionServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v20.services.RemarketingActionServiceClient createRemarketingActionServiceClient(
        ) {
      try {
        com.google.ads.googleads.v20.services.RemarketingActionServiceSettings settings =
          com.google.ads.googleads.v20.services.RemarketingActionServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v20.services.RemarketingActionServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v20.services.ShareablePreviewServiceClient createShareablePreviewServiceClient(
        ) {
      try {
        com.google.ads.googleads.v20.services.ShareablePreviewServiceSettings settings =
          com.google.ads.googleads.v20.services.ShareablePreviewServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v20.services.ShareablePreviewServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v20.services.SharedCriterionServiceClient createSharedCriterionServiceClient(
        ) {
      try {
        com.google.ads.googleads.v20.services.SharedCriterionServiceSettings settings =
          com.google.ads.googleads.v20.services.SharedCriterionServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v20.services.SharedCriterionServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v20.services.SharedSetServiceClient createSharedSetServiceClient(
        ) {
      try {
        com.google.ads.googleads.v20.services.SharedSetServiceSettings settings =
          com.google.ads.googleads.v20.services.SharedSetServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v20.services.SharedSetServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v20.services.SmartCampaignSettingServiceClient createSmartCampaignSettingServiceClient(
        ) {
      try {
        com.google.ads.googleads.v20.services.SmartCampaignSettingServiceSettings settings =
          com.google.ads.googleads.v20.services.SmartCampaignSettingServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v20.services.SmartCampaignSettingServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v20.services.SmartCampaignSuggestServiceClient createSmartCampaignSuggestServiceClient(
        ) {
      try {
        com.google.ads.googleads.v20.services.SmartCampaignSuggestServiceSettings settings =
          com.google.ads.googleads.v20.services.SmartCampaignSuggestServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v20.services.SmartCampaignSuggestServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v20.services.ThirdPartyAppAnalyticsLinkServiceClient createThirdPartyAppAnalyticsLinkServiceClient(
        ) {
      try {
        com.google.ads.googleads.v20.services.ThirdPartyAppAnalyticsLinkServiceSettings settings =
          com.google.ads.googleads.v20.services.ThirdPartyAppAnalyticsLinkServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v20.services.ThirdPartyAppAnalyticsLinkServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v20.services.TravelAssetSuggestionServiceClient createTravelAssetSuggestionServiceClient(
        ) {
      try {
        com.google.ads.googleads.v20.services.TravelAssetSuggestionServiceSettings settings =
          com.google.ads.googleads.v20.services.TravelAssetSuggestionServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v20.services.TravelAssetSuggestionServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v20.services.UserDataServiceClient createUserDataServiceClient(
        ) {
      try {
        com.google.ads.googleads.v20.services.UserDataServiceSettings settings =
          com.google.ads.googleads.v20.services.UserDataServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v20.services.UserDataServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v20.services.UserListCustomerTypeServiceClient createUserListCustomerTypeServiceClient(
        ) {
      try {
        com.google.ads.googleads.v20.services.UserListCustomerTypeServiceSettings settings =
          com.google.ads.googleads.v20.services.UserListCustomerTypeServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v20.services.UserListCustomerTypeServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v20.services.UserListServiceClient createUserListServiceClient(
        ) {
      try {
        com.google.ads.googleads.v20.services.UserListServiceSettings settings =
          com.google.ads.googleads.v20.services.UserListServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v20.services.UserListServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }
  }
}
