// Copyright 2020 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
package com.google.ads.googleads.lib.catalog;

import com.google.ads.googleads.v18.errors.GoogleAdsException;
import com.google.ads.googleads.v18.services.GoogleAdsVersion;
import com.google.common.collect.ImmutableSet;
import javax.annotation.Generated;

@Generated("GoogleAdsCatalogAnnotationProcessor")
public class VersionFactory {
  protected static ImmutableSet<Version> getVersions() throws IllegalAccessException,
      InstantiationException {
    ImmutableSet.Builder<Version> builder = ImmutableSet.builder();
    builder.add(new Version(
          "v18",
          new GoogleAdsException.Factory(),
          GoogleAdsVersion.class));
    builder.add(new Version(
          "v19",
          new com.google.ads.googleads.v19.errors.GoogleAdsException.Factory(),
          com.google.ads.googleads.v19.services.GoogleAdsVersion.class));
    builder.add(new Version(
          "v20",
          new com.google.ads.googleads.v20.errors.GoogleAdsException.Factory(),
          com.google.ads.googleads.v20.services.GoogleAdsVersion.class));
    return builder.build();
  }
}
