/*
 * Decompiled with CFR 0.152.
 */
package com.google.ads.googleads.lib;

import com.google.ads.googleads.lib.$AutoValue_GoogleAdsHeaderProvider;
import com.google.ads.googleads.v20.services.stub.GoogleAdsServiceStubSettings;
import com.google.api.gax.core.GaxProperties;
import com.google.api.gax.grpc.GaxGrpcProperties;
import com.google.api.gax.rpc.ApiClientHeaderProvider;
import com.google.api.gax.rpc.HeaderProvider;
import com.google.auto.value.AutoValue;
import com.google.auto.value.extension.memoized.Memoized;
import com.google.common.base.Joiner;
import com.google.common.collect.ImmutableMap;
import com.google.protobuf.Message;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Properties;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@AutoValue
public abstract class GoogleAdsHeaderProvider
implements HeaderProvider {
    private static final Logger logger = LoggerFactory.getLogger(GoogleAdsHeaderProvider.class);

    public static Builder newBuilder() {
        return new $AutoValue_GoogleAdsHeaderProvider.Builder();
    }

    @Nullable
    public abstract String getDeveloperToken();

    @Nullable
    public abstract Long getLoginCustomerId();

    @Nullable
    public abstract Long getLinkedCustomerId();

    @Memoized
    public ImmutableMap<String, String> getHeaders() {
        HashMap<String, String> headers = new HashMap<String, String>();
        if (this.getDeveloperToken() != null) {
            headers.put("developer-token", this.getDeveloperToken());
        }
        if (this.getLoginCustomerId() != null) {
            headers.put("login-customer-id", String.valueOf(this.getLoginCustomerId()));
        }
        if (this.getLinkedCustomerId() != null) {
            headers.put("linked-customer-id", String.valueOf(this.getLinkedCustomerId()));
        }
        ApiClientHeaderProvider apiClient = ApiClientHeaderProvider.newBuilder().setGeneratedLibToken("gapic", GaxProperties.getLibraryVersion(GoogleAdsServiceStubSettings.class)).setTransportToken(GaxGrpcProperties.getGrpcTokenName(), GaxGrpcProperties.getGrpcVersion()).setClientLibToken("gccl", GoogleAdsHeaderProvider.getLibraryVersion()).build();
        headers.putAll(apiClient.getHeaders());
        String protobufVersion = GoogleAdsHeaderProvider.getProtobufVersion();
        if (protobufVersion != null) {
            String apiClientHeader = (String)headers.get(ApiClientHeaderProvider.getDefaultApiClientHeaderKey());
            apiClientHeader = Joiner.on((char)' ').skipNulls().join((Object)apiClientHeader, (Object)String.format("pb/%s", protobufVersion), new Object[0]);
            headers.put(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), apiClientHeader);
        }
        return ImmutableMap.copyOf(headers);
    }

    private static String getLibraryVersion() {
        String implementationVersion = GoogleAdsHeaderProvider.class.getPackage().getImplementationVersion();
        return implementationVersion == null ? "0.0.0" : implementationVersion;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static String getProtobufVersion() {
        String protobufImplVersion = Message.class.getPackage().getImplementationVersion();
        if (protobufImplVersion != null) {
            return protobufImplVersion;
        }
        try (InputStream in = Message.class.getResourceAsStream("/META-INF/maven/com.google.protobuf/protobuf-java/pom.properties");){
            if (in == null) return null;
            Properties props = new Properties();
            props.load(in);
            String string = props.getProperty("version");
            return string;
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return null;
    }

    @AutoValue.Builder
    public static abstract class Builder {
        public abstract Builder setDeveloperToken(String var1);

        public abstract Builder setLoginCustomerId(Long var1);

        public abstract Builder setLinkedCustomerId(Long var1);

        public abstract GoogleAdsHeaderProvider build();
    }
}

