/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.client.googleapis.auth.oauth2;

import com.google.api.client.auth.oauth2.AuthorizationCodeRequestUrl;
import com.google.api.client.googleapis.auth.oauth2.GoogleClientSecrets;
import com.google.api.client.util.Key;
import com.google.common.base.Preconditions;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GoogleAuthorizationCodeRequestUrl
extends AuthorizationCodeRequestUrl {
    @Key(value="approval_prompt")
    private String approvalPrompt;
    @Key(value="access_type")
    private String accessType;

    public GoogleAuthorizationCodeRequestUrl(String clientId, String redirectUri, Iterable<String> scopes) {
        super("https://accounts.google.com/o/oauth2/auth", clientId);
        this.setRedirectUri(redirectUri);
        this.setScopes((Iterable)scopes);
    }

    public GoogleAuthorizationCodeRequestUrl(GoogleClientSecrets clientSecrets, String redirectUri, Iterable<String> scopes) {
        this(clientSecrets.getDetails().getClientId(), redirectUri, scopes);
    }

    public final String getApprovalPrompt() {
        return this.approvalPrompt;
    }

    public GoogleAuthorizationCodeRequestUrl setApprovalPrompt(String approvalPrompt) {
        this.approvalPrompt = approvalPrompt;
        return this;
    }

    public final String getAccessType() {
        return this.accessType;
    }

    public GoogleAuthorizationCodeRequestUrl setAccessType(String accessType) {
        this.accessType = accessType;
        return this;
    }

    public GoogleAuthorizationCodeRequestUrl setResponseTypes(String ... responseTypes) {
        return (GoogleAuthorizationCodeRequestUrl)super.setResponseTypes(responseTypes);
    }

    public GoogleAuthorizationCodeRequestUrl setResponseTypes(Iterable<String> responseTypes) {
        return (GoogleAuthorizationCodeRequestUrl)super.setResponseTypes(responseTypes);
    }

    public GoogleAuthorizationCodeRequestUrl setRedirectUri(String redirectUri) {
        Preconditions.checkNotNull((Object)redirectUri);
        return (GoogleAuthorizationCodeRequestUrl)super.setRedirectUri(redirectUri);
    }

    public GoogleAuthorizationCodeRequestUrl setScopes(String ... scopes) {
        Preconditions.checkArgument((scopes.length != 0 ? 1 : 0) != 0);
        return (GoogleAuthorizationCodeRequestUrl)super.setScopes(scopes);
    }

    public GoogleAuthorizationCodeRequestUrl setScopes(Iterable<String> scopes) {
        Preconditions.checkArgument((boolean)scopes.iterator().hasNext());
        return (GoogleAuthorizationCodeRequestUrl)super.setScopes(scopes);
    }

    public GoogleAuthorizationCodeRequestUrl setClientId(String clientId) {
        return (GoogleAuthorizationCodeRequestUrl)super.setClientId(clientId);
    }

    public GoogleAuthorizationCodeRequestUrl setState(String state) {
        return (GoogleAuthorizationCodeRequestUrl)super.setState(state);
    }
}

