/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.client.googleapis.auth.clientlogin;

import com.google.api.client.googleapis.GoogleHeaders;
import com.google.api.client.googleapis.auth.clientlogin.AuthKeyValueParser;
import com.google.api.client.googleapis.auth.clientlogin.ClientLoginResponseException;
import com.google.api.client.http.GenericUrl;
import com.google.api.client.http.HttpContent;
import com.google.api.client.http.HttpExecuteInterceptor;
import com.google.api.client.http.HttpRequest;
import com.google.api.client.http.HttpRequestInitializer;
import com.google.api.client.http.HttpResponse;
import com.google.api.client.http.HttpResponseException;
import com.google.api.client.http.HttpTransport;
import com.google.api.client.http.UrlEncodedContent;
import com.google.api.client.util.Key;
import com.google.api.client.util.ObjectParser;
import com.google.api.client.util.StringUtils;
import com.google.common.base.Strings;
import java.io.IOException;

public final class ClientLogin {
    public HttpTransport transport;
    public GenericUrl serverUrl = new GenericUrl("https://www.google.com");
    @Key(value="source")
    public String applicationName;
    @Key(value="service")
    public String authTokenType;
    @Key(value="Email")
    public String username;
    @Key(value="Passwd")
    public String password;
    @Key
    public String accountType;
    @Key(value="logintoken")
    public String captchaToken;
    @Key(value="logincaptcha")
    public String captchaAnswer;

    public Response authenticate() throws IOException {
        GenericUrl url = this.serverUrl.clone();
        url.appendRawPath("/accounts/ClientLogin");
        HttpRequest request = this.transport.createRequestFactory().buildPostRequest(url, (HttpContent)new UrlEncodedContent((Object)this));
        request.setParser((ObjectParser)AuthKeyValueParser.INSTANCE);
        request.setContentLoggingLimit(0);
        request.setThrowExceptionOnExecuteError(false);
        HttpResponse response = request.execute();
        if (response.isSuccessStatusCode()) {
            return (Response)response.parseAs(Response.class);
        }
        ErrorInfo details = (ErrorInfo)response.parseAs(ErrorInfo.class);
        String detailString = details.toString();
        StringBuilder message = HttpResponseException.computeMessageBuffer((HttpResponse)response);
        if (!Strings.isNullOrEmpty((String)detailString)) {
            message.append(StringUtils.LINE_SEPARATOR).append(detailString);
        }
        throw new ClientLoginResponseException(response, details, message.toString());
    }

    public static final class ErrorInfo {
        @Key(value="Error")
        public String error;
        @Key(value="Url")
        public String url;
        @Key(value="CaptchaToken")
        public String captchaToken;
        @Key(value="CaptchaUrl")
        public String captchaUrl;
    }

    public static final class Response
    implements HttpExecuteInterceptor,
    HttpRequestInitializer {
        @Key(value="Auth")
        public String auth;

        public String getAuthorizationHeaderValue() {
            return GoogleHeaders.getGoogleLoginValue(this.auth);
        }

        public void initialize(HttpRequest request) {
            request.setInterceptor((HttpExecuteInterceptor)this);
        }

        public void intercept(HttpRequest request) {
            request.getHeaders().setAuthorization(this.getAuthorizationHeaderValue());
        }
    }
}

