/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.client.googleapis.auth.oauth2;

import com.google.api.client.auth.oauth2.BearerToken;
import com.google.api.client.auth.oauth2.ClientParametersAuthentication;
import com.google.api.client.auth.oauth2.Credential;
import com.google.api.client.auth.oauth2.CredentialRefreshListener;
import com.google.api.client.auth.oauth2.TokenRequest;
import com.google.api.client.auth.oauth2.TokenResponse;
import com.google.api.client.googleapis.auth.oauth2.GoogleClientSecrets;
import com.google.api.client.http.GenericUrl;
import com.google.api.client.http.HttpExecuteInterceptor;
import com.google.api.client.http.HttpRequestInitializer;
import com.google.api.client.http.HttpTransport;
import com.google.api.client.json.JsonFactory;
import com.google.api.client.json.webtoken.JsonWebSignature;
import com.google.api.client.json.webtoken.JsonWebToken;
import com.google.api.client.util.Beta;
import com.google.api.client.util.Clock;
import com.google.api.client.util.Joiner;
import com.google.api.client.util.PemReader;
import com.google.api.client.util.Preconditions;
import com.google.api.client.util.SecurityUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.security.PrivateKey;
import java.security.spec.PKCS8EncodedKeySpec;
import java.util.Collection;
import java.util.Collections;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GoogleCredential
extends Credential {
    private String serviceAccountId;
    private Collection<String> serviceAccountScopes;
    private PrivateKey serviceAccountPrivateKey;
    private String serviceAccountUser;

    public GoogleCredential() {
        this(new Builder());
    }

    protected GoogleCredential(Builder builder) {
        super((Credential.Builder)builder);
        if (builder.serviceAccountPrivateKey == null) {
            Preconditions.checkArgument((builder.serviceAccountId == null && builder.serviceAccountScopes == null && builder.serviceAccountUser == null ? 1 : 0) != 0);
        } else {
            this.serviceAccountId = (String)Preconditions.checkNotNull((Object)builder.serviceAccountId);
            this.serviceAccountScopes = Collections.unmodifiableCollection(builder.serviceAccountScopes);
            this.serviceAccountPrivateKey = builder.serviceAccountPrivateKey;
            this.serviceAccountUser = builder.serviceAccountUser;
        }
    }

    public GoogleCredential setAccessToken(String accessToken) {
        return (GoogleCredential)super.setAccessToken(accessToken);
    }

    public GoogleCredential setRefreshToken(String refreshToken) {
        if (refreshToken != null) {
            Preconditions.checkArgument((this.getJsonFactory() != null && this.getTransport() != null && this.getClientAuthentication() != null ? 1 : 0) != 0, (Object)"Please use the Builder and call setJsonFactory, setTransport and setClientSecrets");
        }
        return (GoogleCredential)super.setRefreshToken(refreshToken);
    }

    public GoogleCredential setExpirationTimeMilliseconds(Long expirationTimeMilliseconds) {
        return (GoogleCredential)super.setExpirationTimeMilliseconds(expirationTimeMilliseconds);
    }

    public GoogleCredential setExpiresInSeconds(Long expiresIn) {
        return (GoogleCredential)super.setExpiresInSeconds(expiresIn);
    }

    public GoogleCredential setFromTokenResponse(TokenResponse tokenResponse) {
        return (GoogleCredential)super.setFromTokenResponse(tokenResponse);
    }

    @Beta
    protected TokenResponse executeRefreshToken() throws IOException {
        if (this.serviceAccountPrivateKey == null) {
            return super.executeRefreshToken();
        }
        JsonWebSignature.Header header = new JsonWebSignature.Header();
        header.setAlgorithm("RS256");
        header.setType("JWT");
        JsonWebToken.Payload payload = new JsonWebToken.Payload();
        long currentTime = this.getClock().currentTimeMillis();
        payload.setIssuer(this.serviceAccountId);
        payload.setAudience((Object)this.getTokenServerEncodedUrl());
        payload.setIssuedAtTimeSeconds(Long.valueOf(currentTime / 1000L));
        payload.setExpirationTimeSeconds(Long.valueOf(currentTime / 1000L + 3600L));
        payload.setSubject(this.serviceAccountUser);
        payload.put("scope", (Object)Joiner.on((char)' ').join(this.serviceAccountScopes));
        try {
            String assertion = JsonWebSignature.signUsingRsaSha256((PrivateKey)this.serviceAccountPrivateKey, (JsonFactory)this.getJsonFactory(), (JsonWebSignature.Header)header, (JsonWebToken.Payload)payload);
            TokenRequest request = new TokenRequest(this.getTransport(), this.getJsonFactory(), new GenericUrl(this.getTokenServerEncodedUrl()), "urn:ietf:params:oauth:grant-type:jwt-bearer");
            request.put("assertion", (Object)assertion);
            return request.execute();
        }
        catch (GeneralSecurityException exception) {
            IOException e = new IOException();
            e.initCause(exception);
            throw e;
        }
    }

    @Beta
    public final String getServiceAccountId() {
        return this.serviceAccountId;
    }

    @Beta
    public final Collection<String> getServiceAccountScopes() {
        return this.serviceAccountScopes;
    }

    @Beta
    public final String getServiceAccountScopesAsString() {
        return this.serviceAccountScopes == null ? null : Joiner.on((char)' ').join(this.serviceAccountScopes);
    }

    @Beta
    public final PrivateKey getServiceAccountPrivateKey() {
        return this.serviceAccountPrivateKey;
    }

    @Beta
    public final String getServiceAccountUser() {
        return this.serviceAccountUser;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Builder
    extends Credential.Builder {
        String serviceAccountId;
        Collection<String> serviceAccountScopes;
        PrivateKey serviceAccountPrivateKey;
        String serviceAccountUser;

        public Builder() {
            super(BearerToken.authorizationHeaderAccessMethod());
            this.setTokenServerEncodedUrl("https://accounts.google.com/o/oauth2/token");
        }

        public GoogleCredential build() {
            return new GoogleCredential(this);
        }

        public Builder setTransport(HttpTransport transport) {
            return (Builder)super.setTransport(transport);
        }

        public Builder setJsonFactory(JsonFactory jsonFactory) {
            return (Builder)super.setJsonFactory(jsonFactory);
        }

        public Builder setClock(Clock clock) {
            return (Builder)super.setClock(clock);
        }

        public Builder setClientSecrets(String clientId, String clientSecret) {
            this.setClientAuthentication((HttpExecuteInterceptor)new ClientParametersAuthentication(clientId, clientSecret));
            return this;
        }

        public Builder setClientSecrets(GoogleClientSecrets clientSecrets) {
            GoogleClientSecrets.Details details = clientSecrets.getDetails();
            this.setClientAuthentication((HttpExecuteInterceptor)new ClientParametersAuthentication(details.getClientId(), details.getClientSecret()));
            return this;
        }

        @Beta
        public final String getServiceAccountId() {
            return this.serviceAccountId;
        }

        @Beta
        public Builder setServiceAccountId(String serviceAccountId) {
            this.serviceAccountId = serviceAccountId;
            return this;
        }

        @Beta
        public final Collection<String> getServiceAccountScopes() {
            return this.serviceAccountScopes;
        }

        @Beta
        public Builder setServiceAccountScopes(Collection<String> serviceAccountScopes) {
            this.serviceAccountScopes = serviceAccountScopes;
            return this;
        }

        @Beta
        public final PrivateKey getServiceAccountPrivateKey() {
            return this.serviceAccountPrivateKey;
        }

        @Beta
        public Builder setServiceAccountPrivateKey(PrivateKey serviceAccountPrivateKey) {
            this.serviceAccountPrivateKey = serviceAccountPrivateKey;
            return this;
        }

        @Beta
        public Builder setServiceAccountPrivateKeyFromP12File(File p12File) throws GeneralSecurityException, IOException {
            this.serviceAccountPrivateKey = SecurityUtils.loadPrivateKeyFromKeyStore((KeyStore)SecurityUtils.getPkcs12KeyStore(), (InputStream)new FileInputStream(p12File), (String)"notasecret", (String)"privatekey", (String)"notasecret");
            return this;
        }

        @Beta
        public Builder setServiceAccountPrivateKeyFromPemFile(File pemFile) throws GeneralSecurityException, IOException {
            byte[] bytes = PemReader.readFirstSectionAndClose((Reader)new FileReader(pemFile), (String)"PRIVATE KEY").getBase64DecodedBytes();
            this.serviceAccountPrivateKey = SecurityUtils.getRsaKeyFactory().generatePrivate(new PKCS8EncodedKeySpec(bytes));
            return this;
        }

        @Beta
        public final String getServiceAccountUser() {
            return this.serviceAccountUser;
        }

        @Beta
        public Builder setServiceAccountUser(String serviceAccountUser) {
            this.serviceAccountUser = serviceAccountUser;
            return this;
        }

        public Builder setRequestInitializer(HttpRequestInitializer requestInitializer) {
            return (Builder)super.setRequestInitializer(requestInitializer);
        }

        public Builder addRefreshListener(CredentialRefreshListener refreshListener) {
            return (Builder)super.addRefreshListener(refreshListener);
        }

        public Builder setRefreshListeners(Collection<CredentialRefreshListener> refreshListeners) {
            return (Builder)super.setRefreshListeners(refreshListeners);
        }

        public Builder setTokenServerUrl(GenericUrl tokenServerUrl) {
            return (Builder)super.setTokenServerUrl(tokenServerUrl);
        }

        public Builder setTokenServerEncodedUrl(String tokenServerEncodedUrl) {
            return (Builder)super.setTokenServerEncodedUrl(tokenServerEncodedUrl);
        }

        public Builder setClientAuthentication(HttpExecuteInterceptor clientAuthentication) {
            return (Builder)super.setClientAuthentication(clientAuthentication);
        }
    }
}

