/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.client.googleapis.auth.oauth2;

import com.google.api.client.auth.jsontoken.JsonWebSignature;
import com.google.api.client.googleapis.auth.oauth2.GoogleIdToken;
import com.google.api.client.http.GenericUrl;
import com.google.api.client.http.HttpResponse;
import com.google.api.client.http.HttpTransport;
import com.google.api.client.http.json.JsonHttpParser;
import com.google.api.client.json.JsonFactory;
import com.google.api.client.json.JsonParser;
import com.google.api.client.json.JsonToken;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.security.PublicKey;
import java.security.Signature;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.codec.binary.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class GoogleIdTokenVerifier {
    private static final Pattern MAX_AGE_PATTERN = Pattern.compile("\\s*max-age\\s*=\\s*(\\d+)\\s*");
    private final JsonFactory jsonFactory;
    private List<PublicKey> publicKeys;
    private long expirationTimeMilliseconds;
    private final String clientId;
    private final HttpTransport transport;
    private final Lock lock = new ReentrantLock();

    public GoogleIdTokenVerifier(HttpTransport transport, JsonFactory jsonFactory, String clientId) {
        this.transport = transport;
        this.jsonFactory = jsonFactory;
        this.clientId = clientId;
    }

    public JsonFactory getJsonFactory() {
        return this.jsonFactory;
    }

    public String getClientId() {
        return this.clientId;
    }

    public List<PublicKey> getPublicKeys() {
        return Collections.unmodifiableList(this.publicKeys);
    }

    public long getExpirationTimeMilliseconds() {
        return this.expirationTimeMilliseconds;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean verify(GoogleIdToken idToken) throws GeneralSecurityException, IOException {
        GoogleIdToken.Payload payload = idToken.getPayload();
        if (!(payload.isValidTime(300L) && "accounts.google.com".equals(payload.getIssuer()) && this.clientId.equals(payload.getAudience()) && this.clientId.equals(payload.getIssuee()))) {
            return false;
        }
        JsonWebSignature.Header header = idToken.getHeader();
        String algorithm = header.getAlgorithm();
        if (algorithm.equals("RS256")) {
            this.lock.lock();
            try {
                if (this.publicKeys == null || System.currentTimeMillis() + 300000L > this.expirationTimeMilliseconds) {
                    this.loadPublicCerts();
                }
                Signature signer = Signature.getInstance("SHA256withRSA");
                for (PublicKey publicKey : this.publicKeys) {
                    signer.initVerify(publicKey);
                    signer.update(idToken.getSignedContentBytes());
                    if (!signer.verify(idToken.getSignatureBytes())) continue;
                    boolean bl = true;
                    return bl;
                }
            }
            finally {
                this.lock.unlock();
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public GoogleIdTokenVerifier loadPublicCerts() throws GeneralSecurityException, IOException {
        this.lock.lock();
        try {
            this.publicKeys = new ArrayList<PublicKey>();
            CertificateFactory factory = CertificateFactory.getInstance("X509");
            HttpResponse certsResponse = this.transport.createRequestFactory().buildGetRequest(new GenericUrl("https://www.googleapis.com/oauth2/v1/certs")).execute();
            for (String arg : certsResponse.getHeaders().getCacheControl().split(",")) {
                Matcher m = MAX_AGE_PATTERN.matcher(arg);
                if (!m.matches()) continue;
                this.expirationTimeMilliseconds = System.currentTimeMillis() + Long.valueOf(m.group(1)) * 1000L;
                break;
            }
            JsonParser parser = JsonHttpParser.parserForResponse((JsonFactory)this.jsonFactory, (HttpResponse)certsResponse);
            try {
                while (parser.nextToken() != JsonToken.END_OBJECT) {
                    parser.nextToken();
                    String certValue = parser.getText();
                    X509Certificate x509Cert = (X509Certificate)factory.generateCertificate(new ByteArrayInputStream(StringUtils.getBytesUtf8((String)certValue)));
                    this.publicKeys.add(x509Cert.getPublicKey());
                }
            }
            finally {
                parser.close();
            }
            GoogleIdTokenVerifier googleIdTokenVerifier = this;
            return googleIdTokenVerifier;
        }
        finally {
            this.lock.unlock();
        }
    }
}

