/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.client.googleapis.mtls;

import com.google.api.client.googleapis.mtls.MtlsProvider;
import com.google.api.client.http.HttpTransport;
import com.google.api.client.util.SecurityUtils;
import java.io.IOException;
import java.io.InputStream;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import org.junit.Assert;
import org.junit.Test;

public abstract class MtlsTransportBaseTest {
    protected KeyStore createTestMtlsKeyStore() throws IOException, GeneralSecurityException {
        InputStream certAndKey = this.getClass().getClassLoader().getResourceAsStream("com/google/api/client/googleapis/util/mtlsCertAndKey.pem");
        return SecurityUtils.createMtlsKeyStore((InputStream)certAndKey);
    }

    protected abstract HttpTransport buildTrustedTransport(MtlsProvider var1) throws IOException, GeneralSecurityException;

    @Test
    public void testNotUseCertificate() throws IOException, GeneralSecurityException {
        TestMtlsProvider mtlsProvider = new TestMtlsProvider(false, this.createTestMtlsKeyStore(), "", false);
        HttpTransport transport = this.buildTrustedTransport(mtlsProvider);
        Assert.assertFalse((boolean)transport.isMtls());
    }

    @Test
    public void testUseProvidedCertificate() throws IOException, GeneralSecurityException {
        TestMtlsProvider mtlsProvider = new TestMtlsProvider(true, this.createTestMtlsKeyStore(), "", false);
        HttpTransport transport = this.buildTrustedTransport(mtlsProvider);
        Assert.assertTrue((boolean)transport.isMtls());
    }

    @Test
    public void testNoCertificate() throws IOException, GeneralSecurityException {
        TestMtlsProvider mtlsProvider = new TestMtlsProvider(true, null, "", false);
        HttpTransport transport = this.buildTrustedTransport(mtlsProvider);
        Assert.assertFalse((boolean)transport.isMtls());
    }

    @Test
    public void testGetKeyStoreThrows() throws GeneralSecurityException {
        TestMtlsProvider mtlsProvider = new TestMtlsProvider(true, null, "", true);
        try {
            this.buildTrustedTransport(mtlsProvider);
            Assert.fail((String)"should throw and exception");
        }
        catch (IOException e) {
            Assert.assertTrue((String)"expected to fail with exception", (boolean)e.getMessage().contains("getKeyStore throws exception"));
        }
    }

    public static class TestMtlsProvider
    implements MtlsProvider {
        private final boolean useClientCertificate;
        private final KeyStore keyStore;
        private final String keyStorePassword;
        private final boolean throwExceptionForGetKeyStore;

        public TestMtlsProvider(boolean useClientCertificate, KeyStore keystore, String keyStorePassword, boolean throwExceptionForGetKeyStore) {
            this.useClientCertificate = useClientCertificate;
            this.keyStore = keystore;
            this.keyStorePassword = keyStorePassword;
            this.throwExceptionForGetKeyStore = throwExceptionForGetKeyStore;
        }

        public boolean useMtlsClientCertificate() {
            return this.useClientCertificate;
        }

        public String getKeyStorePassword() {
            return this.keyStorePassword;
        }

        public KeyStore getKeyStore() throws IOException, GeneralSecurityException {
            if (this.throwExceptionForGetKeyStore) {
                throw new IOException("getKeyStore throws exception");
            }
            return this.keyStore;
        }
    }
}

