/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.client.googleapis.services.json;

import com.google.api.client.googleapis.json.GoogleJsonError;
import com.google.api.client.googleapis.json.GoogleJsonResponseException;
import com.google.api.client.googleapis.services.json.AbstractGoogleJsonClient;
import com.google.api.client.googleapis.testing.services.json.MockGoogleJsonClient;
import com.google.api.client.googleapis.testing.services.json.MockGoogleJsonClientRequest;
import com.google.api.client.http.HttpTransport;
import com.google.api.client.http.LowLevelHttpRequest;
import com.google.api.client.http.LowLevelHttpResponse;
import com.google.api.client.json.JsonFactory;
import com.google.api.client.json.gson.GsonFactory;
import com.google.api.client.testing.http.MockHttpTransport;
import com.google.api.client.testing.http.MockLowLevelHttpRequest;
import com.google.api.client.testing.http.MockLowLevelHttpResponse;
import junit.framework.TestCase;

public class AbstractGoogleJsonClientTest
extends TestCase {
    public void testExecuteUnparsed_error() throws Exception {
        MockHttpTransport transport = new MockHttpTransport(){

            public LowLevelHttpRequest buildRequest(String name, String url) {
                return new MockLowLevelHttpRequest(){

                    public LowLevelHttpResponse execute() {
                        MockLowLevelHttpResponse result = new MockLowLevelHttpResponse();
                        result.setStatusCode(401);
                        result.setContentType("application/json; charset=UTF-8");
                        result.setContent("{\"error\":{\"code\":401,\"errors\":[{\"domain\":\"global\",\"location\":\"Authorization\",\"locationType\":\"header\",\"message\":\"me\",\"reason\":\"authError\"}],\"message\":\"me\"}}");
                        return result;
                    }
                };
            }
        };
        GsonFactory jsonFactory = new GsonFactory();
        MockGoogleJsonClient client = new MockGoogleJsonClient.Builder((HttpTransport)transport, (JsonFactory)jsonFactory, "http://google.com/", "", null, false).setApplicationName("Test Application").build();
        MockGoogleJsonClientRequest request = new MockGoogleJsonClientRequest((AbstractGoogleJsonClient)client, "GET", "foo", null, String.class);
        try {
            request.executeUnparsed();
            AbstractGoogleJsonClientTest.fail((String)("expected " + GoogleJsonResponseException.class));
        }
        catch (GoogleJsonResponseException e) {
            GoogleJsonError details = e.getDetails();
            AbstractGoogleJsonClientTest.assertEquals((String)"me", (String)details.getMessage());
            AbstractGoogleJsonClientTest.assertEquals((String)"me", (String)((GoogleJsonError.ErrorInfo)details.getErrors().get(0)).getMessage());
        }
    }
}

