/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.client.googleapis.auth.oauth2;

import com.google.api.client.googleapis.auth.oauth2.CloudShellCredential;
import com.google.api.client.googleapis.auth.oauth2.DefaultCredentialProvider;
import com.google.api.client.googleapis.auth.oauth2.GoogleCredential;
import com.google.api.client.googleapis.auth.oauth2.GoogleCredentialTest;
import com.google.api.client.googleapis.testing.auth.oauth2.MockTokenServerTransport;
import com.google.api.client.googleapis.testing.compute.MockMetadataServerTransport;
import com.google.api.client.http.HttpTransport;
import com.google.api.client.http.LowLevelHttpRequest;
import com.google.api.client.http.LowLevelHttpResponse;
import com.google.api.client.json.GenericJson;
import com.google.api.client.json.JsonFactory;
import com.google.api.client.json.gson.GsonFactory;
import com.google.api.client.testing.http.MockHttpTransport;
import com.google.api.client.testing.http.MockLowLevelHttpRequest;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import junit.framework.TestCase;

public class DefaultCredentialProviderTest
extends TestCase {
    private static final JsonFactory JSON_FACTORY = new GsonFactory();
    private static final Collection<String> SCOPES = Collections.unmodifiableCollection(Arrays.asList("scope1", "scope2"));
    private static final String SA_KEY_ID = "key_id";
    private static final String SA_KEY_TEXT = "-----BEGIN PRIVATE KEY-----\nMIICdgIBADANBgkqhkiG9w0BAQEFAASCAmAwggJcAgEAAoGBALX0PQoe1igW12ikv1bN/r9lN749y2ijmbc/mFHPyS3hNTyOCjDvBbXYbDhQJzWVUikh4mvGBA07qTj79Xc3yBDfKP2IeyYQIFe0t0zkd7R9Zdn98Y2rIQC47aAbDfubtkU1U72t4zL11kHvoa0/RuFZjncvlr42X7be7lYh4p3NAgMBAAECgYASk5wDw4Az2ZkmeuN6Fk/y9H+Lcb2pskJIXjrL533vrDWGOC48LrsThMQPv8cxBky8HFSEklPpkfTF95tpD43iVwJRB/GrCtGTw65IfJ4/tI09h6zGc4yqvIo1cHX/LQ+SxKLGyir/dQM925rGt/VojxY5ryJR7GLbCzxPnJm/oQJBANwOCO6D2hy1LQYJhXh7O+RLtA/tSnT1xyMQsGT+uUCMiKS2bSKx2wxo9k7h3OegNJIu1q6nZ6AbxDK8H3+d0dUCQQDTrPSXagBxzp8PecbaCHjzNRSQE2in81qYnrAFNB4o3DpHyMMY6s5ALLeHKscEWnqP8Ur6X4PvzZecCWU9BKAZAkAutLPknAuxSCsUOvUfS1i87ex77Ot+w6POp34pEX+UWb+u5iFn2cQacDTHLV1LtE80L8jVLSbrbrlH43H0DjU5AkEAgidhycxS86dxpEljnOMCw8CKoUBd5I880IUahEiUltk7OLJYS/Ts1wbn3kPOVX3wyJs8WBDtBkFrDHW2ezth2QJADj3e1YhMVdjJW5jqwlD/VNddGjgzyunmiZg0uOXsHXbytYmsA545S8KRQFaJKFXYYFo2kOjqOiC1T2cAzMDjCQ==\n-----END PRIVATE KEY-----\n";
    private static final String ACCESS_TOKEN = "1/MkSJoj1xsli0AccessToken_NKPY2";
    private static final String GAE_SIGNAL_CLASS = "com.google.appengine.api.utils.SystemProperty";
    private static final Lock lock = new ReentrantLock();
    private static File tempDirectory = null;

    public void testDefaultCredentialAppEngineDeployed() throws IOException {
        MockHttpTransport transport = new MockHttpTransport();
        TestDefaultCredentialProvider testProvider = new TestDefaultCredentialProvider();
        testProvider.addType("com.google.api.client.googleapis.extensions.appengine.auth.oauth2.AppIdentityCredential$AppEngineCredentialWrapper", MockAppEngineCredential.class);
        testProvider.addType(GAE_SIGNAL_CLASS, MockAppEngineSystemProperty.class);
        GoogleCredential defaultCredential = testProvider.getDefaultCredential((HttpTransport)transport, JSON_FACTORY);
        DefaultCredentialProviderTest.assertNotNull((Object)defaultCredential);
        DefaultCredentialProviderTest.assertTrue((boolean)(defaultCredential instanceof MockAppEngineCredential));
        DefaultCredentialProviderTest.assertSame((Object)transport, (Object)defaultCredential.getTransport());
        DefaultCredentialProviderTest.assertSame((Object)JSON_FACTORY, (Object)defaultCredential.getJsonFactory());
    }

    public void testDefaultCredentialAppEngineComponentOffAppEngineGivesNotFoundError() {
        MockHttpTransport transport = new MockHttpTransport();
        TestDefaultCredentialProvider testProvider = new TestDefaultCredentialProvider();
        testProvider.addType("com.google.api.client.googleapis.extensions.appengine.auth.oauth2.AppIdentityCredential$AppEngineCredentialWrapper", MockAppEngineCredential.class);
        testProvider.addType(GAE_SIGNAL_CLASS, MockOffAppEngineSystemProperty.class);
        try {
            testProvider.getDefaultCredential((HttpTransport)transport, JSON_FACTORY);
            DefaultCredentialProviderTest.fail((String)"No credential expected when not on App Engine.");
        }
        catch (IOException e) {
            String message = e.getMessage();
            DefaultCredentialProviderTest.assertTrue((boolean)message.contains("https://developers.google.com/accounts/docs/application-default-credentials"));
        }
    }

    public void testDefaultCredentialAppEngineWithoutDependencyThrowsHelpfulLoadError() {
        MockHttpTransport transport = new MockHttpTransport();
        TestDefaultCredentialProvider testProvider = new TestDefaultCredentialProvider();
        testProvider.addType(GAE_SIGNAL_CLASS, MockAppEngineSystemProperty.class);
        try {
            testProvider.getDefaultCredential((HttpTransport)transport, JSON_FACTORY);
            DefaultCredentialProviderTest.fail((String)"Credential expected to fail to load if credential class not present.");
        }
        catch (IOException e) {
            String message = e.getMessage();
            DefaultCredentialProviderTest.assertFalse((boolean)message.contains("https://developers.google.com/accounts/docs/application-default-credentials"));
            DefaultCredentialProviderTest.assertTrue((boolean)message.contains("com.google.api.client.googleapis.extensions.appengine.auth.oauth2.AppIdentityCredential$AppEngineCredentialWrapper"));
        }
    }

    public void testDefaultCredentialCaches() throws IOException {
        MockHttpTransport transport = new MockHttpTransport();
        TestDefaultCredentialProvider testProvider = new TestDefaultCredentialProvider();
        testProvider.addType("com.google.api.client.googleapis.extensions.appengine.auth.oauth2.AppIdentityCredential$AppEngineCredentialWrapper", MockAppEngineCredential.class);
        testProvider.addType(GAE_SIGNAL_CLASS, MockAppEngineSystemProperty.class);
        GoogleCredential firstCall = testProvider.getDefaultCredential((HttpTransport)transport, JSON_FACTORY);
        DefaultCredentialProviderTest.assertNotNull((Object)firstCall);
        GoogleCredential secondCall = testProvider.getDefaultCredential((HttpTransport)transport, JSON_FACTORY);
        DefaultCredentialProviderTest.assertSame((Object)firstCall, (Object)secondCall);
    }

    public void testGetDefaultCredentials_cloudshell() throws IOException {
        MockHttpTransport transport = new MockHttpTransport();
        TestDefaultCredentialProvider testProvider = new TestDefaultCredentialProvider();
        testProvider.setEnv("DEVSHELL_CLIENT_PORT", "4");
        GoogleCredential defaultCredential = testProvider.getDefaultCredential((HttpTransport)transport, JSON_FACTORY);
        DefaultCredentialProviderTest.assertTrue((boolean)(defaultCredential instanceof CloudShellCredential));
        DefaultCredentialProviderTest.assertEquals((int)((CloudShellCredential)defaultCredential).getAuthPort(), (int)4);
    }

    public void testGetDefaultCredentials_cloudshell_withComputCredentialsPresent() throws IOException {
        MockMetadataServerTransport transport = new MockMetadataServerTransport(ACCESS_TOKEN);
        TestDefaultCredentialProvider testProvider = new TestDefaultCredentialProvider();
        testProvider.setEnv("DEVSHELL_CLIENT_PORT", "4");
        GoogleCredential defaultCredential = testProvider.getDefaultCredential((HttpTransport)transport, JSON_FACTORY);
        DefaultCredentialProviderTest.assertTrue((boolean)(defaultCredential instanceof CloudShellCredential));
        DefaultCredentialProviderTest.assertEquals((int)((CloudShellCredential)defaultCredential).getAuthPort(), (int)4);
    }

    public void testDefaultCredentialCompute() throws IOException {
        MockMetadataServerTransport transport = new MockMetadataServerTransport(ACCESS_TOKEN);
        TestDefaultCredentialProvider testProvider = new TestDefaultCredentialProvider();
        GoogleCredential defaultCredential = testProvider.getDefaultCredential((HttpTransport)transport, JSON_FACTORY);
        DefaultCredentialProviderTest.assertNotNull((Object)defaultCredential);
        DefaultCredentialProviderTest.assertTrue((boolean)defaultCredential.refreshToken());
        DefaultCredentialProviderTest.assertEquals((String)ACCESS_TOKEN, (String)defaultCredential.getAccessToken());
    }

    public void testDefaultCredentialComputeErrorNotFound() throws IOException {
        MockMetadataServerTransport transport = new MockMetadataServerTransport(ACCESS_TOKEN);
        transport.setTokenRequestStatusCode(Integer.valueOf(404));
        TestDefaultCredentialProvider testProvider = new TestDefaultCredentialProvider();
        GoogleCredential defaultCredential = testProvider.getDefaultCredential((HttpTransport)transport, JSON_FACTORY);
        DefaultCredentialProviderTest.assertNotNull((Object)defaultCredential);
        try {
            defaultCredential.refreshToken();
            DefaultCredentialProviderTest.fail((String)"Expected error refreshing token.");
        }
        catch (IOException expected) {
            String message = expected.getMessage();
            DefaultCredentialProviderTest.assertTrue((boolean)message.contains(Integer.toString(404)));
            DefaultCredentialProviderTest.assertTrue((boolean)message.contains("scope"));
        }
    }

    public void testDefaultCredentialComputeErrorUnexpected() throws IOException {
        MockMetadataServerTransport transport = new MockMetadataServerTransport(ACCESS_TOKEN);
        transport.setTokenRequestStatusCode(Integer.valueOf(500));
        TestDefaultCredentialProvider testProvider = new TestDefaultCredentialProvider();
        GoogleCredential defaultCredential = testProvider.getDefaultCredential((HttpTransport)transport, JSON_FACTORY);
        DefaultCredentialProviderTest.assertNotNull((Object)defaultCredential);
        try {
            defaultCredential.refreshToken();
            DefaultCredentialProviderTest.fail((String)"Expected error refreshing token.");
        }
        catch (IOException expected) {
            String message = expected.getMessage();
            DefaultCredentialProviderTest.assertTrue((boolean)message.contains(Integer.toString(500)));
            DefaultCredentialProviderTest.assertTrue((boolean)message.contains("Unexpected"));
        }
    }

    public void testDefaultCredentialComputeCachesFailureAfterFixedNumberOfRetries() {
        MockRequestUrlRecordingTransport transport = new MockRequestUrlRecordingTransport();
        TestDefaultCredentialProvider testProvider = new TestDefaultCredentialProvider();
        try {
            testProvider.getDefaultCredential((HttpTransport)transport, JSON_FACTORY);
            DefaultCredentialProviderTest.fail((String)"No credential expected for default test provider.");
        }
        catch (IOException iOException) {
            // empty catch block
        }
        DefaultCredentialProviderTest.assertEquals((int)3, (int)transport.getRequestCount());
        try {
            testProvider.getDefaultCredential((HttpTransport)transport, JSON_FACTORY);
            DefaultCredentialProviderTest.fail((String)"No credential expected for default test provider.");
        }
        catch (IOException iOException) {
            // empty catch block
        }
        DefaultCredentialProviderTest.assertEquals((int)3, (int)transport.getRequestCount());
    }

    public void testDefaultCredentialNoGceCheck() throws IOException {
        MockRequestUrlRecordingTransport transport = new MockRequestUrlRecordingTransport();
        TestDefaultCredentialProvider testProvider = new TestDefaultCredentialProvider();
        testProvider.setEnv("NO_GCE_CHECK", "True");
        try {
            testProvider.getDefaultCredential((HttpTransport)transport, JSON_FACTORY);
            DefaultCredentialProviderTest.fail((String)"No credential expected for default test provider.");
        }
        catch (IOException iOException) {
            // empty catch block
        }
        DefaultCredentialProviderTest.assertEquals((int)0, (int)transport.getRequestCount());
    }

    public void testDefaultCredentialWithCustomMetadataServerAddress() throws IOException {
        MockRequestUrlRecordingTransport transport = new MockRequestUrlRecordingTransport();
        TestDefaultCredentialProvider testProvider = new TestDefaultCredentialProvider();
        testProvider.setEnv("GCE_METADATA_HOST", "test.metadata.server.address");
        try {
            testProvider.getDefaultCredential((HttpTransport)transport, JSON_FACTORY);
            DefaultCredentialProviderTest.fail((String)"No credential expected for default test provider.");
        }
        catch (IOException iOException) {
            // empty catch block
        }
        DefaultCredentialProviderTest.assertTrue((boolean)transport.urlWasRequested("http://test.metadata.server.address"));
    }

    public void testDefaultCredentialNonExistentFileThrows() throws Exception {
        File nonExistentFile = new File(DefaultCredentialProviderTest.getTempDirectory(), "DefaultCredentialBadFile.json");
        DefaultCredentialProviderTest.assertFalse((boolean)nonExistentFile.exists());
        MockHttpTransport transport = new MockHttpTransport();
        TestDefaultCredentialProvider testProvider = new TestDefaultCredentialProvider();
        testProvider.setEnv("GOOGLE_APPLICATION_CREDENTIALS", nonExistentFile.getAbsolutePath());
        try {
            testProvider.getDefaultCredential((HttpTransport)transport, JSON_FACTORY);
            DefaultCredentialProviderTest.fail((String)"Non existent user credential should throw exception.");
        }
        catch (IOException e) {
            String message = e.getMessage();
            DefaultCredentialProviderTest.assertTrue((boolean)message.contains("GOOGLE_APPLICATION_CREDENTIALS"));
            DefaultCredentialProviderTest.assertTrue((boolean)message.contains(nonExistentFile.getAbsolutePath()));
        }
    }

    public void testDefaultCredentialNotFoundError() {
        MockHttpTransport transport = new MockHttpTransport();
        TestDefaultCredentialProvider testProvider = new TestDefaultCredentialProvider();
        try {
            testProvider.getDefaultCredential((HttpTransport)transport, JSON_FACTORY);
            DefaultCredentialProviderTest.fail();
        }
        catch (IOException e) {
            String message = e.getMessage();
            DefaultCredentialProviderTest.assertTrue((boolean)message.contains("https://developers.google.com/accounts/docs/application-default-credentials"));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testDefaultCredentialServiceAccount() throws IOException {
        File serviceAccountFile = new File(DefaultCredentialProviderTest.getTempDirectory(), "DefaultCredentialServiceAccount.json");
        if (serviceAccountFile.exists()) {
            serviceAccountFile.delete();
        }
        String serviceAccountId = "36680232662-vrd7ji19qe3nelgchd0ah2csanun6bnr.apps.googleusercontent.com";
        String serviceAccountEmail = "36680232662-vrd7ji19qe3nelgchdcsanun6bnr@developer.gserviceaccount.com";
        MockTokenServerTransport transport = new MockTokenServerTransport();
        transport.addServiceAccount("36680232662-vrd7ji19qe3nelgchdcsanun6bnr@developer.gserviceaccount.com", ACCESS_TOKEN);
        TestDefaultCredentialProvider testProvider = new TestDefaultCredentialProvider();
        try {
            GenericJson serviceAccountContents = new GenericJson();
            serviceAccountContents.setFactory(JSON_FACTORY);
            serviceAccountContents.put("client_id", (Object)"36680232662-vrd7ji19qe3nelgchd0ah2csanun6bnr.apps.googleusercontent.com");
            serviceAccountContents.put("client_email", (Object)"36680232662-vrd7ji19qe3nelgchdcsanun6bnr@developer.gserviceaccount.com");
            serviceAccountContents.put("private_key", (Object)SA_KEY_TEXT);
            serviceAccountContents.put("private_key_id", (Object)SA_KEY_ID);
            serviceAccountContents.put("type", (Object)"service_account");
            PrintWriter writer = new PrintWriter(serviceAccountFile);
            String json = serviceAccountContents.toPrettyString();
            writer.println(json);
            writer.close();
            testProvider.setEnv("GOOGLE_APPLICATION_CREDENTIALS", serviceAccountFile.getAbsolutePath());
            GoogleCredential credential = testProvider.getDefaultCredential((HttpTransport)transport, JSON_FACTORY);
            DefaultCredentialProviderTest.assertNotNull((Object)credential);
            credential = credential.createScoped(SCOPES);
            DefaultCredentialProviderTest.assertTrue((boolean)credential.refreshToken());
            DefaultCredentialProviderTest.assertEquals((String)ACCESS_TOKEN, (String)credential.getAccessToken());
        }
        finally {
            if (serviceAccountFile.exists()) {
                serviceAccountFile.delete();
            }
        }
    }

    public void testDefaultCredentialUser() throws IOException {
        File userCredentialFile = new File(DefaultCredentialProviderTest.getTempDirectory(), "DefaultCredentialUser.json");
        if (userCredentialFile.exists()) {
            userCredentialFile.delete();
        }
        TestDefaultCredentialProvider testProvider = new TestDefaultCredentialProvider();
        testProvider.setEnv("GOOGLE_APPLICATION_CREDENTIALS", userCredentialFile.getAbsolutePath());
        this.testDefaultCredentialUser(userCredentialFile, testProvider);
    }

    public void testDefaultCredentialWellKnownFileNonWindows() throws IOException {
        File wellKnownFile;
        File cloudConfigDir;
        File homeDir = DefaultCredentialProviderTest.getTempDirectory();
        File configDir = new File(homeDir, ".config");
        if (!configDir.exists()) {
            configDir.mkdir();
        }
        if (!(cloudConfigDir = new File(configDir, "gcloud")).exists()) {
            cloudConfigDir.mkdir();
        }
        if ((wellKnownFile = new File(cloudConfigDir, "application_default_credentials.json")).exists()) {
            wellKnownFile.delete();
        }
        TestDefaultCredentialProvider testProvider = new TestDefaultCredentialProvider();
        testProvider.addFile(wellKnownFile.getAbsolutePath());
        testProvider.setProperty("os.name", "linux");
        testProvider.setProperty("user.home", homeDir.getAbsolutePath());
        this.testDefaultCredentialUser(wellKnownFile, testProvider);
    }

    public void testDefaultCredentialWellKnownFileWindows() throws IOException {
        File wellKnownFile;
        File appDataDir = DefaultCredentialProviderTest.getTempDirectory();
        File cloudConfigDir = new File(appDataDir, "gcloud");
        if (!cloudConfigDir.exists()) {
            cloudConfigDir.mkdir();
        }
        if ((wellKnownFile = new File(cloudConfigDir, "application_default_credentials.json")).exists()) {
            wellKnownFile.delete();
        }
        TestDefaultCredentialProvider testProvider = new TestDefaultCredentialProvider();
        testProvider.addFile(wellKnownFile.getAbsolutePath());
        testProvider.setProperty("os.name", "windows");
        testProvider.setEnv("APPDATA", appDataDir.getAbsolutePath());
        this.testDefaultCredentialUser(wellKnownFile, testProvider);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testDefaultCredentialEnvironmentVariableWinsOverWellKnownFile() throws IOException {
        File wellKnownFile;
        File cloudConfigDir;
        String clientSecret = "jakuaL9YyieakhECKL2SwZcu";
        String clientId = "ya29.1.AADtN_UtlxH8cruGAxrN2XQnZTVRvDyVWnYq4I6dws";
        String refreshTokenEnv = "2/Tl6awhpFjkMkSJoj1xsli0H2eL5YsMgU_NKPY2TyGWY";
        String accessTokenEnv = "2/MkSJoj1xsli0AccessToken_NKPY2";
        String refreshTokenWkf = "3/Tl6awhpFjkMkSJoj1xsli0H2eL5YsMgU_NKPY2TyGWY";
        String accessTokenWkf = "3/MkSJoj1xsli0AccessToken_NKPY2";
        TestDefaultCredentialProvider testProvider = new TestDefaultCredentialProvider();
        File environmentVariableFile = new File(DefaultCredentialProviderTest.getTempDirectory(), "EnvVarUser.json");
        if (environmentVariableFile.exists()) {
            environmentVariableFile.delete();
        }
        testProvider.setEnv("GOOGLE_APPLICATION_CREDENTIALS", environmentVariableFile.getAbsolutePath());
        File homeDir = DefaultCredentialProviderTest.getTempDirectory();
        File configDir = new File(homeDir, ".config");
        if (!configDir.exists()) {
            configDir.mkdir();
        }
        if (!(cloudConfigDir = new File(configDir, "gcloud")).exists()) {
            cloudConfigDir.mkdir();
        }
        if ((wellKnownFile = new File(cloudConfigDir, "application_default_credentials.json")).exists()) {
            wellKnownFile.delete();
        }
        testProvider.addFile(wellKnownFile.getAbsolutePath());
        testProvider.setProperty("os.name", "linux");
        testProvider.setProperty("user.home", homeDir.getAbsolutePath());
        MockTokenServerTransport transport = new MockTokenServerTransport();
        transport.addClient("ya29.1.AADtN_UtlxH8cruGAxrN2XQnZTVRvDyVWnYq4I6dws", "jakuaL9YyieakhECKL2SwZcu");
        transport.addRefreshToken("2/Tl6awhpFjkMkSJoj1xsli0H2eL5YsMgU_NKPY2TyGWY", "2/MkSJoj1xsli0AccessToken_NKPY2");
        transport.addRefreshToken("3/Tl6awhpFjkMkSJoj1xsli0H2eL5YsMgU_NKPY2TyGWY", "3/MkSJoj1xsli0AccessToken_NKPY2");
        String jsonEnv = GoogleCredentialTest.createUserJson("ya29.1.AADtN_UtlxH8cruGAxrN2XQnZTVRvDyVWnYq4I6dws", "jakuaL9YyieakhECKL2SwZcu", "2/Tl6awhpFjkMkSJoj1xsli0H2eL5YsMgU_NKPY2TyGWY");
        String jsonWkf = GoogleCredentialTest.createUserJson("ya29.1.AADtN_UtlxH8cruGAxrN2XQnZTVRvDyVWnYq4I6dws", "jakuaL9YyieakhECKL2SwZcu", "3/Tl6awhpFjkMkSJoj1xsli0H2eL5YsMgU_NKPY2TyGWY");
        try {
            PrintWriter writer = new PrintWriter(environmentVariableFile);
            writer.println(jsonEnv);
            writer.close();
            writer = new PrintWriter(wellKnownFile);
            writer.println(jsonWkf);
            writer.close();
            GoogleCredential credential = testProvider.getDefaultCredential((HttpTransport)transport, JSON_FACTORY);
            DefaultCredentialProviderTest.assertNotNull((Object)credential);
            DefaultCredentialProviderTest.assertEquals((String)"2/Tl6awhpFjkMkSJoj1xsli0H2eL5YsMgU_NKPY2TyGWY", (String)credential.getRefreshToken());
            DefaultCredentialProviderTest.assertTrue((boolean)credential.refreshToken());
            DefaultCredentialProviderTest.assertEquals((String)"2/MkSJoj1xsli0AccessToken_NKPY2", (String)credential.getAccessToken());
        }
        finally {
            if (wellKnownFile.exists()) {
                wellKnownFile.delete();
            }
            if (environmentVariableFile.exists()) {
                environmentVariableFile.delete();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void testDefaultCredentialUser(File userFile, TestDefaultCredentialProvider testProvider) throws IOException {
        String clientSecret = "jakuaL9YyieakhECKL2SwZcu";
        String clientId = "ya29.1.AADtN_UtlxH8cruGAxrN2XQnZTVRvDyVWnYq4I6dws";
        String refreshToken = "1/Tl6awhpFjkMkSJoj1xsli0H2eL5YsMgU_NKPY2TyGWY";
        MockTokenServerTransport transport = new MockTokenServerTransport();
        transport.addClient("ya29.1.AADtN_UtlxH8cruGAxrN2XQnZTVRvDyVWnYq4I6dws", "jakuaL9YyieakhECKL2SwZcu");
        transport.addRefreshToken("1/Tl6awhpFjkMkSJoj1xsli0H2eL5YsMgU_NKPY2TyGWY", ACCESS_TOKEN);
        String json = GoogleCredentialTest.createUserJson("ya29.1.AADtN_UtlxH8cruGAxrN2XQnZTVRvDyVWnYq4I6dws", "jakuaL9YyieakhECKL2SwZcu", "1/Tl6awhpFjkMkSJoj1xsli0H2eL5YsMgU_NKPY2TyGWY");
        try {
            PrintWriter writer = new PrintWriter(userFile);
            writer.println(json);
            writer.close();
            GoogleCredential credential = testProvider.getDefaultCredential((HttpTransport)transport, JSON_FACTORY);
            DefaultCredentialProviderTest.assertNotNull((Object)credential);
            DefaultCredentialProviderTest.assertEquals((String)"1/Tl6awhpFjkMkSJoj1xsli0H2eL5YsMgU_NKPY2TyGWY", (String)credential.getRefreshToken());
            DefaultCredentialProviderTest.assertTrue((boolean)credential.refreshToken());
            DefaultCredentialProviderTest.assertEquals((String)ACCESS_TOKEN, (String)credential.getAccessToken());
        }
        finally {
            if (userFile.exists()) {
                userFile.delete();
            }
        }
    }

    private static File getTempDirectory() {
        lock.lock();
        try {
            if (tempDirectory == null) {
                String userHome = System.getProperty("user.home");
                File temp = new File(userHome, ".temptest");
                if (!temp.exists()) {
                    temp.mkdir();
                } else if (!temp.isDirectory()) {
                    DefaultCredentialProviderTest.fail((String)"Temp directory is a file!");
                }
                tempDirectory = temp;
            }
        }
        finally {
            lock.unlock();
        }
        return tempDirectory;
    }

    private static class TestDefaultCredentialProvider
    extends DefaultCredentialProvider {
        private Map<String, Class<?>> types = new HashMap();
        private Map<String, String> variables = new HashMap<String, String>();
        private Map<String, String> properties = new HashMap<String, String>();
        private Set<String> files = new HashSet<String>();
        private int forNameCallCount = 0;

        TestDefaultCredentialProvider() {
        }

        void addFile(String file) {
            this.files.add(file);
        }

        void addType(String className, Class<?> type) {
            this.types.put(className, type);
        }

        String getEnv(String name) {
            return this.variables.get(name);
        }

        boolean getEnvEquals(String name, String value) {
            return this.variables.containsKey(name) && this.variables.get(name).equals(value);
        }

        void setEnv(String name, String value) {
            this.variables.put(name, value);
        }

        String getProperty(String property, String def) {
            String value = this.properties.get(property);
            return value == null ? def : value;
        }

        void setProperty(String property, String value) {
            this.properties.put(property, value);
        }

        boolean fileExists(File file) {
            return this.files.contains(file.getAbsolutePath());
        }

        Class<?> forName(String className) throws ClassNotFoundException {
            ++this.forNameCallCount;
            Class<?> lookup = this.types.get(className);
            if (lookup != null) {
                return lookup;
            }
            throw new ClassNotFoundException("TestDefaultCredentialProvider: Class not found.");
        }

        int getForNameCallCount() {
            return this.forNameCallCount;
        }
    }

    private static class MockRequestUrlRecordingTransport
    extends MockHttpTransport {
        List<String> requestUrls = new ArrayList<String>();

        MockRequestUrlRecordingTransport() {
        }

        int getRequestCount() {
            return this.requestUrls.size();
        }

        boolean urlWasRequested(String url) {
            return this.requestUrls.contains(url);
        }

        public LowLevelHttpRequest buildRequest(String method, String url) {
            MockLowLevelHttpRequest request = new MockLowLevelHttpRequest(url){

                public LowLevelHttpResponse execute() throws IOException {
                    MockRequestUrlRecordingTransport.this.requestUrls.add(this.getUrl());
                    throw new IOException("MockRequestCountingTransport request failed.");
                }
            };
            return request;
        }
    }

    public static class MockEnvironment {
        private MockEnvironmentEnum innerValue;

        MockEnvironment(MockEnvironmentEnum value) {
            this.innerValue = value;
        }

        public MockEnvironmentEnum value() {
            return this.innerValue;
        }
    }

    private static enum MockEnvironmentEnum {
        Production,
        Development;

    }

    private static class MockOffAppEngineSystemProperty {
        public static final MockEnvironment environment = new MockEnvironment(null);

        private MockOffAppEngineSystemProperty() {
        }
    }

    private static class MockAppEngineSystemProperty {
        public static final MockEnvironment environment = new MockEnvironment(MockEnvironmentEnum.Production);

        private MockAppEngineSystemProperty() {
        }
    }

    public static class MockAppEngineCredential
    extends GoogleCredential {
        public MockAppEngineCredential(HttpTransport transport, JsonFactory jsonFactory) {
            super(new GoogleCredential.Builder().setTransport(transport).setJsonFactory(jsonFactory));
        }
    }
}

