/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.core;

import com.google.api.core.ApiAsyncFunction;
import com.google.api.core.ApiFunction;
import com.google.api.core.ApiFuture;
import com.google.api.core.ApiFutureCallback;
import com.google.api.core.ApiFutures;
import com.google.api.core.SettableApiFuture;
import com.google.common.collect.ImmutableList;
import com.google.common.truth.Truth;
import com.google.common.util.concurrent.MoreExecutors;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicInteger;
import org.junit.jupiter.api.Test;

class ApiFuturesTest {
    ApiFuturesTest() {
    }

    @Test
    void testAddCallback() {
        final AtomicInteger flag = new AtomicInteger();
        SettableApiFuture future = SettableApiFuture.create();
        ApiFutures.addCallback((ApiFuture)future, (ApiFutureCallback)new ApiFutureCallback<Integer>(){

            public void onSuccess(Integer i) {
                flag.set(i + 1);
            }

            public void onFailure(Throwable t) {
                flag.set(-1);
            }
        }, (Executor)MoreExecutors.directExecutor());
        future.set((Object)0);
        Truth.assertThat((Integer)flag.get()).isEqualTo((Object)1);
    }

    @Test
    void testCatch() throws Exception {
        SettableApiFuture future = SettableApiFuture.create();
        ApiFuture fallback = ApiFutures.catching((ApiFuture)future, Exception.class, (ApiFunction)new ApiFunction<Exception, Integer>(){

            public Integer apply(Exception ex) {
                return 42;
            }
        }, (Executor)MoreExecutors.directExecutor());
        future.setException((Throwable)new Exception());
        Truth.assertThat((Integer)((Integer)fallback.get())).isEqualTo((Object)42);
    }

    @Test
    void testCatchAsync() throws Exception {
        SettableApiFuture future = SettableApiFuture.create();
        ApiFuture fallback = ApiFutures.catchingAsync((ApiFuture)future, Exception.class, (ApiAsyncFunction)new ApiAsyncFunction<Exception, Integer>(){

            public ApiFuture<Integer> apply(Exception ex) {
                return ApiFutures.immediateFuture((Object)42);
            }
        }, (Executor)MoreExecutors.directExecutor());
        future.setException((Throwable)new Exception());
        Truth.assertThat((Integer)((Integer)fallback.get())).isEqualTo((Object)42);
    }

    @Test
    void testTransform() throws Exception {
        SettableApiFuture inputFuture = SettableApiFuture.create();
        ApiFuture transformedFuture = ApiFutures.transform((ApiFuture)inputFuture, (ApiFunction)new ApiFunction<Integer, String>(){

            public String apply(Integer input) {
                return input.toString();
            }
        }, (Executor)MoreExecutors.directExecutor());
        inputFuture.set((Object)6);
        Truth.assertThat((String)((String)transformedFuture.get())).isEqualTo((Object)"6");
    }

    @Test
    void testTransformWithExecutor() throws Exception {
        SettableApiFuture inputFuture = SettableApiFuture.create();
        final AtomicInteger counter = new AtomicInteger(0);
        ApiFuture transformedFuture = ApiFutures.transform((ApiFuture)inputFuture, (ApiFunction)new ApiFunction<Integer, String>(){

            public String apply(Integer input) {
                return input.toString();
            }
        }, (Executor)new Executor(){

            @Override
            public void execute(Runnable command) {
                counter.incrementAndGet();
                command.run();
            }
        });
        inputFuture.set((Object)6);
        Truth.assertThat((String)((String)transformedFuture.get())).isEqualTo((Object)"6");
        Truth.assertThat((Integer)counter.get()).isEqualTo((Object)1);
    }

    @Test
    void testAllAsList() throws Exception {
        SettableApiFuture inputFuture1 = SettableApiFuture.create();
        SettableApiFuture inputFuture2 = SettableApiFuture.create();
        ApiFuture listFuture = ApiFutures.allAsList((Iterable)ImmutableList.of((Object)inputFuture1, (Object)inputFuture2));
        inputFuture1.set((Object)1);
        inputFuture2.set((Object)2);
        Truth.assertThat((Iterable)((Iterable)listFuture.get())).containsExactly(new Object[]{1, 2}).inOrder();
    }

    @Test
    void successfulAllAsList() throws Exception {
        SettableApiFuture inputFuture1 = SettableApiFuture.create();
        SettableApiFuture inputFuture2 = SettableApiFuture.create();
        ApiFuture listFuture = ApiFutures.successfulAsList((Iterable)ImmutableList.of((Object)inputFuture1, (Object)inputFuture2));
        inputFuture1.set((Object)1);
        inputFuture2.setException((Throwable)new Exception());
        Truth.assertThat((Iterable)((Iterable)listFuture.get())).containsExactly(new Object[]{1, null}).inOrder();
    }

    @Test
    void testTransformAsync() throws Exception {
        ApiFuture inputFuture = ApiFutures.immediateFuture((Object)0);
        ApiFuture outputFuture = ApiFutures.transformAsync((ApiFuture)inputFuture, (ApiAsyncFunction)new ApiAsyncFunction<Integer, Integer>(){

            public ApiFuture<Integer> apply(Integer input) {
                return ApiFutures.immediateFuture((Object)(input + 1));
            }
        }, (Executor)MoreExecutors.directExecutor());
        Truth.assertThat((Integer)((Integer)outputFuture.get())).isEqualTo((Object)1);
    }

    @Test
    void testTransformAsyncWithExecutor() throws Exception {
        ApiFuture inputFuture = ApiFutures.immediateFuture((Object)0);
        AtomicInteger counter = new AtomicInteger(0);
        ApiFuture outputFuture = ApiFutures.transformAsync((ApiFuture)inputFuture, input -> ApiFutures.immediateFuture((Object)(input + 1)), command -> {
            counter.incrementAndGet();
            command.run();
        });
        Truth.assertThat((Integer)((Integer)outputFuture.get())).isEqualTo((Object)1);
        Truth.assertThat((Integer)counter.get()).isEqualTo((Object)1);
    }

    @Test
    void testImmediateFailedFuture() throws InterruptedException {
        ApiFuture future = ApiFutures.immediateFailedFuture((Throwable)new IllegalArgumentException("The message"));
        IllegalArgumentException exception = null;
        try {
            future.get();
        }
        catch (ExecutionException e) {
            exception = (IllegalArgumentException)e.getCause();
        }
        Truth.assertThat(exception).isNotNull();
        Truth.assertThat((String)exception.getMessage()).isEqualTo((Object)"The message");
    }

    @Test
    void testImmediateCancelledFuture() throws InterruptedException, ExecutionException {
        ApiFuture future = ApiFutures.immediateCancelledFuture();
        CancellationException exception = null;
        try {
            future.get();
        }
        catch (CancellationException e) {
            exception = e;
        }
        Truth.assertThat((Throwable)exception).isNotNull();
    }
}

