/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.core;

import com.google.api.core.AbstractApiService;
import com.google.api.core.ApiService;
import com.google.common.util.concurrent.MoreExecutors;
import java.util.concurrent.atomic.AtomicReference;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

class ApiServiceTest {
    ApiServiceTest() {
    }

    @Test
    void testNoopService() {
        AbstractApiService service = new AbstractApiService(){

            protected void doStop() {
                this.notifyStopped();
            }

            protected void doStart() {
                this.notifyStarted();
            }
        };
        service.startAsync().awaitRunning();
        Assertions.assertTrue((boolean)service.isRunning());
        service.stopAsync().awaitTerminated();
    }

    @Test
    void testFailingService() {
        final AtomicReference savedFailure = new AtomicReference();
        AbstractApiService service = new AbstractApiService(){

            protected void doStop() {
                throw new Error();
            }

            protected void doStart() {
                this.notifyFailed(new IllegalStateException("this service always fails"));
            }
        };
        service.addListener(new ApiService.Listener(){

            public void failed(ApiService.State from, Throwable failure) {
                savedFailure.set(failure);
            }
        }, MoreExecutors.directExecutor());
        try {
            service.startAsync().awaitRunning();
            throw new RuntimeException("unreachable");
        }
        catch (IllegalStateException illegalStateException) {
            Assertions.assertEquals((Object)service.state(), (Object)ApiService.State.FAILED);
            Assertions.assertEquals((Object)((Throwable)savedFailure.get()).getMessage(), (Object)"this service always fails");
            Assertions.assertEquals((Object)service.failureCause().getMessage(), (Object)"this service always fails");
            return;
        }
    }
}

