/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.core;

import com.google.api.core.SettableApiFuture;
import com.google.common.truth.Truth;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

class SettableApiFutureTest {
    SettableApiFutureTest() {
    }

    @Test
    void testSet() throws Exception {
        SettableApiFuture future = SettableApiFuture.create();
        Truth.assertThat((Boolean)future.isDone()).isFalse();
        future.set((Object)42);
        Truth.assertThat((Integer)((Integer)future.get())).isEqualTo((Object)42);
        Truth.assertThat((Integer)((Integer)future.get(1L, TimeUnit.HOURS))).isEqualTo((Object)42);
        Truth.assertThat((Boolean)future.isDone()).isTrue();
    }

    @Test
    void testCancel() {
        SettableApiFuture future = SettableApiFuture.create();
        Truth.assertThat((Boolean)future.isDone()).isFalse();
        Truth.assertThat((Boolean)future.isCancelled()).isFalse();
        future.cancel(false);
        Truth.assertThat((Boolean)future.isDone()).isTrue();
        Truth.assertThat((Boolean)future.isCancelled()).isTrue();
    }

    @Test
    void testException() {
        Assertions.assertThrows(ExecutionException.class, () -> {
            SettableApiFuture future = SettableApiFuture.create();
            future.setException((Throwable)new Exception());
            future.get();
        });
    }

    @Test
    void testListener() {
        final AtomicInteger flag = new AtomicInteger();
        SettableApiFuture future = SettableApiFuture.create();
        future.addListener(new Runnable(){

            @Override
            public void run() {
                flag.set(1);
            }
        }, new Executor(){

            @Override
            public void execute(Runnable r) {
                r.run();
            }
        });
        future.set((Object)0);
        Truth.assertThat((Integer)flag.get()).isEqualTo((Object)1);
    }
}

