/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.pathtemplate;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.pathtemplate.ValidationException;
import com.google.common.collect.ImmutableMap;
import com.google.common.truth.Truth;
import java.util.Map;
import java.util.Set;
import java.util.stream.Stream;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.MethodSource;

class PathTemplateTest {
    PathTemplateTest() {
    }

    @Test
    void matchAtomicResourceName() {
        PathTemplate template = PathTemplate.create((String)"buckets/*/*/objects/*");
        PathTemplateTest.assertPositionalMatch(template.match("buckets/f/o/objects/bar"), "f", "o", "bar");
    }

    @Test
    void matchTemplateWithUnboundedWildcard() {
        PathTemplate template = PathTemplate.create((String)"buckets/*/objects/**");
        PathTemplateTest.assertPositionalMatch(template.match("buckets/foo/objects/bar/baz"), "foo", "bar/baz");
    }

    @Test
    void matchWithForcedHostName() {
        PathTemplate template = PathTemplate.create((String)"buckets/*/objects/*");
        Map match = template.matchFromFullName("somewhere.io/buckets/b/objects/o");
        Truth.assertThat((Map)match).isNotNull();
        Truth.assertThat((String)((String)match.get("$hostname"))).isEqualTo((Object)"somewhere.io");
        Truth.assertThat((String)((String)match.get("$0"))).isEqualTo((Object)"b");
        Truth.assertThat((String)((String)match.get("$1"))).isEqualTo((Object)"o");
    }

    @Test
    void matchWithHostName() {
        PathTemplate template = PathTemplate.create((String)"buckets/*/objects/*");
        Map match = template.match("//somewhere.io/buckets/b/objects/o");
        Truth.assertThat((Map)match).isNotNull();
        Truth.assertThat((String)((String)match.get("$hostname"))).isEqualTo((Object)"//somewhere.io");
        Truth.assertThat((String)((String)match.get("$0"))).isEqualTo((Object)"b");
        Truth.assertThat((String)((String)match.get("$1"))).isEqualTo((Object)"o");
    }

    @Test
    void matchWithHostNameAndProtocol() {
        PathTemplate template = PathTemplate.create((String)"projects/{project}/zones/{zone}");
        Map match = template.match("https://www.googleapis.com/compute/v1/projects/project-123/zones/europe-west3-c");
        Truth.assertThat((Map)match).isNotNull();
        Truth.assertThat((String)((String)match.get("$hostname"))).isEqualTo((Object)"https://www.googleapis.com");
        Truth.assertThat((String)((String)match.get("project"))).isEqualTo((Object)"project-123");
        Truth.assertThat((String)((String)match.get("zone"))).isEqualTo((Object)"europe-west3-c");
    }

    @Test
    void matchWithHostNameAndProtocolWithTemplateStartWithBinding() {
        PathTemplate template = PathTemplate.create((String)"{project}/zones/{zone}");
        Map match = template.match("https://www.googleapis.com/compute/v1/projects/project-123/zones/europe-west3-c");
        Truth.assertThat((Map)match).isNotNull();
        Truth.assertThat((String)((String)match.get("$hostname"))).isEqualTo((Object)"https://www.googleapis.com");
        Truth.assertThat((String)((String)match.get("project"))).isEqualTo((Object)"project-123");
        Truth.assertThat((String)((String)match.get("zone"))).isEqualTo((Object)"europe-west3-c");
    }

    @Test
    void pathWildcards_matchZeroOrMoreSegments() {
        PathTemplate start = PathTemplate.create((String)"{glob=**}/b");
        PathTemplate middle = PathTemplate.create((String)"a/{glob=**}/b");
        PathTemplate end = PathTemplate.create((String)"a/{glob=**}");
        PathTemplate endWithCustomVerb = PathTemplate.create((String)"a/{glob=**}:foo");
        Truth.assertThat((String)((String)start.match("b").get("glob"))).isEmpty();
        Truth.assertThat((String)((String)start.match("/b").get("glob"))).isEmpty();
        Truth.assertThat((String)((String)start.match("a/b").get("glob"))).isEqualTo((Object)"a");
        Truth.assertThat((String)((String)start.match("a/a/a/b").get("glob"))).isEqualTo((Object)"a/a/a");
        Truth.assertThat((String)((String)middle.match("a/b").get("glob"))).isEmpty();
        Truth.assertThat((String)((String)middle.match("a//b").get("glob"))).isEmpty();
        Truth.assertThat((String)((String)middle.match("a/x/b").get("glob"))).isEqualTo((Object)"x");
        Truth.assertThat((String)((String)middle.match("a/x/y/z/b").get("glob"))).isEqualTo((Object)"x/y/z");
        Truth.assertThat((String)((String)end.match("a").get("glob"))).isEmpty();
        Truth.assertThat((String)((String)end.match("a/").get("glob"))).isEmpty();
        Truth.assertThat((String)((String)end.match("a/b").get("glob"))).isEqualTo((Object)"b");
        Truth.assertThat((String)((String)end.match("a/b/b/b").get("glob"))).isEqualTo((Object)"b/b/b");
        Truth.assertThat((String)((String)endWithCustomVerb.match("a/:foo").get("glob"))).isEmpty();
        Truth.assertThat((String)((String)endWithCustomVerb.match("a/b:foo").get("glob"))).isEqualTo((Object)"b");
        Truth.assertThat((String)((String)endWithCustomVerb.match("a/b/b:foo").get("glob"))).isEqualTo((Object)"b/b");
    }

    @Test
    void pathWildcard_canMatchTheEmptyString() {
        PathTemplate template = PathTemplate.create((String)"{glob=**}");
        Truth.assertThat((String)((String)template.match("").get("glob"))).isEmpty();
        Truth.assertThat((String)((String)template.match("a").get("glob"))).isEqualTo((Object)"a");
        Truth.assertThat((String)((String)template.match("a/b").get("glob"))).isEqualTo((Object)"a/b");
    }

    @Test
    void matchWithCustomMethod() {
        PathTemplate template = PathTemplate.create((String)"buckets/*/objects/*:custom");
        Map match = template.match("buckets/b/objects/o:custom");
        Truth.assertThat((Map)match).isNotNull();
        Truth.assertThat((String)((String)match.get("$0"))).isEqualTo((Object)"b");
        Truth.assertThat((String)((String)match.get("$1"))).isEqualTo((Object)"o");
    }

    @Test
    void matchFailWhenPathMismatch() {
        PathTemplate template = PathTemplate.create((String)"buckets/*/*/objects/*");
        Truth.assertThat((Map)template.match("buckets/f/o/o/objects/bar")).isNull();
    }

    @Test
    void matchFailWhenPathTooShort() {
        PathTemplate template = PathTemplate.create((String)"buckets/*/*/objects/*");
        Truth.assertThat((Map)template.match("buckets/f/o/objects")).isNull();
    }

    @Test
    void matchFailWhenPathTooLong() {
        PathTemplate template = PathTemplate.create((String)"buckets/*/*/objects/*");
        Truth.assertThat((Map)template.match("buckets/f/o/objects/too/long")).isNull();
    }

    @Test
    void matchWithUnboundInMiddle() {
        PathTemplate template = PathTemplate.create((String)"bar/**/foo/*");
        PathTemplateTest.assertPositionalMatch(template.match("bar/foo/foo/foo/bar"), "foo/foo", "bar");
    }

    @Test
    void matchWithNamedBindings() {
        PathTemplate template = PathTemplate.create((String)"projects/*/{instance_id=instances/*}/**");
        Map actual = template.match("projects/proj_foo/instances/instance_bar/table/table_baz");
        Truth.assertThat((Map)actual).containsEntry((Object)"instance_id", (Object)"instances/instance_bar");
    }

    @Test
    void matchFailWithNamedBindingsWhenPathMismatches() {
        PathTemplate template = PathTemplate.create((String)"projects/*/{instance_id=instances/*}/**");
        Map actual = template.match("projects/proj_foo/instances_fail/instance_bar/table/table_baz");
        Truth.assertThat((Map)actual).isNull();
    }

    @Test
    void matchWithNamedBindingsThatHasOnlyWildcard() {
        PathTemplate template = PathTemplate.create((String)"profiles/{routing_id=*}");
        Map actual = template.match("profiles/prof_qux");
        Truth.assertThat((Map)actual).containsEntry((Object)"routing_id", (Object)"prof_qux");
    }

    @Test
    void matchFailWithNamedBindingsThatHasOnlyWildcardWhenPathMismatches() {
        PathTemplate template = PathTemplate.create((String)"profiles/{routing_id=*}");
        Map actual = template.match("profiles/prof_qux/fail");
        Truth.assertThat((Map)actual).isNull();
    }

    @Test
    void matchWithCustomVerbs() {
        PathTemplate template = PathTemplate.create((String)"**:foo");
        PathTemplateTest.assertPositionalMatch(template.match("a/b/c:foo"), "a/b/c");
    }

    @Test
    void complexResourceIdBasicCases() {
        PathTemplate template = PathTemplate.create((String)"projects/{project}/zones/{zone_a}~{zone_b}");
        Map match = template.match("https://www.googleapis.com/compute/v1/projects/project-123/zones/europe-west3-c~us-east3-a");
        Truth.assertThat((Map)match).isNotNull();
        Truth.assertThat((String)((String)match.get("$hostname"))).isEqualTo((Object)"https://www.googleapis.com");
        Truth.assertThat((String)((String)match.get("project"))).isEqualTo((Object)"project-123");
        Truth.assertThat((String)((String)match.get("zone_a}~{zone_b"))).isNull();
        Truth.assertThat((String)((String)match.get("zone_a"))).isEqualTo((Object)"europe-west3-c");
        Truth.assertThat((String)((String)match.get("zone_b"))).isEqualTo((Object)"us-east3-a");
        template = PathTemplate.create((String)"projects/{project}/zones/{zone_a}-{zone_b}");
        match = template.match("projects/project-123/zones/europe-west3-c~us-east3-a");
        Truth.assertThat((Map)match).isNotNull();
        Truth.assertThat((String)((String)match.get("project"))).isEqualTo((Object)"project-123");
        Truth.assertThat((String)((String)match.get("zone_a"))).isEqualTo((Object)"europe");
        Truth.assertThat((String)((String)match.get("zone_b"))).isEqualTo((Object)"west3-c~us-east3-a");
        template = PathTemplate.create((String)"projects/{project}/zones/{zone_a}.{zone_b}");
        match = template.match("projects/project-123/zones/europe-west3-c.us-east3-a");
        Truth.assertThat((Map)match).isNotNull();
        Truth.assertThat((String)((String)match.get("project"))).isEqualTo((Object)"project-123");
        Truth.assertThat((String)((String)match.get("zone_a"))).isEqualTo((Object)"europe-west3-c");
        Truth.assertThat((String)((String)match.get("zone_b"))).isEqualTo((Object)"us-east3-a");
        template = PathTemplate.create((String)"projects/{project}/zones/{zone_a}_{zone_b}");
        match = template.match("projects/project-123/zones/europe-west3-c_us-east3-a");
        Truth.assertThat((Map)match).isNotNull();
        Truth.assertThat((String)((String)match.get("project"))).isEqualTo((Object)"project-123");
        Truth.assertThat((String)((String)match.get("zone_a"))).isEqualTo((Object)"europe-west3-c");
        Truth.assertThat((String)((String)match.get("zone_b"))).isEqualTo((Object)"us-east3-a");
    }

    @Test
    void complexResourceIdCustomVerb() {
        PathTemplate template = PathTemplate.create((String)"projects/{project}/zones/{zone_a}~{zone_b}:hello");
        Map match = template.match("https://www.googleapis.com/compute/v1/projects/project-123/zones/europe-west3-c~us-east3-a:hello");
        Truth.assertThat((Map)match).isNotNull();
        Truth.assertThat((String)((String)match.get("$hostname"))).isEqualTo((Object)"https://www.googleapis.com");
        Truth.assertThat((String)((String)match.get("project"))).isEqualTo((Object)"project-123");
        Truth.assertThat((String)((String)match.get("zone_a}~{zone_b"))).isNull();
        Truth.assertThat((String)((String)match.get("zone_a"))).isEqualTo((Object)"europe-west3-c");
        Truth.assertThat((String)((String)match.get("zone_b"))).isEqualTo((Object)"us-east3-a");
        template = PathTemplate.create((String)"projects/{project}/zones/{zone_a}-{zone_b}:hello");
        match = template.match("projects/project-123/zones/europe-west3-c~us-east3-a:hello");
        Truth.assertThat((Map)match).isNotNull();
        Truth.assertThat((String)((String)match.get("project"))).isEqualTo((Object)"project-123");
        Truth.assertThat((String)((String)match.get("zone_a"))).isEqualTo((Object)"europe");
        Truth.assertThat((String)((String)match.get("zone_b"))).isEqualTo((Object)"west3-c~us-east3-a");
        template = PathTemplate.create((String)"projects/{project}/zones/{zone_a}.{zone_b}:hello");
        match = template.match("projects/project-123/zones/europe-west3-c.us-east3-a:hello");
        Truth.assertThat((Map)match).isNotNull();
        Truth.assertThat((String)((String)match.get("project"))).isEqualTo((Object)"project-123");
        Truth.assertThat((String)((String)match.get("zone_a"))).isEqualTo((Object)"europe-west3-c");
        Truth.assertThat((String)((String)match.get("zone_b"))).isEqualTo((Object)"us-east3-a");
        template = PathTemplate.create((String)"projects/{project}/zones/{zone_a}_{zone_b}:hello");
        match = template.match("projects/project-123/zones/europe-west3-c_us-east3-a:hello");
        Truth.assertThat((Map)match).isNotNull();
        Truth.assertThat((String)((String)match.get("project"))).isEqualTo((Object)"project-123");
        Truth.assertThat((String)((String)match.get("zone_a"))).isEqualTo((Object)"europe-west3-c");
        Truth.assertThat((String)((String)match.get("zone_b"))).isEqualTo((Object)"us-east3-a");
    }

    @Test
    void complexResourceIdEqualsWildcard() {
        PathTemplate template = PathTemplate.create((String)"projects/{project=*}/zones/{zone_a=*}~{zone_b=*}");
        Map match = template.match("projects/project-123/zones/europe-west3-c~us-east3-a");
        Truth.assertThat((Map)match).isNotNull();
        Truth.assertThat((String)((String)match.get("project"))).isEqualTo((Object)"project-123");
        Truth.assertThat((String)((String)match.get("zone_a}~{zone_b"))).isNull();
        Truth.assertThat((String)((String)match.get("zone_a"))).isEqualTo((Object)"europe-west3-c");
        Truth.assertThat((String)((String)match.get("zone_b"))).isEqualTo((Object)"us-east3-a");
    }

    @Test
    void complexResourceIdEqualsPathWildcard() {
        Exception exception = (Exception)Assertions.assertThrows(ValidationException.class, () -> PathTemplate.create((String)"projects/{project=*}/zones/{zone_a=**}~{zone_b}"));
        Assertions.assertEquals((Object)String.format("parse error: wildcard path not allowed in complex ID resource '%s'", "zone_a"), (Object)exception.getMessage());
    }

    @Test
    void complexResourceIdMissingMatches() {
        PathTemplate template = PathTemplate.create((String)"projects/{project}/zones/{zone_a}~{zone_b}");
        Truth.assertThat((Map)template.match("projects/project-123/zones/europe-west3-c")).isNull();
        template = PathTemplate.create((String)"projects/{project}/zones/{zone_a}~{zone_b}.{zone_c}");
        Map match = template.match("projects/project-123/zones/europe-west3-c~.us-east3-a");
        Truth.assertThat((Map)match).isNotNull();
        Truth.assertThat((String)((String)match.get("project"))).isEqualTo((Object)"project-123");
        Truth.assertThat((String)((String)match.get("zone_a}~{zone_b"))).isNull();
        Truth.assertThat((String)((String)match.get("zone_a"))).isEqualTo((Object)"europe-west3-c");
        Truth.assertThat((String)((String)match.get("zone_b"))).isEmpty();
        Truth.assertThat((String)((String)match.get("zone_c"))).isEqualTo((Object)"us-east3-a");
    }

    @Test
    void complexResourceIdNoSeparator() {
        Exception exception = (Exception)Assertions.assertThrows(ValidationException.class, () -> PathTemplate.create((String)"projects/{project}/zones/{zone_a}{zone_b}"));
        Assertions.assertEquals((Object)String.format("parse error: missing or 2+ consecutive delimiter characters in '%s'", "{zone_a}{zone_b}"), (Object)exception.getMessage());
        exception = (Exception)Assertions.assertThrows(ValidationException.class, () -> PathTemplate.create((String)"projects/{project}/zones/{zone_a}_{zone_b}{zone_c}"));
        Assertions.assertEquals((Object)String.format("parse error: missing or 2+ consecutive delimiter characters in '%s'", "{zone_a}_{zone_b}{zone_c}"), (Object)exception.getMessage());
        exception = (Exception)Assertions.assertThrows(ValidationException.class, () -> PathTemplate.create((String)"projects/{project=*}/zones/{zone_a}{{zone_b}"));
        Assertions.assertEquals((Object)String.format("parse error: missing or 2+ consecutive delimiter characters in '%s'", "{zone_a}{{zone_b}"), (Object)exception.getMessage());
    }

    @ParameterizedTest
    @MethodSource(value={"invalidDelimiters"})
    void complexResourceIdInvalidDelimiter(String invalidDelimiter) {
        ValidationException exception = (ValidationException)Assertions.assertThrows(ValidationException.class, () -> PathTemplate.create((String)String.format("projects/{project=*}/zones/{zone_a}%s{zone_b}", invalidDelimiter)));
        Assertions.assertEquals((Object)String.format("parse error: invalid complex resource ID delimiter character in '%s'", String.format("zone_a}%s{zone_b}", invalidDelimiter)), (Object)exception.getMessage());
    }

    static Stream<String> invalidDelimiters() {
        return Stream.of("|", "!", "@", "a", "1", ",", ")");
    }

    @Test
    void complexResourceIdMixedSeparators() {
        PathTemplate template = PathTemplate.create((String)"projects/{project}/zones/{zone_a}~{zone_b}.{zone_c}-{zone_d}");
        Map match = template.match("https://www.googleapis.com/compute/v1/projects/project-123/zones/europe-west3-c~us-east3-a.us-west2-b-europe-west2-b");
        Truth.assertThat((Map)match).isNotNull();
        Truth.assertThat((String)((String)match.get("$hostname"))).isEqualTo((Object)"https://www.googleapis.com");
        Truth.assertThat((String)((String)match.get("project"))).isEqualTo((Object)"project-123");
        Truth.assertThat((String)((String)match.get("zone_a"))).isEqualTo((Object)"europe-west3-c");
        Truth.assertThat((String)((String)match.get("zone_b"))).isEqualTo((Object)"us-east3-a");
        Truth.assertThat((String)((String)match.get("zone_c"))).isEqualTo((Object)"us");
        Truth.assertThat((String)((String)match.get("zone_d"))).isEqualTo((Object)"west2-b-europe-west2-b");
        template = PathTemplate.create((String)"projects/{project}/zones/{zone_a}.{zone_b}.{zone_c}~{zone_d}");
        match = template.match("https://www.googleapis.com/compute/v1/projects/project-123/zones/europe-west3-c.us-east3-a.us-west2-b~europe-west2-b");
        Truth.assertThat((Map)match).isNotNull();
        Truth.assertThat((String)((String)match.get("$hostname"))).isEqualTo((Object)"https://www.googleapis.com");
        Truth.assertThat((String)((String)match.get("project"))).isEqualTo((Object)"project-123");
        Truth.assertThat((String)((String)match.get("zone_a"))).isEqualTo((Object)"europe-west3-c");
        Truth.assertThat((String)((String)match.get("zone_b"))).isEqualTo((Object)"us-east3-a");
        Truth.assertThat((String)((String)match.get("zone_c"))).isEqualTo((Object)"us-west2-b");
        Truth.assertThat((String)((String)match.get("zone_d"))).isEqualTo((Object)"europe-west2-b");
    }

    @Test
    void collectionWildcardMatchingInParent() {
        PathTemplate template = PathTemplate.create((String)"v1/publishers/-/books/{book}");
        Map match = template.match("https://example.googleapis.com/v1/publishers/publisher-abc/books/blockchain_for_babies");
        Truth.assertThat((Map)match).isNotNull();
        template = PathTemplate.create((String)"/v1/{parent=rooms/-}/blurbs/{blurb}");
        match = template.match("https://example.googleapis.com/v1/rooms/den/blurbs/asdf");
        Truth.assertThat((Map)match).isNotNull();
    }

    @Test
    void collectionWildcardMatchingInvalid() {
        ValidationException exception = (ValidationException)Assertions.assertThrows(ValidationException.class, () -> PathTemplate.create((String)"v1/publishers/{publisher}/books/-"));
    }

    @Test
    void complexResourceIdPubSubDeletedTopic() {
        PathTemplate template = PathTemplate.create((String)"_deleted-topic_");
        Truth.assertThat((Object)template).isNotNull();
    }

    @Test
    void complexResourceIdInParent() {
        PathTemplate template = PathTemplate.create((String)"projects/{project}/zones/{zone_a}-{zone_b}_{zone_c}/machines/{machine}");
        Map match = template.match("https://www.googleapis.com/compute/v1/projects/project-123/zones/europe-west3-c-us-east3-a_us-west2-b/machines/roomba");
        Truth.assertThat((Map)match).isNotNull();
        Truth.assertThat((String)((String)match.get("$hostname"))).isEqualTo((Object)"https://www.googleapis.com");
        Truth.assertThat((String)((String)match.get("project"))).isEqualTo((Object)"project-123");
        Truth.assertThat((String)((String)match.get("zone_a"))).isEqualTo((Object)"europe");
        Truth.assertThat((String)((String)match.get("zone_b"))).isEqualTo((Object)"west3-c-us-east3-a");
        Truth.assertThat((String)((String)match.get("zone_c"))).isEqualTo((Object)"us-west2-b");
        Truth.assertThat((String)((String)match.get("machine"))).isEqualTo((Object)"roomba");
        template = PathTemplate.create((String)"projects/{foo}_{bar}/zones/{zone_a}-{zone_b}_{zone_c}/machines/{cell1}.{cell2}");
        match = template.match("https://www.googleapis.com/compute/v1/projects/project_123/zones/europe-west3-c-us-east3-a_us-west2-b/machines/roomba.broomba");
        Truth.assertThat((Map)match).isNotNull();
        Truth.assertThat((String)((String)match.get("$hostname"))).isEqualTo((Object)"https://www.googleapis.com");
        Truth.assertThat((String)((String)match.get("foo"))).isEqualTo((Object)"project");
        Truth.assertThat((String)((String)match.get("bar"))).isEqualTo((Object)"123");
        Truth.assertThat((String)((String)match.get("zone_a"))).isEqualTo((Object)"europe");
        Truth.assertThat((String)((String)match.get("zone_b"))).isEqualTo((Object)"west3-c-us-east3-a");
        Truth.assertThat((String)((String)match.get("zone_c"))).isEqualTo((Object)"us-west2-b");
        Truth.assertThat((String)((String)match.get("cell1"))).isEqualTo((Object)"roomba");
        Truth.assertThat((String)((String)match.get("cell2"))).isEqualTo((Object)"broomba");
    }

    @Test
    void complexResourcePathTemplateVariables() {
        String pattern = "projects/{foo}_{bar}/zones/{zone_a}-{zone_b}_{zone_c}/machines/{cell1}.{cell2}";
        PathTemplate template = PathTemplate.create((String)pattern);
        Set variables = template.vars();
        Truth.assertThat((Iterable)variables).containsExactly(new Object[]{"foo", "bar", "zone_a", "zone_b", "zone_c", "cell1", "cell2"});
        pattern = "projects/{foo}_{bar}/zones/*";
        template = PathTemplate.create((String)pattern);
        Map match = template.match("https://www.googleapis.com/compute/v1/projects/foo1_bar2/zones/azone");
        Truth.assertThat((Map)match).isNotNull();
        Truth.assertThat((String)((String)match.get("foo"))).isEqualTo((Object)"foo1");
        Truth.assertThat((String)((String)match.get("bar"))).isEqualTo((Object)"bar2");
        variables = template.vars();
        System.out.println("DEL: vars: " + variables);
    }

    @Test
    void complexResourceBasicInvalidIds() {
        ValidationException exception = (ValidationException)Assertions.assertThrows(ValidationException.class, () -> PathTemplate.create((String)"projects/*/zones/~{zone_a}"));
        Assertions.assertEquals((Object)String.format("parse error: invalid begin or end character in '%s'", "~{zone_a}"), (Object)exception.getMessage());
        exception = (ValidationException)Assertions.assertThrows(ValidationException.class, () -> PathTemplate.create((String)"projects/*/zones/{zone_a}~"));
        Assertions.assertEquals((Object)String.format("parse error: invalid begin or end character in '%s'", "{zone_a}~"), (Object)exception.getMessage());
        exception = (ValidationException)Assertions.assertThrows(ValidationException.class, () -> PathTemplate.create((String)"projects/*/zones/.{zone_a}"));
        Assertions.assertEquals((Object)String.format("parse error: invalid begin or end character in '%s'", ".{zone_a}"), (Object)exception.getMessage());
        exception = (ValidationException)Assertions.assertThrows(ValidationException.class, () -> PathTemplate.create((String)"projects/*/zones/{zone_a}."));
        Assertions.assertEquals((Object)String.format("parse error: invalid begin or end character in '%s'", "{zone_a}."), (Object)exception.getMessage());
        exception = (ValidationException)Assertions.assertThrows(ValidationException.class, () -> PathTemplate.create((String)"projects/*/zones/-{zone_a}"));
        Assertions.assertEquals((Object)String.format("parse error: invalid begin or end character in '%s'", "-{zone_a}"), (Object)exception.getMessage());
        exception = (ValidationException)Assertions.assertThrows(ValidationException.class, () -> PathTemplate.create((String)"projects/*/zones/{zone_a}-"));
        Assertions.assertEquals((Object)String.format("parse error: invalid begin or end character in '%s'", "{zone_a}-"), (Object)exception.getMessage());
        exception = (ValidationException)Assertions.assertThrows(ValidationException.class, () -> PathTemplate.create((String)"projects/*/zones/_{zone_a}"));
        Assertions.assertEquals((Object)String.format("parse error: invalid begin or end character in '%s'", "_{zone_a}"), (Object)exception.getMessage());
        exception = (ValidationException)Assertions.assertThrows(ValidationException.class, () -> PathTemplate.create((String)"projects/*/zones/{zone_a}_"));
        Assertions.assertEquals((Object)String.format("parse error: invalid begin or end character in '%s'", "{zone_a}_"), (Object)exception.getMessage());
    }

    @Test
    void complexResourceMultipleDelimiters() {
        ValidationException exception = (ValidationException)Assertions.assertThrows(ValidationException.class, () -> PathTemplate.create((String)"projects/*/zones/{zone_a}~.{zone_b}"));
        Assertions.assertEquals((Object)String.format("parse error: missing or 2+ consecutive delimiter characters in '%s'", "{zone_a}~.{zone_b}"), (Object)exception.getMessage());
        exception = (ValidationException)Assertions.assertThrows(ValidationException.class, () -> PathTemplate.create((String)"projects/*/zones/{zone_a}~{zone_b}..{zone_c}"));
        Assertions.assertEquals((Object)String.format("parse error: missing or 2+ consecutive delimiter characters in '%s'", "{zone_a}~{zone_b}..{zone_c}"), (Object)exception.getMessage());
        String pathString = "projects/project_123/zones/lorum~ipsum";
        PathTemplate template = PathTemplate.create((String)"projects/*/zones/{zone_.~-a}~{zone_b}");
        template.validate(pathString, "");
        Map match = template.match(pathString);
        Truth.assertThat((Map)match).isNotNull();
        Truth.assertThat((String)((String)match.get("zone_.~-a"))).isEqualTo((Object)"lorum");
        Truth.assertThat((String)((String)match.get("zone_b"))).isEqualTo((Object)"ipsum");
    }

    @Test
    void validateSuccess() {
        String templateString = "buckets/*/objects/*";
        String pathString = "buckets/bucket/objects/object";
        PathTemplate template = PathTemplate.create((String)templateString);
        template.validate(pathString, "");
    }

    @Test
    void validateFailure() {
        String templateString = "buckets/*/objects/*";
        String pathString = "buckets/bucket/invalid/object";
        PathTemplate template = PathTemplate.create((String)templateString);
        ValidationException exception = (ValidationException)Assertions.assertThrows(ValidationException.class, () -> template.validate(pathString, ""));
        Assertions.assertEquals((Object)String.format(": Parameter \"%s\" must be in the form \"%s\"", pathString, templateString), (Object)exception.getMessage());
    }

    @Test
    void validateMatchSuccess() {
        String templateString = "buckets/*/objects/{object_id}";
        String pathString = "buckets/bucket/objects/object";
        PathTemplate template = PathTemplate.create((String)templateString);
        Map matchMap = template.validatedMatch(pathString, "");
        Truth.assertThat((String)((String)matchMap.get("$0"))).isEqualTo((Object)"bucket");
        Truth.assertThat((String)((String)matchMap.get("object_id"))).isEqualTo((Object)"object");
    }

    @Test
    void validateMatchFailure() {
        String templateString = "buckets/*/objects/*";
        String pathString = "buckets/bucket/invalid/object";
        PathTemplate template = PathTemplate.create((String)templateString);
        ValidationException exception = (ValidationException)Assertions.assertThrows(ValidationException.class, () -> template.validatedMatch(pathString, ""));
        Assertions.assertEquals((Object)String.format(": Parameter \"%s\" must be in the form \"%s\"", pathString, templateString), (Object)exception.getMessage());
    }

    @Test
    void instantiateAtomicResource() {
        PathTemplate template = PathTemplate.create((String)"buckets/*/*/*/objects/*");
        String url = template.instantiate(new String[]{"$0", "f", "$1", "o", "$2", "o", "$3", "bar"});
        Truth.assertThat((String)url).isEqualTo((Object)"buckets/f/o/o/objects/bar");
    }

    @Test
    void instantiateEscapeUnsafeChar() {
        PathTemplate template = PathTemplate.create((String)"buckets/*/objects/*");
        Truth.assertThat((String)template.instantiate(new String[]{"$0", "f/o/o", "$1", "b/a/r"})).isEqualTo((Object)"buckets/f%2Fo%2Fo/objects/b%2Fa%2Fr");
    }

    @Test
    void instantiateNotEscapeForUnboundedWildcard() {
        PathTemplate template = PathTemplate.create((String)"buckets/*/objects/**");
        Truth.assertThat((String)template.instantiate(new String[]{"$0", "f/o/o", "$1", "b/a/r"})).isEqualTo((Object)"buckets/f%2Fo%2Fo/objects/b/a/r");
    }

    @Test
    void instantiateFailWhenTooFewVariables() {
        PathTemplate template = PathTemplate.create((String)"buckets/*/*/*/objects/*");
        ValidationException exception = (ValidationException)Assertions.assertThrows(ValidationException.class, () -> template.instantiate(new String[]{"$0", "f", "1", "o"}));
    }

    @Test
    void instantiateWithUnboundInMiddle() {
        PathTemplate template = PathTemplate.create((String)"bar/**/foo/*");
        Truth.assertThat((String)template.instantiate(new String[]{"$0", "1/2", "$1", "3"})).isEqualTo((Object)"bar/1/2/foo/3");
    }

    @Test
    void instantiatePartial() {
        PathTemplate template = PathTemplate.create((String)"bar/*/foo/*");
        String instance = template.instantiatePartial((Map)ImmutableMap.of((Object)"$0", (Object)"_1"));
        Truth.assertThat((String)instance).isEqualTo((Object)"bar/_1/foo/*");
    }

    @Test
    void instantiateWithHostName() {
        PathTemplate template = PathTemplate.create((String)"bar/*");
        String instance = template.instantiate((Map)ImmutableMap.of((Object)"$hostname", (Object)"//somewhere.io", (Object)"$0", (Object)"foo"));
        Truth.assertThat((String)instance).isEqualTo((Object)"//somewhere.io/bar/foo");
    }

    @Test
    void instantiateEscapeUnsafeCharNoEncoding() {
        PathTemplate template = PathTemplate.createWithoutUrlEncoding((String)"buckets/*/objects/*");
        ValidationException exception = (ValidationException)Assertions.assertThrows(ValidationException.class, () -> template.instantiate(new String[]{"$0", "f/o/o", "$1", "b/a/r"}));
        Assertions.assertEquals((Object)String.format("Invalid character \"/\" in path section \"f/o/o\".", new Object[0]), (Object)exception.getMessage());
    }

    @Test
    void instantiateNotEscapeForUnboundedWildcardNoEncoding() {
        PathTemplate template = PathTemplate.createWithoutUrlEncoding((String)"buckets/*/objects/**");
        Truth.assertThat((String)template.instantiate(new String[]{"$0", "foo", "$1", "b/a/r"})).isEqualTo((Object)"buckets/foo/objects/b/a/r");
    }

    @Test
    void instantiateWithGoogProject() {
        PathTemplate template = PathTemplate.create((String)"projects/{project}");
        String instance = template.instantiate((Map)ImmutableMap.of((Object)"project", (Object)"google.com:test-proj"));
        Truth.assertThat((String)instance).isEqualTo((Object)"projects/google.com%3Atest-proj");
    }

    @Test
    void instantiateWithGoogProjectNoEncoding() {
        PathTemplate template = PathTemplate.createWithoutUrlEncoding((String)"projects/{project}");
        String instance = template.instantiate((Map)ImmutableMap.of((Object)"project", (Object)"google.com:test-proj"));
        Truth.assertThat((String)instance).isEqualTo((Object)"projects/google.com:test-proj");
    }

    @Test
    void instantiateWithUnusualCharactersNoEncoding() {
        PathTemplate template = PathTemplate.createWithoutUrlEncoding((String)"bar/*");
        String instance = template.instantiate((Map)ImmutableMap.of((Object)"$0", (Object)"asdf:;`~,.<>[]!@#$%^&*()"));
        Truth.assertThat((String)instance).isEqualTo((Object)"bar/asdf:;`~,.<>[]!@#$%^&*()");
    }

    @Test
    void instantiateWithComplexResourceId_basic() {
        PathTemplate template = PathTemplate.create((String)"projects/{project}/zones/{zone_a}~{zone_b}");
        String instance = template.instantiate(new String[]{"project", "a/b/c", "zone_a", "apple", "zone_b", "baseball"});
        Truth.assertThat((String)instance).isEqualTo((Object)"projects/a%2Fb%2Fc/zones/apple~baseball");
    }

    @Test
    void instantiateWithComplexResourceId_customVerb() {
        PathTemplate template = PathTemplate.create((String)"projects/{project}/zones/{zone_a}~{zone_b}:hello");
        String instance = template.instantiate(new String[]{"project", "a/b/c", "zone_a", "apple", "zone_b", "baseball"});
        Truth.assertThat((String)instance).isEqualTo((Object)"projects/a%2Fb%2Fc/zones/apple~baseball:hello");
        template = PathTemplate.create((String)"projects/{project}/zones/{zone_a}~{zone_b}/stuff:hello");
        instance = template.instantiate(new String[]{"project", "a/b/c", "zone_a", "apple", "zone_b", "baseball"});
        Truth.assertThat((String)instance).isEqualTo((Object)"projects/a%2Fb%2Fc/zones/apple~baseball/stuff:hello");
    }

    @Test
    void instantiateWithComplexResourceId_mixedSeparators() {
        PathTemplate template = PathTemplate.create((String)"projects/{project}/zones/{zone_a}~{zone_b}.{zone_c}-{zone_d}~{zone_e}");
        String instance = template.instantiate(new String[]{"project", "a/b/c", "zone_a", "apple", "zone_b", "baseball/basketball", "zone_c", "cat/kitty", "zone_d", "dog/hound", "zone_e", "12345"});
        Truth.assertThat((String)instance).isEqualTo((Object)"projects/a%2Fb%2Fc/zones/apple~baseball%2Fbasketball.cat%2Fkitty-dog%2Fhound~12345");
    }

    @Test
    void instantiateWithComplexResourceId_mixedSeparatorsInParent() {
        PathTemplate template = PathTemplate.create((String)"projects/{project_a}~{project_b}.{project_c}/zones/{zone_a}~{zone_b}");
        String instance = template.instantiate(new String[]{"project_a", "a/b/c", "project_b", "foo", "project_c", "bar", "zone_a", "apple", "zone_b", "baseball"});
        Truth.assertThat((String)instance).isEqualTo((Object)"projects/a%2Fb%2Fc~foo.bar/zones/apple~baseball");
    }

    @Test
    void instantiateWithCustomVerbs() {
        PathTemplate template = PathTemplate.create((String)"/v1/{name=operations/**}:cancel");
        String templateInstance = template.instantiate(new String[]{"name", "operations/3373707"});
        Truth.assertThat((String)templateInstance).isEqualTo((Object)"v1/operations/3373707:cancel");
        Truth.assertThat((Boolean)template.matches(templateInstance)).isTrue();
    }

    @Test
    void instantiateWithASegmentStartsWithADelimiter() {
        PathTemplate pathTemplate = PathTemplate.create((String)"v1beta1/{parent=projects/*/locations/*/clusters/*}/.well-known/openid-configuration");
        String pattern = "v1beta1/projects/abc/locations/def/clusters/yte/.well-known/openid-configuration";
        Truth.assertThat((Boolean)pathTemplate.matches(pattern)).isTrue();
    }

    @Test
    void instantiateWithASegmentContainingComplexResourceNamesAndStartsWithADelimiter() {
        ValidationException exception = (ValidationException)Assertions.assertThrows(ValidationException.class, () -> PathTemplate.create((String)"v1beta1/{parent=projects/*/locations/*/clusters/*}/.{well}-{known}/openid-configuration"));
        Assertions.assertEquals((Object)String.format("parse error: invalid begin or end character in '%s'", ".{well}-{known}"), (Object)exception.getMessage());
    }

    @Test
    void instantiateWithASegmentContainingNoComplexResourceNamesAndStartsWithMultipleDelimiters() {
        PathTemplate pathTemplate = PathTemplate.create((String)"v1beta1/{parent=projects/*/locations/*/clusters/*}/.-~well-known/openid-configuration");
        String pattern = "v1beta1/projects/abc/locations/def/clusters/yte/.-~well-known/openid-configuration";
        Truth.assertThat((Boolean)pathTemplate.matches(pattern)).isTrue();
    }

    @Test
    void instantiateWithASegmentOnlyContainingOneDelimiter() {
        ValidationException exception = (ValidationException)Assertions.assertThrows(ValidationException.class, () -> PathTemplate.create((String)"v1/publishers/{publisher}/books/."));
        Assertions.assertEquals((Object)String.format("parse error: invalid begin or end character in '%s'", "."), (Object)exception.getMessage());
    }

    @Test
    void instantiateWithASegmentOnlyContainingOneCharacter() {
        PathTemplate pathTemplate = PathTemplate.create((String)"v1/publishers/{publisher}/books/a");
        String pattern = "v1/publishers/o'reilly/books/a";
        Truth.assertThat((Boolean)pathTemplate.matches(pattern)).isTrue();
    }

    @Test
    void instantiateWithASegmentEndsWithADelimiter() {
        PathTemplate pathTemplate = PathTemplate.create((String)"v1beta1/{parent=projects/*/locations/*/clusters/*}/well-known./openid-configuration");
        String pattern = "v1beta1/projects/abc/locations/def/clusters/yte/well-known./openid-configuration";
        Truth.assertThat((Boolean)pathTemplate.matches(pattern)).isTrue();
    }

    @Test
    void instantiateWithASegmentContainingComplexResourceNamesAndEndsWithADelimiter() {
        ValidationException exception = (ValidationException)Assertions.assertThrows(ValidationException.class, () -> PathTemplate.create((String)"v1beta1/{parent=projects/*/locations/*/clusters/*}/{well}-{known}./openid-configuration"));
        Assertions.assertEquals((Object)String.format("parse error: invalid begin or end character in '%s'", "{well}-{known}."), (Object)exception.getMessage());
    }

    @Test
    void instantiateWithASegmentContainingNoComplexResourceNamesAndEndsWithMultipleDelimiters() {
        PathTemplate pathTemplate = PathTemplate.create((String)"v1beta1/{parent=projects/*/locations/*/clusters/*}/well-known.-~/openid-configuration");
        String pattern = "v1beta1/projects/abc/locations/def/clusters/yte/well-known.-~/openid-configuration";
        Truth.assertThat((Boolean)pathTemplate.matches(pattern)).isTrue();
    }

    @Test
    void testMultiplePathWildcardFailure() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> PathTemplate.create((String)"bar/**/{name=foo/**}:verb"));
    }

    @Test
    void testTemplateWithSimpleBinding() {
        PathTemplate template = PathTemplate.create((String)"/v1/messages/{message_id}");
        String url = template.instantiate(new String[]{"message_id", "mymessage"});
        Truth.assertThat((String)url).isEqualTo((Object)"v1/messages/mymessage");
    }

    @Test
    void testTemplateWithMultipleSimpleBindings() {
        PathTemplate template = PathTemplate.create((String)"v1/shelves/{shelf}/books/{book}");
        String url = template.instantiate(new String[]{"shelf", "s1", "book", "b1"});
        Truth.assertThat((String)url).isEqualTo((Object)"v1/shelves/s1/books/b1");
    }

    private static void assertPositionalMatch(Map<String, String> match, String ... expected) {
        int i;
        Truth.assertThat(match).isNotNull();
        for (i = 0; i < expected.length; ++i) {
            Truth.assertThat((String)expected[i]).isEqualTo((Object)match.get("$" + i));
        }
        Truth.assertThat((Integer)i).isEqualTo((Object)match.size());
    }
}

